/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.ForwardChainingReasoner;
import org.obo.test.AbstractOBOTest;
import org.obo.util.TermUtil;

public abstract class AbstractReasonerFaceoffTest
extends AbstractOBOTest {
    Collection<ReasonedLinkDatabase> testReasoners = new LinkedList<ReasonedLinkDatabase>();
    ReasonedLinkDatabase reference;

    protected AbstractReasonerFaceoffTest(String name) {
        super(name);
    }

    public void setReferenceReasoner(ReasonedLinkDatabase reasoner) {
        this.reference = reasoner;
    }

    public void addReasoner(ReasonedLinkDatabase reasoner) {
        this.testReasoners.add(reasoner);
    }

    protected void runReasoner(ReasonedLinkDatabase reasoner) {
        reasoner.setLinkDatabase(this.linkDatabase);
        reasoner.recache();
    }

    protected abstract void installTestReasoners();

    @Override
    public void setUp() throws Exception {
        long time;
        super.setUp();
        this.installTestReasoners();
        for (ReasonedLinkDatabase reasoner : this.testReasoners) {
            time = System.nanoTime();
            System.out.print("Running test reasoner " + reasoner + " ...");
            System.out.flush();
            this.runReasoner(reasoner);
            logger.info((Object)("done (" + (double)(System.nanoTime() - time) / 1000000.0 + " ms)"));
        }
        time = System.nanoTime();
        System.out.print("Running reference reasoner...");
        System.out.flush();
        this.runReasoner(this.reference);
        logger.info((Object)("done (" + (double)(System.nanoTime() - time) / 1000000.0 + " ms, explainTime = " + ((ForwardChainingReasoner)this.reference).explainTime + ")"));
        logger.info((Object)"setup complete.");
    }

    protected static void hasAllLinks(ReasonedLinkDatabase checkme, ReasonedLinkDatabase againstme, Collection<Link> alreadyChecked, boolean checkExplanations) {
        int i = 0;
        for (IdentifiedObject io : checkme.getObjects()) {
            logger.info((Object)("Checking term " + i++ + " of " + checkme.getObjects().size()));
            if (!(io instanceof LinkedObject)) continue;
            for (Link link : checkme.getParents((LinkedObject)io)) {
                boolean containsExps;
                if (alreadyChecked.contains(link)) continue;
                alreadyChecked.add(link);
                Collection<Explanation> refExps = checkme.getExplanations(link);
                boolean contains = TermUtil.containsLink(againstme, link);
                Collection<Explanation> exps = againstme.getExplanations(link);
                boolean bl = containsExps = !TermUtil.isImplied(link) || exps.equals(refExps);
                if (!contains) {
                    logger.info((Object)("Reasoner " + againstme + " does not contain reference " + link));
                    logger.info((Object)("all parents of " + link.getChild() + ": "));
                    for (Link p : againstme.getParents(link.getChild())) {
                        logger.info((Object)("   " + p));
                    }
                }
                AbstractReasonerFaceoffTest.assertTrue((String)("Reasoner " + againstme + " does not contain reference " + link), (boolean)contains);
                if (!checkExplanations) continue;
                AbstractReasonerFaceoffTest.assertTrue((String)("Reasoner " + againstme + " has different explanations for " + link), (boolean)containsExps);
            }
        }
    }

    public void testLinks() {
        boolean testExplanations = false;
        for (ReasonedLinkDatabase reasoner : this.testReasoners) {
            HashSet<Link> checked = new HashSet<Link>();
            AbstractReasonerFaceoffTest.hasAllLinks(this.reference, reasoner, checked, testExplanations);
            AbstractReasonerFaceoffTest.hasAllLinks(reasoner, this.reference, checked, testExplanations);
        }
    }
}

