/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.filters.Filter;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.ReasonerFactory;
import org.obo.reasoner.impl.TrimmedLinkDatabase;
import org.obo.reasoner.rbr.RuleBasedReasonerFactory;
import org.obo.test.AbstractOBOTest;
import org.obo.util.ReasonerUtil;

public abstract class AbstractReasonerTest
extends AbstractOBOTest {
    protected ReasonedLinkDatabase reasonedDB;
    protected LinkDatabase trimmedDB;
    protected static final Logger logger = Logger.getLogger(AbstractReasonerTest.class);
    protected static ReasonerFactory reasonerFactory = new RuleBasedReasonerFactory();

    protected LinkDatabase getLinkDatabase() {
        return this.reasonedDB;
    }

    protected AbstractReasonerTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.reasonedDB = this.createReasoner();
        this.reasonedDB.setLinkDatabase(this.linkDatabase);
        this.reasonedDB.recache();
        this.trimmedDB = new TrimmedLinkDatabase(this.reasonedDB);
    }

    public void reReason(ReasonerFactory fac) {
        AbstractReasonerTest.setReasonerFactory(fac);
        this.reasonedDB = this.createReasoner();
        this.reasonedDB.setLinkDatabase(this.linkDatabase);
        this.reasonedDB.recache();
        this.trimmedDB = new TrimmedLinkDatabase(this.reasonedDB);
    }

    protected ReasonedLinkDatabase createReasoner() {
        return reasonerFactory.createReasoner();
    }

    public static ReasonerFactory getReasonerFactory() {
        return reasonerFactory;
    }

    public static void setReasonerFactory(ReasonerFactory reasonerFactoryIn) {
        reasonerFactory = reasonerFactoryIn;
    }

    public Collection<Link> getLinks(LinkDatabase ldb, String childID, String relID, String parentID) {
        LinkedObject child = (LinkedObject)this.session.getObject(childID);
        LinkedObject parent = (LinkedObject)this.session.getObject(parentID);
        OBOProperty rel = (OBOProperty)this.session.getObject(relID);
        ArrayList<Link> links = new ArrayList<Link>();
        for (Link link : ldb.getParents(child)) {
            if (!link.getType().equals(rel) || !link.getParent().equals(parent)) continue;
            links.add(link);
        }
        return links;
    }

    public Collection<Link> getLinks(String childID, String relID, String parentID) {
        return this.getLinks(this.reasonedDB, childID, relID, parentID);
    }

    public boolean hasLink(LinkDatabase ldb, String childID, String relID, String parentID) {
        return this.getLinks(ldb, childID, relID, parentID).size() > 0;
    }

    public boolean hasLink(String childID, String relID, String parentID) {
        return this.hasLink(this.reasonedDB, childID, relID, parentID);
    }

    public boolean hasIsALink(LinkDatabase ldb, String childID, String parentID) {
        return this.hasLink(ldb, childID, OBOProperty.IS_A.getID(), parentID);
    }

    public boolean hasIsALink(String childID, String parentID) {
        return this.hasLink(childID, OBOProperty.IS_A.getID(), parentID);
    }

    @Override
    public void testForIsA(String childID, String parentID) {
        this.testForLink(childID, OBOProperty.IS_A.getID(), parentID);
    }

    @Override
    public void testForNoIsA(String childID, String parentID) {
        AbstractReasonerTest.assertFalse((boolean)this.hasIsALink(childID, parentID));
    }

    public void testForIsAInTrimmed(String childID, String parentID) {
        AbstractReasonerTest.assertTrue((boolean)this.hasIsALink(this.trimmedDB, childID, parentID));
    }

    public void testForNoIsAInTrimmed(String childID, String parentID) {
        AbstractReasonerTest.assertFalse((boolean)this.hasIsALink(this.trimmedDB, childID, parentID));
    }

    public void testForEquivalentTo(String childID, String parentID) {
        LinkedObject child = (LinkedObject)this.session.getObject(childID);
        LinkedObject parent = (LinkedObject)this.session.getObject(parentID);
        AbstractReasonerTest.assertTrue((boolean)ReasonerUtil.isEquivalent(this.reasonedDB, child, parent));
    }

    public void testForNotEquivalentTo(String childID, String parentID) {
        LinkedObject child = (LinkedObject)this.session.getObject(childID);
        LinkedObject parent = (LinkedObject)this.session.getObject(parentID);
        AbstractReasonerTest.assertFalse((boolean)ReasonerUtil.isEquivalent(this.reasonedDB, child, parent));
    }

    public boolean isRedundantIsA(String childID, String parentID) {
        LinkedObject child = (LinkedObject)this.session.getObject(childID);
        LinkedObject parent = (LinkedObject)this.session.getObject(parentID);
        logger.info((Object)(this.reasonedDB + " testing redundant isa " + child + " - " + parent));
        for (Link link : this.reasonedDB.getParents(child)) {
            if (!link.getParent().equals(parent) || !link.getType().equals(OBOProperty.IS_A)) continue;
            return ReasonerUtil.isRedundant(this.reasonedDB, link);
        }
        return false;
    }

    public void testForRedundantIsA(String childID, String parentID) {
        AbstractReasonerTest.assertTrue((boolean)this.isRedundantIsA(childID, parentID));
    }

    public void testForNonRedundantIsA(String childID, String parentID) {
        AbstractReasonerTest.assertFalse((boolean)this.isRedundantIsA(childID, parentID));
    }

    @Override
    public void testForLink(String childID, String relID, String parentID) {
        AbstractReasonerTest.assertTrue((boolean)this.hasLink(childID, relID, parentID));
    }

    public void testForNoLink(String childID, String relID, String parentID) {
        AbstractReasonerTest.assertFalse((boolean)this.hasLink(childID, relID, parentID));
    }

    public void testForLinkInTrimmed(String childID, String relID, String parentID) {
        AbstractReasonerTest.assertTrue((boolean)this.hasLink(this.trimmedDB, childID, relID, parentID));
    }

    public Collection<Link> filterReasonedLinks(Filter filter) {
        LinkedList<Link> matches = new LinkedList<Link>();
        for (IdentifiedObject io : this.session.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            for (Link link : this.reasonedDB.getParents(lo)) {
                if (!filter.satisfies(link)) continue;
                matches.add(link);
            }
        }
        return matches;
    }

    public String tab(int depth) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    public void showExplanation(Link link, int depth) {
        System.out.println(this.tab(depth) + "LINK: " + link);
        if (++depth > 10) {
            System.err.println("TOO DEEP!");
            return;
        }
        for (Explanation exp : this.reasonedDB.getExplanations(link)) {
            System.out.println(this.tab(depth) + "EXP: " + exp);
            for (Link elink : exp.getEvidence()) {
                this.showExplanation(elink, depth + 1);
            }
        }
    }

    public File writeTempTrimmedReasonedOBOFile() throws IOException, DataAdapterException {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        OBOSerializationEngine.FilteredPath path = new OBOSerializationEngine.FilteredPath();
        File outFile = File.createTempFile("foo", "bar");
        path.setPath(outFile.getAbsolutePath());
        path.setSaveImplied(true);
        config.getSaveRecords().add(path);
        path.setReasonerFactory(reasonerFactory);
        config.setBasicSave(false);
        logger.info((Object)("writePath = " + config.getWritePath()));
        logger.info((Object)("savePath = " + config.getSaveRecords()));
        adapter.doOperation(OBOAdapter.WRITE_ONTOLOGY, (AdapterConfiguration)config, this.session);
        return outFile;
    }
}

