/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.rbr.RelationCompositionTable;
import org.obo.reasoner.rbr.RuleBasedReasoner;
import org.obo.test.AbstractReasonerTest;

public class AdvancedReasonerTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(AdvancedReasonerTest.class);

    public AdvancedReasonerTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"genome_intervals.obo"};
        return Arrays.asList(files);
    }

    public void testReasonedLinks() throws Exception {
        OBOProperty df = (OBOProperty)this.session.getObject("disconnected_from");
        if (this.reasonedDB instanceof RuleBasedReasoner) {
            RuleBasedReasoner rbr = (RuleBasedReasoner)this.reasonedDB;
            RelationCompositionTable rct = rbr.getRelationCompositionTable();
            Set<OBOProperty> cset = rct.lookup(df, OBOProperty.IS_A);
            System.out.println(cset);
            AdvancedReasonerTest.assertTrue((boolean)cset.isEmpty());
        }
        this.testForNoLink("SO:0000201", "disconnected_from", "SO:0000001");
        OBOObject ie = (OBOObject)this.session.getObject("SO:0000201");
        for (Link link : this.reasonedDB.getParents(ie)) {
            System.out.println(link);
        }
        this.writeTempTrimmedReasonedOBOFile();
    }
}

