/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.DataAdapterException;
import org.obo.annotation.datamodel.Annotation;
import org.obo.datamodel.DatatypeValue;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.Value;
import org.obo.datamodel.ValueLink;
import org.obo.test.AbstractAnnotationTest;
import org.obo.util.AnnotationUtil;

public class AnnotationStanzaFileTest
extends AbstractAnnotationTest {
    protected static final Logger logger = Logger.getLogger(AnnotationStanzaFileTest.class);

    public AnnotationStanzaFileTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"simple-annot-stanza-example.obo"};
        return Arrays.asList(files);
    }

    public void testAnnot() throws IOException, DataAdapterException {
        this.testAnnot(this.session);
        File file = this.writeTempOBOFile();
        this.session = this.getSessionFromResources(Collections.singleton(file.toString()));
        this.testAnnot(this.session);
    }

    private void testAnnot(OBOSession session) throws IOException, DataAdapterException {
        Instance fred = (Instance)session.getObject("fred");
        logger.info((Object)fred);
        boolean likesBread = false;
        boolean dislikesShuggy = false;
        boolean hasSSNo = false;
        for (Link link : fred.getParents()) {
            logger.info((Object)("  link: " + link + " :: " + link.getClass()));
            if (link.getType().getID().equals("likes") && link.getParent().getID().equals("bread")) {
                likesBread = true;
                AnnotationStanzaFileTest.assertTrue((boolean)(link instanceof OBORestriction));
            }
            if (link.getType().getID().equals("dislikes")) {
                AnnotationStanzaFileTest.assertTrue((boolean)(link instanceof ValueLink));
                if (link.getParent().getID().equals("shuggy")) {
                    dislikesShuggy = true;
                    AnnotationStanzaFileTest.assertTrue((boolean)(link instanceof ValueLink));
                }
            }
            if (!link.getType().getID().equals("has_ss_no")) continue;
            LinkedObject p = link.getParent();
            logger.info(link.getClass());
            if (link instanceof ValueLink) {
                ValueLink ipv = (ValueLink)link;
                Value v = ipv.getValue();
                if (v instanceof DatatypeValue) {
                    DatatypeValue dv = (DatatypeValue)v;
                    logger.info((Object)(dv.getValue() + " :: " + ipv.getType() + " :: " + v.getType()));
                    AnnotationStanzaFileTest.assertTrue((boolean)dv.getValue().equals("123-45-6789"));
                    AnnotationStanzaFileTest.assertTrue((boolean)v.getType().getID().equals("xsd:string"));
                    hasSSNo = true;
                    continue;
                }
                AnnotationStanzaFileTest.assertTrue((boolean)false);
                continue;
            }
            AnnotationStanzaFileTest.assertTrue((boolean)false);
        }
        for (PropertyValue pv : fred.getPropertyValues()) {
            AnnotationStanzaFileTest.assertTrue((boolean)false);
            logger.info((Object)("  fred pv:" + pv));
            Iterator<IdentifiedObject> prop = pv.getProperty();
            logger.info((Object)("  prop:" + (String)((Object)prop)));
            String v = pv.getValue();
            logger.info((Object)("  val:" + (String)((Object)prop)));
            if (((String)((Object)prop)).equals("has_ss_no")) {
                AnnotationStanzaFileTest.assertTrue((boolean)false);
            }
            if (!((String)((Object)prop)).equals("likes")) continue;
            AnnotationStanzaFileTest.assertTrue((boolean)false);
        }
        AnnotationStanzaFileTest.assertTrue((boolean)likesBread);
        AnnotationStanzaFileTest.assertTrue((boolean)dislikesShuggy);
        AnnotationStanzaFileTest.assertTrue((boolean)hasSSNo);
        AnnotationStanzaFileTest.assertTrue((boolean)fred.getNamespace().getID().equals("test"));
        Collection<Annotation> annots = AnnotationUtil.getAnnotations(session);
        logger.info((Object)("N annots:" + annots.size()));
        AnnotationStanzaFileTest.assertTrue((annots.size() > 0 ? 1 : 0) != 0);
        boolean annotCompareTestOk = false;
        for (Annotation annot : annots) {
            logger.info((Object)(annot.getNamespace() + " annot: " + annot + ":: " + annot.getSubject() + " -" + annot.getRelationship() + "-> " + annot.getObject()));
            for (PropertyValue pv : annot.getPropertyValues()) {
                logger.info((Object)("  pv:" + pv));
            }
            if (!annot.getSubject().getID().equals("biggles") || !annot.getObject().getID().equals("dread")) continue;
            for (Link link : annot.getParents()) {
                logger.info((Object)("BIGGLES:" + link));
                if (!link.getType().getID().equals("holds_more_strongly_than") || !link.getParent().getID().equals("_:annot1")) continue;
                annotCompareTestOk = true;
            }
            OBOProperty property = (OBOProperty)session.getObject("holds_more_strongly_than");
            IdentifiedObject annot2 = session.getObject("_:annot2");
            annot.addPropertyValue(property, annot2);
        }
        AnnotationStanzaFileTest.assertTrue((boolean)annotCompareTestOk);
        this.testForAnnotation("fred", "bread");
        this.testForAnnotationAssignedBy("biggles", "dread", "GO");
        this.testForAnnotationPublication("biggles", "dread", "PMID:biggles_flies_again");
        for (IdentifiedObject io : session.getObjects()) {
            if (io.isBuiltIn() || io instanceof Annotation) continue;
            logger.info((Object)(" regular object " + io));
        }
        OBOObject bread = (OBOObject)session.getObject("bread");
        for (PropertyValue pv : bread.getPropertyValues()) {
            logger.info((Object)("  property:" + pv.getProperty()));
            logger.info((Object)("     value:" + pv.getValue() + "\n"));
        }
        bread.setDefinition("test\na b c d e f\nggg\ty\rfoo");
    }
}

