/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.DataAdapterException;
import org.obo.datamodel.DanglingObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.test.AbstractAnnotationTest;
import org.obo.util.AdapterUtil;

public class DanglingObjectTest
extends AbstractAnnotationTest {
    protected static final Logger logger = Logger.getLogger(DanglingObjectTest.class);

    public DanglingObjectTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"dangling_object_test.obo"};
        return Arrays.asList(files);
    }

    public void testDangling() throws IOException, DataAdapterException {
        for (IdentifiedObject io : this.session.getObjects()) {
            if (io.isBuiltIn()) continue;
            logger.info((Object)(io.getID() + " :: " + io.getName()));
        }
        OBOClass clsA = (OBOClass)this.session.getObject("clsA");
        this.checkObject(clsA, false, false);
        OBOClass clsAcln = (OBOClass)clsA.clone();
        this.checkObject(clsAcln, false, false);
        OBOClass clsB = (OBOClass)this.session.getObject("clsB");
        this.checkObject(clsB, false, true);
        OBOClass clsBcln = (OBOClass)clsB.clone();
        this.checkObject(clsBcln, false, true);
        Instance inst = (Instance)this.session.getObject("fred");
        this.checkObject(inst, false, false);
        Instance instcln = (Instance)inst.clone();
        this.checkObject(instcln, false, false);
        OBOProperty prop = (OBOProperty)this.session.getObject("foo");
        this.checkObject(prop, false, false);
        OBOProperty propcln = (OBOProperty)prop.clone();
        this.checkObject(propcln, false, false);
        OBOObject sprop = (OBOObject)this.session.getObject("superfoo");
        this.checkObject(sprop, false, true);
        OBOSession s2 = AdapterUtil.parseFile(this.getResourcePath() + "/dangling_object_test-append.obo");
        clsA = (OBOClass)s2.getObject("clsA");
        this.checkObject(clsA, true, false);
        clsAcln = (OBOClass)clsA.clone();
        this.checkObject(clsAcln, true, false);
        DanglingObjectTest.assertTrue((boolean)clsAcln.getName().equals("a"));
        clsB = (OBOClass)s2.getObject("clsB");
        this.checkObject(clsB, false, false);
        OBOClass clsC = (OBOClass)s2.getObject("clsC");
        this.checkObject(clsC, false, true);
        this.session.importSession(s2, true);
        clsA = (OBOClass)this.session.getObject("clsA");
        this.checkObject(clsA, false, false);
        clsB = (OBOClass)this.session.getObject("clsB");
        this.checkObject(clsB, false, false);
        prop = (OBOProperty)this.session.getObject("foo");
        OBOProperty superfoo = (OBOProperty)this.session.getObject("superfoo");
        this.checkObject(superfoo, false, false);
        this.checkObject(sprop, false, true);
    }

    private void checkObject(OBOObject obj, boolean named, boolean dangling) {
        DanglingObjectTest.assertTrue((obj != null ? 1 : 0) != 0);
        logger.info((Object)("obj=" + obj));
        DanglingObjectTest.assertTrue((boolean)(obj.getName() == null ? !named : named));
        DanglingObjectTest.assertTrue((boolean)(obj instanceof DanglingObject ? dangling : !dangling));
    }
}

