/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.impl.DirectLinkReasonerFactory;
import org.obo.test.AbstractReasonerTest;

public class DirectLinkReasonerTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(DirectLinkReasonerTest.class);

    public DirectLinkReasonerTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        DirectLinkReasonerTest.setReasonerFactory(new DirectLinkReasonerFactory());
        super.setUp();
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"directlinktest.obo"};
        return Arrays.asList(files);
    }

    public static Collection<String> getTests() {
        String[] tests = new String[]{};
        return Arrays.asList(tests);
    }

    public void testSubsumed() throws Exception {
        this.testForIsA("X:1", "X:2");
    }

    public void testAssertedDisjoint() throws Exception {
        this.hasLink("X:5", OBOProperty.DISJOINT_FROM.getID(), "X:4");
    }

    public void testInferredDisjoint() throws Exception {
        this.hasLink("X:4", OBOProperty.DISJOINT_FROM.getID(), "X:5");
    }

    public void testAssertedDisjoint2() throws Exception {
        boolean ok = false;
        for (Link link : this.reasonedDB.getChildren((LinkedObject)this.session.getObject("X:4"))) {
            if (!link.getType().equals(OBOProperty.DISJOINT_FROM) || !link.getChild().getID().equals("X:5") || !link.getParent().getID().equals("X:4")) continue;
            ok = true;
        }
        DirectLinkReasonerTest.assertTrue((boolean)ok);
    }

    public void testInferredDisjoint2() throws Exception {
        boolean ok = false;
        for (Link link : this.reasonedDB.getChildren((LinkedObject)this.session.getObject("X:5"))) {
            if (!link.getType().equals(OBOProperty.DISJOINT_FROM) || !link.getChild().getID().equals("X:4") || !link.getParent().getID().equals("X:5")) continue;
            ok = true;
        }
        DirectLinkReasonerTest.assertTrue((boolean)ok);
    }

    public void testAllLinks() throws Exception {
        IdentifiedObject x = this.session.getObject("X:5");
        for (Link link : ((LinkedObject)x).getParents()) {
            System.out.println("ALINK:" + link);
        }
        for (Link link : this.reasonedDB.getParents((LinkedObject)x)) {
            System.out.println("ILINK:" + link);
        }
        this.testForIsA("X:1", "X:2");
    }
}

