/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.io.AuditedPrintStream;
import org.obo.annotation.datamodel.Annotation;
import org.obo.dataadapter.GOStyleAnnotationFileAdapter;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.test.GOAnnotationFileTest;

public class GOAnnotationFilePlusOntologyTest
extends GOAnnotationFileTest {
    protected static final Logger logger = Logger.getLogger(GOAnnotationFilePlusOntologyTest.class);
    String outPath;

    public GOAnnotationFilePlusOntologyTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"gene_assoc.test"};
        return Arrays.asList(files);
    }

    public Collection<String> getOntologyFilesToLoad() {
        String[] files = new String[]{"http://purl.org/obo/obo/GO"};
        return Arrays.asList(files);
    }

    @Override
    public void setUp() throws Exception {
        logger.info((Object)("Setting up: " + (Object)((Object)this)));
        this.session = this.getSessionFromResources(this.getOntologyFilesToLoad());
        GOStyleAnnotationFileAdapter adapter = new GOStyleAnnotationFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        for (String f : this.getFilesToLoad()) {
            config.getReadPaths().add(this.getResourcePath() + "/" + f);
            logger.info((Object)f);
        }
        config.setAllowDangling(true);
        config.setBasicSave(false);
        config.setFailFast(false);
        this.session.importSession(adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null), true);
        this.linkDatabase = new DefaultLinkDatabase(this.session);
    }

    public void testAnnotWithGO() {
        Collection<Annotation> annots = this.getAnnotationsForSubject("FB:FBgn0024177");
        for (Annotation annot : annots) {
            logger.info((Object)annot.getObject().getName());
        }
    }

    public static Test suite() {
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        GOAnnotationFilePlusOntologyTest.addTests(suite);
        return suite;
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new GOAnnotationFilePlusOntologyTest("testAnnot"));
        suite.addTest((Test)new GOAnnotationFilePlusOntologyTest("testAnnotWithGO"));
    }
}

