/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.test.AbstractReasonerTest;

public class HoldsOverChainReasonerTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(HoldsOverChainReasonerTest.class);

    public HoldsOverChainReasonerTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"positive_regulation_of_anti_apoptosis.obo"};
        return Arrays.asList(files);
    }

    public static Collection<String> getTests() {
        String[] tests = new String[]{};
        return Arrays.asList(tests);
    }

    public void testReasonedLinks() throws Exception {
        String PRoAA = "GO:0045768";
        String APOPTOSIS = "GO:0006915";
        String BCL2 = "MGI:MGI:88139";
        String IR = "indirectly_regulates";
        String INR = "indirectly_negatively_regulates";
        OBOProperty propIR = (OBOProperty)this.session.getObject(IR);
        for (List<OBOProperty> chain : propIR.getHoldsOverChains()) {
            logger.info(chain);
        }
        logger.info((Object)("all props: " + this.reasonedDB.getProperties()));
        this.testForLink(PRoAA, IR, APOPTOSIS);
        this.testForLink(PRoAA, INR, APOPTOSIS);
        for (Link link : this.reasonedDB.getParents((LinkedObject)this.session.getObject(BCL2))) {
            logger.info((Object)("Bcl2: " + link));
        }
        this.testForLink(BCL2, "indirect_negative_regulator_of", APOPTOSIS);
    }
}

