/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.obo.datamodel.OBOObject;
import org.obo.test.AbstractOBOTest;
import org.obo.util.IDMapper;

public class IDMapperTest
extends AbstractOBOTest {
    protected static final Logger logger = Logger.getLogger(IDMapperTest.class);
    IDMapper mapper;

    public IDMapperTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"testfile.1.0.obo"};
        return Arrays.asList(files);
    }

    public void testMapIDs() throws IOException {
        this.mapper = new IDMapper();
        this.mapper.setSession(this.session);
        this.mapper.addCategory("goslim_generic");
        Collection<OBOObject> mappedObjs = this.mapper.mapIdentifierViaCategories("GO:0005921", false);
        IDMapperTest.assertTrue((mappedObjs.size() == 1 ? 1 : 0) != 0);
        IDMapperTest.assertTrue((boolean)mappedObjs.iterator().next().getName().equals("plasma membrane"));
        this.mapper = new IDMapper();
        this.mapper.setSession(this.session);
        this.mapper.addCategory("goslim_generic");
        String inputPath = this.getResourcePath() + "/gene_assoc.test";
        Map<String, Collection<String>> e2ids = this.mapper.simpleAnnotationFileParse(inputPath);
        this.mapper.calcEntityCountByOboID(e2ids);
        Map<String, Integer> entityCountByOboIDMap = this.mapper.getEntityCountByOboIDMap();
        for (String id : entityCountByOboIDMap.keySet()) {
            OBOObject obj = (OBOObject)this.mapper.getSession().getObject(id);
            logger.info((Object)(entityCountByOboIDMap.get(id) + "\t" + id + "\t" + obj.getName()));
        }
    }
}

