/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.impl.OBOClassImpl;
import org.obo.identifier.IDWarning;
import org.obo.test.AbstractOBOTest;
import org.obo.util.IDMapper;

public class IDMapperTestWithIDLifecycle
extends AbstractOBOTest {
    protected static final Logger logger = Logger.getLogger(IDMapperTestWithIDLifecycle.class);
    IDMapper mapper;

    public IDMapperTestWithIDLifecycle(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"cellular_component.obo"};
        return Arrays.asList(files);
    }

    private void showObjs(Collection<OBOObject> objs) {
        for (OBOObject obj : objs) {
            logger.info((Object)(obj.getID() + " " + obj.getName()));
        }
    }

    private void showWarnings(Collection<IDWarning> warnings) {
        for (IDWarning warning : warnings) {
            logger.info((Object)("warning: " + warning));
        }
    }

    public void testMapIDs() throws IOException {
        this.mapper = new IDMapper();
        this.mapper.setSession(this.session);
        this.mapper.addCategory("goslim_generic");
        Collection<OBOObject> mappedObjs = this.mapper.mapIdentifierViaCategories("GO:0005921", false);
        IDMapperTestWithIDLifecycle.assertTrue((mappedObjs.size() == 1 ? 1 : 0) != 0);
        IDMapperTestWithIDLifecycle.assertTrue((boolean)mappedObjs.iterator().next().getName().equals("plasma membrane"));
        this.mapper = new IDMapper();
        this.mapper.setSession(this.session);
        this.mapper.addCategory("goslim_generic");
        mappedObjs = this.mapper.mapIdentifierViaCategories("GO:0005660", false);
        this.showWarnings(this.mapper.getWarnings());
        this.showObjs(mappedObjs);
        IDMapperTestWithIDLifecycle.assertTrue((mappedObjs.size() == 3 ? 1 : 0) != 0);
        IDMapperTestWithIDLifecycle.assertTrue((boolean)mappedObjs.contains(new OBOClassImpl("GO:0043234")));
        this.mapper = new IDMapper();
        this.mapper.setSession(this.session);
        this.mapper.addCategory("goslim_generic");
        this.mapper.setAutoReplaceConsiderTags(true);
        mappedObjs = this.mapper.mapIdentifierViaCategories("GO:0005645", false);
        this.showWarnings(this.mapper.getWarnings());
        this.showObjs(mappedObjs);
        IDMapperTestWithIDLifecycle.assertTrue((mappedObjs.size() == 4 ? 1 : 0) != 0);
        this.mapper = new IDMapper();
        this.mapper.setSession(this.session);
        this.mapper.addCategory("goslim_generic");
        this.mapper.setAutoReplaceConsiderTags(false);
        mappedObjs = this.mapper.mapIdentifierViaCategories("GO:0005645", false);
        this.showWarnings(this.mapper.getWarnings());
        this.showObjs(mappedObjs);
        IDMapperTestWithIDLifecycle.assertTrue((mappedObjs.size() == 0 ? 1 : 0) != 0);
    }
}

