/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.io.AuditedPrintStream;
import org.obo.identifier.LinkIDResolution;
import org.obo.identifier.LinkIDWarning;
import org.obo.identifier.UnresolvedIDsException;
import org.obo.test.AbstractOBOTest;
import org.obo.util.IDUtil;

public class IDUpdateTest
extends AbstractOBOTest {
    protected static final Logger logger = Logger.getLogger(IDUpdateTest.class);

    public IDUpdateTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"id_updates.obo"};
        return Arrays.asList(files);
    }

    public static Collection<String> getTests() {
        String[] tests = new String[]{};
        return Arrays.asList(tests);
    }

    public void testLinks() throws Exception {
        LinkedList<LinkIDResolution> resolutions = new LinkedList<LinkIDResolution>();
        block2: while (true) {
            try {
                IDUtil.updateIDs(this.session, resolutions, true);
            }
            catch (UnresolvedIDsException ex) {
                Iterator<LinkIDWarning> iterator = ex.getWarnings().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    LinkIDWarning warning = iterator.next();
                    resolutions.addAll(warning.getResolutions());
                }
            }
            break;
        }
        this.testForIsA("A", "D");
        this.testForIsA("A", "E");
        this.testForIsA("A", "Z");
    }

    public static Test suite() {
        logger.info((Object)"foo");
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        IDUpdateTest.addTests(suite);
        return suite;
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new IDUpdateTest("testLinks"));
    }
}

