/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.bbop.dataadapter.CancelledAdapterException;
import org.obo.dataadapter.OBOConstants;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.dataadapter.OBOSerializer;
import org.obo.dataadapter.OBO_1_2_Serializer;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.PropertyValue;
import org.obo.filters.Filter;
import org.obo.test.AbstractOBOTest;

public class ImportTest
extends AbstractOBOTest {
    public ImportTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        return Collections.singleton("import_test/a.obo");
    }

    public void testLoad() {
        OBOClass one = (OBOClass)this.session.getObject("A:0001");
        ImportTest.assertNotNull((Object)one);
        OBOClass two = (OBOClass)this.session.getObject("B:0002");
        ImportTest.assertNotNull((Object)two);
        OBOClass three = (OBOClass)this.session.getObject("C:0003");
        ImportTest.assertNotNull((Object)three);
        Collection<PropertyValue> propertyValues = this.session.getPropertyValues();
        ImportTest.assertEquals((int)2, (int)propertyValues.size());
        for (PropertyValue propertyValue : propertyValues) {
            String p = propertyValue.getProperty();
            String v = propertyValue.getValue();
            if ("import".equals(p)) {
                ImportTest.assertEquals((String)"http://purl.obolibrary.org/obo/foo.owl", (String)v);
                continue;
            }
            if ("ontology".equals(p)) {
                ImportTest.assertEquals((String)"A", (String)v);
                continue;
            }
            ImportTest.fail((String)("Unexpected property" + p));
        }
        ImportTest.assertEquals((String)"namespace_a", (String)this.session.getDefaultNamespace().getID());
    }

    public void testWrite() throws Exception {
        OBO_1_2_Serializer serializer = new OBO_1_2_Serializer();
        OBOSerializationEngine engine = new OBOSerializationEngine(){

            @Override
            public void writeFile(OBOSession session, Filter objectFilter, Filter linkFilter, HashSet<OBOConstants.TagMapping> tagFilter, OBOSerializer serializer, PrintStream stream, OBOSerializationEngine.FilteredPath filteredPath) throws IOException, CancelledAdapterException {
                this.setSerializer(serializer);
                super.writeFile(session, objectFilter, linkFilter, tagFilter, serializer, stream, filteredPath);
            }
        };
        Filter objectFilter = null;
        Filter linkFilter = null;
        HashSet<OBOConstants.TagMapping> tagFilter = null;
        serializer.setEngine(engine);
        PrintStream stream = System.out;
        OBOSerializationEngine.FilteredPath filteredPath = new OBOSerializationEngine.FilteredPath();
        filteredPath.setPath("foo");
        engine.writeFile(this.session, objectFilter, linkFilter, tagFilter, serializer, stream, filteredPath);
    }
}

