/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.filters.IsImpliedLinkCriterion;
import org.obo.filters.LinkFilter;
import org.obo.filters.LinkFilterFactory;
import org.obo.filters.ObjectFilter;
import org.obo.filters.ObjectFilterFactory;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.test.AbstractReasonerTest;
import org.obo.util.TermUtil;

public class IntersectionCamphorCatabolismExampleTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(IntersectionCamphorCatabolismExampleTest.class);

    public IntersectionCamphorCatabolismExampleTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"camphor_catabolism.obo"};
        return Arrays.asList(files);
    }

    public static Collection<String> getTests() {
        String[] tests = new String[]{};
        return Arrays.asList(tests);
    }

    public void testReasonedLinks() throws Exception {
        String CAMPHOR_CATABOLISM = "GO:0019383";
        String XENOBIOTIC_CATABOLISM = "GO:0042178";
        String RCAMPHOR = "CHEBI:15396";
        String CAMPHOR = "CHEBI:36773";
        String CAMPHORS = "CHEBI:22996";
        String XENOBIOTIC = "CHEBI:35703";
        LinkedObject camcat = (LinkedObject)this.session.getObject(CAMPHOR_CATABOLISM);
        for (Link link : this.reasonedDB.getParents(camcat)) {
            if (!link.getType().equals(OBOProperty.IS_A)) continue;
            logger.info((Object)("  reasonedDB:" + link));
        }
        for (Link link : this.trimmedDB.getParents(camcat)) {
            if (!link.getType().equals(OBOProperty.IS_A)) continue;
            logger.info((Object)("  trimmedDB:" + link));
        }
        this.testForIsA(RCAMPHOR, CAMPHOR);
        this.testForIsA("CHEBI:24974", "CHEBI:23367");
        this.testForIsA("CHEBI:33304", "CHEBI:33675");
        this.testForIsA(CAMPHOR_CATABOLISM, "GO:0009056");
        boolean gotXPLink = false;
        boolean gotPlainLink = false;
        for (Link link : this.getLinks(CAMPHOR_CATABOLISM, OBOProperty.IS_A.getID(), "GO:0009056")) {
            logger.info((Object)("genus link: " + link));
            if (TermUtil.isIntersection(link)) {
                gotXPLink = true;
                continue;
            }
            gotPlainLink = true;
        }
        IntersectionCamphorCatabolismExampleTest.assertTrue((boolean)gotXPLink);
        IntersectionCamphorCatabolismExampleTest.assertTrue((boolean)gotPlainLink);
        this.testForIsA(CAMPHOR_CATABOLISM, XENOBIOTIC_CATABOLISM);
        this.testForLink("testA", "part_of", "testB");
        this.testForLink("testA", "part_of", "testC");
        this.testForLink("GO:0019383", "UCDHSC:results_in_division_of", "CHEBI:35703");
        this.testForIsAInTrimmed(CAMPHOR_CATABOLISM, XENOBIOTIC_CATABOLISM);
        this.testForLink("GO:0019383", "UCDHSC:results_in_division_of", "CHEBI:35703");
        Link link = this.reasonedDB.hasRelationship((LinkedObject)this.session.getObject(RCAMPHOR), OBOProperty.IS_A, (LinkedObject)this.session.getObject(CAMPHOR));
        HistoryItem item = new DeleteLinkHistoryItem(link);
        this.session.getOperationModel().apply(item);
        this.reasonedDB.removeLink(link);
        this.testForNoIsA(CAMPHOR_CATABOLISM, XENOBIOTIC_CATABOLISM);
        item = new CreateLinkHistoryItem(link);
        this.session.getOperationModel().apply(item);
        this.reasonedDB.addLink(link);
        this.testForIsA(CAMPHOR_CATABOLISM, XENOBIOTIC_CATABOLISM);
        LinkFilterFactory lff = new LinkFilterFactory();
        ObjectFilterFactory off = new ObjectFilterFactory();
        LinkFilter lfilter = (LinkFilter)lff.createNewFilter();
        ObjectFilter ofilter = (ObjectFilter)off.createNewFilter();
        ofilter = (ObjectFilter)off.createNewFilter();
        ofilter.setCriterion(new IsImpliedLinkCriterion());
        lfilter = (LinkFilter)lff.createNewFilter();
        lfilter.setAspect(4);
        lfilter.setFilter(ofilter);
        Collection<Link> matches = this.filterReasonedLinks(lfilter);
        logger.info((Object)(lfilter + " N_matches: " + matches.size()));
        IntersectionCamphorCatabolismExampleTest.assertTrue((matches.size() > 0 ? 1 : 0) != 0);
        this.writeTempTrimmedReasonedOBOFile();
    }
}

