/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.io.AuditedPrintStream;
import org.obo.annotation.datamodel.Annotation;
import org.obo.dataadapter.GOStyleAnnotationFileAdapter;
import org.obo.dataadapter.OBDSQLDatabaseAdapter;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.datamodel.impl.OBOClassImpl;
import org.obo.datamodel.impl.OBOSessionImpl;
import org.obo.reasoner.impl.ForwardChainingReasoner;
import org.obo.test.AbstractAnnotationTest;
import org.obo.util.AnnotationUtil;

public class OBDAnnotationSaveTest
extends AbstractAnnotationTest {
    protected static final Logger logger = Logger.getLogger(OBDAnnotationSaveTest.class);
    String jdbcPath = "jdbc:postgresql://localhost:5432/obdtest";

    public OBDAnnotationSaveTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"gene_assoc.test"};
        return Arrays.asList(files);
    }

    @Override
    public void setUp() throws Exception {
        ForwardChainingReasoner.checkRecache = false;
        GOStyleAnnotationFileAdapter adapter = new GOStyleAnnotationFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        for (String f : this.getFilesToLoad()) {
            config.getReadPaths().add(this.getResourcePath() + "/" + f);
            logger.info((Object)f);
        }
        config.setAllowDangling(true);
        config.setBasicSave(false);
        config.setFailFast(false);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        this.testForAnnotationAssignedBy("FB:FBgn0061475", "GO:0005843", "FlyBase");
        OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration wconfig = new OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration();
        wconfig.setSaveImplied(false);
        wconfig.setWritePath(this.jdbcPath);
        OBDSQLDatabaseAdapter wadapter = new OBDSQLDatabaseAdapter();
        wadapter.doOperation(OBOAdapter.WRITE_ONTOLOGY, (AdapterConfiguration)wconfig, this.session);
    }

    public void testHasLoaded() throws DataAdapterException, SQLException {
        logger.info((Object)"reading");
        OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration wconfig = new OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration();
        wconfig.setReadPath(this.jdbcPath);
        OBDSQLDatabaseAdapter wadapter = new OBDSQLDatabaseAdapter();
        this.session = wadapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)wconfig, null);
        logger.info((Object)("read: " + this.session));
        this.testForName("FB:FBgn0061475", "18SrRNA");
        Collection<Annotation> annots = AnnotationUtil.getAnnotations(this.session);
        logger.info((Object)("N annots:" + annots.size()));
        this.testForAnnotation("FB:FBgn0061475", "GO:0005843");
        this.testForAnnotation("FB:FBgn0024177", "GO:0005921");
        this.testForNamespace("FB:FBgn0061475", "FB");
        this.testForLink("FB:FBgn0061475", "has_taxon", "taxon:7227");
        this.testForAnnotationPublication("FB:FBgn0061475", "GO:0005843", "FB:FBrf0121292");
        this.testForAnnotationWithEvidenceCode("FB:FBgn0061475", "GO:0005843", "ISS");
        this.testForAnnotationAssignedBy("FB:FBgn0061475", "GO:0005843", "FlyBase");
        this.session = new OBOSessionImpl();
        annots = wadapter.fetchAnnotationsByObject(this.session, new OBOClassImpl("GO:0005843"));
        logger.info((Object)("N matching annots:" + annots.size()));
        OBDAnnotationSaveTest.assertTrue((annots.size() > 0 ? 1 : 0) != 0);
    }

    public void testQuery() throws SQLException, ClassNotFoundException {
        OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration wconfig = new OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration();
        wconfig.setReadPath(this.jdbcPath);
        OBDSQLDatabaseAdapter wadapter = new OBDSQLDatabaseAdapter();
        wadapter.setConfiguration(wconfig);
        wadapter.connect();
        this.session = new OBOSessionImpl();
        Collection<Annotation> annots = wadapter.fetchAnnotationsByObject(this.session, new OBOClassImpl("GO:0005843"));
        logger.info((Object)("N matching annots:" + annots.size()));
        for (Annotation annot : annots) {
            logger.info((Object)("  match:" + annot));
        }
        OBDAnnotationSaveTest.assertTrue((annots.size() > 0 ? 1 : 0) != 0);
    }

    public void testNamespaceFilteredLoad() throws DataAdapterException {
        OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration config = new OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration();
        OBDSQLDatabaseAdapter adapter = new OBDSQLDatabaseAdapter();
        logger.info((Object)"reading ns filtered");
        config.addNamespace("MGI");
        config.setReadPath(this.jdbcPath);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        logger.info((Object)("read: " + this.session));
        Collection<Annotation> annots = AnnotationUtil.getAnnotations(this.session);
        for (Annotation annot : annots) {
            logger.info((Object)(annot.getSubject() + "-----" + annot.getObject()));
        }
        logger.info((Object)("N annots:" + annots.size()));
        this.testFileSave("mgi-filtered");
        this.testForName("MGI:MGI:95723", "Gjb5");
        this.testForAnnotation("MGI:MGI:95723", "GO:0016020");
        this.testForAnnotationAssignedBy("MGI:MGI:95723", "GO:0016020", "UniProt");
        this.testNotPresent("FB:FBgn0061475");
    }

    public void testFileSave(String base) throws DataAdapterException {
        OBOFileAdapter fileAdapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration fileConfig = new OBOFileAdapter.OBOAdapterConfiguration();
        OBOSerializationEngine.FilteredPath path = new OBOSerializationEngine.FilteredPath();
        path.setUseSessionReasoner(false);
        path.setPath(base + ".obo");
        fileConfig.getSaveRecords().add(path);
        fileConfig.setBasicSave(false);
        fileConfig.setSerializer("OBO_1_2");
        fileAdapter.doOperation(OBOAdapter.WRITE_ONTOLOGY, (AdapterConfiguration)fileConfig, this.session);
    }

    public static Test suite() {
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        OBDAnnotationSaveTest.addTests(suite);
        return suite;
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new OBDAnnotationSaveTest("testHasLoaded"));
        suite.addTest((Test)new OBDAnnotationSaveTest("testNamespaceFilteredLoad"));
        suite.addTest((Test)new OBDAnnotationSaveTest("testQuery"));
    }
}

