/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.io.AuditedPrintStream;
import org.obo.annotation.datamodel.Annotation;
import org.obo.dataadapter.OBDSQLDatabaseAdapter;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.impl.ForwardChainingReasoner;
import org.obo.test.AbstractAnnotationTest;
import org.obo.util.AnnotationUtil;
import org.obo.util.TermUtil;

public class OBDPostcompSaveTest
extends AbstractAnnotationTest {
    protected static final Logger logger = Logger.getLogger(OBDPostcompSaveTest.class);
    String jdbcPath = "jdbc:postgresql://localhost:5432/obdtest";

    protected OBDPostcompSaveTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"sox9b_zfin.obo"};
        return Arrays.asList(files);
    }

    @Override
    public void setUp() throws Exception {
        logger.info((Object)"foo");
        logger.info((Object)("Setting up: " + (Object)((Object)this)));
        ForwardChainingReasoner.checkRecache = false;
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        for (String f : this.getFilesToLoad()) {
            config.getReadPaths().add(this.getResourcePath() + "/" + f);
            logger.info((Object)f);
        }
        config.setAllowDangling(true);
        config.setBasicSave(false);
        config.setFailFast(false);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        this.testPostCompClasses();
        OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration wconfig = new OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration();
        wconfig.setSaveImplied(false);
        wconfig.setWritePath(this.jdbcPath);
        OBDSQLDatabaseAdapter wadapter = new OBDSQLDatabaseAdapter();
        wadapter.doOperation(OBOAdapter.WRITE_ONTOLOGY, (AdapterConfiguration)wconfig, this.session);
    }

    public void testPostCompClasses() {
        LinkedObject obj = (LinkedObject)this.session.getObject("PATO:0000462^during(ZFIN:ZDB-STAGE-010723-35)^OBO_REL:inheres_in(ZFA:0000051)");
        for (Link link : obj.getParents()) {
            logger.info((Object)("  " + TermUtil.isIntersection(link) + " " + link.getType() + " " + link.getParent()));
        }
    }

    public void testHasLoaded() throws DataAdapterException {
        logger.info((Object)"reading");
        OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration wconfig = new OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration();
        wconfig.setReadPath(this.jdbcPath);
        OBDSQLDatabaseAdapter wadapter = new OBDSQLDatabaseAdapter();
        this.session = wadapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)wconfig, null);
        logger.info((Object)("read: " + this.session));
        this.testForName("ZFIN:ZDB-GENO-070219-2", "Df(LG03:sox8,sox9b)b971/b971;sox9a<sup>hi1134Tg/hi1134Tg</sup>");
        this.testInstanceType("ZFIN:ZDB-GENO-070219-2", "SO:0001027");
        Collection<Annotation> annots = AnnotationUtil.getAnnotations(this.session);
        logger.info((Object)("N annots:" + annots.size()));
        for (Annotation annot : annots) {
            logger.info((Object)annot);
        }
        IdentifiedObject ae = this.session.getObject("ZFIN:ZDB-GENO-070219-2");
        Collection<Annotation> annots2 = this.getAnnotationsForSubject(ae);
        boolean assignedByOk = false;
        boolean descFound = false;
        Annotation match = null;
        for (Annotation annot : annots2) {
            LinkedObject obj = annot.getObject();
            for (String desc : annot.getDescriptions()) {
                System.out.println("desc=" + desc);
                descFound = true;
            }
            boolean genusFound = false;
            boolean diffFound = false;
            for (Link link : obj.getParents()) {
                if (!TermUtil.isIntersection(link)) continue;
                String exprObj = link.getParent().getID();
                if (link.getType().equals(OBOProperty.IS_A) && exprObj.equals("PATO:0000462")) {
                    genusFound = true;
                    continue;
                }
                if (!link.getType().getID().equals("OBO_REL:inheres_in") || !exprObj.equals("ZFA:0000051")) continue;
                diffFound = true;
            }
            if (!(genusFound & diffFound)) continue;
            logger.info((Object)("* assby=" + annot.getAssignedBy() + " ns=" + annot.getNamespace()));
            if (annot.getAssignedBy() != null && annot.getAssignedBy().getID().equals("ZFIN")) {
                assignedByOk = true;
            }
            match = annot;
        }
        OBDPostcompSaveTest.assertTrue((boolean)descFound);
        OBDPostcompSaveTest.assertTrue((match != null ? 1 : 0) != 0);
        logger.info((Object)("assby=" + match.getAssignedBy()));
        logger.info((Object)("annotation ns=" + match.getNamespace()));
        OBDPostcompSaveTest.assertTrue((boolean)match.getNamespace().getID().equals("zfin"));
        OBDPostcompSaveTest.assertTrue((boolean)match.getAssignedBy().getID().equals("ZFIN"));
        OBDPostcompSaveTest.assertTrue((boolean)assignedByOk);
    }

    public void testNamespaceFilteredLoad() throws DataAdapterException {
        OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration config = new OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration();
        OBDSQLDatabaseAdapter adapter = new OBDSQLDatabaseAdapter();
        logger.info((Object)"reading ns filtered");
        config.addNamespace("MGI");
        config.setReadPath(this.jdbcPath);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        logger.info((Object)("read: " + this.session));
        Collection<Annotation> annots = AnnotationUtil.getAnnotations(this.session);
        for (Annotation annot : annots) {
            logger.info((Object)(annot.getSubject() + "-----" + annot.getObject()));
        }
        logger.info((Object)("N annots:" + annots.size()));
        this.testFileSave("mgi-filtered");
        this.testForName("MGI:MGI:95723", "Gjb5");
        this.testForAnnotation("MGI:MGI:95723", "GO:0016020");
        this.testForAnnotationAssignedBy("MGI:MGI:95723", "GO:0016020", "UniProt");
        this.testNotPresent("FB:FBgn0061475");
    }

    public void testFileSave(String base) throws DataAdapterException {
        OBOFileAdapter fileAdapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration fileConfig = new OBOFileAdapter.OBOAdapterConfiguration();
        OBOSerializationEngine.FilteredPath path = new OBOSerializationEngine.FilteredPath();
        path.setUseSessionReasoner(false);
        path.setPath(base + ".obo");
        fileConfig.getSaveRecords().add(path);
        fileConfig.setBasicSave(false);
        fileConfig.setSerializer("OBO_1_2");
        fileAdapter.doOperation(OBOAdapter.WRITE_ONTOLOGY, (AdapterConfiguration)fileConfig, this.session);
    }

    public static Test suite() {
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        OBDPostcompSaveTest.addTests(suite);
        return suite;
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new OBDPostcompSaveTest("testHasLoaded"));
    }
}

