/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.filters.EqualsComparison;
import org.obo.filters.Filter;
import org.obo.filters.IsCompleteLinkCriterion;
import org.obo.filters.IsImpliedLinkCriterion;
import org.obo.filters.LinkFilter;
import org.obo.filters.LinkFilterFactory;
import org.obo.filters.ObjectFilter;
import org.obo.filters.ObjectFilterFactory;
import org.obo.filters.RegexpComparison;
import org.obo.filters.SubsetSearchCriterion;
import org.obo.test.AbstractReasonerTest;
import org.obo.util.FilterUtil;

public class ReasonerFilterTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(ReasonerFilterTest.class);
    LinkFilterFactory lff = new LinkFilterFactory();
    ObjectFilterFactory off = new ObjectFilterFactory();

    public ReasonerFilterTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"caro.obo", "bone.obo"};
        return Arrays.asList(files);
    }

    public Collection<IdentifiedObject> filterObjects(ObjectFilter filter) {
        LinkedList<IdentifiedObject> matches = new LinkedList<IdentifiedObject>();
        for (IdentifiedObject io : this.session.getObjects()) {
            if (!filter.satisfies(io)) continue;
            matches.add(io);
        }
        logger.info((Object)(filter + " N_matches: " + matches.size()));
        return matches;
    }

    @Override
    public Collection<Link> filterLinks(Filter filter) {
        LinkedList<Link> matches = new LinkedList<Link>();
        for (IdentifiedObject io : this.session.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            for (Link link : this.reasonedDB.getParents(lo)) {
                if (!filter.satisfies(link)) continue;
                matches.add(link);
            }
        }
        return matches;
    }

    public void testSubsetFilter() {
        ObjectFilter filter = (ObjectFilter)this.off.createNewFilter();
        SubsetSearchCriterion c = new SubsetSearchCriterion();
        filter.setCriterion(c);
        filter.setValue("test");
        Collection<IdentifiedObject> matches = this.filterObjects(filter);
        ReasonerFilterTest.assertTrue((matches.size() == 2 ? 1 : 0) != 0);
    }

    public void testSearch() throws Exception {
        ObjectFilter filter = (ObjectFilter)this.off.createNewFilter();
        RegexpComparison c = new RegexpComparison();
        filter.setComparison(c);
        filter.setValue(".*epithel.*");
        Collection<IdentifiedObject> matches = this.filterObjects(filter);
        ReasonerFilterTest.assertTrue((matches.size() > 8 ? 1 : 0) != 0);
        filter.setComparison(c);
        filter.setValue("endochondral_bone");
        matches = this.filterObjects(filter);
        ReasonerFilterTest.assertTrue((matches.size() == 1 ? 1 : 0) != 0);
        filter = (ObjectFilter)this.off.createNewFilter();
        filter.setCriterion(new IsCompleteLinkCriterion());
        matches = this.filterObjects(filter);
        ReasonerFilterTest.assertTrue((matches.size() == 0 ? 1 : 0) != 0);
    }

    public void testLinkFilter() throws Exception {
        LinkFilter lfilter = this.getLinkFilter("CARO:0000003", 3);
        Collection<Link> matches = this.filterLinks(lfilter);
        logger.info((Object)(lfilter + " N_matches: " + matches.size()));
        for (Link match : matches) {
            logger.info((Object)("  Match to 000003: " + match));
        }
        ReasonerFilterTest.assertTrue((matches.size() == 37 ? 1 : 0) != 0);
    }

    public void testIsImpliedFilter() {
        LinkFilter lfilter = (LinkFilter)this.lff.createNewFilter();
        ObjectFilter ofilter = (ObjectFilter)this.off.createNewFilter();
        ofilter = (ObjectFilter)this.off.createNewFilter();
        ofilter.setCriterion(new IsImpliedLinkCriterion());
        lfilter = (LinkFilter)this.lff.createNewFilter();
        lfilter.setAspect(4);
        lfilter.setFilter(ofilter);
        Collection<Link> matches = this.filterLinks(lfilter);
        logger.info((Object)(lfilter + " N_implied_links: " + matches.size()));
        ReasonerFilterTest.assertTrue((matches.size() > 0 ? 1 : 0) != 0);
    }

    public void testIsIntersectionFilter() {
        LinkFilter lfilter = (LinkFilter)this.lff.createNewFilter();
        ObjectFilter ofilter = (ObjectFilter)this.off.createNewFilter();
        ofilter = (ObjectFilter)this.off.createNewFilter();
        ofilter.setCriterion(new IsCompleteLinkCriterion());
        lfilter = (LinkFilter)this.lff.createNewFilter();
        lfilter.setAspect(4);
        lfilter.setFilter(ofilter);
        Collection<Link> matches = this.filterLinks(lfilter);
        logger.info((Object)(lfilter + " N_matches: " + matches.size()));
        ReasonerFilterTest.assertTrue((matches.size() == 2 ? 1 : 0) != 0);
    }

    public void testLinkFilterFindParents() throws Exception {
        LinkFilter lfilter = this.getLinkFilter("CARO:0000003", 1);
        Collection<Link> matches = this.filterLinks(lfilter);
        logger.info((Object)(lfilter + " N_matches: " + matches.size()));
        ReasonerFilterTest.assertTrue((matches.size() == 2 ? 1 : 0) != 0);
    }

    public void testLinkFilterConstrainBoth() throws Exception {
        LinkFilter lfilter1 = this.getLinkFilter("CARO:0000003", 1);
        LinkFilter lfilter2 = this.getLinkFilter("CARO:0000006", 3);
        Filter<Link> filter = FilterUtil.mergeFilters(lfilter1, lfilter2);
        Collection<Link> matches = this.filterLinks(filter);
        logger.info((Object)(filter + " N_matches: " + matches.size()));
        ReasonerFilterTest.assertTrue((matches.size() == 1 ? 1 : 0) != 0);
    }

    private LinkFilter getLinkFilter(String id, int aspect) {
        LinkFilter lfilter = (LinkFilter)this.lff.createNewFilter();
        ObjectFilter ofilter = (ObjectFilter)this.off.createNewFilter();
        EqualsComparison c = new EqualsComparison();
        ofilter.setComparison(c);
        ofilter.setValue(id);
        lfilter.setFilter(ofilter);
        lfilter.setAspect(aspect);
        return lfilter;
    }
}

