/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.impl.TrimmedLinkDatabase;
import org.obo.test.AbstractReasonerTest;

public class ReasonerReflexiveRelationTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(ReasonerReflexiveRelationTest.class);

    public ReasonerReflexiveRelationTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"carx.obo"};
        return Arrays.asList(files);
    }

    public void testFilter() {
        boolean hasReflexive = false;
        Collection<Link> rlinks = this.reasonedDB.getLinks(OBOProperty.IS_A);
        for (Link link : rlinks) {
            System.out.println("REASONER:" + link);
            if (!link.getChild().equals(link.getParent())) continue;
            hasReflexive = true;
        }
        TrimmedLinkDatabase tdb = new TrimmedLinkDatabase(this.reasonedDB);
        Collection<Link> links = tdb.getLinks(OBOProperty.IS_A);
        for (Link link : links) {
            System.out.println("TDB:" + link);
            if (!link.getChild().equals(link.getParent())) continue;
            hasReflexive = true;
        }
        ReasonerReflexiveRelationTest.assertTrue((!hasReflexive ? 1 : 0) != 0);
        LinkedObject car = (LinkedObject)this.session.getObject("TEST:0000001");
        for (Link link : this.reasonedDB.getChildren(car)) {
            System.out.println("RDB-children:" + link);
            if (!link.getChild().equals(car)) continue;
            hasReflexive = true;
        }
        for (Link link : tdb.getChildren(car)) {
            System.out.println("TDB-children:" + link);
            if (!link.getChild().equals(car)) continue;
            hasReflexive = true;
        }
        ReasonerReflexiveRelationTest.assertTrue((!hasReflexive ? 1 : 0) != 0);
    }
}

