/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.io.AuditedPrintStream;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.datamodel.impl.DefaultOperationModel;
import org.obo.history.CompletesHistoryItem;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.history.StringRelationship;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.impl.ForwardChainingReasoner;
import org.obo.reasoner.impl.ReasonerOperationModel;

public class ReasonerTest
extends TestCase {
    protected static final Logger logger = Logger.getLogger(ReasonerTest.class);
    protected OBOSession session;
    public static final String SO_XP_PATH = "test_resources/so-xp.obo";

    public ReasonerTest(String name) {
        super(name);
    }

    public static Test suite() {
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new ReasonerTest("testBrokenAddLink"));
        suite.addTest((Test)new ReasonerTest("testBrokenAddLink2"));
        suite.addTest((Test)new ReasonerTest("testBrokenCompleteChange"));
        for (int i = 0; i < 200; ++i) {
            suite.addTest((Test)new ReasonerTest("testAddNewLink"));
            suite.addTest((Test)new ReasonerTest("testCompleteLinkChange"));
            suite.addTest((Test)new ReasonerTest("testLinkDel"));
            suite.addTest((Test)new ReasonerTest("testCompleteLinkDel"));
        }
        return suite;
    }

    public void setUp() throws Exception {
        ForwardChainingReasoner.checkRecache = false;
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add(SO_XP_PATH);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
    }

    public void tearDown() throws Exception {
        this.session = null;
    }

    public void testCompleteLinkDel() throws Exception {
        LinkedList<DeleteLinkHistoryItem> items = new LinkedList<DeleteLinkHistoryItem>();
        for (int i = 0; i < 1; ++i) {
            Link link = this.getRandomCompleteLink();
            if (link == null) {
                System.err.println("can't do complete link test; no complete links in ontology");
                return;
            }
            items.add(new DeleteLinkHistoryItem(link));
        }
        this.doLinkTest(items);
    }

    public void testLinkDel() throws Exception {
        LinkedList<DeleteLinkHistoryItem> items = new LinkedList<DeleteLinkHistoryItem>();
        for (int i = 0; i < 5; ++i) {
            Link link = this.getRandomLink();
            items.add(new DeleteLinkHistoryItem(link));
        }
        this.doLinkTest(items);
    }

    public void testBrokenCompleteChange() throws Exception {
        StringRelationship sr = new StringRelationship("SO:0000913", "has_quality", "SO:0000756");
        CompletesHistoryItem item = new CompletesHistoryItem(sr, false);
        LinkedList<CompletesHistoryItem> items = new LinkedList<CompletesHistoryItem>();
        items.add(item);
        this.doLinkTest(items);
    }

    public void testBrokenLinkDel() throws Exception {
        LinkedList<DeleteLinkHistoryItem> items = new LinkedList<DeleteLinkHistoryItem>();
        items.add(new DeleteLinkHistoryItem(new StringRelationship("SO:0000665", "has_quality", "SO:0000878", true)));
        this.doLinkTest(items);
    }

    public void testBrokenAddLink() throws Exception {
        LinkedList<CreateLinkHistoryItem> items = new LinkedList<CreateLinkHistoryItem>();
        items.add(new CreateLinkHistoryItem("SO:0000895", "OBO_REL:is_a", "SO:0000507"));
        items.add(new CreateLinkHistoryItem("SO:0000331", "OBO_REL:is_a", "SO:0000360"));
        items.add(new CreateLinkHistoryItem("SO:0000816", "OBO_REL:is_a", "SO:0000515"));
        items.add(new CreateLinkHistoryItem("SO:2000061", "OBO_REL:is_a", "SO:0000466"));
        items.add(new CreateLinkHistoryItem("SO:0000877", "OBO_REL:is_a", "SO:1000101"));
        this.doLinkTest(items);
    }

    public void testBrokenAddLink2() throws Exception {
        LinkedList<CreateLinkHistoryItem> items = new LinkedList<CreateLinkHistoryItem>();
        items.add(new CreateLinkHistoryItem("SO:1000075", "OBO_REL:is_a", "SO:0000140"));
        items.add(new CreateLinkHistoryItem("SO:0000690", "OBO_REL:is_a", "SO:1000083"));
        items.add(new CreateLinkHistoryItem("SO:0000677", "OBO_REL:is_a", "SO:0000574"));
        items.add(new CreateLinkHistoryItem("SO:1000052", "OBO_REL:is_a", "SO:0000470"));
        items.add(new CreateLinkHistoryItem("SO:0000235", "OBO_REL:is_a", "SO:1000036"));
        this.doLinkTest(items);
    }

    public void testCompleteLinkChange() throws Exception {
        Link link = this.getRandomLink();
        logger.info((Object)("doing check on " + link));
        this.doLinkTest(link, new CompletesHistoryItem((OBORestriction)link));
    }

    public void testAddNewLink() throws Exception {
        LinkedList<CreateLinkHistoryItem> items = new LinkedList<CreateLinkHistoryItem>();
        for (int i = 0; i < 5; ++i) {
            Link link = this.getRandomLink();
            Link link2 = this.getRandomLink();
            logger.info((Object)("creating link " + link2.getChild() + " -" + link.getType() + "-> " + link.getParent()));
            items.add(new CreateLinkHistoryItem(link2.getChild(), link.getType(), link.getParent()));
        }
        this.doLinkTest(items);
    }

    public void doLinkTest(Link link) throws Exception {
        this.doLinkTest(link, new DeleteLinkHistoryItem(link));
    }

    public void doLinkTest(Link link, HistoryItem item) throws Exception {
        this.doLinkTest(item);
    }

    public void doLinkTest(HistoryItem item) throws Exception {
        this.doLinkTest(Collections.singleton(item));
    }

    public void doLinkTest(Collection items) throws Exception {
        long time;
        ForwardChainingReasoner.weirdLink = null;
        ForwardChainingReasoner.checkRecache = false;
        DefaultLinkDatabase linkDatabase = new DefaultLinkDatabase(this.session);
        ForwardChainingReasoner reasonedDB = new ForwardChainingReasoner();
        reasonedDB.setLinkDatabase(linkDatabase);
        ForwardChainingReasoner reasoner = reasonedDB;
        ReasonerOperationModel opModel = new ReasonerOperationModel(reasoner);
        opModel.setSession(this.session);
        reasoner.recache();
        DefaultOperationModel model = new DefaultOperationModel();
        model.setSession(this.session);
        long incrementalTime = 0L;
        Iterator<Object> it = items.iterator();
        int i = 0;
        while (it.hasNext()) {
            HistoryItem item = (HistoryItem)it.next();
            logger.info((Object)("applying " + item));
            model.apply(item);
            time = System.currentTimeMillis();
            opModel.apply(item);
            incrementalTime += System.currentTimeMillis() - time;
            ++i;
        }
        LinkedHashMap objCache = new LinkedHashMap();
        for (IdentifiedObject io : this.session.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            LinkedHashSet<Link> dynamicParents = new LinkedHashSet<Link>();
            dynamicParents.addAll(reasoner.getParents(lo));
            objCache.put(lo, dynamicParents);
        }
        time = System.currentTimeMillis();
        reasoner.recache();
        logger.info((Object)("recache time    : " + (System.currentTimeMillis() - time) + " ms"));
        logger.info((Object)("incremental time: " + incrementalTime + " ms"));
        String failureMessage = "";
        it = this.session.getObjects().iterator();
        int i2 = 0;
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (io instanceof LinkedObject) {
                LinkedObject lo = (LinkedObject)io;
                Set dynamicParents = (Set)objCache.get(lo);
                LinkedList dynamicParentsCopy = new LinkedList(dynamicParents);
                LinkedHashSet<Link> cacheParents = new LinkedHashSet<Link>();
                Collection<Link> fullReasonerParents = reasoner.getParents(lo);
                cacheParents.addAll(fullReasonerParents);
                cacheParents.removeAll(dynamicParents);
                if (cacheParents.size() > 0) {
                    failureMessage = failureMessage.length() > 0 ? failureMessage + "\n" : "On application of history items " + items + "...\n";
                    String parentsMessage = "";
                    Iterator it2 = cacheParents.iterator();
                    boolean first = true;
                    Link parent = null;
                    while (it2.hasNext()) {
                        parent = (Link)it2.next();
                        if (first) {
                            first = false;
                        } else {
                            parentsMessage = parentsMessage + ", ";
                        }
                        parentsMessage = parentsMessage + parent.toString();
                        for (Explanation exp : reasoner.getExplanations(parent)) {
                            parentsMessage = parentsMessage + "\n         exp = " + exp;
                        }
                    }
                    OBOFileAdapter adapter = new OBOFileAdapter();
                    OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
                    config.getReadPaths().add(SO_XP_PATH);
                    OBOSession tempSession = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
                    DefaultOperationModel tempModel = new DefaultOperationModel();
                    tempModel.setSession(tempSession);
                    it = items.iterator();
                    while (it.hasNext()) {
                        HistoryItem item = (HistoryItem)it.next();
                        logger.info((Object)("reapplying " + item));
                        tempModel.apply(item);
                    }
                    DefaultLinkDatabase tempLinkDatabase = new DefaultLinkDatabase(tempSession);
                    ForwardChainingReasoner tempReasonedDB = new ForwardChainingReasoner();
                    tempReasonedDB.setLinkDatabase(tempLinkDatabase);
                    ForwardChainingReasoner.checkRecache = true;
                    ForwardChainingReasoner.weirdLink = (Link)cacheParents.iterator().next();
                    tempReasonedDB.recache();
                    Collection<Link> kids = tempReasonedDB.getChildren(parent.getParent());
                    it2 = dynamicParents.iterator();
                    int j = 0;
                    while (it2.hasNext()) {
                        parent = (Link)it2.next();
                        parentsMessage = parentsMessage + "\n         parent " + (j + 1) + ") = " + parent;
                        ++j;
                    }
                    failureMessage = failureMessage + "    dynamic run unable to generate " + parentsMessage;
                }
            }
            ++i2;
        }
        if (failureMessage.length() > 0) {
            ReasonerTest.fail((String)failureMessage);
        }
    }

    protected Link getRandomCompleteLink() {
        LinkedHashSet<OBORestriction> completeLinks = new LinkedHashSet<OBORestriction>();
        for (IdentifiedObject io : this.session.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            for (Link link : lo.getParents()) {
                OBORestriction or;
                if (!(link instanceof OBORestriction) || !(or = (OBORestriction)link).getCompletes()) continue;
                completeLinks.add(or);
            }
        }
        int index = (int)(Math.random() * (double)completeLinks.size());
        if (index >= completeLinks.size()) {
            return null;
        }
        Iterator<IdentifiedObject> it = completeLinks.iterator();
        Link cl = null;
        for (int i = 0; i < index + 1; ++i) {
            cl = (Link)((Object)it.next());
        }
        ReasonerTest.assertNotNull((String)("null random complete link, index = " + index), (Object)cl);
        return cl;
    }

    protected Link getRandomLink() {
        int count = 0;
        for (IdentifiedObject io : this.session.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            for (Link link : lo.getParents()) {
                if (link instanceof OBORestriction) {
                    OBORestriction or = (OBORestriction)link;
                    if (or.getCompletes()) continue;
                    ++count;
                    continue;
                }
                ++count;
            }
        }
        int index = (int)(Math.random() * (double)count);
        for (IdentifiedObject io : this.session.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            for (Link link : ((LinkedObject)io).getParents()) {
                if (index == 0) {
                    return link;
                }
                if (link instanceof OBORestriction) {
                    if (((OBORestriction)link).getCompletes()) continue;
                    --index;
                    continue;
                }
                --index;
            }
        }
        return null;
    }
}

