/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.OBOObject;
import org.obo.filters.IsRedundantLinkCriterion;
import org.obo.filters.LinkFilter;
import org.obo.filters.LinkFilterFactory;
import org.obo.filters.ObjectFilter;
import org.obo.filters.ObjectFilterFactory;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.impl.LinkPileReasoner;
import org.obo.test.AbstractReasonerTest;
import org.obo.util.TermUtil;

public class RedundancyTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(RedundancyTest.class);
    LinkFilterFactory lff = new LinkFilterFactory();
    ObjectFilterFactory off = new ObjectFilterFactory();

    public RedundancyTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"redundant1.obo"};
        return Arrays.asList(files);
    }

    public void testIsRedundant() throws Exception {
        for (OBOObject oo : TermUtil.getOBOObjects(this.session)) {
            for (Link link : this.reasonedDB.getParents(oo)) {
                System.out.println(link.getClass() + " " + link);
                if (this.reasonedDB instanceof LinkPileReasoner) {
                    LinkPileReasoner lpr = (LinkPileReasoner)this.reasonedDB;
                    Link rl = lpr.findRealLink(link);
                    System.out.println(" RL:" + rl.getClass() + " " + rl);
                }
                Collection<Explanation> exps = this.reasonedDB.getExplanations(link);
                for (Explanation exp : exps) {
                    System.out.println("EXP: " + exp);
                }
            }
        }
        this.testForIsA("C", "A");
        this.testForRedundantIsA("C", "A");
        this.testForNonRedundantIsA("C", "B");
        ObjectFilter ofilter = (ObjectFilter)this.off.createNewFilter();
        ofilter = (ObjectFilter)this.off.createNewFilter();
        ofilter.setCriterion(new IsRedundantLinkCriterion());
        LinkFilter lfilter = (LinkFilter)this.lff.createNewFilter();
        lfilter.setAspect(4);
        lfilter.setFilter(ofilter);
        Collection<Link> matches = this.filterLinks(lfilter);
        logger.info((Object)(lfilter + " N_matches: " + matches.size()));
        System.out.println(lfilter + " N_matches: " + matches.size());
    }
}

