/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.test.AbstractReasonerTest;

public class SimpleReasonerTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(SimpleReasonerTest.class);

    public SimpleReasonerTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"simple_ontology.obo"};
        return Arrays.asList(files);
    }

    public static Collection<String> getTests() {
        String[] tests = new String[]{};
        return Arrays.asList(tests);
    }

    public void testReasonedLinks() throws Exception {
        String A = "A";
        String B = "B";
        String C = "C";
        String D = "D";
        String E = "E";
        this.testForIsA(B, A);
        this.testForIsA(C, A);
        this.testForIsA(D, B);
        this.testForIsA(D, C);
        this.testForIsA(D, A);
        this.printData(A);
        this.deleteLink(D, OBOProperty.IS_A, C);
        this.printData(A);
        this.deleteLink(D, OBOProperty.IS_A, B);
        this.printData(A);
    }

    public void deleteLink(String id1, OBOProperty prop, String id2) {
        Link link = this.reasonedDB.hasRelationship((LinkedObject)this.session.getObject(id1), prop, (LinkedObject)this.session.getObject(id2));
        DeleteLinkHistoryItem item = new DeleteLinkHistoryItem(link);
        this.session.getOperationModel().apply(item);
        this.reasonedDB.removeLink(link);
    }

    public void printData(String id) {
        IdentifiedObject io = this.session.getObject(id);
        if (io instanceof LinkedObject) {
            for (Link l : this.reasonedDB.getParents((LinkedObject)io)) {
                System.out.printf("%s [%s]\n", l, l.isImplied() ? "implied" : "asserted");
            }
            System.out.println("========");
            for (Link l : this.reasonedDB.getChildren((LinkedObject)io)) {
                System.out.printf("%s [%s]\n", l, l.isImplied() ? "implied" : "asserted");
            }
            System.out.println("~~~~~~~~");
        }
    }
}

