/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.impl.DefaultOperationModel;
import org.obo.history.DefaultHistoryList;
import org.obo.history.HistoryList;
import org.obo.history.OperationModel;
import org.obo.history.TermMergeHistoryItem;
import org.obo.test.AbstractOBOTest;
import org.obo.util.ReasonerUtil;

public class TermMergeTest
extends AbstractOBOTest {
    protected OperationModel operationModel;
    HistoryList out = new DefaultHistoryList();

    public TermMergeTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"merge_xp_test.obo"};
        return Arrays.asList(files);
    }

    public void testMerge() throws IOException {
        OBOClass master = (OBOClass)this.session.getObject("Test:00040004");
        OBOClass slave = (OBOClass)this.session.getObject("Test:00040005");
        TermMergeHistoryItem item = new TermMergeHistoryItem(master, slave);
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setSession(this.session);
        this.operationModel.apply(item);
        this.out.addItem(item);
        TermMergeTest.assertNull((Object)this.session.getObject("Test:00040005"));
        OBOClass mergedObj = (OBOClass)this.session.getObject("Test:00040004");
        TermMergeTest.assertEquals((int)2, (int)mergedObj.getSubsets().size());
    }

    public void testMergeIntersectionTerm() throws IOException {
        OBOClass master = (OBOClass)this.session.getObject("Test:00040001");
        OBOClass slave = (OBOClass)this.session.getObject("Test:00040002");
        TermMergeHistoryItem item = new TermMergeHistoryItem(master, slave);
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setSession(this.session);
        this.operationModel.apply(item);
        OBOClass mergedObj = (OBOClass)this.session.getObject("Test:00040001");
        TermMergeTest.assertEquals((int)2, (int)ReasonerUtil.getIntersectionLinks(mergedObj).size());
    }

    public void testMerge2IntersectionTerms() throws IOException {
        OBOClass master = (OBOClass)this.session.getObject("Test:00040006");
        OBOClass slave = (OBOClass)this.session.getObject("Test:00040002");
        TermMergeHistoryItem item = new TermMergeHistoryItem(master, slave);
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setSession(this.session);
        this.operationModel.apply(item);
        OBOClass mergedObj = (OBOClass)this.session.getObject("Test:00040006");
        TermMergeTest.assertTrue((ReasonerUtil.getIntersectionLinks(mergedObj).size() == 3 ? 1 : 0) != 0);
    }

    public void testMergeCycles1() throws IOException {
        OBOClass master = (OBOClass)this.session.getObject("Test:00040004");
        OBOClass slave = (OBOClass)this.session.getObject("Test:00040005");
        TermMergeHistoryItem item = new TermMergeHistoryItem(master, slave);
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setSession(this.session);
        this.operationModel.apply(item);
        OBOClass mergedObj = (OBOClass)this.session.getObject("Test:00040004");
        TermMergeTest.assertTrue((this.session.getObject("Test:00040005") == null ? 1 : 0) != 0);
    }

    public void testMergeCycles2() throws IOException {
        OBOClass master = (OBOClass)this.session.getObject("Test:00040005");
        OBOClass slave = (OBOClass)this.session.getObject("Test:00040004");
        TermMergeHistoryItem item = new TermMergeHistoryItem(master, slave);
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setSession(this.session);
        this.operationModel.apply(item);
        OBOClass mergedObj = (OBOClass)this.session.getObject("Test:00040005");
        TermMergeTest.assertTrue((this.session.getObject("Test:00040004") == null ? 1 : 0) != 0);
    }

    public void testMergeSynonymType() throws Exception {
        OBOClass master = (OBOClass)this.session.getObject("Test:00050000");
        OBOClass slave = (OBOClass)this.session.getObject("Test:00050001");
        TermMergeHistoryItem item = new TermMergeHistoryItem(master, slave);
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setSession(this.session);
        this.operationModel.apply(item);
        OBOClass mergedObj = (OBOClass)this.session.getObject("Test:00050000");
        Set<Synonym> synonyms = mergedObj.getSynonyms();
        TermMergeTest.assertEquals((int)2, (int)synonyms.size());
        boolean found = false;
        for (Synonym synonym : synonyms) {
            String text = synonym.getText();
            if (!"foo bar".equals(text)) continue;
            SynonymType synonymType = synonym.getSynonymType();
            TermMergeTest.assertNotNull((Object)synonymType);
            String id = synonymType.getID();
            found = "st1".equals(id);
            break;
        }
        TermMergeTest.assertTrue((boolean)found);
    }

    public void testMergeXrefs() throws Exception {
        OBOClass master = (OBOClass)this.session.getObject("Test:00060000");
        OBOClass slave = (OBOClass)this.session.getObject("Test:00060001");
        TermMergeHistoryItem item = new TermMergeHistoryItem(master, slave);
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setSession(this.session);
        this.operationModel.apply(item);
        OBOClass mergedObj = (OBOClass)this.session.getObject("Test:00060000");
        Set<Dbxref> dbxrefs = mergedObj.getDbxrefs();
        TermMergeTest.assertEquals((int)2, (int)dbxrefs.size());
        HashSet<String> expectedXrefs = new HashSet<String>(Arrays.asList("FOO:bar1", "FOO:bar2"));
        for (Dbxref dbxref : dbxrefs) {
            String id = dbxref.getDatabase() + ":" + dbxref.getDatabaseID();
            TermMergeTest.assertTrue((boolean)expectedXrefs.contains(id));
        }
    }

    public void testMergeSynonymDbXrefs() throws Exception {
        OBOClass master = (OBOClass)this.session.getObject("Test:00060002");
        OBOClass slave = (OBOClass)this.session.getObject("Test:00060003");
        TermMergeHistoryItem item = new TermMergeHistoryItem(master, slave);
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setSession(this.session);
        this.operationModel.apply(item);
        OBOClass mergedObj = (OBOClass)this.session.getObject("Test:00060002");
        Set<Synonym> synonyms = mergedObj.getSynonyms();
        TermMergeTest.assertEquals((int)2, (int)synonyms.size());
        boolean found = false;
        HashSet<String> expectedXrefs = new HashSet<String>(Arrays.asList("FOO:bar1", "FOO:bar2"));
        for (Synonym synonym : synonyms) {
            String text = synonym.getText();
            if (!"foo bar".equals(text)) continue;
            Collection<Dbxref> xrefs = synonym.getXrefs();
            TermMergeTest.assertEquals((int)2, (int)xrefs.size());
            for (Dbxref dbxref : xrefs) {
                String id = dbxref.getDatabase() + ":" + dbxref.getDatabaseID();
                TermMergeTest.assertTrue((boolean)expectedXrefs.contains(id));
            }
            found = true;
            break;
        }
        TermMergeTest.assertTrue((boolean)found);
    }

    public void testMergeDefXrefs() throws Exception {
        OBOClass master = (OBOClass)this.session.getObject("Test:00060004");
        OBOClass slave = (OBOClass)this.session.getObject("Test:00060005");
        TermMergeHistoryItem item = new TermMergeHistoryItem(master, slave);
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setSession(this.session);
        this.operationModel.apply(item);
        OBOClass mergedObj = (OBOClass)this.session.getObject("Test:00060004");
        Set<Dbxref> defDbxrefs = mergedObj.getDefDbxrefs();
        TermMergeTest.assertEquals((int)2, (int)defDbxrefs.size());
    }
}

