/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.io.AuditedPrintStream;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.impl.FilteredLinkDatabase;
import org.obo.reasoner.impl.TrimmedLinkDatabase;
import org.obo.test.AbstractReasonerTest;

public class TrimmingTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(TrimmingTest.class);
    protected long oldTime = 0L;
    protected long newTime = 0L;
    protected static int checkedLinkCount = 0;

    public TrimmingTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"so-xp.obo"};
        return Arrays.asList(files);
    }

    public static Collection<String> getTests() {
        String[] tests = new String[]{};
        return Arrays.asList(tests);
    }

    public void testLinks() throws Exception {
        this.oldTime = 0L;
        this.newTime = 0L;
        TrimmedLinkDatabase linkDatabase = new TrimmedLinkDatabase(new FilteredLinkDatabase(this.reasonedDB));
        for (IdentifiedObject io : linkDatabase.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            long time = System.nanoTime();
            linkDatabase.normalTrimming = false;
            TrimmingTest.fetchParents((LinkedObject)io, linkDatabase);
            this.newTime += System.nanoTime() - time;
            time = System.nanoTime();
            linkDatabase.normalTrimming = true;
            TrimmingTest.fetchParents((LinkedObject)io, linkDatabase);
            this.oldTime += System.nanoTime() - time;
        }
        logger.info((Object)("original implementation time = " + (double)this.oldTime / 1.0E9));
        System.err.println("new implementation time = " + (double)this.newTime / 1.0E9);
    }

    protected static void fetchParents(LinkedObject object, TrimmedLinkDatabase linkDatabase) {
        Collection<Link> parents = linkDatabase.getParents(object);
        for (Link link : parents) {
            ++checkedLinkCount;
        }
        Collection<Link> children = linkDatabase.getChildren(object);
        for (Link link : children) {
            ++checkedLinkCount;
        }
    }

    public static Test suite() {
        logger.info((Object)"foo");
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        TrimmingTest.addTests(suite);
        return suite;
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new TrimmingTest("testLinks"));
    }
}

