/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.io.AuditedPrintStream;
import org.obo.test.AbstractOBOTest;
import org.obo.util.WebSearchUtil;

public class WebSearchUtilTest
extends AbstractOBOTest {
    protected static final Logger logger = Logger.getLogger(WebSearchUtilTest.class);

    public WebSearchUtilTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"so-xp.obo"};
        return Arrays.asList(files);
    }

    public static Collection<String> getTests() {
        String[] tests = new String[]{};
        return Arrays.asList(tests);
    }

    public void testExpand() throws Exception {
        Set<String> terms = WebSearchUtil.expandSearchTerm(this.session, "transcript");
        for (String term : terms) {
            logger.info((Object)term);
        }
        WebSearchUtilTest.assertTrue((terms.size() > 0 ? 1 : 0) != 0);
        String qs = WebSearchUtil.createQueryString(WebSearchUtil.SearchableDatabase.NCBI, terms);
        logger.info((Object)qs);
        WebSearchUtilTest.assertTrue((boolean)qs.contains("RNA"));
    }

    public static Test suite() {
        logger.info((Object)"foo");
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        WebSearchUtilTest.addTests(suite);
        return suite;
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new WebSearchUtilTest("testExpand"));
    }
}

