/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.DefinedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObsoletableObject;

public class CodeGenUtil {
    protected static final Logger logger = Logger.getLogger(CodeGenUtil.class);

    private static String generateJavaSource(IdentifiedObject io) {
        StringBuffer sb = new StringBuffer();
        String method = CodeGenUtil.makeJavaSafe(io.getName());
        String localId = io.getID().replaceAll(".*:", "");
        String idspace = io.getID().replaceAll(":.*", "");
        String url = "http://purl.org/obo/owl/" + idspace + "#" + idspace + "_" + localId;
        String tab = "    ";
        sb.append(tab + "/**\n");
        if (io instanceof DefinedObject) {
            String def = ((DefinedObject)io).getDefinition();
            sb.append(tab + " * " + def + " \n");
            sb.append(tab + " * <p>\n");
        }
        if (io instanceof CommentedObject) {
            String comment = ((CommentedObject)io).getComment();
            sb.append(tab + " * " + comment + " \n");
            sb.append(tab + " * <p>\n");
        }
        sb.append(tab + " * @see <a href=\"" + url + "\">" + io.getID() + "</a> \n");
        sb.append(tab + " */\n");
        sb.append(tab + "public String " + method + "() {\n");
        sb.append(tab + tab + "return generateId(\"" + localId + "\");\n");
        sb.append(tab + "}\n\n");
        return sb.toString();
    }

    public static String generateJavaSourceForVocabulary(String ns, OBOSession session) {
        StringBuffer sb = new StringBuffer();
        sb.append("    // AUTO-GENERATED BY org.obo.util.CodeGenUtil\n\n");
        HashSet<String> done = new HashSet<String>();
        for (IdentifiedObject io : session.getObjects()) {
            if (io instanceof ObsoletableObject && ((ObsoletableObject)io).isObsolete() || done.contains(io.getID())) continue;
            if (ns == null || io.getNamespace() != null && io.getNamespace().getID().equals(ns)) {
                sb.append(CodeGenUtil.generateJavaSource(io));
            }
            done.add(io.getID());
        }
        return sb.toString();
    }

    public static String generateJavaSourceForVocabulary(String ns, Collection<String> paths) {
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().addAll(paths);
        config.setAllowDangling(true);
        config.setBasicSave(false);
        config.setFailFast(false);
        OBOFileAdapter adapter = new OBOFileAdapter();
        String s = null;
        try {
            OBOSession session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
            s = CodeGenUtil.generateJavaSourceForVocabulary(ns, session);
        }
        catch (DataAdapterException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static void main(String[] args) throws Exception {
        String ns = null;
        LinkedList<String> paths = new LinkedList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-ns")) {
                ns = args[++i];
                continue;
            }
            if (args[i].equals("-help")) {
                CodeGenUtil.printUsage();
                System.exit(0);
            }
            if (args[i].equals("-source")) {
                String srcPath = args[++i];
                LineNumberReader lnr = new LineNumberReader(new FileReader(srcPath));
                String line = lnr.readLine();
                while (line != null && !line.contains("AUTO")) {
                    logger.info((Object)line);
                    line = lnr.readLine();
                }
                continue;
            }
            paths.add(args[i]);
        }
        logger.info((Object)CodeGenUtil.generateJavaSourceForVocabulary(ns, paths));
    }

    public static void printUsage() {
        logger.info((Object)"obocodegen [-ns <namespace>] [-source <java-source-file-path>] <obo-file>*");
    }

    public static String makeJavaSafe(String label) {
        return label.replaceAll(" ", "_").replaceAll("[^A-Za-z0-9_]", "");
    }
}

