/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ExplanationType;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.AbstractExplanation;
import org.obo.reasoner.impl.CompletenessExplanation;
import org.obo.reasoner.impl.CompletenessMatch;
import org.obo.reasoner.impl.ExternallyImpliedExplanation;
import org.obo.util.HTMLUtil;
import org.obo.util.ReasonerUtil;
import org.obo.util.TermUtil;

public class ExplanationUtil {
    protected static final Logger logger = Logger.getLogger(ExplanationUtil.class);

    private ExplanationUtil() {
    }

    public static String getDescriptionReasoned(ReasonedLinkDatabase reasoner, LinkDatabase activeLinkDatabase, Link link, boolean documentation) {
        return ExplanationUtil.getDescriptionReasoned(reasoner, activeLinkDatabase, link, null, new HashMap<Link, String>(), documentation);
    }

    public static boolean isGiven(ReasonedLinkDatabase reasoner, Link link) {
        Collection<Explanation> explanations = reasoner.getExplanations(link);
        for (Explanation e : explanations) {
            if (e.getExplanationType() != ExplanationType.GIVEN) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBeenTrimmed(ReasonedLinkDatabase reasoner, LinkDatabase activeLinkDatabase, Link link) {
        return !ExplanationUtil.isGiven(reasoner, link) && ReasonerUtil.shouldBeTrimmedNew(activeLinkDatabase, link);
    }

    public static String getDescriptionReasoned(ReasonedLinkDatabase reasoner, LinkDatabase activeLinkDatabase, Link link, Collection subExplanations, Map<Link, String> cachedExplanations, boolean documentation) {
        StringBuffer out = new StringBuffer();
        if (reasoner == null) {
            logger.info((Object)"Can't get explanation--reasoner is null!");
            return "";
        }
        if (link.getParent() == null) {
            return "";
        }
        Collection<Explanation> explanations = reasoner.getExplanations(link);
        out.append("<a name='" + link.getChild().getID().replace(':', '_') + "-" + link.getType().getID().replace(':', '_') + "-" + link.getParent().getID().replace(':', '_') + "'></a>");
        out.append("<b>Why is the link " + HTMLUtil.getHTMLLink(link, !ExplanationUtil.hasBeenTrimmed(reasoner, activeLinkDatabase, link)) + " in the ontology?</b>");
        if (documentation && explanations.size() > 1) {
            out.append("<br><br><b>Note:</b> There are several different explanations for why this link appears in the ontology. This is not necessarily a problem; in complex ontologies with  cross products, it's not unusual for there to be several ways of deriving a link. Further, just because a link has multiple explanations does not mean that it is redundant. By default the reasoner considers a link redundant if it can be inferred by the reasoner, but has been explicitly asserted in the ontology as well.<br>");
        }
        if (explanations.size() > 1) {
            out.append("<ol>\n");
        }
        for (Explanation e : explanations) {
            if (explanations.size() > 1) {
                out.append("<li>");
            }
            if (e.getExplanationType() == ExplanationType.INTERSECTION) {
                out.append("The reasoner created an <b>is_a</b> link between " + HTMLUtil.getHTMLLink(link.getChild(), true) + " and " + HTMLUtil.getHTMLLink(link.getParent(), true) + " because:");
                CompletenessExplanation ce = (CompletenessExplanation)e;
                out.append("<ol>\n");
                for (CompletenessMatch me : ce.getMatches()) {
                    out.append("<li>" + (TermUtil.isImplied(me.getMatchLink()) ? "<i>" : "") + HTMLUtil.getHTMLLink(me.getMatchLink(), !ExplanationUtil.hasBeenTrimmed(reasoner, activeLinkDatabase, me.getMatchLink())) + (TermUtil.isImplied(me.getMatchLink()) ? "</i>" : ""));
                    out.append(" ");
                    if (subExplanations != null) {
                        out.append(HTMLUtil.getHTMLLink(subExplanations.contains(me.getMatchLink()) ? "HIDE" : "EXPAND", subExplanations.contains(me.getMatchLink()) ? "<font size=-1><b>(hide explanation)</b></font>" : "<font size=-1><b>(show explanation)</b></font>", me.getMatchLink(), true));
                    }
                    if (subExplanations == null || link.equals(me.getMatchLink()) || !subExplanations.contains(me.getMatchLink()) || cachedExplanations.containsKey(me.getMatchLink())) continue;
                    out.append("<ol>\n");
                    out.append("<li>\n");
                    String expStr = cachedExplanations.get(me.getMatchLink());
                    if (expStr == null) {
                        cachedExplanations.put(me.getMatchLink(), null);
                        expStr = ExplanationUtil.getDescriptionReasoned(reasoner, activeLinkDatabase, me.getMatchLink(), subExplanations, cachedExplanations, documentation);
                        cachedExplanations.put(me.getMatchLink(), expStr);
                    }
                    out.append(expStr);
                    out.append("</ol>\n");
                }
                out.append("</ol>\n");
                out.append(" and " + HTMLUtil.getHTMLLink(link.getParent(), true) + " has a cross-product definition that says any term with the following relationships:");
                out.append("<ol>\n");
                for (CompletenessMatch me : ce.getMatches()) {
                    out.append("<li><b>" + me.getCompletenessLink().getType().getID() + "</b> " + HTMLUtil.getHTMLLink(me.getCompletenessLink().getParent(), true));
                }
                out.append("</ol>\n");
                out.append("is an implied subclass of " + link.getParent());
                continue;
            }
            if (e.getExplanationType() == ExplanationType.TRANSITIVITY) {
                out.append("The reasoner created a <b>" + link.getType().getID() + "</b> link between " + HTMLUtil.getHTMLLink(link.getChild(), true) + " and " + HTMLUtil.getHTMLLink(link.getParent(), true) + " because of transitivity. This new link is the result of applying the rules of transitivity to the following links:");
                out.append("<ol>");
                for (Link ev : ((AbstractExplanation)e).getEvidence()) {
                    out.append("<li>" + (TermUtil.isImplied(ev) ? "<i>" : "") + HTMLUtil.getHTMLLink(ev, !ExplanationUtil.hasBeenTrimmed(reasoner, activeLinkDatabase, ev)) + (TermUtil.isImplied(ev) ? "</i>" : ""));
                    out.append(" ");
                    if (subExplanations != null) {
                        out.append(HTMLUtil.getHTMLLink(subExplanations.contains(ev) ? "HIDE" : "EXPAND", subExplanations.contains(ev) ? "<font size=-1><b>(hide explanation)</b></font>" : "<font size=-1><b>(show explanation)</b></font>", ev, true));
                    }
                    if (subExplanations == null || ev.equals(link) || !subExplanations.contains(ev) || cachedExplanations.containsKey(ev)) continue;
                    out.append("<ol>");
                    out.append("<li>");
                    String expStr = cachedExplanations.get(ev);
                    if (expStr == null) {
                        cachedExplanations.put(ev, null);
                        expStr = ExplanationUtil.getDescriptionReasoned(reasoner, activeLinkDatabase, ev, subExplanations, cachedExplanations, documentation);
                        cachedExplanations.put(ev, expStr);
                    }
                    out.append(expStr);
                    out.append("</ol>");
                }
                out.append("</ol>");
                if (!documentation) continue;
                out.append("The definition of transitivity can be broken down into two major cases:");
                out.append("<ol>");
                out.append("<li>If <font color=blue>B -<b>p</b>-> C</font> and <font  color=blue>A -<b>is_a</b>-> B</font>, then <font  color=blue>A -<b>p</b>-> C</font>, whether or not relationship type <b>p</b> is transitive.");
                out.append("<li>If <b>p</b> is transitive and <font color=blue>A -<b>p</b>-> B</font> and <font color=blue>B -<b>p</b>-> C</font>, then <font color=blue>A -<b>p</b>-> C</font>.");
                out.append("</ol>");
                continue;
            }
            if (e.getExplanationType() == ExplanationType.GENUS) {
                out.append("This reasoner created an <b>is_a</b> link between " + HTMLUtil.getHTMLLink(link.getChild(), true) + " and " + HTMLUtil.getHTMLLink(link.getParent(), true) + " because the cross-product definition of " + HTMLUtil.getHTMLLink(link.getChild(), true) + " names " + HTMLUtil.getHTMLLink(link.getParent(), true) + " as its genus term.");
                if (!documentation) continue;
                out.append(" An <b>is_a</b> link is always implied between a term and its genus.");
                continue;
            }
            if (e.getExplanationType() == ExplanationType.DIFFERENTIA) {
                out.append("This reasoner created a <b>" + link.getType().getID() + "</b> link between " + HTMLUtil.getHTMLLink(link.getChild(), true) + " and " + HTMLUtil.getHTMLLink(link.getParent(), true) + " because the cross-product definition of " + HTMLUtil.getHTMLLink(link.getChild(), true) + " lists " + HTMLUtil.getHTMLLink(link.getParent(), true) + " as a differentia term with type <b>" + link.getType().getID() + "</b>.");
                if (!documentation) continue;
                out.append(" A link of the specified differentia type is always implied between a term and its differentia.");
                continue;
            }
            if (e.getExplanationType() == ExplanationType.IMPLIED_BY_EXTERNAL_REASONER) {
                String message;
                out.append("This link was computed by an external reasoner.<br>");
                if (e instanceof ExternallyImpliedExplanation && (message = ((ExternallyImpliedExplanation)e).getMessage()) != null) {
                    out.append("The external reasoner says the following about this implied link:<br><br>");
                    out.append(message);
                    out.append("<br><br>");
                }
                if (e.getEvidence().size() > 0) {
                    out.append("The following links constitute evidence for this implied link:");
                    out.append("<ul>");
                    for (Link elink : e.getEvidence()) {
                        out.append("<li>" + HTMLUtil.getHTMLLink(link, true));
                    }
                    out.append("</ul>");
                }
                if (!reasoner.isRedundant(link)) continue;
                if (documentation) {
                    out.append("<font color=red><b>Note:</b> This link has been marked redundant by the reasoner, because the reasoner can infer the link automatically. Redundant links are not necessarily a problem, but they can make an ontology more difficult to maintain.</font>");
                    continue;
                }
                out.append("<font color=red><b>Note:</b> This link has been marked redundant by the reasoner.</font>");
                continue;
            }
            if (e.getExplanationType() == ExplanationType.GIVEN) {
                out.append("This link was explicitly added to the ontology by a human being.");
                if (!reasoner.isRedundant(link)) continue;
                if (documentation) {
                    out.append("<font color=red><b>Note:</b> This link has been marked redundant by the reasoner, because the reasoner can infer the link automatically. Redundant links are not necessarily a problem, but they can make an ontology more difficult to maintain.</font>");
                    continue;
                }
                out.append("<font color=red><b>Note:</b> This link has been marked redundant by the reasoner.</font>");
                continue;
            }
            out.append("This link was derived by the reasoner.<br>" + e);
        }
        if (explanations.size() > 1) {
            out.append("</ol>");
        }
        return out.toString();
    }
}

