/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.util.VectorFilter;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.SynonymedObject;
import org.obo.datamodel.TermSubset;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;
import org.obo.history.StringRelationship;
import org.obo.history.TermMacroHistoryItem;
import org.obo.util.TermUtil;

public class HistoryUtil {
    protected static final Logger logger = Logger.getLogger(HistoryUtil.class);

    public static Collection findMatchingItems(TermMacroHistoryItem mitem, VectorFilter filter) {
        LinkedList<HistoryItem> out = new LinkedList<HistoryItem>();
        for (int i = 0; i < mitem.size(); ++i) {
            HistoryItem item = mitem.getItemAt(i);
            if (filter.satisfies((Object)item)) {
                out.add(item);
            }
            if (!(item instanceof TermMacroHistoryItem)) continue;
            out.addAll(HistoryUtil.findMatchingItems((TermMacroHistoryItem)item, filter));
        }
        return out;
    }

    public static Collection findMatchingItems(HistoryList list, VectorFilter filter) {
        LinkedList<HistoryItem> out = new LinkedList<HistoryItem>();
        for (HistoryItem item : list.getHistoryItems()) {
            if (filter.satisfies((Object)item)) {
                out.add(item);
            }
            if (!(item instanceof TermMacroHistoryItem)) continue;
            out.addAll(HistoryUtil.findMatchingItems((TermMacroHistoryItem)item, filter));
        }
        return out;
    }

    public static Link createRealRel(OBOSession session, StringRelationship tr) {
        if (tr == null) {
            return null;
        }
        LinkedObject parent = (LinkedObject)session.getObject(tr.getParent());
        LinkedObject child = (LinkedObject)session.getObject(tr.getChild());
        OBOProperty type = (OBOProperty)session.getObject(tr.getType());
        Namespace ns = session.getNamespace(tr.getNamespace());
        OBORestriction realtr = session.getObjectFactory().createOBORestriction(child, type, parent, false);
        realtr.setNamespace(ns);
        realtr.setNecessarilyTrue(tr.isNecessary());
        realtr.setInverseNecessarilyTrue(tr.isInverseNecessary());
        realtr.setCompletes(tr.completes());
        realtr.setMinCardinality(tr.getMinCardinality());
        realtr.setMaxCardinality(tr.getMaxCardinality());
        realtr.setCardinality(tr.getCardinality());
        return realtr;
    }

    public static Link getRealRel(OBOSession session, StringRelationship tr) {
        if (tr == null) {
            return null;
        }
        LinkedObject child = (LinkedObject)session.getObject(tr.getChild());
        OBOProperty type = (OBOProperty)session.getObject(tr.getType());
        LinkedObject parent = (LinkedObject)session.getObject(tr.getParent());
        if (child == null) {
            return null;
        }
        for (Link link : child.getParents()) {
            if (!link.getType().equals(type) || !link.getParent().equals(parent)) continue;
            return link;
        }
        return null;
    }

    public static TermSubset findCategory(String name, OBOSession session) {
        for (TermSubset cat : session.getSubsets()) {
            if (!cat.getName().equals(name)) continue;
            return cat;
        }
        return null;
    }

    public static TermSubset findCategory(TermSubset cat, OBOSession session) {
        return HistoryUtil.findCategory(cat.getName(), session);
    }

    public static Link findChildRel(Link tr, LinkedObject t) {
        if (t == null) {
            if (tr.getParent() == null) {
                return tr;
            }
            return null;
        }
        for (Link ptr : t.getChildren()) {
            if (!TermUtil.equals(ptr, tr)) continue;
            return ptr;
        }
        return null;
    }

    @Deprecated
    public static Link findChildRelNoIntersection(Link tr, LinkedObject t) {
        if (t == null) {
            if (tr.getParent() == null) {
                return tr;
            }
            return null;
        }
        for (Link ptr : t.getChildren()) {
            if (!TermUtil.equalsWithoutIntersection(ptr, tr)) continue;
            return ptr;
        }
        return null;
    }

    public static Link findParentRel(Link tr, LinkedObject t) {
        for (Link ctr : t.getParents()) {
            if (!TermUtil.equals(ctr, tr)) continue;
            return ctr;
        }
        return null;
    }

    @Deprecated
    public static Link findParentRelNoIntersection(Link tr, LinkedObject t) {
        for (Link ctr : t.getParents()) {
            if (!TermUtil.equalsWithoutIntersection(ctr, tr)) continue;
            return ctr;
        }
        return null;
    }

    public static Namespace findNamespace(Namespace ns, OBOSession session) {
        return HistoryUtil.findNamespace(ns.getID(), session);
    }

    public static Namespace findNamespace(String nsid, OBOSession session) {
        for (Namespace ns : session.getNamespaces()) {
            if (!ns.getID().equals(nsid)) continue;
            return ns;
        }
        return null;
    }

    public static Synonym findSynonym(SynonymedObject t, String stext) {
        for (Synonym s : t.getSynonyms()) {
            if (!s.getText().equals(stext)) continue;
            return s;
        }
        return null;
    }

    public static Synonym findSynonym(SynonymedObject t, Synonym s) {
        return HistoryUtil.findSynonym(t, s.getText());
    }

    public static SynonymType findSynonymCategory(String cat_id, OBOSession session) {
        for (SynonymType cat : session.getSynonymTypes()) {
            if (!cat.getID().equals(cat_id)) continue;
            return cat;
        }
        return null;
    }

    public static SynonymType findSynonymCategory(SynonymType cat, OBOSession session) {
        return HistoryUtil.findSynonymCategory(cat.getID(), session);
    }

    public static boolean hasChild(LinkedObject t, Link tr) {
        if (tr.getType() == null) {
            return false;
        }
        for (Link tra : t.getChildren()) {
            if (!tr.getChild().equals(tra.getChild()) || !tr.getType().equals(tra.getType())) continue;
            if (tr instanceof OBORestriction && tra instanceof OBORestriction && ((OBORestriction)tr).getCompletes() == ((OBORestriction)tra).getCompletes()) {
                return true;
            }
            return true;
        }
        return false;
    }
}

