/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.codec.language.Soundex;
import org.apache.log4j.Logger;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.OBOSession;
import org.obo.util.SessionWrapper;
import org.obo.util.TermUtil;

public class LexUtil
extends SessionWrapper {
    protected static final Logger logger = Logger.getLogger(LexUtil.class);
    protected TextComparisonAlgorithm algorithm = TextComparisonAlgorithm.EXACT;

    public LexUtil() {
    }

    public LexUtil(OBOSession session) {
        this.session = session;
    }

    public LexUtil(TextComparisonAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public Map<String, Collection<OBOObject>> getDefinitionToObjectMap() {
        HashMap<String, Collection<OBOObject>> map = new HashMap<String, Collection<OBOObject>>();
        Soundex soundex = new Soundex();
        for (OBOObject obj : TermUtil.getOBOObjects(this.getSession())) {
            String def = obj.getDefinition();
            if (def == null || def.equals("")) continue;
            String key = def;
            if (this.algorithm.equals((Object)TextComparisonAlgorithm.SOUNDEX)) {
                key = soundex.soundex(def);
            }
            if (!map.containsKey(key)) {
                map.put(key, new LinkedList());
            }
            ((Collection)map.get(key)).add(obj);
        }
        return map;
    }

    public void findTermSetsWithSimilarDefinitions() {
        Map<String, Collection<OBOObject>> map = this.getDefinitionToObjectMap();
        for (String key : map.keySet()) {
            Collection<OBOObject> objs = map.get(key);
            if (objs.size() <= 1) continue;
            logger.info((Object)("TermSet: " + key));
            for (OBOObject obj : objs) {
                logger.info((Object)("  Term: " + obj + " " + obj.getDefinition()));
            }
        }
    }

    public static enum TextComparisonAlgorithm {
        EXACT,
        SOUNDEX,
        STEM;

    }
}

