/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.bbop.util.TaskDelegate;
import org.obo.datamodel.LinkDatabase;
import org.obo.query.Query;
import org.obo.query.QueryEngine;

public class QueryUtil {
    protected static final Logger logger = Logger.getLogger(QueryUtil.class);

    public static <V> Collection<V> getResults(TaskDelegate<Collection<V>> task) {
        task.run();
        return (Collection)task.getResults();
    }

    public static <T, V> Collection<V> query(QueryEngine engine, LinkDatabase linkDatabase, Query<T, V> q) {
        TaskDelegate<Collection<V>> task = engine.query(linkDatabase, q);
        return QueryUtil.getResults(task);
    }

    public static <T, V> Collection<V> subquery(QueryEngine engine, Collection<? extends V> objects, Query<T, V> q) {
        TaskDelegate<Collection<? extends V>> task = engine.subquery(objects, q);
        return QueryUtil.getResults(task);
    }

    public static <T, V> Collection<V> query(QueryEngine engine, Collection<? extends T> objects, Query<T, V> q) {
        TaskDelegate<Collection<V>> task = engine.query(objects, q);
        return QueryUtil.getResults(task);
    }
}

