/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.PathCapable;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ExplanationType;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.util.TermUtil;

public class ReasonerUtil {
    protected static final Logger logger = Logger.getLogger(ReasonerUtil.class);

    public static boolean containsExplanation(ReasonedLinkDatabase reasoner, Explanation e) {
        Collection<Explanation> explanations = reasoner.getExplanations(e.getExplainedObject());
        return explanations != null && explanations.contains(e);
    }

    @Deprecated
    public static Collection<PathCapable> getShortestExplanationPath(ReasonedLinkDatabase reasoner, PathCapable link) {
        int leastHops = 0;
        LinkedList shortestPath = new LinkedList();
        logger.info((Object)("Link: " + link));
        for (Explanation e : reasoner.getExplanations(link)) {
            logger.info((Object)("  Explanation: " + e));
            if (e.getExplanationType().equals((Object)ExplanationType.GIVEN)) {
                return Collections.singleton(link);
            }
            LinkedList<PathCapable> path = new LinkedList<PathCapable>();
            for (Link evidence : e.getEvidence()) {
                logger.info((Object)("    Evidence: " + e));
                path.addAll(ReasonerUtil.getShortestExplanationPath(reasoner, evidence));
            }
            if (leastHops != 0 && path.size() > leastHops) continue;
            leastHops = path.size();
            shortestPath = path;
        }
        LinkedList<PathCapable> newPath = new LinkedList<PathCapable>();
        newPath.add(link);
        newPath.addAll(shortestPath);
        return newPath;
    }

    public static Collection<PathCapable> getShortestExplanationPath(ReasonedLinkDatabase reasoner, LinkedObject child, OBOProperty prop, LinkedObject parent) {
        OBORestrictionImpl link = new OBORestrictionImpl(child, prop, parent);
        return ReasonerUtil.getShortestExplanationPath(reasoner, link);
    }

    public static boolean generateTransitiveImplication(ReasonedLinkDatabase reasoner, Link out, Link link, Link gpLink) {
        if (gpLink.getType().isNonInheritable() || link.getType().isNonInheritable()) {
            return false;
        }
        if (!link.getParent().equals(gpLink.getChild())) {
            throw new RuntimeException("link and gpLink don't fit!");
        }
        if (reasoner.isSubPropertyOf(link.getType(), OBOProperty.IS_A)) {
            out.setChild(link.getChild());
            out.setType(gpLink.getType());
            out.setParent(gpLink.getParent());
            return true;
        }
        if (reasoner.isSubPropertyOf(gpLink.getType(), OBOProperty.IS_A)) {
            out.setChild(link.getChild());
            out.setType(link.getType());
            out.setParent(gpLink.getParent());
            return true;
        }
        if (link.getType().isTransitive() && gpLink.getType().isTransitive()) {
            if (reasoner.isSubPropertyOf(link.getType(), gpLink.getType())) {
                out.setChild(link.getChild());
                out.setType(gpLink.getType());
                out.setParent(gpLink.getParent());
                return true;
            }
            if (reasoner.isSubPropertyOf(gpLink.getType(), link.getType())) {
                out.setChild(link.getChild());
                out.setType(link.getType());
                out.setParent(gpLink.getParent());
                return true;
            }
        }
        return false;
    }

    protected static boolean onlyHasGenusDiffExplanation(ReasonedLinkDatabase linkDatabase, Link link) {
        if (!(linkDatabase instanceof ReasonedLinkDatabase)) {
            return false;
        }
        Collection<Explanation> exps = linkDatabase.getExplanations(link);
        boolean foundGenusDiff = false;
        for (Explanation e : exps) {
            if (e.getExplanationType().equals((Object)ExplanationType.GENUS) || e.getExplanationType().equals((Object)ExplanationType.DIFFERENTIA)) continue;
            return false;
        }
        return exps.size() > 0;
    }

    public static Collection<Link> getGivenSupportingLinks(ReasonedLinkDatabase database, Link link) {
        LinkedList<Link> out = new LinkedList<Link>();
        ReasonerUtil.populateGivenSupportingLinks(out, database, link);
        out.remove(link);
        return out;
    }

    public static Collection<PathCapable> getImmediateSupportingLinks(ReasonedLinkDatabase database, Link link) {
        LinkedList<PathCapable> out = new LinkedList<PathCapable>();
        Collection<Explanation> exps = database.getExplanations(link);
        for (Explanation explanation : exps) {
            for (Link evLink : explanation.getEvidence()) {
                out.add(evLink);
            }
        }
        return out;
    }

    public static List<LinkedObject> getMostSpecific(ReasonedLinkDatabase reasoner, Collection<LinkedObject> objects, OBOProperty property) {
        ArrayList<LinkedObject> out = new ArrayList<LinkedObject>();
        ArrayList<LinkedObject> in = new ArrayList<LinkedObject>(objects);
        for (int i = 0; i < in.size(); ++i) {
            LinkedObject a = (LinkedObject)in.get(i);
            boolean found = false;
            for (int j = i + 1; j < in.size(); ++j) {
                LinkedObject b = (LinkedObject)in.get(j);
                if (reasoner.hasRelationship(b, property, a) == null) continue;
                found = true;
                break;
            }
            if (found) continue;
            out.add(a);
        }
        return out;
    }

    public static boolean isDisjoint(ReasonedLinkDatabase linkDatabase, OBOClass a, OBOClass b, boolean siblingsAreDisjoint) {
        if (a.equals(b)) {
            return false;
        }
        if (siblingsAreDisjoint) {
            if (linkDatabase.isSubclassOf(a, b) || linkDatabase.isSubclassOf(b, a)) {
                return false;
            }
            Collection<LinkedObject> a_superClasses = linkDatabase.getParentsOfType(a, OBOProperty.IS_A);
            Collection<LinkedObject> b_superClasses = linkDatabase.getParentsOfType(b, OBOProperty.IS_A);
            a_superClasses.retainAll(b_superClasses);
            return a_superClasses.size() > 0;
        }
        Collection<LinkedObject> disjoints = linkDatabase.getParentsOfType(a, OBOProperty.DISJOINT_FROM);
        if (disjoints.contains(b)) {
            return true;
        }
        disjoints = linkDatabase.getParentsOfType(b, OBOProperty.DISJOINT_FROM);
        return disjoints.contains(a);
    }

    public static boolean isExplanationForLinkCyclic(ReasonedLinkDatabase reasoner, Explanation exp, Link link) {
        return ReasonerUtil.isExplanationForLinkCyclic(reasoner, exp, link, new HashSet<Link>());
    }

    public static boolean isExplanationForLinkCyclic(ReasonedLinkDatabase reasoner, Explanation exp, Link link, Set<Link> checkedLinks) {
        for (Link evidenceLink : exp.getEvidence()) {
            if (checkedLinks.contains(evidenceLink)) {
                return true;
            }
            checkedLinks.add(evidenceLink);
            if (evidenceLink.equals(link)) {
                return true;
            }
            boolean hasNonCyclicExplanation = false;
            for (Explanation evidenceExp : reasoner.getExplanations(evidenceLink)) {
                if (ReasonerUtil.isExplanationForLinkCyclic(reasoner, evidenceExp, link, checkedLinks)) continue;
                hasNonCyclicExplanation = true;
            }
            if (hasNonCyclicExplanation) continue;
            return true;
        }
        return false;
    }

    public static Explanation getRedundancyExplanation(ReasonedLinkDatabase reasoner, Link link, Boolean isRepairMode) {
        if (TermUtil.isIntersection(link)) {
            return null;
        }
        if (TermUtil.isImplied(link)) {
            return null;
        }
        Explanation redExp = null;
        for (Explanation exp : reasoner.getExplanations(link)) {
            if (exp.getExplanationType().equals((Object)ExplanationType.GIVEN) || isRepairMode.booleanValue() && (exp.getExplanationType().equals((Object)ExplanationType.GENUS) || exp.getExplanationType().equals((Object)ExplanationType.DIFFERENTIA) || exp.getExplanationType().equals((Object)ExplanationType.INTERSECTION)) || exp.getExplanationType().equals((Object)ExplanationType.INTERSECTION)) continue;
            boolean nr = false;
            for (Link evLink : exp.getEvidence()) {
                for (Explanation evExp : reasoner.getExplanations(evLink)) {
                    if (!evExp.getExplanationType().equals((Object)ExplanationType.INTERSECTION)) continue;
                    for (Link ilink : evExp.getEvidence()) {
                        if (!ilink.getChild().equals(link.getChild()) || !ilink.getType().equals(link.getType()) || !ilink.getParent().equals(link.getParent())) continue;
                        nr = true;
                    }
                }
            }
            if (nr) {
                return null;
            }
            redExp = exp;
        }
        return redExp;
    }

    public static boolean isRedundant(ReasonedLinkDatabase reasoner, Link link, Boolean isRepairMode) {
        return ReasonerUtil.getRedundancyExplanation(reasoner, link, isRepairMode) != null;
    }

    public static boolean isRedundant(ReasonedLinkDatabase reasoner, Link link) {
        return ReasonerUtil.isRedundant(reasoner, link, true);
    }

    @Deprecated
    public static boolean isRedundantDEPRECATED(ReasonedLinkDatabase reasoner, Link link) {
        if (TermUtil.isIntersection(link)) {
            return false;
        }
        Collection<Explanation> exps = reasoner.getExplanations(link);
        Iterator<Explanation> it2 = exps.iterator();
        boolean hasGiven = false;
        boolean nonGenus = false;
        int i = 0;
        while (it2.hasNext()) {
            Explanation exp = it2.next();
            if (exp.getExplanationType().equals((Object)ExplanationType.GIVEN)) {
                hasGiven = true;
            } else if (!exp.getExplanationType().equals((Object)ExplanationType.GENUS)) {
                nonGenus = true;
            }
            if (hasGiven && nonGenus) break;
            ++i;
        }
        return hasGiven && nonGenus;
    }

    public static Collection<Link> getAllRedundantLinks(ReasonedLinkDatabase reasoner, LinkDatabase ldb) {
        LinkedHashSet<Link> redundantLinks = new LinkedHashSet<Link>();
        Iterator<Link> it = TermUtil.getAllLinks(ldb);
        while (it.hasNext()) {
            Link link = it.next();
            if (!ReasonerUtil.isRedundant(reasoner, link, true)) continue;
            redundantLinks.add(link);
        }
        return redundantLinks;
    }

    public static boolean shouldBeTrimmedNew(LinkDatabase linkDatabase, Link inLink) {
        if (!TermUtil.isImplied(inLink)) {
            return false;
        }
        if (TermUtil.isIntersection(inLink)) {
            return true;
        }
        LinkedList<Link> parents = new LinkedList<Link>(linkDatabase.getParents(inLink.getChild()));
        Collection<Link> children = linkDatabase.getChildren(inLink.getParent());
        OBORestrictionImpl scratch = new OBORestrictionImpl();
        for (Link link : parents) {
            if (TermUtil.isIntersection(link)) continue;
            scratch.setChild(link.getParent());
            scratch.setType(inLink.getType());
            scratch.setParent(inLink.getParent());
            if (children.contains(scratch)) {
                return true;
            }
            scratch.setType(OBOProperty.IS_A);
            if (!children.contains(scratch)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldBeTrimmed(LinkDatabase linkDatabase, Link link) {
        if (!TermUtil.isImplied(link)) {
            return false;
        }
        if (TermUtil.isIntersection(link)) {
            return true;
        }
        if (!link.getType().equals(OBOProperty.IS_A)) {
            return true;
        }
        if (link.getChild().equals(link.getParent())) {
            return true;
        }
        Collection<Link> parents = linkDatabase.getParents(link.getChild());
        for (Link parentLink : parents) {
            if (parentLink.equals(link) || parentLink.getChild().equals(parentLink.getParent()) || !parentLink.getType().equals(link.getType()) && !parentLink.getType().equals(OBOProperty.IS_A)) continue;
            boolean sawType = parentLink.getType().equals(link.getType());
            for (Link gpLink : linkDatabase.getParents(parentLink.getParent())) {
                if (gpLink.getChild().equals(gpLink.getParent()) || TermUtil.isIntersection(gpLink) || !link.getParent().equals(gpLink.getParent())) continue;
                if ((!sawType || link.getType().isTransitive()) && link.getType().equals(gpLink.getType())) {
                    return true;
                }
                if (!sawType || !gpLink.getType().equals(OBOProperty.IS_A)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSubclass(LinkDatabase linkDatabase, OBOProperty a, OBOProperty b) {
        if (linkDatabase instanceof ReasonedLinkDatabase) {
            return ((ReasonedLinkDatabase)linkDatabase).isSubPropertyOf(a, b);
        }
        for (Link link : linkDatabase.getParents(a)) {
            if (!link.getType().equals(OBOProperty.IS_A) || !link.getParent().equals(b)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubclass(LinkedObject a, LinkedObject b) {
        if (a.equals(b)) {
            return true;
        }
        for (Link tr : a.getParents()) {
            if (!ReasonerUtil.isSubclass(tr.getType(), OBOProperty.IS_A) || !ReasonerUtil.isSubclass(tr.getParent(), b)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubclass(LinkDatabase db, LinkedObject a, LinkedObject b) {
        if (a.equals(b)) {
            return true;
        }
        for (Link tr : db.getParents(a)) {
            if (!tr.getType().equals(OBOProperty.IS_A) || !tr.getParent().equals(b)) continue;
            return true;
        }
        return false;
    }

    public static void populateGivenSupportingLinks(Collection<Link> out, ReasonedLinkDatabase database, Link link) {
        ReasonerUtil.populateGivenSupportingLinks(out, database, link, new HashSet<Link>());
    }

    public static void populateGivenSupportingLinks(Collection<Link> out, ReasonedLinkDatabase database, Link link, Collection<Link> seenIt) {
        if (seenIt.contains(link)) {
            return;
        }
        seenIt.add(link);
        Collection<Explanation> exps = database.getExplanations(link);
        if (!TermUtil.isImplied(link)) {
            out.add(link);
        }
        for (Explanation explanation : exps) {
            for (Link evLink : explanation.getEvidence()) {
                ReasonerUtil.populateGivenSupportingLinks(out, database, evLink, seenIt);
            }
        }
    }

    public static boolean isIllegalIntersection(LinkedObject lo, boolean forceGenusDifferentia) {
        Collection<OBOClass> genae;
        LinkedList<Link> out = new LinkedList<Link>();
        for (Link link : lo.getParents()) {
            if (!TermUtil.isIntersection(link)) continue;
            out.add(link);
        }
        if (out.size() == 0) {
            return false;
        }
        if (out.size() == 1) {
            return true;
        }
        return forceGenusDifferentia && (genae = ReasonerUtil.getGenae((OBOClass)lo)).size() != 1;
    }

    public static Collection<OBOClass> getGenae(OBOClass oboClass) {
        LinkedList<OBOClass> out = new LinkedList<OBOClass>();
        for (Link parentLink : oboClass.getParents()) {
            if (!parentLink.getType().equals(OBOProperty.IS_A) || !TermUtil.isIntersection(parentLink)) continue;
            out.add(TermUtil.castToClass(parentLink.getParent()));
        }
        return out;
    }

    public static OBOClass getGenus(OBOClass obj) {
        OBOClass genus = null;
        for (OBOClass g : ReasonerUtil.getGenae(obj)) {
            if (genus != null) {
                throw new RuntimeException(">1 genus for " + obj);
            }
            genus = g;
        }
        return genus;
    }

    public static Collection<Link> getDifferentia(OBOClass oboClass) {
        LinkedList<Link> out = new LinkedList<Link>();
        for (Link parentLink : oboClass.getParents()) {
            if (parentLink.getType().equals(OBOProperty.IS_A) || !TermUtil.isIntersection(parentLink)) continue;
            out.add(TermUtil.castParentToClass(parentLink));
        }
        return out;
    }

    public static Collection<OBOClass> getDifferentiaByType(OBOClass oboClass, OBOProperty prop) {
        LinkedList<OBOClass> out = new LinkedList<OBOClass>();
        for (Link parentLink : oboClass.getParents()) {
            if (!parentLink.getType().equals(prop) || !TermUtil.isIntersection(parentLink)) continue;
            out.add(TermUtil.castToClass(parentLink.getParent()));
        }
        return out;
    }

    public static Collection<OBOClass> getDifferentiaByType(OBOClass oboClass, String propName) {
        LinkedList<OBOClass> out = new LinkedList<OBOClass>();
        for (Link parentLink : oboClass.getParents()) {
            if (parentLink.getType().getName() == null || !parentLink.getType().getName().equals(propName) || !TermUtil.isIntersection(parentLink)) continue;
            out.add(TermUtil.castToClass(parentLink.getParent()));
        }
        return out;
    }

    public static Collection<Link> getIntersectionLinks(OBOClass oboClass) {
        LinkedList<Link> out = new LinkedList<Link>();
        for (Link parentLink : oboClass.getParents()) {
            if (!TermUtil.isIntersection(parentLink)) continue;
            out.add(TermUtil.castParentToClass(parentLink));
        }
        return out;
    }

    public static boolean isEquivalent(LinkedObject child, LinkedObject parent) {
        return false;
    }

    public static boolean isEquivalent(LinkDatabase ldb, LinkedObject a, LinkedObject b) {
        return ReasonerUtil.isSubclass(ldb, a, b) && ReasonerUtil.isSubclass(ldb, b, a);
    }
}

