/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.text.ParseException;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.apache.log4j.Logger;
import org.bbop.util.StringUtil;

public class VersionNumber
implements Comparable<VersionNumber> {
    protected static final Logger logger = Logger.getLogger(VersionNumber.class);
    protected int majorVersion;
    protected int minorVersion;
    protected int subminorVersion = -999;
    protected int betaVersion;
    protected int rcVersion;

    public VersionNumber(String str) throws ParseException {
        MatchResult result;
        Scanner s = new Scanner(str);
        try {
            s.findInLine("(\\d+)");
            result = s.match();
            this.majorVersion = Integer.parseInt(result.group(1));
        }
        catch (IllegalStateException ex) {
            throw new ParseException(str, -1);
        }
        try {
            s.findInLine(".(\\d+)");
            result = s.match();
            this.minorVersion = Integer.parseInt(result.group(1));
        }
        catch (IllegalStateException ex) {
            throw new ParseException(str, -1);
        }
        try {
            Scanner s2 = s;
            s2.findInLine("\\.(\\d+)");
            MatchResult result2 = s2.match();
            this.subminorVersion = Integer.parseInt(result2.group(1));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            s.findInLine("-beta(\\d+)");
            result = s.match();
            this.betaVersion = Integer.parseInt(result.group(1));
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            s.findInLine("-b(\\d+)");
            result = s.match();
            this.betaVersion = Integer.parseInt(result.group(1));
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            s.findInLine("-rc(\\d+)");
            result = s.match();
            this.rcVersion = Integer.parseInt(result.group(1));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        s.close();
    }

    public String toString() {
        return this.majorVersion + "." + StringUtil.pad((String)(this.minorVersion + ""), (char)'0', (int)1, (boolean)true) + (this.subminorVersion == -999 ? "" : "." + this.subminorVersion) + (this.isRC() ? "-rc" + this.rcVersion : "") + (this.isBeta() ? "-beta" + this.betaVersion : "");
    }

    public boolean isBeta() {
        return this.betaVersion > 0;
    }

    public int getBetaVersion() {
        return this.betaVersion;
    }

    public boolean isRC() {
        return this.rcVersion > 0;
    }

    public int getRCVersion() {
        return this.rcVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int hashCode() {
        return this.getMajorVersion() * 100000 + this.getMinorVersion() * 100 + this.getRCVersion();
    }

    public boolean equals(Object o) {
        if (o instanceof VersionNumber) {
            VersionNumber vn = (VersionNumber)o;
            return vn.getRCVersion() == this.getRCVersion() && vn.getMajorVersion() == this.getMajorVersion() && vn.getMinorVersion() == this.getMinorVersion();
        }
        return false;
    }

    @Override
    public int compareTo(VersionNumber o) {
        int majorDiff = o.getMajorVersion() - this.getMajorVersion();
        int minorDiff = o.getMinorVersion() - this.getMinorVersion();
        int rcDiff = o.getRCVersion() - this.getRCVersion();
        return majorDiff * 100000 + minorDiff * 100 + rcDiff;
    }
}

