/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.manchesterowlsyntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntax;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyHeader;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxTokenizer;
import org.coode.owlapi.manchesterowlsyntax.OntologyAxiomPair;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.OWLOntologyChecker;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterOWLSyntaxEditorParser {
    private OWLOntologyLoaderConfiguration configuration;
    protected OWLDataFactory dataFactory;
    private List<ManchesterOWLSyntaxTokenizer.Token> tokens;
    private int tokenIndex;
    private OWLEntityChecker owlEntityChecker;
    private OWLOntologyChecker owlOntologyChecker = new OWLOntologyChecker(){

        public OWLOntology getOntology(String name) {
            return null;
        }
    };
    private String base;
    private Set<String> classNames;
    private Set<String> objectPropertyNames;
    private Set<String> dataPropertyNames;
    private Set<String> individualNames;
    private Set<String> dataTypeNames;
    private Set<String> annotationPropertyNames;
    private Map<String, SWRLBuiltInsVocabulary> ruleBuiltIns = new TreeMap<String, SWRLBuiltInsVocabulary>();
    private DefaultPrefixManager pm = new DefaultPrefixManager();
    public static final String AND = ManchesterOWLSyntax.AND.toString();
    public static final String OR = ManchesterOWLSyntax.OR.toString();
    public static final String INVERSE = ManchesterOWLSyntax.INVERSE.toString();
    public static final String SOME = ManchesterOWLSyntax.SOME.toString();
    public static final String SELF = ManchesterOWLSyntax.SELF.toString();
    public static final String ONLY = ManchesterOWLSyntax.ONLY.toString();
    public static final String VALUE = ManchesterOWLSyntax.VALUE.toString();
    public static final String MIN = ManchesterOWLSyntax.MIN.toString();
    public static final String MAX = ManchesterOWLSyntax.MAX.toString();
    public static final String EXACTLY = ManchesterOWLSyntax.EXACTLY.toString();
    public static final String ONLYSOME = ManchesterOWLSyntax.ONLYSOME.toString();
    public static final String NOT = ManchesterOWLSyntax.NOT.toString();
    public static final String CLASS = ManchesterOWLSyntax.CLASS.toString() + ":";
    public static final String DATATYPE = ManchesterOWLSyntax.DATATYPE.toString() + ":";
    public static final String SUB_CLASS_OF = ManchesterOWLSyntax.SUBCLASS_OF.toString() + ":";
    public static final String SUPER_CLASS_OF = ManchesterOWLSyntax.SUPERCLASS_OF.toString() + ":";
    public static final String INSTANCES = "Instances:";
    public static final String EQUIVALENT_TO = ManchesterOWLSyntax.EQUIVALENT_TO.toString() + ":";
    public static final String EQUIVALENT_CLASSES = ManchesterOWLSyntax.EQUIVALENT_CLASSES.toString() + ":";
    public static final String EQUIVALENT_PROPERTIES = ManchesterOWLSyntax.EQUIVALENT_PROPERTIES.toString() + ":";
    public static final String DISJOINT_WITH = ManchesterOWLSyntax.DISJOINT_WITH.toString() + ":";
    public static final String DISJOINT_UNION_OF = ManchesterOWLSyntax.DISJOINT_UNION_OF.toString() + ":";
    public static final String HAS_KEY = ManchesterOWLSyntax.HAS_KEY.toString() + ":";
    public static final String DISJOINT_CLASSES = ManchesterOWLSyntax.DISJOINT_CLASSES.toString() + ":";
    public static final String DISJOINT_PROPERTIES = ManchesterOWLSyntax.DISJOINT_PROPERTIES.toString() + ":";
    public static final String OBJECT_PROPERTY = ManchesterOWLSyntax.OBJECT_PROPERTY.toString() + ":";
    public static final String DATA_PROPERTY = ManchesterOWLSyntax.DATA_PROPERTY.toString() + ":";
    public static final String ANNOTATION_PROPERTY = ManchesterOWLSyntax.ANNOTATION_PROPERTY.toString() + ":";
    public static final String SUB_PROPERTY_OF = ManchesterOWLSyntax.SUB_PROPERTY_OF.toString() + ":";
    public static final String SUPER_PROPERTY_OF = ManchesterOWLSyntax.SUPER_PROPERTY_OF.toString() + ":";
    public static final String DOMAIN = ManchesterOWLSyntax.DOMAIN.toString() + ":";
    public static final String RANGE = ManchesterOWLSyntax.RANGE.toString() + ":";
    public static final String INVERSES = ManchesterOWLSyntax.INVERSES.toString() + ":";
    public static final String CHARACTERISTICS = ManchesterOWLSyntax.CHARACTERISTICS.toString() + ":";
    public static final String INDIVIDUAL = ManchesterOWLSyntax.INDIVIDUAL.toString() + ":";
    public static final String INDIVIDUALS = ManchesterOWLSyntax.INDIVIDUALS.toString() + ":";
    public static final String ANNOTATIONS = ManchesterOWLSyntax.ANNOTATIONS.toString() + ":";
    public static final String TYPES = ManchesterOWLSyntax.TYPES.toString() + ":";
    public static final String TYPE = ManchesterOWLSyntax.TYPE.toString() + ":";
    public static final String FACTS = ManchesterOWLSyntax.FACTS.toString() + ":";
    public static final String SAME_AS = ManchesterOWLSyntax.SAME_AS.toString() + ":";
    public static final String SAME_INDIVIDUAL = ManchesterOWLSyntax.SAME_INDIVIDUAL.toString() + ":";
    public static final String DIFFERENT_FROM = ManchesterOWLSyntax.DIFFERENT_FROM.toString() + ":";
    public static final String DIFFERENT_INDIVIDUALS = ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS.toString() + ":";
    public static final String VALUE_PARTITION = "ValuePartition:";
    public static final String ONTOLOGY = ManchesterOWLSyntax.ONTOLOGY.toString() + ":";
    public static final String PREFIX = ManchesterOWLSyntax.PREFIX.toString() + ":";
    public static final String IMPORT = ManchesterOWLSyntax.IMPORT.toString() + ":";
    public static final String SUB_PROPERTY_CHAIN = ManchesterOWLSyntax.SUB_PROPERTY_CHAIN.toString() + ":";
    public static final String FUNCTIONAL = ManchesterOWLSyntax.FUNCTIONAL.toString();
    public static final String INVERSE_FUNCTIONAL = ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString();
    public static final String SYMMETRIC = ManchesterOWLSyntax.SYMMETRIC.toString();
    public static final String ANTI_SYMMETRIC = ManchesterOWLSyntax.ANTI_SYMMETRIC.toString();
    public static final String ASYMMETRIC = ManchesterOWLSyntax.ASYMMETRIC.toString();
    public static final String TRANSITIVE = ManchesterOWLSyntax.TRANSITIVE.toString();
    public static final String REFLEXIVE = ManchesterOWLSyntax.REFLEXIVE.toString();
    public static final String IRREFLEXIVE = ManchesterOWLSyntax.IRREFLEXIVE.toString();
    public static final String INVERSE_OF = (Object)((Object)ManchesterOWLSyntax.INVERSE_OF) + ":";
    public static final String RULE = (Object)((Object)ManchesterOWLSyntax.RULE) + ":";
    private Set<String> potentialKeywords;
    private OWLOntology defaultOntology = null;
    private boolean allowEmptyFrameSections = false;
    private Map<String, AnnotatedListItemParser<OWLDataProperty, ?>> dataPropertyFrameSections = new HashMap();
    private Map<String, AnnotatedListItemParser<OWLClass, ?>> classFrameSections = new HashMap();
    private Map<String, AnnotatedListItemParser<OWLObjectProperty, ?>> objectPropertyFrameSections = new HashMap();
    private Map<String, AnnotatedListItemParser<OWLAnnotationProperty, ?>> annotationPropertyFrameSections = new HashMap();
    private Map<String, AnnotatedListItemParser<OWLIndividual, ?>> individualFrameSections = new HashMap();
    private Map<String, IRI> nameIRIMap = new HashMap<String, IRI>();

    public ManchesterOWLSyntaxEditorParser(OWLDataFactory dataFactory, String s) {
        this(new OWLOntologyLoaderConfiguration(), dataFactory, s);
    }

    public boolean isAllowEmptyFrameSections() {
        return this.allowEmptyFrameSections;
    }

    public void setAllowEmptyFrameSections(boolean allowEmptyFrameSections) {
        this.allowEmptyFrameSections = allowEmptyFrameSections;
    }

    public ManchesterOWLSyntaxEditorParser(OWLOntologyLoaderConfiguration configuration, OWLDataFactory dataFactory, String s) {
        this.configuration = configuration;
        this.dataFactory = dataFactory;
        this.potentialKeywords = new HashSet<String>();
        this.classNames = new HashSet<String>();
        this.objectPropertyNames = new HashSet<String>();
        this.dataPropertyNames = new HashSet<String>();
        this.individualNames = new HashSet<String>();
        this.dataTypeNames = new HashSet<String>();
        this.annotationPropertyNames = new HashSet<String>();
        this.pm.setPrefix("rdf:", Namespaces.RDF.toString());
        this.pm.setPrefix("rdfs:", Namespaces.RDFS.toString());
        this.pm.setPrefix("owl:", Namespaces.OWL.toString());
        this.pm.setPrefix("dc:", "http://purl.org/dc/elements/1.1/");
        NamespaceUtil u = new NamespaceUtil();
        this.initialiseClassFrameSections();
        this.initialiseObjectPropertyFrameSections();
        this.initialiseDataPropertyFrameSections();
        this.initialiseAnnotationPropertyFrameSections();
        this.initialiseIndividualFrameSections();
        for (XSDVocabulary xSDVocabulary : XSDVocabulary.values()) {
            this.dataTypeNames.add(xSDVocabulary.getIRI().getFragment());
            this.dataTypeNames.add("xsd:" + xSDVocabulary.getIRI().getFragment());
        }
        this.dataTypeNames.add(OWLRDFVocabulary.RDF_XML_LITERAL.getIRI().getFragment());
        this.dataTypeNames.add("rdf:" + OWLRDFVocabulary.RDF_XML_LITERAL.getIRI().getFragment());
        this.dataTypeNames.add(dataFactory.getTopDatatype().getIRI().getFragment());
        for (IRI iri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS) {
            String[] res = u.split(iri.toString(), null);
            this.annotationPropertyNames.add(u.getPrefix(res[0]) + ":" + res[1]);
        }
        this.base = "http://www.semanticweb.org#";
        this.owlEntityChecker = new DefaultEntityChecker();
        this.tokens = new ArrayList<ManchesterOWLSyntaxTokenizer.Token>();
        this.tokens.addAll(this.getTokenizer(s).tokenize());
        this.tokenIndex = 0;
        for (Enum enum_ : SWRLBuiltInsVocabulary.values()) {
            this.ruleBuiltIns.put(((SWRLBuiltInsVocabulary)enum_).getShortName(), (SWRLBuiltInsVocabulary)enum_);
            this.ruleBuiltIns.put(((SWRLBuiltInsVocabulary)enum_).getIRI().toQuotedString(), (SWRLBuiltInsVocabulary)enum_);
        }
    }

    protected ManchesterOWLSyntaxTokenizer getTokenizer(String s) {
        return new ManchesterOWLSyntaxTokenizer(s);
    }

    public OWLDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public void initialiseClassFrameSections() {
        this.initialiseSection(new EntityAnnotationsListItemParser(), this.classFrameSections, new String[0]);
        this.initialiseSection(new ClassSubClassOfListItemParser(), this.classFrameSections, new String[0]);
        this.initialiseSection(new ClassEquivalentToListItemParser(), this.classFrameSections, new String[0]);
        this.initialiseSection(new ClassDisjointWithListItemParser(), this.classFrameSections, new String[0]);
        this.initialiseSection(new ClassHasKeyListItemParser(), this.classFrameSections, new String[0]);
        this.initialiseSection(new ClassSuperClassOfListItemParser(), this.classFrameSections, new String[0]);
        this.initialiseSection(new ClassDisjointClassesListItemParser(), this.classFrameSections, new String[0]);
        this.initialiseSection(new ClassIndividualsListItemParser(), this.classFrameSections, new String[0]);
    }

    private void initialiseObjectPropertyFrameSections() {
        this.initialiseSection(new EntityAnnotationsListItemParser(), this.objectPropertyFrameSections, new String[0]);
        this.initialiseSection(new ObjectPropertySubPropertyOfListItemParser(), this.objectPropertyFrameSections, new String[0]);
        this.initialiseSection(new ObjectPropertyEquivalentToListItemParser(), this.objectPropertyFrameSections, new String[0]);
        this.initialiseSection(new ObjectPropertyDisjointWithListItemParser(), this.objectPropertyFrameSections, new String[0]);
        this.initialiseSection(new ObjectPropertyDomainListItemParser(), this.objectPropertyFrameSections, new String[0]);
        this.initialiseSection(new ObjectPropertyRangeListItemParser(), this.objectPropertyFrameSections, new String[0]);
        this.initialiseSection(new ObjectPropertyInverseOfListItemParser(), this.objectPropertyFrameSections, new String[0]);
        this.initialiseSection(new ObjectPropertyCharacteristicsItemParser(), this.objectPropertyFrameSections, new String[0]);
        this.initialiseSection(new ObjectPropertySubPropertyChainListItemParser(), this.objectPropertyFrameSections, new String[0]);
        this.initialiseSection(new ObjectPropertySuperPropertyOfListItemParser(), this.objectPropertyFrameSections, new String[0]);
    }

    private void initialiseDataPropertyFrameSections() {
        this.initialiseSection(new DataPropertySubPropertyOfListItemParser(), this.dataPropertyFrameSections, new String[0]);
        this.initialiseSection(new DataPropertyEquivalentToListItemParser(), this.dataPropertyFrameSections, new String[0]);
        this.initialiseSection(new DataPropertyDisjointWithListItemParser(), this.dataPropertyFrameSections, new String[0]);
        this.initialiseSection(new DataPropertyDomainListItemParser(), this.dataPropertyFrameSections, new String[0]);
        this.initialiseSection(new DataPropertyRangeListItemParser(), this.dataPropertyFrameSections, new String[0]);
        this.initialiseSection(new DataPropertyCharacteristicsItemParser(), this.dataPropertyFrameSections, new String[0]);
        this.initialiseSection(new EntityAnnotationsListItemParser(), this.dataPropertyFrameSections, new String[0]);
    }

    private void initialiseAnnotationPropertyFrameSections() {
        this.initialiseSection(new AnnotationPropertySubPropertyOfListItemParser(), this.annotationPropertyFrameSections, new String[0]);
        this.initialiseSection(new AnnotationPropertyDomainListItemParser(), this.annotationPropertyFrameSections, new String[0]);
        this.initialiseSection(new AnnotationPropertyRangeListItemParser(), this.annotationPropertyFrameSections, new String[0]);
        this.initialiseSection(new EntityAnnotationsListItemParser(), this.annotationPropertyFrameSections, new String[0]);
    }

    public void initialiseIndividualFrameSections() {
        this.initialiseSection(new IndividualAnnotationItemParser(), this.individualFrameSections, new String[0]);
        this.initialiseSection(new IndividualTypesItemParser(), this.individualFrameSections, new String[0]);
        this.initialiseSection(new IndividualFactsItemParser(), this.individualFrameSections, new String[0]);
        this.initialiseSection(new IndividualSameAsItemParser(), this.individualFrameSections, new String[0]);
        this.initialiseSection(new IndividualDifferentFromItemParser(), this.individualFrameSections, new String[0]);
        this.initialiseSection(new IndividualDifferentIndividualsItemParser(), this.individualFrameSections, new String[0]);
    }

    protected List<ManchesterOWLSyntaxTokenizer.Token> getTokens() {
        return this.tokens;
    }

    protected void reset() {
        this.tokenIndex = 0;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public OWLEntityChecker getOWLEntityChecker() {
        return this.owlEntityChecker;
    }

    public void setOWLEntityChecker(OWLEntityChecker owlEntityChecker) {
        this.owlEntityChecker = owlEntityChecker;
    }

    public boolean isOntologyName(String name) {
        return this.owlOntologyChecker.getOntology(name) != null;
    }

    public boolean isClassName(String name) {
        return this.classNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLClass(name) != null;
    }

    public OWLOntology getOntology(String name) {
        return this.owlOntologyChecker.getOntology(name);
    }

    public void setOWLOntologyChecker(OWLOntologyChecker owlOntologyChecker) {
        this.owlOntologyChecker = owlOntologyChecker;
    }

    public boolean isObjectPropertyName(String name) {
        return this.objectPropertyNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLObjectProperty(name) != null;
    }

    public boolean isAnnotationPropertyName(String name) {
        return this.annotationPropertyNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLAnnotationProperty(name) != null;
    }

    public boolean isDataPropertyName(String name) {
        return this.dataPropertyNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLDataProperty(name) != null;
    }

    public boolean isIndividualName(String name) {
        return this.individualNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLIndividual(name) != null;
    }

    public boolean isDatatypeName(String name) {
        return this.dataTypeNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLDatatype(name) != null;
    }

    public boolean isSWRLBuiltin(String name) {
        return this.ruleBuiltIns.containsKey(name);
    }

    public OWLClass getOWLClass(String name) {
        OWLClass cls = this.owlEntityChecker.getOWLClass(name);
        if (cls == null && this.classNames.contains(name)) {
            cls = this.dataFactory.getOWLClass(this.getIRI(name));
        }
        return cls;
    }

    public OWLObjectProperty getOWLObjectProperty(String name) {
        OWLObjectProperty prop = this.owlEntityChecker.getOWLObjectProperty(name);
        if (prop == null && this.objectPropertyNames.contains(name)) {
            prop = this.dataFactory.getOWLObjectProperty(this.getIRI(name));
        }
        return prop;
    }

    public OWLIndividual getOWLIndividual(String name) {
        if (name.startsWith("_:")) {
            return this.dataFactory.getOWLAnonymousIndividual(name);
        }
        return this.getOWLNamedIndividual(name);
    }

    private OWLNamedIndividual getOWLNamedIndividual(String name) {
        OWLNamedIndividual ind = this.owlEntityChecker.getOWLIndividual(name);
        if (ind == null && this.individualNames.contains(name)) {
            ind = this.dataFactory.getOWLNamedIndividual(this.getIRI(name));
        }
        return ind;
    }

    public OWLDataProperty getOWLDataProperty(String name) {
        OWLDataProperty prop = this.owlEntityChecker.getOWLDataProperty(name);
        if (prop == null && this.dataPropertyNames.contains(name)) {
            prop = this.dataFactory.getOWLDataProperty(this.getIRI(name));
        }
        return prop;
    }

    public OWLDatatype getOWLDatatype(String name) {
        OWLDatatype dt = this.owlEntityChecker.getOWLDatatype(name);
        if (dt == null && this.dataTypeNames.contains(name)) {
            dt = this.dataFactory.getOWLDatatype(this.getIRI(name));
        }
        return dt;
    }

    public OWLAnnotationProperty getOWLAnnotationProperty(String name) {
        OWLAnnotationProperty prop = this.owlEntityChecker.getOWLAnnotationProperty(name);
        if (prop == null && this.annotationPropertyNames.contains(name)) {
            prop = this.dataFactory.getOWLAnnotationProperty(this.getIRI(name));
        }
        return prop;
    }

    protected ManchesterOWLSyntaxTokenizer.Token getLastToken() {
        if (this.tokenIndex - 1 > -1) {
            return this.tokens.get(this.tokenIndex - 1);
        }
        return this.tokens.get(0);
    }

    protected String peekToken() {
        return this.getToken().getToken();
    }

    protected String consumeToken() {
        String token = this.getToken().getToken();
        if (this.tokenIndex < this.tokens.size() - 1) {
            ++this.tokenIndex;
        }
        return token;
    }

    protected void consumeToken(String expected) throws ParserException {
        String tok = this.consumeToken();
        if (!tok.equals(expected)) {
            throw this.createException(expected);
        }
    }

    public ManchesterOWLSyntaxTokenizer.Token getToken() {
        return this.tokens.get(this.tokenIndex < this.tokens.size() ? this.tokenIndex : this.tokenIndex - 1);
    }

    public int getTokenPos() {
        return this.getToken().getPos();
    }

    public int getTokenCol() {
        return this.getToken().getCol();
    }

    public int getTokenRow() {
        return this.getToken().getRow();
    }

    public OWLClassExpression parseClassExpression() throws ParserException {
        OWLClassExpression desc = this.parseIntersection();
        if (!this.consumeToken().equals("|EOF|")) {
            throw this.createException("|EOF|");
        }
        return desc;
    }

    public OWLClassExpression parseIntersection() throws ParserException {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        String kw = AND;
        while (kw.equalsIgnoreCase(AND)) {
            this.potentialKeywords.remove(AND);
            ops.add(this.parseUnion());
            this.potentialKeywords.add(AND);
            kw = this.peekToken();
            if (kw.equalsIgnoreCase(AND)) {
                kw = this.consumeToken();
                continue;
            }
            if (!kw.equalsIgnoreCase("that")) continue;
            this.consumeToken();
            kw = AND;
        }
        if (ops.size() == 1) {
            return (OWLClassExpression)ops.iterator().next();
        }
        return this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    public OWLClassExpression parseUnion() throws ParserException {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        String kw = OR;
        while (kw.equalsIgnoreCase(OR)) {
            this.potentialKeywords.remove(OR);
            ops.add(this.parseNonNaryClassExpression());
            this.potentialKeywords.add(OR);
            kw = this.peekToken();
            if (!kw.equalsIgnoreCase(OR)) continue;
            kw = this.consumeToken();
        }
        if (ops.size() == 1) {
            return (OWLClassExpression)ops.iterator().next();
        }
        return this.dataFactory.getOWLObjectUnionOf(ops);
    }

    public OWLObjectPropertyExpression parseObjectPropertyExpression(boolean allowUndeclared) throws ParserException {
        String tok = this.consumeToken();
        if (tok.equalsIgnoreCase(INVERSE)) {
            String close;
            String open = this.peekToken();
            boolean brackets = false;
            if (open.equals("(")) {
                this.consumeToken();
                brackets = true;
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            if (brackets && !(close = this.consumeToken()).equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLObjectInverseOf(prop);
        }
        if (!allowUndeclared && !this.isObjectPropertyName(tok)) {
            throw this.createException(false, true, false, false, false, false, INVERSE);
        }
        return this.getOWLObjectProperty(tok);
    }

    public OWLObjectPropertyExpression parseObjectPropertyExpression() throws ParserException {
        return this.parseObjectPropertyExpression(false);
    }

    public OWLPropertyExpression<?, ?> parsePropertyExpression() throws ParserException {
        String tok = this.peekToken();
        if (this.isObjectPropertyName(tok)) {
            return this.parseObjectPropertyExpression();
        }
        if (tok.equalsIgnoreCase(INVERSE)) {
            return this.parseObjectPropertyExpression();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataProperty();
        }
        this.consumeToken();
        throw this.createException(false, true, true, false, false, false, INVERSE);
    }

    public OWLClassExpression parseRestriction() throws ParserException {
        String tok = this.peekToken();
        if (this.isObjectPropertyName(tok) || tok.equalsIgnoreCase(INVERSE)) {
            return this.parseObjectRestriction();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataRestriction();
        }
        this.consumeToken();
        throw this.createException(false, true, true, false);
    }

    public OWLClassExpression parseNonNaryClassExpression() throws ParserException {
        String tok = this.peekToken();
        if (tok.equalsIgnoreCase(NOT)) {
            this.consumeToken();
            OWLClassExpression complemented = this.parseNestedClassExpression(false);
            return this.dataFactory.getOWLObjectComplementOf(complemented);
        }
        if (this.isObjectPropertyName(tok) || tok.equalsIgnoreCase(INVERSE)) {
            return this.parseObjectRestriction();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataRestriction();
        }
        if (tok.equals("{")) {
            return this.parseObjectOneOf();
        }
        if (tok.equals("(")) {
            return this.parseNestedClassExpression(false);
        }
        if (this.isClassName(tok)) {
            this.consumeToken();
            return this.getOWLClass(tok);
        }
        this.consumeToken();
        throw this.createException(true, true, true, false, false, false, "(", "{", NOT, INVERSE);
    }

    public OWLClassExpression parseObjectRestriction() throws ParserException {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(SOME)) {
            String possSelfToken = this.peekToken();
            if (possSelfToken.equalsIgnoreCase(SELF)) {
                this.consumeToken();
                return this.dataFactory.getOWLObjectHasSelf(prop);
            }
            OWLClassExpression filler = null;
            try {
                filler = this.parseNestedClassExpression(false);
            }
            catch (ParserException e) {
                HashSet<String> keywords = new HashSet<String>();
                keywords.addAll(e.getExpectedKeywords());
                keywords.add(SELF);
                throw this.createException(e.isClassNameExpected(), e.isObjectPropertyNameExpected(), e.isDataPropertyNameExpected(), e.isIndividualNameExpected(), e.isDatatypeNameExpected(), e.isAnnotationPropertyNameExpected(), keywords.toArray(new String[keywords.size()]));
            }
            return this.dataFactory.getOWLObjectSomeValuesFrom(prop, filler);
        }
        if (kw.equalsIgnoreCase(ONLY)) {
            OWLClassExpression filler = this.parseNestedClassExpression(false);
            return this.dataFactory.getOWLObjectAllValuesFrom(prop, filler);
        }
        if (kw.equalsIgnoreCase(VALUE)) {
            String indName = this.consumeToken();
            if (!this.isIndividualName(indName)) {
                throw this.createException(false, false, false, true);
            }
            return this.dataFactory.getOWLObjectHasValue(prop, this.getOWLIndividual(indName));
        }
        if (kw.equalsIgnoreCase(MIN)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            if (filler != null) {
                return this.dataFactory.getOWLObjectMinCardinality(card, prop, filler);
            }
            return this.dataFactory.getOWLObjectMinCardinality(card, prop);
        }
        if (kw.equalsIgnoreCase(MAX)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            if (filler != null) {
                return this.dataFactory.getOWLObjectMaxCardinality(card, prop, filler);
            }
            return this.dataFactory.getOWLObjectMaxCardinality(card, prop);
        }
        if (kw.equalsIgnoreCase(EXACTLY)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            if (filler != null) {
                return this.dataFactory.getOWLObjectExactCardinality(card, prop, filler);
            }
            return this.dataFactory.getOWLObjectExactCardinality(card, prop);
        }
        if (kw.equalsIgnoreCase(ONLYSOME)) {
            String tok = this.peekToken();
            HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
            if (!tok.equals("[")) {
                descs.add(this.parseIntersection());
            } else {
                descs.addAll(this.parseClassExpressionList("[", "]"));
            }
            HashSet<OWLQuantifiedObjectRestriction> ops = new HashSet<OWLQuantifiedObjectRestriction>();
            for (OWLClassExpression desc : descs) {
                ops.add(this.dataFactory.getOWLObjectSomeValuesFrom(prop, desc));
            }
            OWLClassExpression filler = descs.size() == 1 ? (OWLClassExpression)descs.iterator().next() : this.dataFactory.getOWLObjectUnionOf(descs);
            ops.add(this.dataFactory.getOWLObjectAllValuesFrom(prop, filler));
            return this.dataFactory.getOWLObjectIntersectionOf(ops);
        }
        if (kw.equalsIgnoreCase(SELF)) {
            return this.dataFactory.getOWLObjectHasSelf(prop);
        }
        throw this.createException(SOME, ONLY, VALUE, MIN, MAX, EXACTLY, SELF);
    }

    public OWLClassExpression parseDataRestriction() throws ParserException {
        OWLDataProperty prop = this.parseDataProperty();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(SOME)) {
            OWLDataRange rng = this.parseDataRange();
            if (rng == null) {
                throw new ParserException(this.getTokenSequence(), this.getTokenPos(), this.getTokenRow(), this.getTokenCol(), true, false, false, false, true, false, Collections.<String>emptySet());
            }
            return this.dataFactory.getOWLDataSomeValuesFrom(prop, rng);
        }
        if (kw.equalsIgnoreCase(ONLY)) {
            OWLDataRange rng = this.parseDataRange();
            return this.dataFactory.getOWLDataAllValuesFrom(prop, rng);
        }
        if (kw.equalsIgnoreCase(VALUE)) {
            OWLLiteral con = this.parseConstant();
            return this.dataFactory.getOWLDataHasValue(prop, con);
        }
        if (kw.equalsIgnoreCase(MIN)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            if (rng != null) {
                return this.dataFactory.getOWLDataMinCardinality(card, prop, rng);
            }
            return this.dataFactory.getOWLDataMinCardinality(card, prop);
        }
        if (kw.equalsIgnoreCase(EXACTLY)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            if (rng != null) {
                return this.dataFactory.getOWLDataExactCardinality(card, prop, rng);
            }
            return this.dataFactory.getOWLDataExactCardinality(card, prop);
        }
        if (kw.equalsIgnoreCase(MAX)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            if (rng != null) {
                return this.dataFactory.getOWLDataMaxCardinality(card, prop, rng);
            }
            return this.dataFactory.getOWLDataMaxCardinality(card, prop);
        }
        throw this.createException(SOME, ONLY, VALUE, MIN, EXACTLY, MAX);
    }

    public OWLFacet parseFacet() throws ParserException {
        String facet = this.consumeToken();
        if (facet.equals(">")) {
            if (this.peekToken().equals("=")) {
                this.consumeToken();
                return OWLFacet.MIN_INCLUSIVE;
            }
            return OWLFacet.MIN_EXCLUSIVE;
        }
        if (facet.equals("<")) {
            if (this.peekToken().equals("=")) {
                this.consumeToken();
                return OWLFacet.MAX_INCLUSIVE;
            }
            return OWLFacet.MAX_EXCLUSIVE;
        }
        return OWLFacet.getFacetBySymbolicName(facet);
    }

    public OWLDatatype parseDatatype() throws ParserException {
        String name = this.consumeToken();
        return this.getOWLDatatype(name);
    }

    public OWLDataRange parseDataRange() throws ParserException {
        return this.parseDataIntersectionOf();
    }

    public OWLDataRange parseDataIntersectionOf() throws ParserException {
        String sep = AND;
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (sep.equals(AND)) {
            ranges.add(this.parseDataUnionOf());
            sep = this.peekToken();
            if (!sep.equals(AND)) continue;
            this.consumeToken();
        }
        if (ranges.size() == 1) {
            return (OWLDataRange)ranges.iterator().next();
        }
        return this.dataFactory.getOWLDataIntersectionOf(ranges);
    }

    public OWLDataRange parseDataUnionOf() throws ParserException {
        String sep = OR;
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (sep.equals(OR)) {
            ranges.add(this.parseDataRangePrimary());
            sep = this.peekToken();
            if (!sep.equals(OR)) continue;
            this.consumeToken();
        }
        if (ranges.size() == 1) {
            return (OWLDataRange)ranges.iterator().next();
        }
        return this.dataFactory.getOWLDataUnionOf(ranges);
    }

    private OWLDataRange parseDataRangePrimary() throws ParserException {
        String tok = this.peekToken();
        if (this.isDatatypeName(tok)) {
            this.consumeToken();
            OWLDatatype datatype = this.getOWLDatatype(tok);
            String next = this.peekToken();
            if (next.equals("[")) {
                this.consumeToken();
                String sep = ",";
                HashSet<OWLFacetRestriction> facetRestrictions = new HashSet<OWLFacetRestriction>();
                while (sep.equals(",")) {
                    OWLFacet fv = this.parseFacet();
                    if (fv == null) {
                        throw this.createException(OWLFacet.getFacets().toArray(new String[OWLFacet.getFacetIRIs().size()]));
                    }
                    OWLLiteral con = this.parseConstant();
                    facetRestrictions.add(this.dataFactory.getOWLFacetRestriction(fv, con));
                    sep = this.consumeToken();
                }
                if (!sep.equals("]")) {
                    throw this.createException("]");
                }
                return this.dataFactory.getOWLDatatypeRestriction(datatype, facetRestrictions);
            }
            return datatype;
        }
        if (tok.equalsIgnoreCase(NOT)) {
            return this.parseDataComplementOf();
        }
        if (tok.equals("{")) {
            return this.parseDataOneOf();
        }
        if (tok.equals("(")) {
            this.consumeToken();
            OWLDataRange rng = this.parseDataRange();
            this.consumeToken(")");
            return rng;
        }
        if (!tok.equals("|EOF|")) {
            this.consumeToken();
            throw this.createException(false, false, false, false, true, false, NOT, "{");
        }
        return null;
    }

    public Set<OWLDataRange> parseDataRangeList() throws ParserException {
        String sep = ",";
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            OWLDataRange rng = this.parseDataRange();
            ranges.add(rng);
            this.potentialKeywords.add(",");
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return ranges;
    }

    private OWLDataRange parseDataOneOf() throws ParserException {
        this.consumeToken();
        HashSet<OWLLiteral> cons = new HashSet<OWLLiteral>();
        String sep = ",";
        while (sep.equals(",")) {
            OWLLiteral con = this.parseConstant();
            cons.add(con);
            sep = this.consumeToken();
        }
        if (!sep.equals("}")) {
            throw this.createException(",", "}");
        }
        return this.dataFactory.getOWLDataOneOf(cons);
    }

    private OWLDataRange parseDataComplementOf() throws ParserException {
        String not = this.consumeToken();
        if (!not.equalsIgnoreCase(NOT)) {
            throw this.createException(NOT);
        }
        OWLDataRange complementedDataRange = this.parseDataRangePrimary();
        return this.dataFactory.getOWLDataComplementOf(complementedDataRange);
    }

    public OWLLiteral parseLiteral() throws ParserException {
        String tok = this.consumeToken();
        if (tok.startsWith("\"")) {
            String lit = "";
            if (tok.length() > 2) {
                lit = tok.substring(1, tok.length() - 1);
            }
            if (this.peekToken().equals("^")) {
                this.consumeToken();
                if (!this.peekToken().equals("^")) {
                    throw this.createException("^");
                }
                this.consumeToken();
                return this.dataFactory.getOWLLiteral(lit, this.parseDatatype());
            }
            if (this.peekToken().startsWith("@")) {
                String lang = this.consumeToken().substring(1);
                return this.dataFactory.getOWLLiteral(lit, lang);
            }
            return this.dataFactory.getOWLLiteral(lit, "");
        }
        try {
            int i = Integer.parseInt(tok);
            return this.dataFactory.getOWLLiteral(tok, OWL2Datatype.XSD_INTEGER);
        }
        catch (NumberFormatException e) {
            if (tok.endsWith("f") || tok.endsWith("F")) {
                try {
                    float f = Float.parseFloat(tok.replace("INF", "Infinity").replace("inf", "Infinity"));
                    return this.dataFactory.getOWLLiteral(Float.toString(f).replace("Infinity", "INF"), OWL2Datatype.XSD_FLOAT);
                }
                catch (NumberFormatException e2) {
                    // empty catch block
                }
            }
            try {
                double d = Double.parseDouble(tok);
                return this.dataFactory.getOWLLiteral(tok, OWL2Datatype.XSD_DOUBLE);
            }
            catch (NumberFormatException numberFormatException) {
                if (tok.equals("true")) {
                    return this.dataFactory.getOWLLiteral(true);
                }
                if (tok.equals("false")) {
                    return this.dataFactory.getOWLLiteral(false);
                }
                throw this.createException(false, false, false, false, false, false, "true", "false", "$integer$", "$float$", "$double$", "\"$Literal$\"", "\"$Literal$\"^^<datatype>", "\"$Literal$\"@<lang>");
            }
        }
    }

    @Deprecated
    public OWLLiteral parseConstant() throws ParserException {
        return this.parseLiteral();
    }

    public int parseInteger() throws ParserException {
        String i = this.consumeToken();
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException e) {
            throw new ParserException(Arrays.asList(this.getToken().getToken()), this.getTokenPos(), this.getTokenRow(), true, this.getTokenCol());
        }
    }

    public String getLineCol() {
        return "Encountered " + this.getLastToken() + " at " + this.getTokenRow() + ":" + this.getTokenCol() + " ";
    }

    private OWLClassExpression parseNestedClassExpression(boolean lookaheadCheck) throws ParserException {
        String tok = this.peekToken();
        if (tok.equals("(")) {
            this.consumeToken();
            OWLClassExpression desc = this.parseIntersection();
            String closeBracket = this.consumeToken();
            if (!closeBracket.equals(")")) {
                throw this.createException(")");
            }
            return desc;
        }
        if (tok.equals("{")) {
            return this.parseObjectOneOf();
        }
        if (this.isClassName(tok)) {
            String name = this.consumeToken();
            return this.getOWLClass(name);
        }
        if (!tok.equals("|EOF|") || !lookaheadCheck) {
            this.consumeToken();
            throw this.createException(true, false, false, false, false, false, "(", "{");
        }
        return null;
    }

    public OWLClassExpression parseObjectOneOf() throws ParserException {
        String open = this.consumeToken();
        if (!open.equals("{")) {
            throw this.createException("{");
        }
        String sep = ",";
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        while (sep.equals(",")) {
            OWLIndividual ind = this.parseIndividual();
            inds.add(ind);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        String close = this.consumeToken();
        if (!close.equals("}")) {
            throw this.createException("}", ",");
        }
        return this.dataFactory.getOWLObjectOneOf(inds);
    }

    private <F> void initialiseSection(AnnotatedListItemParser<F, ?> parser, Map<String, AnnotatedListItemParser<F, ?>> map, String ... synonyms) {
        map.put(parser.getFrameSectionKeyword(), parser);
        for (String syn : synonyms) {
            map.put(syn, parser);
        }
    }

    public Set<OntologyAxiomPair> parseFrames() throws ParserException {
        String tok;
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        HashSet<String> possible = new HashSet<String>();
        this.resetPossible(possible);
        while (true) {
            if ((tok = this.peekToken()).equalsIgnoreCase(CLASS)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseClassFrame());
                possible.addAll(this.classFrameSections.keySet());
                continue;
            }
            if (tok.equalsIgnoreCase(OBJECT_PROPERTY)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseObjectPropertyFrame());
                possible.addAll(this.objectPropertyFrameSections.keySet());
                continue;
            }
            if (tok.equalsIgnoreCase(DATA_PROPERTY)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseDataPropertyFrame());
                possible.addAll(this.dataPropertyFrameSections.keySet());
                continue;
            }
            if (tok.equalsIgnoreCase(ANNOTATION_PROPERTY)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseAnnotationPropertyFrame());
                possible.addAll(Arrays.asList(SUB_PROPERTY_OF, DOMAIN, RANGE));
                continue;
            }
            if (tok.equalsIgnoreCase(INDIVIDUAL)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseIndividualFrame());
                possible.addAll(Arrays.asList(TYPES, FACTS, DIFFERENT_FROM, SAME_AS));
                continue;
            }
            if (tok.equalsIgnoreCase(DATATYPE)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseDatatypeFrame());
                possible.add(EQUIVALENT_TO);
                continue;
            }
            if (tok.equalsIgnoreCase(VALUE_PARTITION)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                this.parseValuePartitionFrame();
                continue;
            }
            if (!tok.equalsIgnoreCase(RULE)) break;
            this.potentialKeywords.clear();
            this.resetPossible(possible);
            axioms.addAll(this.parseRuleFrame());
        }
        if (!tok.equals("|EOF|")) {
            this.consumeToken();
            throw this.createException(possible.toArray(new String[possible.size()]));
        }
        return axioms;
    }

    public Set<OntologyAxiomPair> parseDatatypeFrame() throws ParserException {
        String tok = this.consumeToken();
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!tok.equalsIgnoreCase(DATATYPE)) {
            throw this.createException(DATATYPE);
        }
        String subj = this.consumeToken();
        OWLDatatype datatype = this.getOWLDatatype(subj);
        if (datatype == null) {
            throw this.createException(false, false, false, false, true, false, new String[0]);
        }
        axioms.add(new OntologyAxiomPair(this.defaultOntology, this.dataFactory.getOWLDeclarationAxiom(datatype)));
        block0: while (true) {
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(EQUIVALENT_TO)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                Set<OWLOntology> onts = this.getOntologies();
                Set<OWLDataRange> drs = this.parseDataRangeList();
                Iterator<OWLOntology> i$ = onts.iterator();
                block1: while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLOntology ont = i$.next();
                    Iterator<OWLDataRange> i$2 = drs.iterator();
                    while (true) {
                        if (!i$2.hasNext()) continue block1;
                        OWLDataRange dr = i$2.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLDatatypeDefinitionAxiom(datatype, dr)));
                    }
                    break;
                }
            }
            if (!sect.equalsIgnoreCase(ANNOTATIONS)) break;
            this.potentialKeywords.clear();
            axioms.addAll(this.parseAnnotations(datatype.getIRI()));
        }
        return axioms;
    }

    private void resetPossible(Set<String> possible) {
        possible.clear();
        possible.add(ANNOTATIONS);
        possible.add(ANNOTATION_PROPERTY);
        possible.add(CLASS);
        possible.add(OBJECT_PROPERTY);
        possible.add(DATATYPE);
        possible.add(DATA_PROPERTY);
        possible.add(INDIVIDUAL);
        possible.add(VALUE_PARTITION);
        possible.add(RULE);
    }

    public Set<OntologyAxiomPair> parseNaryEquivalentClasses() throws ParserException {
        Set<Object> annotations;
        String tok = this.consumeToken();
        if (!tok.equalsIgnoreCase(EQUIVALENT_CLASSES)) {
            throw this.createException(EQUIVALENT_CLASSES);
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        String next = this.peekToken();
        if (next.equalsIgnoreCase(ANNOTATIONS)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        } else {
            annotations = Collections.emptySet();
        }
        Set<OWLClassExpression> classExpressions = this.parseClassExpressionList(false);
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLEquivalentClassesAxiom(classExpressions, annotations)));
        }
        return pairs;
    }

    public Set<OntologyAxiomPair> parseNaryEquivalentProperties() throws ParserException {
        OWLNaryPropertyAxiom<OWLObjectPropertyExpression> propertyAxiom;
        Set<Object> annotations;
        String tok = this.consumeToken();
        if (!tok.equalsIgnoreCase(EQUIVALENT_PROPERTIES)) {
            throw this.createException(EQUIVALENT_PROPERTIES);
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        String next = this.peekToken();
        if (next.equalsIgnoreCase(ANNOTATIONS)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        } else {
            annotations = Collections.emptySet();
        }
        Set<OWLPropertyExpression<?, ?>> properties = this.parsePropertyList();
        if (properties.iterator().next().isObjectPropertyExpression()) {
            HashSet<OWLObjectPropertyExpression> ope = new HashSet<OWLObjectPropertyExpression>();
            for (OWLPropertyExpression<?, ?> pe : properties) {
                ope.add((OWLObjectPropertyExpression)pe);
            }
            propertyAxiom = this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(ope, annotations);
        } else {
            HashSet<OWLDataPropertyExpression> dpe = new HashSet<OWLDataPropertyExpression>();
            for (OWLPropertyExpression<?, ?> pe : properties) {
                dpe.add((OWLDataPropertyExpression)pe);
            }
            propertyAxiom = this.dataFactory.getOWLEquivalentDataPropertiesAxiom(dpe, annotations);
        }
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, propertyAxiom));
        }
        return pairs;
    }

    public Set<OntologyAxiomPair> parseAnnotations(OWLAnnotationSubject subject) throws ParserException {
        String header = this.consumeToken();
        if (!header.equals(ANNOTATIONS)) {
            throw this.createException(ANNOTATIONS);
        }
        Set<OWLOntology> onts = this.getOntologies();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        Set<OWLAnnotation> annos = this.parseAnnotationList();
        for (OWLOntology ont : onts) {
            for (OWLAnnotation anno : annos) {
                if (!this.configuration.isLoadAnnotationAxioms()) continue;
                OWLAnnotationAssertionAxiom ax = this.dataFactory.getOWLAnnotationAssertionAxiom(subject, anno);
                pairs.add(new OntologyAxiomPair(ont, ax));
            }
        }
        return pairs;
    }

    private Set<OWLAnnotation> parseAnnotationList() throws ParserException {
        String sep = ",";
        HashSet<OWLAnnotation> annos = new HashSet<OWLAnnotation>();
        while (sep.equals(",")) {
            Set<OWLAnnotation> annoAnnos;
            this.potentialKeywords.clear();
            String nextToken = this.peekToken();
            if (nextToken.equals(ANNOTATIONS)) {
                this.consumeToken();
                annoAnnos = this.parseAnnotationList();
            } else {
                annoAnnos = Collections.emptySet();
            }
            OWLAnnotation anno = this.parseAnnotation();
            if (anno != null) {
                anno = anno.getAnnotatedAnnotation(annoAnnos);
                annos.add(anno);
            }
            if (!(sep = this.peekToken()).equals(",")) continue;
            this.consumeToken();
        }
        return annos;
    }

    private OWLAnnotation parseAnnotation() throws ParserException {
        OWLAnnotationProperty annoProp = this.parseAnnotationProperty();
        String obj = this.peekToken();
        OWLAnnotation anno = null;
        if (this.isIndividualName(obj) || this.isClassName(obj) || this.isObjectPropertyName(obj) || this.isDataPropertyName(obj)) {
            this.consumeToken();
            OWLAnnotationValue value = obj.startsWith("_:") ? this.dataFactory.getOWLAnonymousIndividual(obj) : this.getIRI(obj);
            anno = this.dataFactory.getOWLAnnotation(annoProp, value);
        } else if (obj.startsWith("<")) {
            IRI value = this.parseIRI();
            anno = this.dataFactory.getOWLAnnotation(annoProp, value);
        } else {
            OWLLiteral con = this.parseLiteral();
            anno = this.dataFactory.getOWLAnnotation(annoProp, con);
        }
        return anno;
    }

    public Set<OntologyAxiomPair> parseClassFrame() throws ParserException {
        return this.parseClassFrame(false);
    }

    public Set<OntologyAxiomPair> parseClassFrameEOF() throws ParserException {
        return this.parseClassFrame(true);
    }

    private Set<OntologyAxiomPair> parseClassFrame(boolean eof) throws ParserException {
        String tok = this.consumeToken();
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!tok.equalsIgnoreCase(CLASS)) {
            throw this.createException(CLASS);
        }
        String subj = this.consumeToken();
        OWLClass cls = this.getOWLClass(subj);
        if (cls == null) {
            throw this.createException(true, false, false, false);
        }
        axioms.add(new OntologyAxiomPair(this.defaultOntology, this.dataFactory.getOWLDeclarationAxiom(cls)));
        this.parseFrameSections(eof, axioms, cls, this.classFrameSections);
        return axioms;
    }

    private Set<OWLOntology> parseOntologyList() throws ParserException {
        this.potentialKeywords.clear();
        this.consumeToken("[");
        this.consumeToken("in");
        String sep = ",";
        HashSet<OWLOntology> onts = new HashSet<OWLOntology>();
        while (sep.equals(",")) {
            String tok = this.consumeToken();
            if (this.isOntologyName(tok)) {
                OWLOntology ont = this.getOntology(tok);
                if (ont != null) {
                    onts.add(ont);
                }
            } else {
                throw this.createException(true);
            }
            sep = this.consumeToken();
            if (sep.equals("]")) break;
            if (sep.equals(",")) continue;
            throw this.createException(",", "]");
        }
        return onts;
    }

    private Set<OWLOntology> getOntologies() throws ParserException {
        if (this.peekToken().equals("[")) {
            return this.parseOntologyList();
        }
        return Collections.singleton(this.defaultOntology);
    }

    public void setDefaultOntology(OWLOntology defaultOntology) {
        this.defaultOntology = defaultOntology;
    }

    private boolean isEmptyFrameSection(Map<String, ?> parsers) {
        if (!this.allowEmptyFrameSections) {
            return false;
        }
        String next = this.peekToken();
        return !next.equals(ANNOTATIONS) && (parsers.containsKey(next) || next.equals("|EOF|"));
    }

    private boolean isClassFrameSection(String token) {
        return this.classFrameSections.containsKey(token);
    }

    private <F> void parseFrameSections(boolean eof, Set<OntologyAxiomPair> axioms, F frameSubject, Map<String, AnnotatedListItemParser<F, ?>> sectionParsers) throws ParserException {
        String sect;
        AnnotatedListItemParser<F, ?> parser;
        while ((parser = sectionParsers.get(sect = this.peekToken())) != null) {
            this.consumeToken();
            Set<OWLOntology> onts = this.getOntologies();
            if (this.isEmptyFrameSection(sectionParsers)) continue;
            axioms.addAll(this.parseAnnotatedListItems(frameSubject, parser, onts));
        }
        if (eof && !"|EOF|".equals(sect)) {
            ArrayList<String> expected = new ArrayList<String>();
            expected.addAll(sectionParsers.keySet());
            if (frameSubject instanceof OWLAnnotationSubject || frameSubject instanceof OWLEntity) {
                expected.add(ANNOTATIONS);
            }
            throw this.createException(expected.toArray(new String[expected.size()]));
        }
    }

    public Set<OntologyAxiomPair> parseObjectPropertyFrame() throws ParserException {
        return this.parseObjectPropertyFrame(false);
    }

    public Set<OntologyAxiomPair> parseObjectPropertyFrame(boolean eof) throws ParserException {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        this.consumeToken(OBJECT_PROPERTY);
        String token = this.consumeToken();
        OWLObjectProperty prop = this.getOWLObjectProperty(token);
        if (prop == null) {
            throw this.createException(false, true, false, false);
        }
        if (!prop.isAnonymous()) {
            axioms.add(new OntologyAxiomPair(this.defaultOntology, this.dataFactory.getOWLDeclarationAxiom(prop.asOWLObjectProperty())));
        }
        this.parseFrameSections(eof, axioms, prop, this.objectPropertyFrameSections);
        return axioms;
    }

    public Set<OntologyAxiomPair> parseDataPropertyFrame() throws ParserException {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        String tok = this.consumeToken();
        if (!tok.equalsIgnoreCase(DATA_PROPERTY)) {
            throw this.createException(DATA_PROPERTY);
        }
        String subj = this.consumeToken();
        OWLDataProperty prop = this.getOWLDataProperty(subj);
        if (prop == null) {
            throw this.createException(false, false, true, false);
        }
        this.parseFrameSections(false, axioms, prop, this.dataPropertyFrameSections);
        return axioms;
    }

    public Set<OntologyAxiomPair> parseAnnotationPropertyFrame() throws ParserException {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        String tok = this.consumeToken();
        if (!tok.equalsIgnoreCase(ANNOTATION_PROPERTY)) {
            throw this.createException(ANNOTATION_PROPERTY);
        }
        String subj = this.consumeToken();
        OWLAnnotationProperty prop = this.getOWLAnnotationProperty(subj);
        for (OWLOntology ont : this.getOntologies()) {
            axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLDeclarationAxiom(prop)));
        }
        if (prop == null) {
            throw this.createException(false, false, true, false);
        }
        this.parseFrameSections(false, axioms, prop, this.annotationPropertyFrameSections);
        return axioms;
    }

    public Set<OntologyAxiomPair> parseIndividualFrame() throws ParserException {
        String tok = this.consumeToken();
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!tok.equalsIgnoreCase(INDIVIDUAL)) {
            throw this.createException(INDIVIDUAL);
        }
        String subj = this.consumeToken();
        OWLIndividual ind = this.getOWLIndividual(subj);
        if (ind == null) {
            throw this.createException(false, false, false, true);
        }
        if (!ind.isAnonymous()) {
            axioms.add(new OntologyAxiomPair(this.getOntology(null), this.dataFactory.getOWLDeclarationAxiom(ind.asOWLNamedIndividual())));
        }
        this.parseFrameSections(false, axioms, ind, this.individualFrameSections);
        return axioms;
    }

    private OWLPropertyAssertionAxiom<?, ?> parseFact(OWLIndividual ind) throws ParserException {
        String prop;
        boolean negative = false;
        if (this.peekToken().equals(NOT)) {
            this.consumeToken();
            negative = true;
        }
        if (this.isDataPropertyName(prop = this.peekToken())) {
            OWLDataProperty p = this.parseDataProperty();
            OWLLiteral con = this.parseConstant();
            if (!negative) {
                return this.dataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)p, ind, con);
            }
            return this.dataFactory.getOWLNegativeDataPropertyAssertionAxiom(p, ind, con);
        }
        if (this.isObjectPropertyName(prop)) {
            OWLObjectPropertyExpression p = this.parseObjectPropertyExpression();
            OWLIndividual obj = this.parseIndividual();
            if (!negative) {
                return this.dataFactory.getOWLObjectPropertyAssertionAxiom(p, ind, obj);
            }
            return this.dataFactory.getOWLNegativeObjectPropertyAssertionAxiom(p, ind, obj);
        }
        this.consumeToken();
        throw this.createException(false, true, true, false, false, false, new String[0]);
    }

    public Set<OntologyAxiomPair> parseValuePartitionFrame() throws ParserException {
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(VALUE_PARTITION)) {
            throw this.createException(VALUE_PARTITION);
        }
        Set<OWLOntology> onts = this.getOntologies();
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        String clsName = this.consumeToken();
        if (clsName.equals("|EOF|")) {
            throw this.createException(false, true, false, false, false, false, new String[0]);
        }
        OWLClass cls = this.getOWLClass(clsName);
        if (cls == null) {
            throw this.createException(true, false, false, false);
        }
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        axioms.addAll(this.parseValuePartitionValues(onts, cls));
        for (OWLOntology ont : onts) {
            axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop)));
            axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, cls)));
        }
        return axioms;
    }

    public Set<OntologyAxiomPair> parseValuePartitionValues(Set<OWLOntology> onts, OWLClass superclass) throws ParserException {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        HashSet<OWLClass> siblings = new HashSet<OWLClass>();
        this.consumeToken("[");
        String sep = ",";
        while (sep.equals(",")) {
            String clsName = this.consumeToken();
            OWLClass cls = this.getOWLClass(clsName);
            if (cls == null) {
                throw this.createException(true, false, false, false);
            }
            siblings.add(cls);
            OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(cls, superclass);
            for (OWLOntology ont : onts) {
                axioms.add(new OntologyAxiomPair(ont, ax));
            }
            if (this.peekToken().equals("[")) {
                axioms.addAll(this.parseValuePartitionValues(onts, cls));
            }
            if (!(sep = this.peekToken()).equals(",")) continue;
            this.consumeToken();
        }
        this.consumeToken("]");
        OWLDisjointClassesAxiom ax = this.dataFactory.getOWLDisjointClassesAxiom(siblings);
        for (OWLOntology ont : onts) {
            axioms.add(new OntologyAxiomPair(ont, ax));
        }
        return axioms;
    }

    public Set<OntologyAxiomPair> parseRuleFrame() throws ParserException {
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(RULE)) {
            throw this.createException(RULE);
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        List<SWRLAtom> body = this.parseRuleAtoms();
        String tok = this.consumeToken();
        if (!tok.equals("-")) {
            throw this.createException("-", ",");
        }
        this.consumeToken(">");
        List<SWRLAtom> head = this.parseRuleAtoms();
        SWRLRule rule = this.dataFactory.getSWRLRule(new LinkedHashSet<SWRLAtom>(body), new LinkedHashSet<SWRLAtom>(head));
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, rule));
        }
        return pairs;
    }

    public List<SWRLAtom> parseRuleAtoms() throws ParserException {
        String sep = ",";
        ArrayList<SWRLAtom> atoms = new ArrayList<SWRLAtom>();
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            SWRLAtom atom = this.parseRuleAtom();
            atoms.add(atom);
            sep = this.peekToken();
            if (sep.equals(",")) {
                this.consumeToken();
            }
            this.potentialKeywords.add(",");
        }
        return atoms;
    }

    public SWRLAtom parseRuleAtom() throws ParserException {
        String predicate = this.peekToken();
        if (this.isClassName(predicate)) {
            return this.parseClassAtom();
        }
        if (this.isObjectPropertyName(predicate)) {
            return this.parseObjectPropertyAtom();
        }
        if (this.isDataPropertyName(predicate)) {
            return this.parseDataPropertyAtom();
        }
        if (predicate.equals(ManchesterOWLSyntax.DIFFERENT_FROM.toString())) {
            return this.parseDifferentFromAtom();
        }
        if (predicate.equals(ManchesterOWLSyntax.SAME_AS.toString())) {
            return this.parseSameAsAtom();
        }
        if (this.isSWRLBuiltin(predicate) || predicate.startsWith("<")) {
            return this.parseBuiltInAtom();
        }
        this.consumeToken();
        TreeSet<String> kw = new TreeSet<String>();
        kw.addAll(this.ruleBuiltIns.keySet());
        kw.add(ManchesterOWLSyntax.DIFFERENT_FROM.toString());
        kw.add(ManchesterOWLSyntax.SAME_AS.toString());
        throw this.createException(true, true, true, false, false, false, kw.toArray(new String[this.ruleBuiltIns.size()]));
    }

    public SWRLAtom parseDataPropertyAtom() throws ParserException {
        String predicate = this.consumeToken();
        if (!this.isDataPropertyName(predicate)) {
            throw this.createException(false, false, true, false);
        }
        this.consumeToken("(");
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(",");
        SWRLDArgument obj2 = this.parseDObject();
        this.consumeToken(")");
        return this.dataFactory.getSWRLDataPropertyAtom(this.getOWLDataProperty(predicate), obj1, obj2);
    }

    public SWRLAtom parseObjectPropertyAtom() throws ParserException {
        String predicate = this.consumeToken();
        if (!this.isObjectPropertyName(predicate)) {
            throw this.createException(false, true, false, false);
        }
        this.consumeToken("(");
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(",");
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(")");
        return this.dataFactory.getSWRLObjectPropertyAtom(this.getOWLObjectProperty(predicate), obj1, obj2);
    }

    public SWRLAtom parseClassAtom() throws ParserException {
        String predicate = this.consumeToken();
        if (!this.isClassName(predicate)) {
            throw this.createException(true, false, false, false);
        }
        this.consumeToken("(");
        SWRLIArgument obj = this.parseIObject();
        this.consumeToken(")");
        return this.dataFactory.getSWRLClassAtom(this.getOWLClass(predicate), obj);
    }

    public SWRLDifferentIndividualsAtom parseDifferentFromAtom() throws ParserException {
        this.consumeToken(ManchesterOWLSyntax.DIFFERENT_FROM.toString());
        this.consumeToken("(");
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(",");
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(")");
        return this.dataFactory.getSWRLDifferentIndividualsAtom(obj1, obj2);
    }

    public SWRLSameIndividualAtom parseSameAsAtom() throws ParserException {
        this.consumeToken(ManchesterOWLSyntax.SAME_AS.toString());
        this.consumeToken("(");
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(",");
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(")");
        return this.dataFactory.getSWRLSameIndividualAtom(obj1, obj2);
    }

    public SWRLIArgument parseIObject() throws ParserException {
        String s = this.peekToken();
        if (this.isIndividualName(s)) {
            return this.parseIIndividualObject();
        }
        if (s.equals("?")) {
            return this.parseIVariable();
        }
        this.consumeToken();
        throw this.createException(false, false, false, true, false, false, "?$var$");
    }

    public IRI getVariableIRI(String var) {
        if (var.startsWith("<") || var.endsWith(">")) {
            return IRI.create(var.substring(1, var.length() - 1));
        }
        return IRI.create(this.base + var);
    }

    public SWRLVariable parseIVariable() throws ParserException {
        IRI var = this.parseVariable();
        return this.dataFactory.getSWRLVariable(var);
    }

    public SWRLIndividualArgument parseIIndividualObject() throws ParserException {
        OWLIndividual ind = this.parseIndividual();
        return this.dataFactory.getSWRLIndividualArgument(ind);
    }

    public IRI parseVariable() throws ParserException {
        this.consumeToken("?");
        return this.parseIRI();
    }

    public SWRLDArgument parseDObject() throws ParserException {
        String s = this.peekToken();
        if (s.equals("?")) {
            return this.parseDVariable();
        }
        try {
            return this.parseLiteralObject();
        }
        catch (ParserException e) {
            HashSet<String> kw = new HashSet<String>(e.getExpectedKeywords());
            kw.add("?");
            throw new ParserException(e.getTokenSequence(), e.getStartPos(), e.getLineNumber(), e.getColumnNumber(), e.isClassNameExpected(), e.isObjectPropertyNameExpected(), e.isDataPropertyNameExpected(), e.isIndividualNameExpected(), e.isDatatypeNameExpected(), e.isAnnotationPropertyNameExpected(), kw);
        }
    }

    public SWRLVariable parseDVariable() throws ParserException {
        IRI var = this.parseVariable();
        return this.dataFactory.getSWRLVariable(var);
    }

    public SWRLLiteralArgument parseLiteralObject() throws ParserException {
        OWLLiteral lit = this.parseLiteral();
        return this.dataFactory.getSWRLLiteralArgument(lit);
    }

    public SWRLBuiltInAtom parseBuiltInAtom() throws ParserException {
        String predicate = this.consumeToken();
        this.consumeToken("(");
        SWRLBuiltInsVocabulary v = null;
        IRI iri = null;
        if (!this.ruleBuiltIns.containsKey(predicate)) {
            iri = this.getIRI(predicate);
        } else {
            v = this.ruleBuiltIns.get(predicate);
            iri = v.getIRI();
        }
        ArrayList<SWRLDArgument> args = new ArrayList<SWRLDArgument>();
        if (v != null && v.getMaxArity() >= 0) {
            for (int i = 0; i < v.getMaxArity(); ++i) {
                SWRLDArgument obj = this.parseDObject();
                args.add(obj);
                if (i < v.getMinArity() - 1) {
                    this.consumeToken(",");
                    continue;
                }
                if (i >= v.getMaxArity() - 1) continue;
                if (this.peekToken().equals(",")) {
                    this.consumeToken();
                    continue;
                }
                break;
            }
        } else {
            String sep = ",";
            while (sep.equals(",")) {
                SWRLDArgument arg = this.parseDObject();
                args.add(arg);
                sep = this.peekToken();
                if (!sep.equals(",")) continue;
                this.consumeToken();
            }
        }
        this.consumeToken(")");
        return this.dataFactory.getSWRLBuiltInAtom(iri, args);
    }

    public Set<OntologyAxiomPair> parseDisjointClasses() throws ParserException {
        Set<Object> annotations;
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(DISJOINT_CLASSES)) {
            throw this.createException(DISJOINT_CLASSES);
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        if (this.peekToken().equals(ANNOTATIONS)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        } else {
            annotations = Collections.emptySet();
        }
        Set<OWLClassExpression> classExpressions = this.parseClassExpressionList(false);
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLDisjointClassesAxiom(classExpressions, annotations)));
        }
        return pairs;
    }

    public Set<OntologyAxiomPair> parseSameIndividual() throws ParserException {
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(SAME_INDIVIDUAL)) {
            throw this.createException(SAME_INDIVIDUAL);
        }
        Set<OWLIndividual> individuals = this.parseIndividualList();
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<Object> annotations = this.peekToken().equals(ANNOTATIONS) ? this.parseAnnotationList() : Collections.emptySet();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLSameIndividualAxiom(individuals, annotations)));
        }
        return pairs;
    }

    public Set<OntologyAxiomPair> parseDisjointProperties() throws ParserException {
        OWLNaryPropertyAxiom<OWLObjectPropertyExpression> propertiesAxiom;
        Set<Object> annotations;
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(DISJOINT_PROPERTIES)) {
            throw this.createException(DISJOINT_PROPERTIES);
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        if (this.peekToken().equalsIgnoreCase(ANNOTATIONS)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        } else {
            annotations = Collections.emptySet();
        }
        Set<OWLPropertyExpression<?, ?>> props = this.parsePropertyList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        if (props.iterator().next().isObjectPropertyExpression()) {
            HashSet<OWLObjectPropertyExpression> ope = new HashSet<OWLObjectPropertyExpression>();
            for (OWLPropertyExpression<?, ?> pe : props) {
                ope.add((OWLObjectPropertyExpression)pe);
            }
            propertiesAxiom = this.dataFactory.getOWLDisjointObjectPropertiesAxiom(ope, annotations);
        } else {
            HashSet<OWLDataPropertyExpression> dpe = new HashSet<OWLDataPropertyExpression>();
            for (OWLPropertyExpression<?, ?> pe : props) {
                dpe.add((OWLDataPropertyExpression)pe);
            }
            propertiesAxiom = this.dataFactory.getOWLDisjointDataPropertiesAxiom(dpe, annotations);
        }
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, propertiesAxiom));
        }
        return pairs;
    }

    public Set<OntologyAxiomPair> parseDifferentIndividuals() throws ParserException {
        Set<Object> annotations;
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(DIFFERENT_INDIVIDUALS)) {
            throw this.createException(DIFFERENT_INDIVIDUALS);
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        if (this.peekToken().equalsIgnoreCase(ANNOTATIONS)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        } else {
            annotations = Collections.emptySet();
        }
        Set<OWLIndividual> individuals = this.parseIndividualList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ontology : ontologies) {
            pairs.add(new OntologyAxiomPair(ontology, this.dataFactory.getOWLDifferentIndividualsAxiom(individuals, annotations)));
        }
        return pairs;
    }

    public Set<OWLAxiom> parseObjectPropertyCharacteristicList(OWLObjectPropertyExpression prop) throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        String sep = ",";
        while (sep.equals(",")) {
            Set<Object> annos;
            String next = this.peekToken();
            if (next.equals(ANNOTATIONS)) {
                this.consumeToken();
                annos = this.parseAnnotationList();
            } else {
                annos = Collections.emptySet();
            }
            this.parseObjectPropertyCharacteristic(prop);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            sep = this.consumeToken();
        }
        return axioms;
    }

    private OWLObjectPropertyCharacteristicAxiom parseObjectPropertyCharacteristic(OWLObjectPropertyExpression prop) throws ParserException {
        String characteristic = this.consumeToken();
        if (characteristic.equalsIgnoreCase(FUNCTIONAL)) {
            return this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop);
        }
        if (characteristic.equalsIgnoreCase(INVERSE_FUNCTIONAL)) {
            return this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop);
        }
        if (characteristic.equalsIgnoreCase(SYMMETRIC)) {
            return this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop);
        }
        if (characteristic.equalsIgnoreCase(ANTI_SYMMETRIC) || characteristic.equalsIgnoreCase(ASYMMETRIC)) {
            return this.dataFactory.getOWLAsymmetricObjectPropertyAxiom(prop);
        }
        if (characteristic.equalsIgnoreCase(TRANSITIVE)) {
            return this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);
        }
        if (characteristic.equalsIgnoreCase(REFLEXIVE)) {
            return this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop);
        }
        if (characteristic.equalsIgnoreCase(IRREFLEXIVE)) {
            return this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop);
        }
        throw this.createException(FUNCTIONAL, INVERSE_FUNCTIONAL, SYMMETRIC, ANTI_SYMMETRIC, TRANSITIVE, REFLEXIVE, IRREFLEXIVE);
    }

    private OWLDataPropertyCharacteristicAxiom parseDataPropertyCharacteristic(OWLDataPropertyExpression prop) throws ParserException {
        String characteristic = this.consumeToken();
        if (characteristic.equalsIgnoreCase(FUNCTIONAL)) {
            return this.dataFactory.getOWLFunctionalDataPropertyAxiom(prop);
        }
        throw this.createException(FUNCTIONAL);
    }

    public Map<OWLClassExpression, Set<Set<OWLAnnotation>>> parseAnnotatedClassExpressionList() throws ParserException {
        HashMap<OWLClassExpression, Set<Set<OWLAnnotation>>> descs = new HashMap<OWLClassExpression, Set<Set<OWLAnnotation>>>();
        String sep = ",";
        while (sep.equals(",")) {
            Set<Object> annos;
            this.potentialKeywords.remove(",");
            String next = this.peekToken();
            if (next.equals(ANNOTATIONS)) {
                this.consumeToken();
                annos = this.parseAnnotationList();
            } else {
                annos = Collections.emptySet();
            }
            OWLClassExpression classExpression = this.parseIntersection();
            HashSet annosSet = (HashSet)descs.get(classExpression);
            if (annosSet == null) {
                annosSet = new HashSet();
                descs.put(classExpression, annosSet);
            }
            annosSet.add(annos);
            this.potentialKeywords.add(",");
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            sep = this.consumeToken();
        }
        return descs;
    }

    public Set<OWLClassExpression> parseClassExpressionList(boolean allowAnnotations) throws ParserException {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        String sep = ",";
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            String next = this.peekToken();
            if (next.equals(ANNOTATIONS)) {
                this.consumeToken();
                Set<OWLAnnotation> annos = this.parseAnnotationList();
            }
            descs.add(this.parseIntersection());
            this.potentialKeywords.add(",");
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            sep = this.consumeToken();
        }
        return descs;
    }

    public Set<OWLClassExpression> parseClassExpressionList(String expectedOpen, String expectedClose) throws ParserException {
        String open = this.consumeToken();
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        if (!open.equals(expectedOpen)) {
            throw this.createException(expectedOpen);
        }
        String sep = ",";
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            OWLClassExpression desc = this.parseIntersection();
            this.potentialKeywords.add(",");
            descs.add(desc);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            sep = this.consumeToken();
        }
        String close = this.consumeToken();
        if (!close.equals(expectedClose)) {
            throw this.createException(expectedClose);
        }
        return descs;
    }

    public Set<OWLDataProperty> parseDataPropertyList() throws ParserException {
        HashSet<OWLDataProperty> props = new HashSet<OWLDataProperty>();
        String sep = ",";
        while (sep.equals(",")) {
            OWLDataProperty prop = this.parseDataProperty();
            props.add(prop);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Map<OWLDataProperty, Set<OWLAnnotation>> parseAnnotatedDataPropertyList() throws ParserException {
        HashMap<OWLDataProperty, Set<OWLAnnotation>> props = new HashMap<OWLDataProperty, Set<OWLAnnotation>>();
        String sep = ",";
        while (sep.equals(",")) {
            Set<Object> annos;
            String next = this.peekToken();
            if (next.equals(ANNOTATIONS)) {
                this.consumeToken();
                annos = this.parseAnnotationList();
            } else {
                annos = Collections.emptySet();
            }
            OWLDataProperty prop = this.parseDataProperty();
            props.put(prop, annos);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLAnnotationProperty> parseAnnotationPropertyList() throws ParserException {
        HashSet<OWLAnnotationProperty> props = new HashSet<OWLAnnotationProperty>();
        String sep = ",";
        while (sep.equals(",")) {
            sep = this.peekToken();
            OWLAnnotationProperty prop = this.parseAnnotationProperty();
            props.add(prop);
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Map<OWLPropertyExpression<?, ?>, Set<OWLAnnotation>> parseAnnotatedPropertyList() throws ParserException {
        HashMap props = new HashMap();
        String sep = ",";
        while (sep.equals(",")) {
            Set<Object> annos;
            String next = this.peekToken();
            if (next.equals(ANNOTATIONS)) {
                this.consumeToken();
                annos = this.parseAnnotationList();
            } else {
                annos = Collections.emptySet();
            }
            OWLPropertyExpression<?, ?> prop = this.parsePropertyExpression();
            props.put(prop, annos);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLPropertyExpression<?, ?>> parsePropertyList() throws ParserException {
        HashSet props = new HashSet();
        String sep = ",";
        while (sep.equals(",")) {
            OWLPropertyExpression<?, ?> prop = this.parsePropertyExpression();
            props.add(prop);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLObjectPropertyExpression> parseObjectPropertyList() throws ParserException {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        String sep = ",";
        while (sep.equals(",")) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            props.add(prop);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Map<OWLObjectPropertyExpression, Set<OWLAnnotation>> parseAnnotatedObjectPropertyList() throws ParserException {
        HashMap<OWLObjectPropertyExpression, Set<OWLAnnotation>> props = new HashMap<OWLObjectPropertyExpression, Set<OWLAnnotation>>();
        String sep = ",";
        while (sep.equals(",")) {
            Set<Object> annos;
            String next = this.peekToken();
            if (next.equals(ANNOTATIONS)) {
                this.consumeToken();
                annos = this.parseAnnotationList();
            } else {
                annos = Collections.emptySet();
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            props.put(prop, annos);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLIndividual> parseIndividualList() throws ParserException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        String sep = ",";
        while (sep.equals(",")) {
            inds.add(this.parseIndividual());
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return inds;
    }

    public List<OWLObjectPropertyExpression> parseObjectPropertyChain() throws ParserException {
        String delim = "o";
        ArrayList<OWLObjectPropertyExpression> properties = new ArrayList<OWLObjectPropertyExpression>();
        while (delim.equals("o")) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            properties.add(prop);
            delim = this.peekToken();
            if (!delim.equals("o")) continue;
            this.consumeToken();
        }
        return properties;
    }

    public OWLSubPropertyChainOfAxiom parsePropertyChainSubPropertyAxiom() throws ParserException {
        List<OWLObjectPropertyExpression> props = this.parseObjectPropertyChain();
        String imp = this.consumeToken() + this.consumeToken();
        if (!imp.equals("->")) {
            throw this.createException("->", "o");
        }
        OWLObjectPropertyExpression superProp = this.parseObjectPropertyExpression();
        return this.dataFactory.getOWLSubPropertyChainOfAxiom(props, superProp);
    }

    public OWLClassAxiom parseClassAxiom() throws ParserException {
        OWLClassExpression lhs = this.parseIntersection();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(ManchesterOWLSyntax.SUBCLASS_OF.toString())) {
            OWLClassExpression rhs = this.parseIntersection();
            return this.dataFactory.getOWLSubClassOfAxiom(lhs, rhs);
        }
        if (kw.equalsIgnoreCase(ManchesterOWLSyntax.EQUIVALENT_TO.toString())) {
            OWLClassExpression rhs = this.parseIntersection();
            return this.dataFactory.getOWLEquivalentClassesAxiom(lhs, rhs);
        }
        if (kw.equalsIgnoreCase(ManchesterOWLSyntax.DISJOINT_WITH.toString())) {
            OWLClassExpression rhs = this.parseIntersection();
            return this.dataFactory.getOWLDisjointClassesAxiom(lhs, rhs);
        }
        throw this.createException(ManchesterOWLSyntax.SUBCLASS_OF.toString(), ManchesterOWLSyntax.EQUIVALENT_TO.toString(), ManchesterOWLSyntax.DISJOINT_WITH.toString());
    }

    public OWLObjectPropertyAxiom parseObjectPropertyAxiom() throws ParserException {
        String tok = this.peekToken();
        if (tok.equals(ManchesterOWLSyntax.FUNCTIONAL.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop);
        }
        if (tok.equals(ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop);
        }
        if (tok.equals(ManchesterOWLSyntax.TRANSITIVE.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);
        }
        if (tok.equals(ManchesterOWLSyntax.SYMMETRIC.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop);
        }
        if (tok.equals(ManchesterOWLSyntax.REFLEXIVE.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop);
        }
        if (tok.equals(ManchesterOWLSyntax.IRREFLEXIVE.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop);
        }
        if (tok.equals(ManchesterOWLSyntax.ASYMMETRIC.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLAsymmetricObjectPropertyAxiom(prop);
        }
        return null;
    }

    public OWLIndividual parseIndividual() throws ParserException {
        String name = this.consumeToken();
        if (!this.isIndividualName(name) && !name.startsWith("_:")) {
            throw this.createException(false, false, false, true);
        }
        return this.getOWLIndividual(name);
    }

    public OWLIndividual parseIndividual(boolean defined) throws ParserException {
        String name = this.consumeToken();
        if (defined && !this.isIndividualName(name)) {
            throw this.createException(false, false, false, true);
        }
        return this.getOWLIndividual(name);
    }

    public OWLDataProperty parseDataProperty() throws ParserException {
        String name = this.consumeToken();
        if (!this.isDataPropertyName(name)) {
            throw this.createException(false, false, true, false);
        }
        return this.getOWLDataProperty(name);
    }

    public OWLAnnotationProperty parseAnnotationProperty() throws ParserException {
        String name = this.consumeToken();
        if (!this.isAnnotationPropertyName(name)) {
            throw this.createException(false, false, false, false, false, true, new String[0]);
        }
        return this.getOWLAnnotationProperty(name);
    }

    public Map<String, IRI> parsePrefixDeclaration() throws ParserException {
        this.consumeToken(PREFIX);
        HashMap<String, IRI> map = new HashMap<String, IRI>(2);
        String prefixName = this.consumeToken();
        String delim = this.peekToken();
        if (delim.equals("=")) {
            this.consumeToken();
        }
        IRI iri = this.parseIRI();
        map.put(prefixName, iri);
        return map;
    }

    public OWLImportsDeclaration parseImportsDeclaration(OWLOntology ont) throws ParserException {
        this.consumeToken(IMPORT);
        IRI importedOntologyIRI = this.parseIRI();
        return this.dataFactory.getOWLImportsDeclaration(importedOntologyIRI);
    }

    public IRI parseIRI() throws ParserException {
        String iriString = this.consumeToken();
        if (!iriString.startsWith("<") || !iriString.endsWith(">")) {
            throw this.createException("<$IRI$>");
        }
        return IRI.create(iriString.substring(1, iriString.length() - 1));
    }

    public Set<IRI> parseNameList() throws ParserException {
        String sep = ",";
        HashSet<IRI> iris = new HashSet<IRI>();
        while (sep.equals(",")) {
            this.potentialKeywords.clear();
            String token = this.peekToken();
            if (this.isClassName(token)) {
                iris.add(this.owlEntityChecker.getOWLClass(token).getIRI());
                this.consumeToken();
            } else if (this.isObjectPropertyName(token)) {
                iris.add(this.owlEntityChecker.getOWLObjectProperty(token).getIRI());
                this.consumeToken();
            } else if (this.isDataPropertyName(token)) {
                iris.add(this.owlEntityChecker.getOWLDataProperty(token).getIRI());
                this.consumeToken();
            } else if (this.isIndividualName(token)) {
                iris.add(this.owlEntityChecker.getOWLIndividual(token).getIRI());
                this.consumeToken();
            } else if (this.isAnnotationPropertyName(token)) {
                iris.add(this.owlEntityChecker.getOWLAnnotationProperty(token).getIRI());
                this.consumeToken();
            } else if (this.isDatatypeName(token)) {
                iris.add(this.owlEntityChecker.getOWLDatatype(token).getIRI());
                this.consumeToken();
            } else if (this.isOntologyName(token)) {
                iris.add(this.getOntology(token).getOntologyID().getOntologyIRI());
                this.consumeToken();
            } else if (token.equals("<")) {
                IRI iri = this.parseIRI();
                iris.add(iri);
            } else {
                throw this.createException(true, true, true, true, true, true, "<$URI$>");
            }
            if (!(sep = this.peekToken()).equals(",")) continue;
            this.consumeToken();
        }
        return iris;
    }

    private void processDeclaredEntities() {
        for (int i = 0; i < this.tokens.size(); ++i) {
            ManchesterOWLSyntaxTokenizer.Token tok = this.tokens.get(i);
            if (tok.getToken().equalsIgnoreCase(CLASS)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.classNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equalsIgnoreCase(OBJECT_PROPERTY)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.objectPropertyNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equalsIgnoreCase(DATA_PROPERTY)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.dataPropertyNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equalsIgnoreCase(INDIVIDUAL)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.individualNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equalsIgnoreCase(DATATYPE)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.dataTypeNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equalsIgnoreCase(ANNOTATION_PROPERTY)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.annotationPropertyNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (!tok.getToken().equalsIgnoreCase(VALUE_PARTITION)) continue;
            if (i + 1 < this.tokens.size()) {
                this.objectPropertyNames.add(this.tokens.get(i + 1).getToken());
            }
            if (i + 2 >= this.tokens.size()) continue;
            this.classNames.add(this.tokens.get(i + 2).getToken());
        }
    }

    private static void addNamesToSet(String buffer, String sectionName, Set<String> names) {
        Pattern p = Pattern.compile("(" + sectionName + "\\s*)(\\S*)");
        Matcher matcher = p.matcher(buffer);
        while (matcher.find()) {
            names.add(matcher.group(2));
        }
    }

    @Deprecated
    public ManchesterOWLSyntaxOntologyFormat parseOntology(OWLOntologyManager manager, OWLOntology ont) throws ParserException, UnloadableImportException {
        return this.parseOntology(ont);
    }

    public ManchesterOWLSyntaxOntologyFormat parseOntology(OWLOntology ont) throws ParserException, UnloadableImportException {
        String section;
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        OWLOntologyID ontologyID = new OWLOntologyID();
        HashSet<AddImport> imports = new HashSet<AddImport>();
        HashSet<AddOntologyAnnotation> ontologyAnnotations = new HashSet<AddOntologyAnnotation>();
        this.defaultOntology = ont;
        this.processDeclaredEntities();
        block0: while (true) {
            if ((section = this.peekToken()).equals(ONTOLOGY)) {
                ManchesterOWLSyntaxOntologyHeader header = this.parseOntologyHeader(false);
                for (OWLImportsDeclaration decl : header.getImportsDeclarations()) {
                    ont.getOWLOntologyManager().makeLoadImportRequest(decl, this.configuration);
                    imports.add(new AddImport(ont, decl));
                }
                for (OWLAnnotation anno : header.getAnnotations()) {
                    ontologyAnnotations.add(new AddOntologyAnnotation(ont, anno));
                }
                ontologyID = header.getOntologyID();
                continue;
            }
            if (section.equalsIgnoreCase(CLASS)) {
                axioms.addAll(this.parseClassFrame());
                continue;
            }
            if (section.equalsIgnoreCase(OBJECT_PROPERTY)) {
                axioms.addAll(this.parseObjectPropertyFrame());
                continue;
            }
            if (section.equalsIgnoreCase(DATA_PROPERTY)) {
                axioms.addAll(this.parseDataPropertyFrame());
                continue;
            }
            if (section.equalsIgnoreCase(INDIVIDUAL)) {
                axioms.addAll(this.parseIndividualFrame());
                continue;
            }
            if (section.equalsIgnoreCase(DATATYPE)) {
                axioms.addAll(this.parseDatatypeFrame());
                continue;
            }
            if (section.equalsIgnoreCase(ANNOTATION_PROPERTY)) {
                axioms.addAll(this.parseAnnotationPropertyFrame());
                continue;
            }
            if (section.equalsIgnoreCase(VALUE_PARTITION)) {
                axioms.addAll(this.parseValuePartitionFrame());
                continue;
            }
            if (section.equalsIgnoreCase(IMPORT)) {
                OWLImportsDeclaration decl = this.parseImportsDeclaration(ont);
                imports.add(new AddImport(ont, decl));
                ont.getOWLOntologyManager().makeLoadImportRequest(decl, this.configuration);
                continue;
            }
            if (section.equalsIgnoreCase(PREFIX)) {
                Map<String, IRI> nsMap = this.parsePrefixDeclaration();
                Iterator<Object> i$ = nsMap.keySet().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    String ns = (String)i$.next();
                    this.pm.setPrefix(ns, nsMap.get(ns).toString());
                }
            }
            if (section.equalsIgnoreCase(DISJOINT_CLASSES)) {
                axioms.addAll(this.parseDisjointClasses());
                continue;
            }
            if (section.equalsIgnoreCase(EQUIVALENT_CLASSES)) {
                axioms.addAll(this.parseNaryEquivalentClasses());
                continue;
            }
            if (section.equalsIgnoreCase(EQUIVALENT_PROPERTIES)) {
                axioms.addAll(this.parseNaryEquivalentProperties());
                continue;
            }
            if (section.equalsIgnoreCase(DISJOINT_PROPERTIES)) {
                axioms.addAll(this.parseDisjointProperties());
                continue;
            }
            if (section.equalsIgnoreCase(DIFFERENT_INDIVIDUALS)) {
                axioms.addAll(this.parseDifferentIndividuals());
                continue;
            }
            if (section.equalsIgnoreCase(SAME_INDIVIDUAL)) {
                axioms.addAll(this.parseSameIndividual());
                continue;
            }
            if (!section.equalsIgnoreCase(RULE)) break;
            axioms.addAll(this.parseRuleFrame());
        }
        if (!section.equals("|EOF|")) {
            this.consumeToken();
            throw this.createException(CLASS, OBJECT_PROPERTY, DATA_PROPERTY, INDIVIDUAL, DATATYPE, ANNOTATION_PROPERTY, IMPORT, VALUE_PARTITION, PREFIX, EQUIVALENT_CLASSES, DISJOINT_CLASSES, DISJOINT_PROPERTIES, DIFFERENT_INDIVIDUALS, SAME_INDIVIDUAL);
        }
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>(axioms.size());
        changes.addAll(imports);
        changes.addAll(ontologyAnnotations);
        for (OntologyAxiomPair pair : axioms) {
            changes.add(new AddAxiom(ont, pair.getAxiom()));
        }
        changes.add(new SetOntologyID(ont, ontologyID));
        ont.getOWLOntologyManager().applyChanges(changes);
        ManchesterOWLSyntaxOntologyFormat format = new ManchesterOWLSyntaxOntologyFormat();
        format.copyPrefixesFrom(this.pm);
        return format;
    }

    public ManchesterOWLSyntaxOntologyHeader parseOntologyHeader(boolean toEOF) throws ParserException {
        String section;
        String tok = this.consumeToken();
        if (!tok.equalsIgnoreCase(ONTOLOGY)) {
            throw this.createException(ONTOLOGY);
        }
        IRI ontologyIRI = null;
        IRI versionIRI = null;
        if (this.peekToken().startsWith("<")) {
            ontologyIRI = this.parseIRI();
            if (this.peekToken().startsWith("<")) {
                versionIRI = this.parseIRI();
            }
        }
        HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
        HashSet<OWLImportsDeclaration> imports = new HashSet<OWLImportsDeclaration>();
        while (true) {
            if ((section = this.peekToken()).equals(IMPORT)) {
                this.consumeToken();
                tok = this.peekToken();
                IRI importedIRI = null;
                if (tok.startsWith("<")) {
                    importedIRI = this.parseIRI();
                } else if (this.isOntologyName(tok)) {
                    this.consumeToken();
                    OWLOntology ont = this.getOntology(tok);
                    if (ont != null) {
                        importedIRI = ont.getOntologyID().getOntologyIRI();
                    }
                } else {
                    this.consumeToken();
                    this.throwOntologyNameOrURIExpectedException();
                }
                imports.add(this.dataFactory.getOWLImportsDeclaration(importedIRI));
                continue;
            }
            if (!section.equals(ANNOTATIONS)) break;
            this.consumeToken();
            annotations.addAll(this.parseAnnotationList());
        }
        if (!section.equalsIgnoreCase("|EOF|") && toEOF) {
            throw this.createException(IMPORT, ANNOTATIONS);
        }
        return new ManchesterOWLSyntaxOntologyHeader(ontologyIRI, versionIRI, annotations, imports);
    }

    protected ParserException createException(boolean ontologyNameExpected) throws ParserException {
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        return new ParserException(this.getTokenSequence(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), ontologyNameExpected, new String[0]);
    }

    protected void throwOntologyNameOrURIExpectedException() throws ParserException {
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        throw new ParserException(this.getTokenSequence(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), true, "<$ONTOLOGYYURI$>");
    }

    protected ParserException createException(String ... keywords) throws ParserException {
        HashSet<String> theKeywords = new HashSet<String>();
        theKeywords.addAll(Arrays.asList(keywords));
        theKeywords.addAll(this.potentialKeywords);
        this.potentialKeywords.clear();
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        return new ParserException(this.getTokenSequence(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), false, false, false, false, false, false, theKeywords);
    }

    protected ParserException createException(boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, boolean annotationPropertyNameExpected, String ... keywords) throws ParserException {
        HashSet<String> theKeywords = new HashSet<String>();
        theKeywords.addAll(Arrays.asList(keywords));
        if (objectPropertyNameExpected) {
            theKeywords.add(INVERSE);
        }
        theKeywords.addAll(this.potentialKeywords);
        this.potentialKeywords.clear();
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        return new ParserException(this.getTokenSequence(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, datatypeNameExpected, annotationPropertyNameExpected, theKeywords);
    }

    protected ParserException createException(boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected) throws ParserException {
        HashSet<String> keywords = new HashSet<String>();
        if (objectPropertyNameExpected) {
            keywords.add(INVERSE);
        }
        keywords.addAll(this.potentialKeywords);
        this.potentialKeywords.clear();
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        return new ParserException(this.getTokenSequence(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, false, false, keywords);
    }

    protected List<String> getTokenSequence() {
        ArrayList<String> seq = new ArrayList<String>();
        int index = this.tokenIndex - 1;
        if (index < 0) {
            index = 0;
        }
        while (index < this.tokens.size() && seq.size() < 4 && seq.indexOf("|EOF|") == -1) {
            seq.add(this.tokens.get(index).getToken());
            ++index;
        }
        if (seq.size() == 0) {
            seq.add("|EOF|");
        }
        return seq;
    }

    public IRI getIRI(String name) {
        IRI uri;
        boolean fullIRI = name.equals("<");
        if (fullIRI) {
            name = this.consumeToken();
            this.consumeToken();
        }
        if ((uri = this.nameIRIMap.get(name)) != null) {
            return uri;
        }
        if (fullIRI) {
            uri = IRI.create(name);
        } else {
            int colonIndex = name.indexOf(58);
            if (colonIndex == -1) {
                name = ":" + name;
            }
            uri = this.pm.getIRI(name);
        }
        this.nameIRIMap.put(name, uri);
        return uri;
    }

    public OWLAxiom parseAxiom() throws ParserException {
        String token = this.peekToken();
        if (this.isClassName(token)) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (this.isObjectPropertyName(token)) {
            return this.parseAxiomWithObjectPropertyStart();
        }
        if (this.isDataPropertyName(token)) {
            return this.parseAxiomWithDataPropertyStart();
        }
        if (this.isIndividualName(token)) {
            return this.parseAxiomWithIndividualStart();
        }
        if (token.equalsIgnoreCase("inv")) {
            return this.parseAxiomWithObjectPropertyStart();
        }
        if (token.equalsIgnoreCase("(")) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (token.equalsIgnoreCase("{")) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (token.equalsIgnoreCase(FUNCTIONAL)) {
            return this.parseFunctionPropertyAxiom();
        }
        if (token.equalsIgnoreCase(INVERSE_FUNCTIONAL)) {
            return this.parseInverseFunctionalPropertyAxiom();
        }
        if (token.equalsIgnoreCase(SYMMETRIC)) {
            return this.parseSymmetricPropertyAxiom();
        }
        if (token.equalsIgnoreCase(ASYMMETRIC)) {
            return this.parseAsymmetricPropertyAxiom();
        }
        if (token.equalsIgnoreCase(TRANSITIVE)) {
            return this.parseTransitivePropertyAxiom();
        }
        if (token.equalsIgnoreCase(REFLEXIVE)) {
            return this.parseReflexivePropertyAxiom();
        }
        if (token.equalsIgnoreCase(IRREFLEXIVE)) {
            return this.parseIrreflexivePropertyAxiom();
        }
        throw this.createException(true, true, true, true, false, false, "(", "{", "inv", FUNCTIONAL, INVERSE_FUNCTIONAL, SYMMETRIC, ASYMMETRIC, TRANSITIVE, REFLEXIVE, IRREFLEXIVE);
    }

    private OWLAxiom parseAxiomWithIndividualStart() throws ParserException {
        OWLIndividual ind = this.parseIndividual();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(TYPE)) {
            OWLClassExpression type = this.parseClassExpression();
            return this.getDataFactory().getOWLClassAssertionAxiom(type, ind);
        }
        throw this.createException(TYPE);
    }

    public OWLAxiom parseAxiomWithDataPropertyStart() throws ParserException {
        OWLDataProperty prop = this.parseDataProperty();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(SOME)) {
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder(this.getDataFactory().getOWLDataSomeValuesFrom(prop, dataRange));
        }
        if (kw.equalsIgnoreCase(ONLY)) {
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder(this.getDataFactory().getOWLDataAllValuesFrom(prop, dataRange));
        }
        if (kw.equalsIgnoreCase(MIN)) {
            int cardi = this.parseInteger();
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder(this.getDataFactory().getOWLDataMinCardinality(cardi, prop, dataRange));
        }
        if (kw.equalsIgnoreCase(MAX)) {
            int cardi = this.parseInteger();
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder(this.getDataFactory().getOWLDataMaxCardinality(cardi, prop, dataRange));
        }
        if (kw.equalsIgnoreCase(EXACTLY)) {
            int cardi = this.parseInteger();
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder(this.getDataFactory().getOWLDataExactCardinality(cardi, prop, dataRange));
        }
        if (kw.equalsIgnoreCase(SUB_PROPERTY_OF)) {
            OWLDataPropertyExpression superProperty = this.parseDataPropertyExpression();
            return this.getDataFactory().getOWLSubDataPropertyOfAxiom(prop, superProperty);
        }
        if (kw.equalsIgnoreCase(EQUIVALENT_TO)) {
            OWLDataPropertyExpression equivProp = this.parseDataPropertyExpression();
            return this.getDataFactory().getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)prop, equivProp);
        }
        if (kw.equalsIgnoreCase(DISJOINT_WITH)) {
            OWLDataPropertyExpression disjProp = this.parseDataPropertyExpression();
            return this.getDataFactory().getOWLDisjointDataPropertiesAxiom(prop, disjProp);
        }
        if (kw.equals(DOMAIN)) {
            OWLClassExpression domain = this.parseClassExpression();
            return this.getDataFactory().getOWLDataPropertyDomainAxiom(prop, domain);
        }
        if (kw.equals(RANGE)) {
            OWLDataRange range = this.parseDataRange();
            return this.getDataFactory().getOWLDataPropertyRangeAxiom(prop, range);
        }
        throw this.createException(SOME, ONLY, MIN, MAX, EXACTLY, SUB_PROPERTY_OF, EQUIVALENT_TO, DISJOINT_WITH, DOMAIN, RANGE);
    }

    public OWLDataPropertyExpression parseDataPropertyExpression() throws ParserException {
        return this.parseDataPropertyExpression(false);
    }

    public OWLDataPropertyExpression parseDataPropertyExpression(boolean allowUndeclared) throws ParserException {
        String tok = this.consumeToken();
        if (!allowUndeclared && !this.isDataPropertyName(tok)) {
            throw this.createException(false, false, true, false, false, false, new String[0]);
        }
        return this.getOWLDataProperty(tok);
    }

    public OWLAxiom parseAxiomWithClassExpressionStart() throws ParserException {
        OWLClassExpression ce = this.parseIntersection();
        return this.parseClassAxiomRemainder(ce);
    }

    public OWLAxiom parseClassAxiomRemainder(OWLClassExpression startExpression) throws ParserException {
        String kw = this.consumeToken();
        System.out.println("Parse class axiom rem: " + startExpression);
        if (kw.equalsIgnoreCase(SUB_CLASS_OF)) {
            OWLClassExpression superClass = this.parseClassExpression();
            return this.dataFactory.getOWLSubClassOfAxiom(startExpression, superClass);
        }
        if (kw.equalsIgnoreCase(DISJOINT_WITH)) {
            OWLClassExpression disjointClass = this.parseClassExpression();
            return this.dataFactory.getOWLDisjointClassesAxiom(startExpression, disjointClass);
        }
        if (kw.equalsIgnoreCase(EQUIVALENT_TO)) {
            OWLClassExpression equivClass = this.parseClassExpression();
            return this.dataFactory.getOWLEquivalentClassesAxiom(startExpression, equivClass);
        }
        if (kw.equalsIgnoreCase(AND)) {
            OWLClassExpression conjunct = this.parseIntersection();
            Set<OWLClassExpression> conjuncts = conjunct.asConjunctSet();
            conjuncts.add(startExpression);
            OWLObjectIntersectionOf ce = this.dataFactory.getOWLObjectIntersectionOf(conjuncts);
            return this.parseClassAxiomRemainder(ce);
        }
        if (kw.equalsIgnoreCase(OR)) {
            OWLClassExpression disjunct = this.parseIntersection();
            Set<OWLClassExpression> disjuncts = disjunct.asDisjunctSet();
            disjuncts.add(startExpression);
            OWLObjectUnionOf ce = this.dataFactory.getOWLObjectUnionOf(disjuncts);
            return this.parseClassAxiomRemainder(ce);
        }
        System.out.println("Throwing exception!");
        throw this.createException(SUB_CLASS_OF, DISJOINT_WITH, EQUIVALENT_TO, AND, OR);
    }

    public OWLAxiom parseAxiomWithObjectPropertyStart() throws ParserException {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(SOME)) {
            OWLClassExpression filler = this.parseIntersection();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLObjectSomeValuesFrom(prop, filler));
        }
        if (kw.equalsIgnoreCase(ONLY)) {
            OWLClassExpression filler = this.parseIntersection();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLObjectAllValuesFrom(prop, filler));
        }
        if (kw.equalsIgnoreCase(MIN)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseIntersection();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLObjectMinCardinality(cardi, prop, filler));
        }
        if (kw.equalsIgnoreCase(MAX)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseIntersection();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLObjectMaxCardinality(cardi, prop, filler));
        }
        if (kw.equalsIgnoreCase(EXACTLY)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseIntersection();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLObjectExactCardinality(cardi, prop, filler));
        }
        if (kw.equalsIgnoreCase(SUB_PROPERTY_OF)) {
            OWLObjectPropertyExpression superProperty = this.parseObjectPropertyExpression();
            return this.dataFactory.getOWLSubObjectPropertyOfAxiom(prop, superProperty);
        }
        if (kw.equalsIgnoreCase(EQUIVALENT_TO)) {
            OWLObjectPropertyExpression equivProp = this.parseObjectPropertyExpression();
            return this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(prop, equivProp);
        }
        if (kw.equalsIgnoreCase(INVERSE_OF)) {
            OWLObjectPropertyExpression invProp = this.parseObjectPropertyExpression();
            return this.dataFactory.getOWLInverseObjectPropertiesAxiom(prop, invProp);
        }
        if (kw.equalsIgnoreCase(DISJOINT_WITH)) {
            OWLObjectPropertyExpression disjProp = this.parseObjectPropertyExpression();
            return this.dataFactory.getOWLDisjointObjectPropertiesAxiom(prop, disjProp);
        }
        if (kw.equals(DOMAIN)) {
            OWLClassExpression domain = this.parseClassExpression();
            return this.dataFactory.getOWLObjectPropertyDomainAxiom(prop, domain);
        }
        if (kw.equals(RANGE)) {
            OWLClassExpression range = this.parseClassExpression();
            return this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, range);
        }
        if (kw.equalsIgnoreCase("o")) {
            String sep = kw;
            ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
            chain.add(prop);
            while (sep.equals("o")) {
                OWLObjectPropertyExpression chainProp = this.parseObjectPropertyExpression();
                chain.add(chainProp);
                sep = this.consumeToken();
            }
            if (!sep.equalsIgnoreCase(SUB_PROPERTY_OF)) {
                throw this.createException(SUB_PROPERTY_OF);
            }
            OWLObjectPropertyExpression superProp = this.parseObjectPropertyExpression();
            return this.dataFactory.getOWLSubPropertyChainOfAxiom(chain, superProp);
        }
        throw this.createException(SOME, ONLY, MIN, MAX, EXACTLY, SUB_PROPERTY_OF, EQUIVALENT_TO, INVERSE_OF, DISJOINT_WITH, DOMAIN, RANGE, "o");
    }

    public OWLAxiom parseInverseFunctionalPropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(INVERSE_FUNCTIONAL)) {
            throw this.createException(INVERSE_FUNCTIONAL);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        return this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop);
    }

    public OWLAxiom parseSymmetricPropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(SYMMETRIC)) {
            throw this.createException(SYMMETRIC);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        return this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop);
    }

    public OWLAxiom parseAsymmetricPropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(ASYMMETRIC)) {
            throw this.createException(ASYMMETRIC);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        return this.dataFactory.getOWLAsymmetricObjectPropertyAxiom(prop);
    }

    public OWLAxiom parseTransitivePropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(TRANSITIVE)) {
            throw this.createException(TRANSITIVE);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        return this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);
    }

    public OWLAxiom parseReflexivePropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(REFLEXIVE)) {
            throw this.createException(REFLEXIVE);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        return this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop);
    }

    public OWLAxiom parseIrreflexivePropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(IRREFLEXIVE)) {
            throw this.createException(IRREFLEXIVE);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        return this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop);
    }

    public OWLAxiom parseFunctionPropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(FUNCTIONAL)) {
            throw this.createException(FUNCTIONAL);
        }
        String name = this.peekToken();
        if (this.isObjectPropertyName(name)) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            return this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop);
        }
        if (this.isDataPropertyName(name)) {
            OWLDataProperty prop = this.parseDataProperty();
            return this.dataFactory.getOWLFunctionalDataPropertyAxiom(prop);
        }
        this.consumeToken();
        throw this.createException(false, true, true, false);
    }

    private <F, O> Set<OntologyAxiomPair> parseAnnotatedListItems(F subject, AnnotatedListItemParser<F, O> itemParser, Set<OWLOntology> ontologies) throws ParserException {
        HashSet<OntologyAxiomPair> result = new HashSet<OntologyAxiomPair>();
        String sep = ",";
        while (sep.equals(",")) {
            String tok = this.peekToken();
            Set<OWLAnnotation> annotations = null;
            if (tok.equals(ANNOTATIONS)) {
                this.consumeToken();
                annotations = this.parseAnnotationList();
            } else {
                annotations = Collections.emptySet();
            }
            O item = itemParser.parseItem(subject);
            OWLAxiom axiom = itemParser.createAxiom(subject, item, annotations);
            for (OWLOntology ontology : ontologies) {
                result.add(new OntologyAxiomPair(ontology, axiom));
            }
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotationPropertyRangeListItemParser
    extends AnnotatedIRIListItemParser<OWLAnnotationProperty> {
        @Override
        public OWLAxiom createAxiom(OWLAnnotationProperty subject, IRI object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationPropertyRangeAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return RANGE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotationPropertyDomainListItemParser
    extends AnnotatedIRIListItemParser<OWLAnnotationProperty> {
        @Override
        public OWLAxiom createAxiom(OWLAnnotationProperty subject, IRI object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationPropertyDomainAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return DOMAIN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotationPropertySubPropertyOfListItemParser
    implements AnnotatedListItemParser<OWLAnnotationProperty, OWLAnnotationProperty> {
        @Override
        public OWLAnnotationProperty parseItem(OWLAnnotationProperty subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseAnnotationProperty();
        }

        @Override
        public OWLAxiom createAxiom(OWLAnnotationProperty subject, OWLAnnotationProperty object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubAnnotationPropertyOfAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return SUB_PROPERTY_OF;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AnnotatedIRIListItemParser<F>
    implements AnnotatedListItemParser<F, IRI> {
        @Override
        public IRI parseItem(F subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseIRI();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndividualAnnotationItemParser
    implements AnnotatedListItemParser<OWLIndividual, OWLAnnotation> {
        @Override
        public OWLAnnotation parseItem(OWLIndividual subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseAnnotation();
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual subject, OWLAnnotation object, Set<OWLAnnotation> annotations) {
            if (subject.isAnonymous()) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationAssertionAxiom(subject.asOWLAnonymousIndividual(), object, annotations);
            }
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationAssertionAxiom(subject.asOWLNamedIndividual().getIRI(), object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return ANNOTATIONS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndividualDifferentIndividualsItemParser
    implements AnnotatedListItemParser<OWLIndividual, Set<OWLIndividual>> {
        @Override
        public Set<OWLIndividual> parseItem(OWLIndividual subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseIndividualList();
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual subject, Set<OWLIndividual> object, Set<OWLAnnotation> annotations) {
            HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
            individuals.add(subject);
            individuals.addAll(object);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDifferentIndividualsAxiom(individuals, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return DIFFERENT_INDIVIDUALS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndividualDifferentFromItemParser
    extends AnnotatedIndividualsListItemParser<OWLIndividual> {
        @Override
        public OWLAxiom createAxiom(OWLIndividual subject, OWLIndividual object, Set<OWLAnnotation> annotations) {
            HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
            individuals.add(subject);
            individuals.add(object);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDifferentIndividualsAxiom(individuals, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return DIFFERENT_FROM;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndividualSameAsItemParser
    extends AnnotatedIndividualsListItemParser<OWLIndividual> {
        @Override
        public OWLAxiom createAxiom(OWLIndividual subject, OWLIndividual object, Set<OWLAnnotation> annotations) {
            HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
            individuals.add(subject);
            individuals.add(object);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSameIndividualAxiom(individuals, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return SAME_AS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndividualFactsItemParser
    implements AnnotatedListItemParser<OWLIndividual, OWLPropertyAssertionAxiom<?, ?>> {
        @Override
        public OWLPropertyAssertionAxiom<?, ?> parseItem(OWLIndividual subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseFact(subject);
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual subject, OWLPropertyAssertionAxiom<?, ?> object, Set<OWLAnnotation> annotations) {
            return object.getAnnotatedAxiom(annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return FACTS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndividualTypesItemParser
    extends AnnotatedClassExpressionListItemParser<OWLIndividual> {
        @Override
        public OWLAxiom createAxiom(OWLIndividual subject, OWLClassExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLClassAssertionAxiom(object, subject, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return TYPES;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataPropertyCharacteristicsItemParser
    implements AnnotatedListItemParser<OWLDataProperty, OWLDataPropertyCharacteristicAxiom> {
        @Override
        public OWLDataPropertyCharacteristicAxiom parseItem(OWLDataProperty subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseDataPropertyCharacteristic(subject);
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty subject, OWLDataPropertyCharacteristicAxiom object, Set<OWLAnnotation> annotations) {
            return object.getAnnotatedAxiom(annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return CHARACTERISTICS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataPropertyRangeListItemParser
    extends AnnotatedDataRangeListItemParser<OWLDataProperty> {
        @Override
        public OWLAxiom createAxiom(OWLDataProperty subject, OWLDataRange object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataPropertyRangeAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return RANGE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AnnotatedDataRangeListItemParser<F>
    implements AnnotatedListItemParser<F, OWLDataRange> {
        @Override
        public OWLDataRange parseItem(F subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseDataRange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataPropertyDomainListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLDataProperty> {
        @Override
        public OWLAxiom createAxiom(OWLDataProperty subject, OWLClassExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataPropertyDomainAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return DOMAIN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataPropertyDisjointWithListItemParser
    extends DataPropertyExpressionListItemParser<OWLDataProperty> {
        @Override
        public OWLAxiom createAxiom(OWLDataProperty subject, OWLDataPropertyExpression object, Set<OWLAnnotation> annotations) {
            HashSet<OWLDataPropertyExpression> properties = new HashSet<OWLDataPropertyExpression>();
            properties.add(subject);
            properties.add(object);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDisjointDataPropertiesAxiom(properties, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return DISJOINT_WITH;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataPropertyEquivalentToListItemParser
    extends DataPropertyExpressionListItemParser<OWLDataProperty> {
        @Override
        public OWLAxiom createAxiom(OWLDataProperty subject, OWLDataPropertyExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return EQUIVALENT_TO;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataPropertySuperPropertyOfListItemParser
    extends DataPropertyExpressionListItemParser<OWLDataProperty> {
        private DataPropertySuperPropertyOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty subject, OWLDataPropertyExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubDataPropertyOfAxiom(object, subject, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return SUPER_PROPERTY_OF;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataPropertySubPropertyOfListItemParser
    extends DataPropertyExpressionListItemParser<OWLDataProperty> {
        @Override
        public OWLAxiom createAxiom(OWLDataProperty subject, OWLDataPropertyExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubDataPropertyOfAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return SUB_PROPERTY_OF;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class DataPropertyExpressionListItemParser<F>
    implements AnnotatedListItemParser<F, OWLDataPropertyExpression> {
        @Override
        public OWLDataProperty parseItem(F subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseDataProperty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertyCharacteristicsItemParser
    implements AnnotatedListItemParser<OWLObjectProperty, OWLObjectPropertyCharacteristicAxiom> {
        @Override
        public OWLObjectPropertyCharacteristicAxiom parseItem(OWLObjectProperty subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseObjectPropertyCharacteristic(subject);
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty subject, OWLObjectPropertyCharacteristicAxiom object, Set<OWLAnnotation> annotations) {
            return object.getAnnotatedAxiom(annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return CHARACTERISTICS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertySubPropertyChainListItemParser
    implements AnnotatedListItemParser<OWLObjectProperty, List<OWLObjectPropertyExpression>> {
        @Override
        public List<OWLObjectPropertyExpression> parseItem(OWLObjectProperty subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseObjectPropertyChain();
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty subject, List<OWLObjectPropertyExpression> object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubPropertyChainOfAxiom(object, subject, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return SUB_PROPERTY_CHAIN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertyInverseOfListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        @Override
        public OWLAxiom createAxiom(OWLObjectProperty subject, OWLObjectPropertyExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLInverseObjectPropertiesAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return INVERSE_OF;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertyRangeListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLObjectProperty> {
        @Override
        public OWLAxiom createAxiom(OWLObjectProperty subject, OWLClassExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLObjectPropertyRangeAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return RANGE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertyDomainListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLObjectProperty> {
        @Override
        public OWLAxiom createAxiom(OWLObjectProperty subject, OWLClassExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLObjectPropertyDomainAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return DOMAIN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertyDisjointWithListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        @Override
        public OWLAxiom createAxiom(OWLObjectProperty subject, OWLObjectPropertyExpression object, Set<OWLAnnotation> annotations) {
            HashSet<OWLObjectPropertyExpression> properties = new HashSet<OWLObjectPropertyExpression>();
            properties.add(subject);
            properties.add(object);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDisjointObjectPropertiesAxiom(properties, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return DISJOINT_WITH;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertyEquivalentToListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        @Override
        public OWLAxiom createAxiom(OWLObjectProperty subject, OWLObjectPropertyExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return EQUIVALENT_TO;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertySuperPropertyOfListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        @Override
        public OWLAxiom createAxiom(OWLObjectProperty subject, OWLObjectPropertyExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubObjectPropertyOfAxiom(object, subject, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return SUPER_PROPERTY_OF;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertySubPropertyOfListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        @Override
        public OWLAxiom createAxiom(OWLObjectProperty subject, OWLObjectPropertyExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubObjectPropertyOfAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return SUB_PROPERTY_OF;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ObjectPropertyExpressionListItemParser<F>
    implements AnnotatedListItemParser<F, OWLObjectPropertyExpression> {
        @Override
        public OWLObjectPropertyExpression parseItem(F subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseObjectPropertyExpression();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotationSubjectAnnotationsListItemParser
    extends AnnotationListItemParser<OWLAnnotationSubject> {
        private AnnotationSubjectAnnotationsListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLAnnotationSubject subject, OWLAnnotation object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationAssertionAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return ANNOTATIONS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassAnnotationsListItemParser
    extends EntityAnnotationsListItemParser<OWLClass> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntityAnnotationsListItemParser<E extends OWLEntity>
    extends AnnotationListItemParser<E> {
        @Override
        public OWLAxiom createAxiom(E subject, OWLAnnotation object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationAssertionAxiom(subject.getIRI(), object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return ANNOTATIONS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassIndividualsListItemParser
    extends AnnotatedIndividualsListItemParser<OWLClass> {
        @Override
        public OWLAxiom createAxiom(OWLClass subject, OWLIndividual object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLClassAssertionAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return INDIVIDUALS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassSuperClassOfListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLClass> {
        @Override
        public OWLAxiom createAxiom(OWLClass subject, OWLClassExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubClassOfAxiom(object, subject, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return SUPER_CLASS_OF;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassHasKeyListItemParser
    extends AnnotatedPropertyListListItemParser<OWLClass> {
        @Override
        public OWLAxiom createAxiom(OWLClass subject, Set<OWLPropertyExpression<?, ?>> object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLHasKeyAxiom((OWLClassExpression)subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return HAS_KEY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassDisjointUnionOfListItemParser
    extends AnnotatedClassExpressionSetListItemParser<OWLClass> {
        @Override
        public OWLAxiom createAxiom(OWLClass subject, Set<OWLClassExpression> object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDisjointUnionAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return DISJOINT_UNION_OF;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassDisjointClassesListItemParser
    extends AnnotatedClassExpressionSetListItemParser<OWLClass> {
        @Override
        public OWLAxiom createAxiom(OWLClass subject, Set<OWLClassExpression> object, Set<OWLAnnotation> annotations) {
            object.add(subject);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDisjointClassesAxiom(object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return DISJOINT_CLASSES;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassDisjointWithListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLClass> {
        @Override
        public OWLAxiom createAxiom(OWLClass subject, OWLClassExpression object, Set<OWLAnnotation> annotations) {
            HashSet<OWLClassExpression> disjointClasses = new HashSet<OWLClassExpression>();
            disjointClasses.add(subject);
            disjointClasses.add(object);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDisjointClassesAxiom(disjointClasses, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return DISJOINT_WITH;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassEquivalentToListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLClass> {
        @Override
        public OWLAxiom createAxiom(OWLClass subject, OWLClassExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return EQUIVALENT_TO;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassSubClassOfListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLClass> {
        @Override
        public OWLAxiom createAxiom(OWLClass subject, OWLClassExpression object, Set<OWLAnnotation> annotations) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubClassOfAxiom(subject, object, annotations);
        }

        @Override
        public String getFrameSectionKeyword() {
            return SUB_CLASS_OF;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AnnotationListItemParser<F>
    implements AnnotatedListItemParser<F, OWLAnnotation> {
        @Override
        public OWLAnnotation parseItem(F subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseAnnotation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AnnotatedIndividualsListItemParser<F>
    implements AnnotatedListItemParser<F, OWLIndividual> {
        @Override
        public OWLIndividual parseItem(F subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseIndividual();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AnnotatedPropertyListListItemParser<F>
    implements AnnotatedListItemParser<F, Set<OWLPropertyExpression<?, ?>>> {
        @Override
        public Set<OWLPropertyExpression<?, ?>> parseItem(F subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parsePropertyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AnnotatedClassExpressionSetListItemParser<F>
    implements AnnotatedListItemParser<F, Set<OWLClassExpression>> {
        @Override
        public Set<OWLClassExpression> parseItem(F subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseClassExpressionList(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AnnotatedClassExpressionListItemParser<F>
    implements AnnotatedListItemParser<F, OWLClassExpression> {
        @Override
        public OWLClassExpression parseItem(F subject) throws ParserException {
            return ManchesterOWLSyntaxEditorParser.this.parseIntersection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AnnotatedListItemParser<F, O> {
        public O parseItem(F var1) throws ParserException;

        public OWLAxiom createAxiom(F var1, O var2, Set<OWLAnnotation> var3);

        public String getFrameSectionKeyword();
    }

    private class DefaultEntityChecker
    implements OWLEntityChecker {
        private Map<String, OWLDatatype> dataTypeNameMap = new HashMap<String, OWLDatatype>();

        public DefaultEntityChecker() {
            for (XSDVocabulary v : XSDVocabulary.values()) {
                this.dataTypeNameMap.put(v.getIRI().getFragment(), ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDatatype(v.getIRI()));
                this.dataTypeNameMap.put("xsd:" + v.getIRI().getFragment(), ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDatatype(v.getIRI()));
            }
        }

        public OWLClass getOWLClass(String name) {
            if (name.equals("Thing") || name.equals("owl:Thing")) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLThing();
            }
            if (name.equals("Nothing") || name.equals("owl:Nothing")) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLNothing();
            }
            if (ManchesterOWLSyntaxEditorParser.this.classNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLClass(ManchesterOWLSyntaxEditorParser.this.getIRI(name));
            }
            return null;
        }

        public OWLObjectProperty getOWLObjectProperty(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.objectPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLObjectProperty(ManchesterOWLSyntaxEditorParser.this.getIRI(name));
            }
            return null;
        }

        public OWLDataProperty getOWLDataProperty(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.dataPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataProperty(ManchesterOWLSyntaxEditorParser.this.getIRI(name));
            }
            return null;
        }

        public OWLNamedIndividual getOWLIndividual(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.individualNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLNamedIndividual(ManchesterOWLSyntaxEditorParser.this.getIRI(name));
            }
            return null;
        }

        public OWLDatatype getOWLDatatype(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.dataTypeNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDatatype(ManchesterOWLSyntaxEditorParser.this.getIRI(name));
            }
            return null;
        }

        public OWLAnnotationProperty getOWLAnnotationProperty(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.annotationPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationProperty(ManchesterOWLSyntaxEditorParser.this.getIRI(name));
            }
            return null;
        }
    }
}

