/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.parser;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Modifiers {
    private Map<String, Set<String>> modifierNameValuesMap = new LinkedHashMap<String, Set<String>>();

    public static Modifiers parseModifiers(String modifiersList) {
        Modifiers modifiers = new Modifiers();
        StringTokenizer tokenizer = new StringTokenizer(modifiersList, ",");
        while (tokenizer.hasMoreTokens()) {
            String nameValuePair = tokenizer.nextToken().trim();
            String[] split = nameValuePair.split("=");
            if (split.length != 2) continue;
            modifiers.addModifier(split[0], split[1]);
        }
        return modifiers;
    }

    public void addModifier(String name, String value) {
        Set<String> values = this.modifierNameValuesMap.get(name);
        if (values == null) {
            values = new HashSet<String>();
            this.modifierNameValuesMap.put(name, values);
        }
        values.add(value);
    }

    public Set<String> getModifierNames() {
        return this.modifierNameValuesMap.keySet();
    }

    public Set<String> getModifierValues(String modifierName) {
        HashSet<String> valuesToReturn = new HashSet<String>();
        Set<String> values = this.modifierNameValuesMap.get(modifierName);
        if (values != null) {
            valuesToReturn.addAll(values);
        }
        return valuesToReturn;
    }
}

