/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.coode.owlapi.obo.parser.AsymmetricHandler;
import org.coode.owlapi.obo.parser.DefaultNamespaceTagValueHandler;
import org.coode.owlapi.obo.parser.DisjointFromHandler;
import org.coode.owlapi.obo.parser.IDTagValueHandler;
import org.coode.owlapi.obo.parser.IntersectionOfHandler;
import org.coode.owlapi.obo.parser.InverseHandler;
import org.coode.owlapi.obo.parser.IsATagValueHandler;
import org.coode.owlapi.obo.parser.NameTagValueHandler;
import org.coode.owlapi.obo.parser.OBOParserHandler;
import org.coode.owlapi.obo.parser.OBOVocabulary;
import org.coode.owlapi.obo.parser.OntologyTagValueHandler;
import org.coode.owlapi.obo.parser.PartOfTagValueHandler;
import org.coode.owlapi.obo.parser.ReflexiveHandler;
import org.coode.owlapi.obo.parser.RelationshipTagValueHandler;
import org.coode.owlapi.obo.parser.SymmetricTagValueHandler;
import org.coode.owlapi.obo.parser.SynonymTagValueHandler;
import org.coode.owlapi.obo.parser.TagValueHandler;
import org.coode.owlapi.obo.parser.TransitiveOverHandler;
import org.coode.owlapi.obo.parser.TransitiveTagValueHandler;
import org.coode.owlapi.obo.parser.UnionOfHandler;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.CollectionFactory;

public class OBOConsumer
implements OBOParserHandler {
    private static final Logger logger = Logger.getLogger(OBOConsumer.class.getName());
    private static final String IMPORT_TAG_NAME = "import";
    private OWLOntologyLoaderConfiguration configuration;
    private OWLOntologyManager owlOntologyManager;
    private OWLOntology ontology;
    private boolean inHeader;
    private String currentId;
    private Map<String, TagValueHandler> handlerMap;
    private String defaultNamespace;
    private String currentNamespace;
    private String stanzaType;
    private boolean termType;
    private boolean typedefType;
    private boolean instanceType;
    private Set<OWLClassExpression> intersectionOfOperands;
    private Set<OWLClassExpression> unionOfOperands;
    private Map<String, IRI> uriCache;

    public OBOConsumer(OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) {
        this.configuration = configuration;
        this.owlOntologyManager = ontology.getOWLOntologyManager();
        this.ontology = ontology;
        this.defaultNamespace = "http://purl.org/obo/owl";
        this.intersectionOfOperands = new HashSet<OWLClassExpression>();
        this.unionOfOperands = new HashSet<OWLClassExpression>();
        this.uriCache = new HashMap<String, IRI>();
        this.loadBuiltinURIs();
        this.setupTagHandlers();
    }

    public OBOConsumer(OWLOntologyManager owlOntologyManager, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) {
        this(ontology, configuration);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public String getCurrentId() {
        return this.currentId;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public String getCurrentNamespace() {
        return this.currentNamespace;
    }

    public void setCurrentNamespace(String currentNamespace) {
        this.currentNamespace = currentNamespace;
    }

    public void setCurrentId(String currentId) {
        this.currentId = currentId;
    }

    public void addUnionOfOperand(OWLClassExpression classExpression) {
        this.unionOfOperands.add(classExpression);
    }

    public void addIntersectionOfOperand(OWLClassExpression classExpression) {
        this.intersectionOfOperands.add(classExpression);
    }

    public String getStanzaType() {
        return this.stanzaType;
    }

    public boolean isTerm() {
        return this.termType;
    }

    public boolean isTypedef() {
        return this.typedefType;
    }

    public boolean isInstanceType() {
        return this.instanceType;
    }

    private void loadBuiltinURIs() {
        for (OBOVocabulary v : OBOVocabulary.values()) {
            this.uriCache.put(v.getName(), v.getIRI());
        }
    }

    private void setupTagHandlers() {
        this.handlerMap = new HashMap<String, TagValueHandler>();
        this.addTagHandler(new OntologyTagValueHandler(this));
        this.addTagHandler(new IDTagValueHandler(this));
        this.addTagHandler(new NameTagValueHandler(this));
        this.addTagHandler(new IsATagValueHandler(this));
        this.addTagHandler(new PartOfTagValueHandler(this));
        this.addTagHandler(new TransitiveTagValueHandler(this));
        this.addTagHandler(new SymmetricTagValueHandler(this));
        this.addTagHandler(new RelationshipTagValueHandler(this));
        this.addTagHandler(new UnionOfHandler(this));
        this.addTagHandler(new IntersectionOfHandler(this));
        this.addTagHandler(new DisjointFromHandler(this));
        this.addTagHandler(new AsymmetricHandler(this));
        this.addTagHandler(new InverseHandler(this));
        this.addTagHandler(new ReflexiveHandler(this));
        this.addTagHandler(new TransitiveOverHandler(this));
        this.addTagHandler(new DefaultNamespaceTagValueHandler(this));
        this.addTagHandler(new SynonymTagValueHandler(this));
    }

    private void addTagHandler(TagValueHandler handler) {
        this.handlerMap.put(handler.getTag(), handler);
    }

    public void startHeader() {
        this.inHeader = true;
    }

    public void endHeader() {
        this.inHeader = false;
    }

    public void startStanza(String name) {
        this.currentId = null;
        this.currentNamespace = null;
        this.stanzaType = name;
        this.termType = this.stanzaType.equals(OBOVocabulary.TERM.getName());
        this.typedefType = false;
        this.instanceType = false;
        if (!this.termType) {
            this.typedefType = this.stanzaType.equals(OBOVocabulary.TYPEDEF.getName());
            if (!this.typedefType) {
                this.instanceType = this.stanzaType.equals(OBOVocabulary.INSTANCE.getName());
            }
        }
    }

    public void endStanza() {
        if (!this.unionOfOperands.isEmpty()) {
            this.createUnionEquivalentClass();
            this.unionOfOperands.clear();
        }
        if (!this.intersectionOfOperands.isEmpty()) {
            this.createIntersectionEquivalentClass();
            this.intersectionOfOperands.clear();
        }
    }

    private void createUnionEquivalentClass() {
        OWLClassExpression equivalentClass = this.unionOfOperands.size() == 1 ? this.unionOfOperands.iterator().next() : this.getDataFactory().getOWLObjectUnionOf(this.unionOfOperands);
        this.createEquivalentClass(equivalentClass);
    }

    private void createIntersectionEquivalentClass() {
        OWLClassExpression equivalentClass = this.intersectionOfOperands.size() == 1 ? this.intersectionOfOperands.iterator().next() : this.getDataFactory().getOWLObjectIntersectionOf(this.intersectionOfOperands);
        this.createEquivalentClass(equivalentClass);
    }

    private void createEquivalentClass(OWLClassExpression classExpression) {
        OWLEquivalentClassesAxiom ax = this.getDataFactory().getOWLEquivalentClassesAxiom(CollectionFactory.createSet(this.getCurrentClass(), classExpression));
        this.getOWLOntologyManager().applyChange(new AddAxiom(this.ontology, ax));
    }

    public void handleTagValue(String tag, String value, String comment) {
        try {
            TagValueHandler handler = this.handlerMap.get(tag);
            if (handler != null) {
                handler.handle(this.currentId, value, comment);
            } else if (this.inHeader) {
                if (tag.equals(IMPORT_TAG_NAME)) {
                    IRI uri = IRI.create(value.trim());
                    OWLImportsDeclaration decl = this.owlOntologyManager.getOWLDataFactory().getOWLImportsDeclaration(uri);
                    this.owlOntologyManager.makeLoadImportRequest(decl, this.configuration);
                    this.owlOntologyManager.applyChange(new AddImport(this.ontology, decl));
                } else {
                    OWLLiteral con = this.getDataFactory().getOWLLiteral(value);
                    OWLAnnotationProperty property = this.getDataFactory().getOWLAnnotationProperty(this.getIRI(tag));
                    OWLAnnotation anno = this.getDataFactory().getOWLAnnotation(property, con);
                    this.owlOntologyManager.applyChange(new AddOntologyAnnotation(this.ontology, anno));
                }
            } else if (this.currentId != null && this.configuration.isLoadAnnotationAxioms()) {
                IRI subject = this.getIRI(this.currentId);
                OWLLiteral con = this.getDataFactory().getOWLLiteral(value, "");
                OWLAnnotationProperty property = this.getDataFactory().getOWLAnnotationProperty(this.getIRI(tag));
                OWLAnnotation anno = this.getDataFactory().getOWLAnnotation(property, con);
                OWLAnnotationAssertionAxiom ax = this.getDataFactory().getOWLAnnotationAssertionAxiom(subject, anno);
                this.owlOntologyManager.addAxiom(this.ontology, ax);
                OWLDeclarationAxiom annotationPropertyDeclaration = this.getDataFactory().getOWLDeclarationAxiom(property);
                this.owlOntologyManager.addAxiom(this.ontology, annotationPropertyDeclaration);
            }
        }
        catch (UnloadableImportException e) {
            logger.severe(e.getMessage());
        }
    }

    private OWLDataFactory getDataFactory() {
        return this.getOWLOntologyManager().getOWLDataFactory();
    }

    public OWLClass getCurrentClass() {
        return this.getDataFactory().getOWLClass(this.getIRI(this.currentId));
    }

    public OWLEntity getCurrentEntity() {
        if (this.isTerm()) {
            return this.getCurrentClass();
        }
        if (this.isTypedef()) {
            return this.getDataFactory().getOWLObjectProperty(this.getIRI(this.currentId));
        }
        return this.getDataFactory().getOWLNamedIndividual(this.getIRI(this.currentId));
    }

    public IRI getTagIRI(String tagName) {
        return this.getIRI(tagName);
    }

    public IRI getIdIRI(String identifier) {
        if (identifier == null) {
            Thread.dumpStack();
        }
        if (identifier.indexOf(":") != -1) {
            return this.getIRI(identifier);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.defaultNamespace);
        sb.append(":");
        sb.append(identifier);
        return this.getIRI(sb.toString());
    }

    private IRI getIRI(String s) {
        IRI iri = this.uriCache.get(s);
        if (iri != null) {
            return iri;
        }
        String escapedString = s.replace(" ", "%20");
        iri = OBOVocabulary.ID2IRI(escapedString);
        this.uriCache.put(s, iri);
        return iri;
    }
}

