/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.List;
import java.util.Map;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationValueShortFormProvider
implements ShortFormProvider {
    private OWLOntologySetProvider ontologySetProvider;
    private ShortFormProvider alternateShortFormProvider;
    private IRIShortFormProvider alternateIRIShortFormProvider;
    private List<OWLAnnotationProperty> annotationProperties;
    private Map<OWLAnnotationProperty, List<String>> preferredLanguageMap;

    public AnnotationValueShortFormProvider(List<OWLAnnotationProperty> annotationProperties, Map<OWLAnnotationProperty, List<String>> preferredLanguageMap, OWLOntologySetProvider ontologySetProvider) {
        this(annotationProperties, preferredLanguageMap, ontologySetProvider, new SimpleShortFormProvider());
    }

    public AnnotationValueShortFormProvider(List<OWLAnnotationProperty> annotationProperties, Map<OWLAnnotationProperty, List<String>> preferredLanguageMap, OWLOntologySetProvider ontologySetProvider, ShortFormProvider alternateShortFormProvider) {
        this(ontologySetProvider, alternateShortFormProvider, new SimpleIRIShortFormProvider(), annotationProperties, preferredLanguageMap);
    }

    public AnnotationValueShortFormProvider(OWLOntologySetProvider ontologySetProvider, ShortFormProvider alternateShortFormProvider, IRIShortFormProvider alternateIRIShortFormProvider, List<OWLAnnotationProperty> annotationProperties, Map<OWLAnnotationProperty, List<String>> preferredLanguageMap) {
        this.ontologySetProvider = ontologySetProvider;
        this.alternateShortFormProvider = alternateShortFormProvider;
        this.alternateIRIShortFormProvider = alternateIRIShortFormProvider;
        this.annotationProperties = annotationProperties;
        this.preferredLanguageMap = preferredLanguageMap;
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        for (OWLAnnotationProperty prop : this.annotationProperties) {
            AnnotationLanguageFilter checker = new AnnotationLanguageFilter(prop, this.preferredLanguageMap.get(prop));
            for (OWLOntology ontology : this.ontologySetProvider.getOntologies()) {
                for (OWLAnnotationAssertionAxiom ax : entity.getAnnotationAssertionAxioms(ontology)) {
                    ax.accept(checker);
                }
            }
            if (checker.getMatch() == null) continue;
            return this.getRendering(checker.getMatch());
        }
        return this.alternateShortFormProvider.getShortForm(entity);
    }

    private String getRendering(OWLObject object) {
        if (object instanceof OWLLiteral) {
            return ((OWLLiteral)object).getLiteral();
        }
        if (object instanceof IRI) {
            return this.alternateIRIShortFormProvider.getShortForm((IRI)object);
        }
        return this.alternateShortFormProvider.getShortForm((OWLEntity)object);
    }

    public List<OWLAnnotationProperty> getAnnotationProperties() {
        return this.annotationProperties;
    }

    public Map<OWLAnnotationProperty, List<String>> getPreferredLanguageMap() {
        return this.preferredLanguageMap;
    }

    @Override
    public void dispose() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationLanguageFilter
    extends OWLObjectVisitorAdapter {
        private OWLAnnotationProperty prop;
        private List<String> preferredLanguages;
        OWLObject candidateValue = null;
        int lastLangMatchIndex = Integer.MAX_VALUE;

        AnnotationLanguageFilter(OWLAnnotationProperty prop, List<String> preferredLanguages) {
            this.prop = prop;
            this.preferredLanguages = preferredLanguages;
        }

        public OWLObject getMatch() {
            return this.candidateValue;
        }

        @Override
        public void visit(OWLAnnotationAssertionAxiom anno) {
            if (this.lastLangMatchIndex > 0 && anno.getProperty().equals(this.prop)) {
                anno.getValue().accept(this);
            }
        }

        @Override
        public void visit(OWLLiteral node) {
            if (this.preferredLanguages == null || this.preferredLanguages.isEmpty()) {
                this.lastLangMatchIndex = 0;
                this.candidateValue = node;
            } else {
                int index = this.preferredLanguages.indexOf(node.getLang());
                if (index >= 0 && index < this.lastLangMatchIndex) {
                    this.lastLangMatchIndex = index;
                    this.candidateValue = node;
                }
            }
        }

        @Override
        public void visit(IRI iri) {
            this.candidateValue = iri;
        }
    }
}

