/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.List;
import java.util.Map;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAssertionValueShortFormProvider
implements ShortFormProvider {
    private List<OWLPropertyExpression<?, ?>> properties;
    private Map<OWLDataPropertyExpression, List<String>> preferredLanguageMap;
    private OWLOntologySetProvider ontologySetProvider;
    private ShortFormProvider alternateShortFormProvider;

    public PropertyAssertionValueShortFormProvider(List<OWLPropertyExpression<?, ?>> properties, Map<OWLDataPropertyExpression, List<String>> preferredLanguageMap, OWLOntologySetProvider ontologySetProvider) {
        this(properties, preferredLanguageMap, ontologySetProvider, new SimpleShortFormProvider());
    }

    public PropertyAssertionValueShortFormProvider(List<OWLPropertyExpression<?, ?>> properties, Map<OWLDataPropertyExpression, List<String>> preferredLanguageMap, OWLOntologySetProvider ontologySetProvider, ShortFormProvider alternateShortFormProvider) {
        this.properties = properties;
        this.preferredLanguageMap = preferredLanguageMap;
        this.ontologySetProvider = ontologySetProvider;
        this.alternateShortFormProvider = alternateShortFormProvider;
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        int lastURIMatchIndex = Integer.MAX_VALUE;
        int lastLangMatchIndex = Integer.MAX_VALUE;
        if (!(entity instanceof OWLIndividual)) {
            return this.alternateShortFormProvider.getShortForm(entity);
        }
        OWLIndividual individual = (OWLIndividual)((Object)entity);
        OWLObject candidateValue = null;
        for (OWLOntology ontology : this.ontologySetProvider.getOntologies()) {
            int index;
            for (OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom : ontology.getObjectPropertyAssertionAxioms(individual)) {
                index = this.properties.indexOf(oWLObjectPropertyAssertionAxiom.getProperty());
                if (index == -1 || index >= lastURIMatchIndex) continue;
                candidateValue = (OWLObject)oWLObjectPropertyAssertionAxiom.getObject();
            }
            for (OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom : ontology.getDataPropertyAssertionAxioms(individual)) {
                index = this.properties.indexOf(oWLDataPropertyAssertionAxiom.getProperty());
                if (index == -1) continue;
                if (index == lastURIMatchIndex) {
                    OWLLiteral lit;
                    int langIndex;
                    List<String> langList;
                    Object obj = oWLDataPropertyAssertionAxiom.getObject();
                    if (!(obj instanceof OWLLiteral) || (langList = this.preferredLanguageMap.get(oWLDataPropertyAssertionAxiom.getProperty())) == null || (langIndex = langList.indexOf((lit = (OWLLiteral)obj).getLang())) == -1 || langIndex >= lastLangMatchIndex) continue;
                    lastLangMatchIndex = langIndex;
                    candidateValue = (OWLObject)oWLDataPropertyAssertionAxiom.getObject();
                    continue;
                }
                if (index >= lastURIMatchIndex) continue;
                lastURIMatchIndex = index;
                candidateValue = (OWLObject)oWLDataPropertyAssertionAxiom.getObject();
            }
        }
        if (candidateValue != null) {
            return this.getRendering(candidateValue);
        }
        return this.alternateShortFormProvider.getShortForm(entity);
    }

    private String getRendering(OWLObject object) {
        if (object instanceof OWLLiteral) {
            return ((OWLLiteral)object).getLiteral();
        }
        return this.alternateShortFormProvider.getShortForm((OWLEntity)object);
    }

    public List<OWLPropertyExpression<?, ?>> getProperties() {
        return this.properties;
    }

    public Map<OWLDataPropertyExpression, List<String>> getPreferredLanguageMap() {
        return this.preferredLanguageMap;
    }

    @Override
    public void dispose() {
    }
}

