/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.View;
import net.infonode.docking.WindowTab;
import net.infonode.docking.internal.HeavyWeightContainer;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowBarItem;
import net.infonode.docking.properties.TabWindowProperties;
import net.infonode.docking.properties.WindowBarProperties;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.panel.BaseContainerUtil;
import net.infonode.gui.panel.ResizablePanel;
import net.infonode.properties.base.Property;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.properties.util.PropertyChangeListener;
import net.infonode.tabbedpanel.TabContentPanel;
import net.infonode.tabbedpanel.TabbedPanelContentPanel;
import net.infonode.util.Direction;

public class WindowBar
extends AbstractTabWindow {
    private RootWindow rootWindow;
    private Direction direction;
    private TabbedPanelContentPanel contentPanel;
    private ResizablePanel edgePanel;
    private HeavyWeightContainer heavyWeightEdgePanel;
    private PropertyChangeListener opaqueListener = new PropertyChangeListener(){

        public void propertyChanged(Property property, Object object, Object object2, Object object3) {
            WindowBar.this.updateEdgePanelOpaque();
        }
    };

    WindowBar(RootWindow rootWindow, Direction direction) {
        super(false, new WindowBarItem());
        this.initMouseListener();
        this.rootWindow = rootWindow;
        this.contentPanel = new TabbedPanelContentPanel(this.getTabbedPanel(), new TabContentPanel(this.getTabbedPanel()){

            public Dimension getMinimumSize() {
                if (WindowBar.this.getWindowBarProperties().getTabWindowProperties().getRespectChildWindowMinimumSize()) {
                    return super.getMinimumSize();
                }
                return new Dimension(0, 0);
            }
        });
        this.direction = direction;
        WindowBarProperties windowBarProperties = new WindowBarProperties();
        windowBarProperties.getTabWindowProperties().addSuperObject(rootWindow.getRootWindowProperties().getTabWindowProperties());
        ((WindowBarItem)this.getWindowItem()).setWindowBarProperties(new WindowBarProperties(windowBarProperties));
        this.getWindowBarProperties().addSuperObject(rootWindow.getRootWindowProperties().getWindowBarProperties());
        this.getWindowBarProperties().addSuperObject(WindowBarProperties.createDefault(this.direction));
        this.edgePanel = new ResizablePanel(rootWindow.isHeavyweightSupported(), this.direction.getOpposite(), this.contentPanel);
        this.edgePanel.setPreferredSize(new Dimension(200, 200));
        this.edgePanel.setComponent(this.contentPanel);
        this.edgePanel.setLayeredPane(rootWindow.getLayeredPane());
        this.edgePanel.setInnerArea(rootWindow.getWindowPanel());
        this.updateEdgePanelOpaque();
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.contentPanel.getProperties().getShapedPanelProperties().getMap(), ShapedPanelProperties.OPAQUE, this.opaqueListener);
        if (rootWindow.isHeavyweightSupported()) {
            this.edgePanel.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    if (WindowBar.this.edgePanel.getParent() != null) {
                        WindowBar.this.edgePanel.getParent().repaint();
                    }
                }
            });
        }
        this.getEdgePanel().setVisible(false);
        this.setTabWindowProperties(this.getWindowBarProperties().getTabWindowProperties());
        this.init();
    }

    public TabWindowProperties getTabWindowProperties() {
        return this.getWindowBarProperties().getTabWindowProperties();
    }

    public WindowBarProperties getWindowBarProperties() {
        return ((WindowBarItem)this.getWindowItem()).getWindowBarProperties();
    }

    protected int addTabNoSelect(DockingWindow dockingWindow, int n) {
        n = super.addTabNoSelect(dockingWindow, n);
        dockingWindow.setLastMinimizedDirection(this.direction);
        return n;
    }

    public void setContentPanelSize(int n) {
        this.edgePanel.setPreferredSize(this.direction.isHorizontal() ? new Dimension(n, 0) : new Dimension(0, n));
    }

    public int getContentPanelSize() {
        Dimension dimension = this.edgePanel.getPreferredSize();
        return this.direction.isHorizontal() ? dimension.width : dimension.height;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public RootWindow getRootWindow() {
        return this.rootWindow;
    }

    protected void showChildWindow(DockingWindow dockingWindow) {
        int n = this.getChildWindowIndex(dockingWindow);
        if (n != -1) {
            this.setSelectedTab(n);
        }
        super.showChildWindow(dockingWindow);
    }

    Component getEdgePanel() {
        if (!this.rootWindow.isHeavyweightSupported()) {
            return this.edgePanel;
        }
        if (this.heavyWeightEdgePanel == null) {
            this.heavyWeightEdgePanel = new HeavyWeightContainer(this.edgePanel);
            this.heavyWeightEdgePanel.setVisible(false);
        }
        return this.heavyWeightEdgePanel;
    }

    protected void update() {
        this.edgePanel.setResizeWidth(this.getWindowBarProperties().getContentPanelEdgeResizeDistance());
        this.edgePanel.setContinuousLayout(this.getWindowBarProperties().getContinuousLayoutEnabled());
        this.edgePanel.setDragIndicatorColor(this.getWindowBarProperties().getDragIndicatorColor());
        this.getWindowBarProperties().getComponentProperties().applyTo(this, this.direction.getNextCW());
    }

    private void updateEdgePanelOpaque() {
        if (this.edgePanel != null) {
            BaseContainerUtil.setForcedOpaque(this.edgePanel, this.rootWindow.isHeavyweightSupported() || this.contentPanel.getProperties().getShapedPanelProperties().getOpaque());
        }
    }

    public Dimension getPreferredSize() {
        if (this.isEnabled()) {
            Dimension dimension = super.getPreferredSize();
            int n = this.getWindowBarProperties().getMinimumWidth();
            return new Dimension(Math.max(n, dimension.width), Math.max(n, dimension.height));
        }
        return new Dimension(0, 0);
    }

    protected void tabSelected(WindowTab windowTab) {
        this.getEdgePanel().setVisible(windowTab != null);
        super.tabSelected(windowTab);
    }

    protected boolean isInsideTabArea(Point point) {
        return true;
    }

    protected void clearFocus(View view) {
        super.clearFocus(view);
        if (view != null && !DockingUtil.isAncestor(this, view)) {
            this.getTabbedPanel().setSelectedTab(null);
        }
    }

    public boolean isMinimized() {
        return true;
    }

    protected boolean acceptsSplitWith(DockingWindow dockingWindow) {
        return false;
    }

    DropAction acceptDrop(Point point, DockingWindow dockingWindow) {
        return this.isEnabled() ? super.acceptDrop(point, dockingWindow) : null;
    }

    protected PropertyMap getPropertyObject() {
        return this.getWindowBarProperties().getMap();
    }

    protected PropertyMap createPropertyObject() {
        return new WindowBarProperties().getMap();
    }

    protected void write(ObjectOutputStream objectOutputStream, WriteContext writeContext, ViewWriter viewWriter) throws IOException {
        objectOutputStream.writeInt(this.getContentPanelSize());
        objectOutputStream.writeBoolean(this.isEnabled());
        this.getWindowItem().writeSettings(objectOutputStream, writeContext);
        super.write(objectOutputStream, writeContext, viewWriter);
    }

    protected DockingWindow newRead(ObjectInputStream objectInputStream, ReadContext readContext, ViewReader viewReader) throws IOException {
        this.setContentPanelSize(objectInputStream.readInt());
        this.setEnabled(objectInputStream.readBoolean());
        this.getWindowItem().readSettings(objectInputStream, readContext);
        super.newRead(objectInputStream, readContext, viewReader);
        return this;
    }

    protected DockingWindow oldRead(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        super.oldRead(objectInputStream, readContext);
        this.setContentPanelSize(objectInputStream.readInt());
        this.setEnabled(objectInputStream.readBoolean());
        return this;
    }
}

