/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.model.RootWindowItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowItemDecoder;
import net.infonode.docking.properties.DockingWindowProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapUtil;
import net.infonode.util.Direction;

public abstract class WindowItem {
    public static final DockingWindowProperties emptyProperties = new DockingWindowProperties();
    private WindowItem parent;
    private WeakReference connectedWindow = new WeakReference<Object>(null);
    private ArrayList windows = new ArrayList();
    private DockingWindowProperties dockingWindowProperties;
    private DockingWindowProperties parentProperties = emptyProperties;
    private Direction lastMinimizedDirection;

    protected abstract DockingWindow createWindow(ViewReader var1, ArrayList var2);

    public abstract WindowItem copy();

    protected WindowItem() {
        this.dockingWindowProperties = new DockingWindowProperties(emptyProperties);
    }

    protected WindowItem(WindowItem windowItem) {
        this.dockingWindowProperties = new DockingWindowProperties(windowItem.getDockingWindowProperties().getMap().copy(true, true));
        this.dockingWindowProperties.getMap().replaceSuperMap(windowItem.getParentDockingWindowProperties().getMap(), emptyProperties.getMap());
        this.lastMinimizedDirection = windowItem.getLastMinimizedDirection();
    }

    public boolean isRestoreWindow() {
        return this.parent != null && this.parent.isRestoreWindow();
    }

    public void addWindow(WindowItem windowItem) {
        this.addWindow(windowItem, this.windows.size());
    }

    public void addWindow(WindowItem windowItem, int n) {
        int n2 = n = n == -1 ? this.windows.size() : n;
        if (windowItem.parent == this) {
            int n3 = this.windows.indexOf(windowItem);
            if (n3 != n) {
                this.windows.remove(n3);
                this.windows.add(n3 < n ? n - 1 : n, windowItem);
            }
        } else {
            windowItem.setParent(this);
            this.windows.add(n, windowItem);
        }
    }

    public void removeWindow(WindowItem windowItem) {
        if (this.windows.remove(windowItem)) {
            windowItem.parent = null;
        }
    }

    public void removeWindowRefs(DockingWindow dockingWindow) {
        if (this.connectedWindow.get() == dockingWindow) {
            this.connectedWindow = new WeakReference<Object>(null);
        }
        for (int i = 0; i < this.getWindowCount(); ++i) {
            this.getWindow(i).removeWindowRefs(dockingWindow);
        }
    }

    public void replaceWith(WindowItem windowItem) {
        if (windowItem == this || this.parent == null) {
            return;
        }
        windowItem.setParent(this.parent);
        int n = this.parent.windows.indexOf(this);
        this.parent.windows.set(n, windowItem);
        this.parent = null;
    }

    public int getWindowIndex(WindowItem windowItem) {
        return this.windows.indexOf(windowItem);
    }

    private void setParent(WindowItem windowItem) {
        if (this.parent == windowItem) {
            return;
        }
        if (this.parent != null) {
            this.parent.removeWindow(this);
        }
        this.parent = windowItem;
    }

    public final int getWindowCount() {
        return this.windows.size();
    }

    public final WindowItem getWindow(int n) {
        return (WindowItem)this.windows.get(n);
    }

    public WindowItem getParent() {
        return this.parent;
    }

    public void setConnectedWindow(DockingWindow dockingWindow) {
        this.connectedWindow = new WeakReference<DockingWindow>(dockingWindow);
    }

    public DockingWindow getConnectedWindow() {
        return (DockingWindow)this.connectedWindow.get();
    }

    public RootWindowItem getRootItem() {
        return this.parent == null ? null : this.parent.getRootItem();
    }

    public DockingWindow getVisibleDockingWindow() {
        DockingWindow dockingWindow = this.getConnectedWindow();
        if (dockingWindow != null && dockingWindow.getRootWindow() != null && !dockingWindow.isMinimized() && !dockingWindow.isUndocked()) {
            return dockingWindow;
        }
        for (int i = 0; i < this.getWindowCount(); ++i) {
            WindowItem windowItem = this.getWindow(i);
            dockingWindow = windowItem.getVisibleDockingWindow();
            if (dockingWindow == null) continue;
            return dockingWindow;
        }
        return null;
    }

    public DockingWindow getInsideDockingWindow() {
        if (this.getParent() == null) {
            return null;
        }
        DockingWindow dockingWindow = this.getParent().getConnectedWindow();
        if (dockingWindow != null) {
            return dockingWindow;
        }
        return this.getParent().getInsideDockingWindow();
    }

    public void removeAll() {
        while (this.getWindowCount() > 0) {
            this.removeWindow(this.getWindow(0));
        }
    }

    public boolean cleanUp() {
        for (int i = this.getWindowCount() - 1; i >= 0; --i) {
            if (!this.getWindow(i).cleanUp()) continue;
            this.windows.remove(i);
        }
        return this.getWindowCount() == 0 && this.getConnectedWindow() == null;
    }

    public DockingWindow getFirstChildWindow() {
        for (int i = 0; i < this.getWindowCount(); ++i) {
            DockingWindow dockingWindow = this.getWindow(i).getFirstWindow();
            if (dockingWindow == null) continue;
            return dockingWindow;
        }
        return null;
    }

    public DockingWindow getFirstWindow() {
        DockingWindow dockingWindow = this.getConnectedWindow();
        return dockingWindow != null ? dockingWindow : this.getFirstChildWindow();
    }

    public WindowItem getChildWindowContaining(WindowItem windowItem) {
        while (windowItem.getParent() != this) {
            if ((windowItem = windowItem.getParent()) != null) continue;
            return null;
        }
        return windowItem;
    }

    public boolean hasAncestor(WindowItem windowItem) {
        return this == windowItem || this.parent != null && this.parent.hasAncestor(windowItem);
    }

    public WindowItem getTopItem() {
        return this.parent == null ? this : this.parent.getTopItem();
    }

    public DockingWindowProperties getDockingWindowProperties() {
        if (this.dockingWindowProperties == null) {
            this.dockingWindowProperties = new DockingWindowProperties(emptyProperties);
            this.parentProperties = emptyProperties;
        }
        return this.dockingWindowProperties;
    }

    public DockingWindowProperties getParentDockingWindowProperties() {
        return this.parentProperties == null ? emptyProperties : this.parentProperties;
    }

    public void setParentDockingWindowProperties(DockingWindowProperties dockingWindowProperties) {
        this.dockingWindowProperties.getMap().replaceSuperMap(this.parentProperties.getMap(), dockingWindowProperties.getMap());
        this.parentProperties = dockingWindowProperties;
    }

    public Direction getLastMinimizedDirection() {
        return this.lastMinimizedDirection;
    }

    public void setLastMinimizedDirection(Direction direction) {
        this.lastMinimizedDirection = direction;
    }

    public void writeSettings(ObjectOutputStream objectOutputStream, WriteContext writeContext) throws IOException {
        objectOutputStream.writeInt(this.getLastMinimizedDirection() == null ? -1 : this.getLastMinimizedDirection().getValue());
        if (writeContext.getWritePropertiesEnabled()) {
            this.dockingWindowProperties.getMap().write(objectOutputStream, true);
            this.getPropertyObject().write(objectOutputStream, true);
        }
    }

    public void readSettings(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        if (readContext.getVersion() > 1) {
            int n = objectInputStream.readInt();
            this.setLastMinimizedDirection(n == -1 ? null : Direction.getDirections()[n]);
        }
        if (readContext.isPropertyValuesAvailable()) {
            if (readContext.getReadPropertiesEnabled()) {
                this.dockingWindowProperties.getMap().read(objectInputStream);
                this.getPropertyObject().read(objectInputStream);
            } else {
                PropertyMapUtil.skipMap(objectInputStream);
                PropertyMapUtil.skipMap(objectInputStream);
            }
        }
    }

    public void write(ObjectOutputStream objectOutputStream, WriteContext writeContext, ViewWriter viewWriter) throws IOException {
        objectOutputStream.writeInt(this.getWindowCount());
        for (int i = 0; i < this.getWindowCount(); ++i) {
            this.getWindow(i).write(objectOutputStream, writeContext, viewWriter);
        }
        DockingWindow dockingWindow = this.getConnectedWindow();
        this.writeSettings(objectOutputStream, writeContext);
        boolean bl = dockingWindow != null && !dockingWindow.isMinimized() && !dockingWindow.isUndocked() && dockingWindow.getRootWindow() != null;
        objectOutputStream.writeBoolean(dockingWindow != null && !dockingWindow.isMinimized() && !dockingWindow.isUndocked() && dockingWindow.getRootWindow() != null);
    }

    public DockingWindow read(ObjectInputStream objectInputStream, ReadContext readContext, ViewReader viewReader) throws IOException {
        ArrayList arrayList = this.readChildWindows(objectInputStream, readContext, viewReader);
        this.readSettings(objectInputStream, readContext);
        return objectInputStream.readBoolean() ? this.createWindow(viewReader, arrayList) : (arrayList.size() > 0 ? (DockingWindow)arrayList.get(0) : null);
    }

    public ArrayList readChildWindows(ObjectInputStream objectInputStream, ReadContext readContext, ViewReader viewReader) throws IOException {
        int n = objectInputStream.readInt();
        this.removeAll();
        ArrayList<DockingWindow> arrayList = new ArrayList<DockingWindow>();
        for (int i = 0; i < n; ++i) {
            WindowItem windowItem = WindowItemDecoder.decodeWindowItem(objectInputStream, readContext, viewReader);
            this.addWindow(windowItem);
            DockingWindow dockingWindow = windowItem.read(objectInputStream, readContext, viewReader);
            if (dockingWindow == null) continue;
            arrayList.add(dockingWindow);
        }
        return arrayList;
    }

    protected PropertyMap getPropertyObject() {
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        DockingWindow dockingWindow = this.getConnectedWindow();
        stringBuffer.append(dockingWindow + ":\n");
        for (int i = 0; i < this.windows.size(); ++i) {
            stringBuffer.append("  " + this.windows.get(i).toString());
        }
        return stringBuffer.toString();
    }

    public void clearWindows() {
        this.removeAll();
    }
}

