/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.obolibrary.cli.OBORunnerConfigCLIReader;
import org.obolibrary.cli.OBORunnerConfiguration;
import org.obolibrary.macro.MacroExpansionGCIVisitor;
import org.obolibrary.macro.MacroExpansionVisitor;
import org.obolibrary.obo2owl.Obo2Owl;
import org.obolibrary.obo2owl.Owl2Obo;
import org.obolibrary.oboformat.diff.Diff;
import org.obolibrary.oboformat.diff.OBODocDiffer;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.SetOntologyID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBODiffRunner {
    private static Logger logger = Logger.getLogger(OBODiffRunner.class);

    public static void main(String[] args) throws Exception {
        OBORunnerConfiguration config = OBORunnerConfigCLIReader.readConfig(args);
        if (config.showHelp.getValue().booleanValue()) {
            OBODiffRunner.usage();
            System.exit(0);
        }
        String buildDir = config.buildDir.getValue();
        if (config.ontsToDownload.getValue().size() > 0 && buildDir == null) {
            logger.error((Object)"must specify dir with -b DIR");
            System.exit(1);
        }
        if (config.outFile.isEmpty() && config.outputdir.isEmpty()) {
            logger.error((Object)"must specify at least one fo the following: outFile OR outputdir");
            OBODiffRunner.usage();
            System.exit(1);
        }
        if (buildDir != null) {
            OBODiffRunner.buildAllOboOwlFiles(buildDir, config, logger);
        }
        OBODiffRunner.runConversion(config, logger);
    }

    protected static void runConversion(OBORunnerConfiguration config, Logger logger) throws Exception {
        String outFile = config.outFile.getValue();
        Vector<OBODoc> obodocs = new Vector<OBODoc>();
        for (String iri : config.paths.getValue()) {
            iri = OBODiffRunner.getURI(iri);
            if (config.isOboToOwl.getValue().booleanValue()) {
                OBOFormatParser p = new OBOFormatParser();
                p.setFollowImports(config.followImports.getValue());
                OBODoc obodoc = p.parseURL(iri);
                obodocs.add(obodoc);
                continue;
            }
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            OWLOntology ontology = manager.loadOntologyFromOntologyDocument(IRI.create((String)iri));
            String version = config.version.getValue();
            if (version != null) {
                OBODiffRunner.addVersion(ontology, version, manager);
            }
            Owl2Obo bridge = new Owl2Obo();
            bridge.setStrictConversion(config.strictConversion.getValue());
            OBODoc doc = bridge.convert(ontology);
            obodocs.add(doc);
        }
        if (obodocs.size() > 2) {
            System.err.println("Max 2 docs!");
        }
        OBODocDiffer dd = new OBODocDiffer();
        OBODoc obodoc1 = (OBODoc)obodocs.get(0);
        OBODoc obodoc2 = (OBODoc)obodocs.get(1);
        List<Diff> diffs = dd.getDiffs(obodoc1, obodoc2);
        for (Diff diff : diffs) {
            System.out.println("MDiff=" + diff);
        }
    }

    private static OWLOntology handleMacroExpansion(OBORunnerConfiguration config, OWLOntology ontology, String gciFile, String outputFile, String ontologyId) throws OWLOntologyStorageException {
        if (!config.isExpandMacros.getValue().booleanValue()) {
            return ontology;
        }
        OBORunnerConfiguration.ExpandMacrosModeOptions option = config.expandMacrosMode.getValue();
        if (option == OBORunnerConfiguration.ExpandMacrosModeOptions.GCI) {
            MacroExpansionGCIVisitor mevGCI = new MacroExpansionGCIVisitor(ontology);
            OWLOntology gciOntology = mevGCI.createGCIOntology();
            if (gciOntology.isEmpty()) {
                return ontology;
            }
            OWLOntologyManager manager = gciOntology.getOWLOntologyManager();
            OWLImportsDeclaration importDeclaration = manager.getOWLDataFactory().getOWLImportsDeclaration(IRI.create((String)new File(outputFile).getName()));
            AddImport change = new AddImport(gciOntology, importDeclaration);
            manager.applyChange((OWLOntologyChange)change);
            File file = new File(gciFile);
            if (gciFile.equals(outputFile)) {
                String name = file.getName();
                String lowerCaseName = name.toLowerCase();
                int pos = lowerCaseName.lastIndexOf(".owl");
                name = pos > 0 ? name.substring(0, pos) + "-aux" + name.substring(pos) : name + "-aux.owl";
                gciFile = new File(file.getParentFile(), name).getAbsolutePath();
            }
            OWLOntologyID id = new OWLOntologyID(IRI.create((String)(ontologyId + "-aux")));
            change = new SetOntologyID(gciOntology, id);
            manager.applyChange((OWLOntologyChange)change);
            IRI gciIRI = IRI.create((File)new File(gciFile));
            OWLOntologyFormat format = config.format.getValue();
            logger.info((Object)("saving gci for " + ontologyId + " to " + gciIRI + " via " + format));
            manager.saveOntology(gciOntology, format, gciIRI);
        } else {
            MacroExpansionVisitor mev = new MacroExpansionVisitor(ontology);
            ontology = mev.expandAll();
        }
        return ontology;
    }

    private static void usage() {
        System.out.println("obolib-obo2owl [--to SYNTAX, --allowdangling --followimports --strictconversion] -o FILEPATH-URI OBO-FILE");
        System.out.println("obolib-obo2owl -b BUILDPATH-URI");
        System.out.println("\n");
        System.out.println("Converts obo files to OWL. If -b option is used, entire\n");
        System.out.println("obo repository is converted\n");
        System.out.println("\n");
        System.out.println("Example:\n");
        System.out.println(" obolib-obo2owl -o file://`pwd`/my.owl my.obo\n");
        System.out.println("Example:\n");
        System.out.println(" obolib-obo2owl -b file://`pwd`\n");
        System.out.println("Example:\n");
        System.out.println(" obolib-obo2owl -b file://`pwd` --download FBBT\n");
    }

    private static String getURI(String path) {
        if (path.startsWith("http://") || path.startsWith("file:///")) {
            return path;
        }
        File f = new File(path);
        return f.toURI().toString();
    }

    public static void showMemory() {
        System.gc();
        System.gc();
        System.gc();
        long tm = Runtime.getRuntime().totalMemory();
        long fm = Runtime.getRuntime().freeMemory();
        long mem = tm - fm;
        System.out.println("Memory total:" + tm + " free:" + fm + " diff:" + mem + " (bytes) diff:" + mem / 1000000L + " (mb)");
    }

    protected static void buildAllOboOwlFiles(String dir, OBORunnerConfiguration config, Logger logger) throws IOException {
        Map<String, String> ontmap = OBODiffRunner.getOntDownloadMap();
        Vector<String> fails = new Vector<String>();
        Set<String> ontsToDownload = config.ontsToDownload.getValue();
        Set<String> omitOntsToDownload = config.omitOntsToDownload.getValue();
        for (String ont : ontmap.keySet()) {
            if (ontsToDownload.size() > 0 && !ontsToDownload.contains(ont) || omitOntsToDownload.size() > 0 && omitOntsToDownload.contains(ont)) continue;
            if (ontmap.containsKey(ont)) {
                try {
                    String url = ontmap.get(ont);
                    long initTime = System.nanoTime();
                    String ontId = ont.toLowerCase();
                    logger.info((Object)("converting: " + ont + " from: " + url + " using default ont:" + ontId));
                    if (url == null) {
                        logger.warn((Object)("no url for " + ont));
                        fails.add(ont);
                        continue;
                    }
                    Obo2Owl.convertURL(url, OBODiffRunner.getURI(dir + "/" + ontId + ".owl"), ontId);
                    long totalTime = System.nanoTime() - initTime;
                    OBODiffRunner.showMemory();
                    logger.info((Object)("TIME_TO_CONVERT " + ont + " " + (double)totalTime / 1000000.0 + " ms"));
                }
                catch (Error e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    fails.add(ont);
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    fails.add(ont);
                }
                continue;
            }
            fails.add(ont);
            logger.warn((Object)("did not convert: " + ont));
        }
        logger.info((Object)"DONE!");
        for (String fail : fails) {
            logger.warn((Object)("FAIL:" + fail));
        }
    }

    private static Map<String, String> getOntDownloadMap() throws IOException {
        return OBODiffRunner.getOntDownloadMap(new URL("http://obo.cvs.sourceforge.net/viewvc/*checkout*/obo/obo/website/cgi-bin/ontologies.txt"));
    }

    private static Map<String, String> getOntDownloadMap(String fn) throws IOException {
        return OBODiffRunner.getOntDownloadMap(new BufferedReader(new FileReader(fn)));
    }

    private static Map<String, String> getOntDownloadMap(URL url) throws IOException {
        return OBODiffRunner.getOntDownloadMap(new BufferedReader(new InputStreamReader(url.openStream())));
    }

    private static Map<String, String> getOntDownloadMap(BufferedReader in) throws IOException {
        String line;
        HashMap<String, String> urlmap = new HashMap<String, String>();
        String ns = null;
        while ((line = in.readLine()) != null) {
            if (line.length() == 0) {
                ns = null;
                continue;
            }
            String[] parts = line.split("\t");
            if (parts.length < 2) continue;
            String tag = parts[0];
            if (tag.equals("namespace")) {
                ns = parts[1];
                continue;
            }
            if (tag.equals("download")) {
                if (parts[1] == "") continue;
                urlmap.put(ns, parts[1]);
                continue;
            }
            if (tag.equals("source")) {
                if (parts[1] == "" || urlmap.containsKey(ns)) continue;
                urlmap.put(ns, parts[1]);
                continue;
            }
            if (tag.equals("is_obsolete")) {
                if (urlmap.containsKey(ns)) {
                    urlmap.remove(ns);
                }
                ns = null;
                continue;
            }
            if (!tag.equals("format") || parts[1].equals("obo")) continue;
            urlmap.remove(ns);
        }
        return urlmap;
    }

    private static void addVersion(OWLOntology ontology, String version, OWLOntologyManager manager) {
        OWLDataFactory fac = manager.getOWLDataFactory();
        OWLAnnotationProperty ap = fac.getOWLAnnotationProperty(Obo2Owl.trTagToIRI(OBOFormatConstants.OboFormatTag.TAG_REMARK.getTag()));
        OWLAnnotation ann = fac.getOWLAnnotation(ap, (OWLAnnotationValue)fac.getOWLLiteral(version));
        OWLAnnotationAssertionAxiom ax = fac.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)ontology.getOntologyID().getOntologyIRI(), ann);
        manager.applyChange((OWLOntologyChange)new AddAxiom(ontology, (OWLAxiom)ax));
    }
}

