/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.cli;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.obolibrary.cli.OBORunnerConfigCLIReader;
import org.obolibrary.cli.OBORunnerConfiguration;
import org.obolibrary.macro.MacroExpansionGCIVisitor;
import org.obolibrary.macro.MacroExpansionVisitor;
import org.obolibrary.obo2owl.Obo2Owl;
import org.obolibrary.obo2owl.Owl2Obo;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatDanglingReferenceException;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.obolibrary.oboformat.writer.OBOFormatWriter;
import org.obolibrary.owl.LabelFunctionalFormat;
import org.obolibrary.owl.LabelFunctionalSyntaxOntologyStorer;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLOntologyStorer;
import org.semanticweb.owlapi.model.SetOntologyID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBORunner {
    private static Logger logger = Logger.getLogger(OBORunner.class);

    public static void main(String[] args) throws Exception {
        OBORunnerConfiguration config = OBORunnerConfigCLIReader.readConfig(args);
        if (config.showHelp.getValue().booleanValue()) {
            OBORunner.usage();
            System.exit(0);
        }
        String buildDir = config.buildDir.getValue();
        if (config.ontsToDownload.getValue().size() > 0 && buildDir == null) {
            logger.error((Object)"must specify dir with -b DIR");
            System.exit(1);
        }
        if (config.outFile.isEmpty() && config.outputdir.isEmpty()) {
            logger.error((Object)"must specify at least one fo the following: outFile OR outputdir");
            OBORunner.usage();
            System.exit(1);
        }
        if (buildDir != null) {
            OBORunner.buildAllOboOwlFiles(buildDir, config, logger);
        }
        OBORunner.runConversion(config, logger);
    }

    protected static void runConversion(OBORunnerConfiguration config, Logger logger) throws Exception {
        String outFile = config.outFile.getValue();
        for (String iri : config.paths.getValue()) {
            OWLOntology ontology;
            Object bridge;
            iri = OBORunner.getURI(iri);
            if (config.isOboToOwl.getValue().booleanValue()) {
                OBODoc obodoc = OBORunner.loadObo(config, iri, logger);
                bridge = new Obo2Owl();
                OWLOntologyManager manager = ((Obo2Owl)bridge).getManager();
                ontology = ((Obo2Owl)bridge).convert(obodoc);
                obodoc = null;
                bridge = null;
                String version = config.version.getValue();
                if (version != null) {
                    OBORunner.addVersion(ontology, version, manager);
                }
                String gciFile = outFile;
                String outputFile = outFile;
                String ontologyId = Owl2Obo.getOntologyId(ontology);
                if (outputFile == null) {
                    gciFile = new File(config.outputdir.getValue(), ontologyId + "-aux.owl").getAbsolutePath();
                    outputFile = new File(config.outputdir.getValue(), ontologyId + ".owl").getAbsolutePath();
                }
                ontology = OBORunner.handleMacroExpansion(config, ontology, gciFile, outputFile, ontologyId);
                IRI outputStream = IRI.create((File)new File(outputFile));
                OWLOntologyFormat format = config.format.getValue();
                logger.info((Object)("saving to " + ontologyId + "," + outputStream + " via " + format));
                manager.saveOntology(ontology, format, outputStream);
                if (!config.writeLabelOWL.getValue().booleanValue()) continue;
                manager.addOntologyStorer((OWLOntologyStorer)new LabelFunctionalSyntaxOntologyStorer());
                LabelFunctionalFormat labelFormat = new LabelFunctionalFormat();
                IRI labelFile = IRI.create((File)new File(config.outputdir.getValue(), ontologyId + ".ofn").getCanonicalFile());
                logger.info((Object)("saving " + ontologyId + " additional OWL to " + outputStream));
                manager.saveOntology(ontology, (OWLOntologyFormat)labelFormat, labelFile);
                continue;
            }
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            ontology = manager.loadOntologyFromOntologyDocument(IRI.create((String)iri));
            String version = config.version.getValue();
            if (version != null) {
                OBORunner.addVersion(ontology, version, manager);
            }
            bridge = new Owl2Obo();
            ((Owl2Obo)bridge).setStrictConversion(config.strictConversion.getValue());
            OBODoc doc = ((Owl2Obo)bridge).convert(ontology);
            String outputFilePath = outFile;
            if (outFile == null) {
                outputFilePath = Owl2Obo.getOntologyId(ontology) + ".obo";
            }
            logger.info((Object)("saving to " + outputFilePath));
            FileOutputStream os = new FileOutputStream(new File(outputFilePath));
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
            BufferedWriter writer = new BufferedWriter(osw);
            OBOFormatWriter oboWriter = new OBOFormatWriter();
            if (config.isDisableDocumentChecking.getValue().booleanValue()) {
                oboWriter.setCheckStructure(false);
            }
            oboWriter.write(doc, writer);
            writer.close();
            String untranslatableAxiomsFile = config.untranslatableAxiomsFile.getValue();
            Collection<OWLAxiom> untranslatableAxioms = ((Owl2Obo)bridge).getUntranslatableAxioms();
            if (untranslatableAxiomsFile == null || untranslatableAxioms == null || untranslatableAxioms.isEmpty()) continue;
            OBORunner.writeUntranslatableAxioms(untranslatableAxiomsFile, untranslatableAxioms);
        }
    }

    private static OBODoc loadObo(OBORunnerConfiguration config, String iri, Logger logger) throws IOException, OBOFormatDanglingReferenceException, OBOFormatParserException {
        OBOFormatParser p = new OBOFormatParser();
        p.setFollowImports(config.followImports.getValue());
        OBODoc obodoc = p.parseURL(iri);
        List<String> errors = p.checkDanglingReferences(obodoc);
        for (String error : errors) {
            logger.error((Object)("Dangling Reference Error: " + error));
        }
        if (!config.allowDangling.getValue().booleanValue() && !errors.isEmpty()) {
            throw new OBOFormatDanglingReferenceException("Dangling references are found during conversion");
        }
        String defaultOntology = config.defaultOnt.getValue();
        if (defaultOntology == null || defaultOntology.trim().length() == 0) {
            defaultOntology = iri;
        }
        if (defaultOntology != null) {
            obodoc.addDefaultOntologyHeader(defaultOntology);
        }
        return obodoc;
    }

    private static void writeUntranslatableAxioms(String path, Collection<OWLAxiom> untranslatableAxioms) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ontology = manager.createOntology();
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>(untranslatableAxioms);
        manager.addAxioms(ontology, axioms);
        FileOutputStream outputStream = new FileOutputStream(new File(path));
        RDFXMLOntologyFormat format = new RDFXMLOntologyFormat();
        manager.saveOntology(ontology, (OWLOntologyFormat)format, (OutputStream)outputStream);
        outputStream.close();
    }

    private static OWLOntology handleMacroExpansion(OBORunnerConfiguration config, OWLOntology ontology, String gciFile, String outputFile, String ontologyId) throws OWLOntologyStorageException {
        if (!config.isExpandMacros.getValue().booleanValue()) {
            return ontology;
        }
        OBORunnerConfiguration.ExpandMacrosModeOptions option = config.expandMacrosMode.getValue();
        if (option == OBORunnerConfiguration.ExpandMacrosModeOptions.GCI) {
            MacroExpansionGCIVisitor mevGCI = new MacroExpansionGCIVisitor(ontology);
            OWLOntology gciOntology = mevGCI.createGCIOntology();
            if (gciOntology.isEmpty()) {
                return ontology;
            }
            OWLOntologyManager manager = gciOntology.getOWLOntologyManager();
            OWLImportsDeclaration importDeclaration = manager.getOWLDataFactory().getOWLImportsDeclaration(IRI.create((String)new File(outputFile).getName()));
            AddImport change = new AddImport(gciOntology, importDeclaration);
            manager.applyChange((OWLOntologyChange)change);
            File file = new File(gciFile);
            if (gciFile.equals(outputFile)) {
                String name = file.getName();
                String lowerCaseName = name.toLowerCase();
                int pos = lowerCaseName.lastIndexOf(".owl");
                name = pos > 0 ? name.substring(0, pos) + "-aux" + name.substring(pos) : name + "-aux.owl";
                gciFile = new File(file.getParentFile(), name).getAbsolutePath();
            }
            OWLOntologyID id = new OWLOntologyID(IRI.create((String)(ontologyId + "-aux")));
            change = new SetOntologyID(gciOntology, id);
            manager.applyChange((OWLOntologyChange)change);
            IRI gciIRI = IRI.create((File)new File(gciFile));
            OWLOntologyFormat format = config.format.getValue();
            logger.info((Object)("saving gci for " + ontologyId + " to " + gciIRI + " via " + format));
            manager.saveOntology(gciOntology, format, gciIRI);
        } else {
            MacroExpansionVisitor mev = new MacroExpansionVisitor(ontology);
            ontology = mev.expandAll();
        }
        return ontology;
    }

    private static void usage() {
        System.out.println("obolib-obo2owl [--to SYNTAX, --allowdangling --followimports --strictconversion] -o FILEPATH-URI OBO-FILE");
        System.out.println("obolib-obo2owl -b BUILDPATH-URI");
        System.out.println("\n");
        System.out.println("Converts obo files to OWL. If -b option is used, entire\n");
        System.out.println("obo repository is converted\n");
        System.out.println("\n");
        System.out.println("Example:\n");
        System.out.println(" obolib-obo2owl -o file://`pwd`/my.owl my.obo\n");
        System.out.println("Example:\n");
        System.out.println(" obolib-obo2owl -b file://`pwd`\n");
        System.out.println("Example:\n");
        System.out.println(" obolib-obo2owl -b file://`pwd` --download FBBT\n");
    }

    private static String getURI(String path) {
        if (path.startsWith("http://") || path.startsWith("file:///")) {
            return path;
        }
        File f = new File(path);
        return f.toURI().toString();
    }

    public static void showMemory() {
        System.gc();
        System.gc();
        System.gc();
        long tm = Runtime.getRuntime().totalMemory();
        long fm = Runtime.getRuntime().freeMemory();
        long mem = tm - fm;
        System.out.println("Memory total:" + tm + " free:" + fm + " diff:" + mem + " (bytes) diff:" + mem / 1000000L + " (mb)");
    }

    protected static void buildAllOboOwlFiles(String dir, OBORunnerConfiguration config, Logger logger) throws IOException {
        Map<String, String> ontmap = OBORunner.getOntDownloadMap();
        Vector<String> fails = new Vector<String>();
        Set<String> ontsToDownload = config.ontsToDownload.getValue();
        Set<String> omitOntsToDownload = config.omitOntsToDownload.getValue();
        for (String ont : ontmap.keySet()) {
            if (ontsToDownload.size() > 0 && !ontsToDownload.contains(ont) || omitOntsToDownload.size() > 0 && omitOntsToDownload.contains(ont)) continue;
            if (ontmap.containsKey(ont)) {
                try {
                    String url = ontmap.get(ont);
                    long initTime = System.nanoTime();
                    String ontId = ont.toLowerCase();
                    logger.info((Object)("converting: " + ont + " from: " + url + " using default ont:" + ontId));
                    if (url == null) {
                        logger.warn((Object)("no url for " + ont));
                        fails.add(ont);
                        continue;
                    }
                    Obo2Owl.convertURL(url, OBORunner.getURI(dir + "/" + ontId + ".owl"), ontId);
                    long totalTime = System.nanoTime() - initTime;
                    OBORunner.showMemory();
                    logger.info((Object)("TIME_TO_CONVERT " + ont + " " + (double)totalTime / 1000000.0 + " ms"));
                }
                catch (Error e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    fails.add(ont);
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    fails.add(ont);
                }
                continue;
            }
            fails.add(ont);
            logger.warn((Object)("did not convert: " + ont));
        }
        logger.info((Object)"DONE!");
        for (String fail : fails) {
            logger.warn((Object)("FAIL:" + fail));
        }
    }

    private static Map<String, String> getOntDownloadMap() throws IOException {
        return OBORunner.getOntDownloadMap(new URL("http://obo.cvs.sourceforge.net/viewvc/*checkout*/obo/obo/website/cgi-bin/ontologies.txt"));
    }

    private static Map<String, String> getOntDownloadMap(String fn) throws IOException {
        return OBORunner.getOntDownloadMap(new BufferedReader(new FileReader(fn)));
    }

    private static Map<String, String> getOntDownloadMap(URL url) throws IOException {
        return OBORunner.getOntDownloadMap(new BufferedReader(new InputStreamReader(url.openStream())));
    }

    private static Map<String, String> getOntDownloadMap(BufferedReader in) throws IOException {
        String line;
        HashMap<String, String> urlmap = new HashMap<String, String>();
        String ns = null;
        while ((line = in.readLine()) != null) {
            if (line.length() == 0) {
                ns = null;
                continue;
            }
            String[] parts = line.split("\t");
            if (parts.length < 2) continue;
            String tag = parts[0];
            if (tag.equals("namespace")) {
                ns = parts[1];
                continue;
            }
            if (tag.equals("download")) {
                if (parts[1] == "") continue;
                urlmap.put(ns, parts[1]);
                continue;
            }
            if (tag.equals("source")) {
                if (parts[1] == "" || urlmap.containsKey(ns)) continue;
                urlmap.put(ns, parts[1]);
                continue;
            }
            if (tag.equals("is_obsolete")) {
                if (urlmap.containsKey(ns)) {
                    urlmap.remove(ns);
                }
                ns = null;
                continue;
            }
            if (!tag.equals("format") || parts[1].equals("obo")) continue;
            urlmap.remove(ns);
        }
        return urlmap;
    }

    private static void addVersion(OWLOntology ontology, String version, OWLOntologyManager manager) {
        OWLDataFactory fac = manager.getOWLDataFactory();
        OWLAnnotationProperty ap = fac.getOWLAnnotationProperty(Obo2Owl.trTagToIRI(OBOFormatConstants.OboFormatTag.TAG_REMARK.getTag()));
        OWLAnnotation ann = fac.getOWLAnnotation(ap, (OWLAnnotationValue)fac.getOWLLiteral(version));
        OWLAnnotationAssertionAxiom ax = fac.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)ontology.getOntologyID().getOntologyIRI(), ann);
        manager.applyChange((OWLOntologyChange)new AddAxiom(ontology, (OWLAxiom)ax));
    }
}

