/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat;
import org.semanticweb.owlapi.io.OWLXMLOntologyFormat;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBORunnerConfiguration {
    private final List<Variable<?>> registeredVariables = new ArrayList();
    public final Variable<String> outFile = new StringParamterVariable("Output File", null, "-o", "--out");
    public final Variable<String> buildDir = new StringParamterVariable("Build Directory", null, "-b", "--build");
    public final Variable<String> defaultOnt = new StringParamterVariable("Default Ontology", null, "--default-ontology");
    public final Variable<Boolean> isOboToOwl = new ParamterVariable<Boolean>("Set owl to obo conversion direction", Boolean.valueOf(true), new String[]{"--owl2obo"}){

        @Override
        public boolean setValue(String value) {
            this.value = false;
            return true;
        }
    };
    public final Variable<Boolean> isExpandMacros = new ParamterVariable<Boolean>("Expand OWL Macros", Boolean.valueOf(false), new String[]{"-x", "--expand-macros"}){

        @Override
        public boolean setValue(String value) {
            this.value = Boolean.TRUE;
            return true;
        }
    };
    public final Variable<ExpandMacrosModeOptions> expandMacrosMode = new ParamterVariable<ExpandMacrosModeOptions>("Expand OWL Macros", ExpandMacrosModeOptions.GCI, new String[]{"-xm", "--expand-macros-mode"}){
        private String failureMessage;
        {
            this.failureMessage = null;
        }

        @Override
        public boolean setValue(String value) {
            if (value == null || ExpandMacrosModeOptions.GCI.name().equals(value.toUpperCase())) {
                this.value = ExpandMacrosModeOptions.GCI;
            } else if (ExpandMacrosModeOptions.INPLACE.name().equals(value.toUpperCase())) {
                this.value = ExpandMacrosModeOptions.INPLACE;
            } else {
                this.failureMessage = "Unknown option for Expand Macros: '" + value + "' -- reverting to default: " + value;
                return false;
            }
            return true;
        }

        @Override
        public String getSetValueFailure() {
            return this.failureMessage;
        }

        @Override
        public boolean doesReadValue() {
            return true;
        }
    };
    public final Variable<Boolean> isDisableDocumentChecking = new ParamterVariable<Boolean>("Disable document checking", Boolean.valueOf(false), new String[]{"--disable-checks", "--disable-document-checks"}){

        @Override
        public boolean setValue(String value) {
            this.value = true;
            return true;
        }
    };
    public final Variable<Boolean> allowDangling = new ParamterVariable<Boolean>("Allow Dangling", Boolean.valueOf(false), new String[]{"--allowdangling", "--allow-dangling"}){

        @Override
        public boolean setValue(String value) {
            this.value = true;
            return true;
        }
    };
    public final Variable<Boolean> followImports = new ParamterVariable<Boolean>("Follow Imports", Boolean.valueOf(false), new String[]{"--followimports", "--follow-imports"}){

        @Override
        public boolean setValue(String value) {
            this.value = true;
            return true;
        }
    };
    public final Variable<Boolean> strictConversion = new ParamterVariable<Boolean>("Strict Conversion", Boolean.valueOf(false), new String[]{"--strictconversion", "--strict-conversion"}){

        @Override
        public boolean setValue(String value) {
            this.value = true;
            return true;
        }
    };
    public final Variable<String> untranslatableAxiomsFile = new StringParamterVariable("Untranslatable Axioms Output File", null, "--untranslatableAxiomsFile");
    protected final Variable<Boolean> showHelp = new ParamterVariable<Boolean>("show help", Boolean.valueOf(false), new String[]{"-h", "--help"}){

        @Override
        public boolean setValue(String value) {
            this.value = true;
            return true;
        }
    };
    public final Variable<String> outputdir = new StringParamterVariable("Output Directory", ".", "--outdir");
    public final Variable<String> version = new StringParamterVariable("OWL version", null, "--owlversion");
    public final Variable<OWLOntologyFormat> format = new ParamterVariable<OWLOntologyFormat>("OWL ontology format", (OWLOntologyFormat)new RDFXMLOntologyFormat(), new String[]{"-t", "--to"}){
        private String failureMessage;
        {
            this.failureMessage = null;
        }

        @Override
        public boolean setValue(String to) {
            if (to.equals("owlxml")) {
                this.value = new OWLXMLOntologyFormat();
            } else if (to.contains("manchester")) {
                this.value = new ManchesterOWLSyntaxOntologyFormat();
            } else if (to.contains("RDF")) {
                this.value = new RDFXMLOntologyFormat();
            } else {
                this.failureMessage = "don't know format '" + to + "' -- reverting to default: " + this.value;
                return false;
            }
            return true;
        }

        @Override
        public String getSetValueFailure() {
            return this.failureMessage;
        }

        @Override
        public boolean doesReadValue() {
            return true;
        }
    };
    public final Variable<Boolean> writeLabelOWL = new ParamterVariable<Boolean>("Write additional owl file in functional syntax file with labels", Boolean.valueOf(false), new String[]{"--write-label-owl"}){

        @Override
        public boolean setValue(String value) {
            this.value = true;
            return true;
        }
    };
    public final Variable<Set<String>> ontsToDownload = new StringSetParamterVariable("Ontologies to download", new String[]{"--download"});
    public final Variable<Set<String>> omitOntsToDownload = new StringSetParamterVariable("Ontologies to be ommited for download", new String[]{"--omit-download"});
    public final Variable<Collection<String>> paths = new Variable<Collection<String>>("paths", new Vector()){

        @Override
        public boolean setValue(String value) {
            ((Collection)this.value).add(value);
            return true;
        }
    };

    public Iterable<Variable<?>> getVariables() {
        return Collections.unmodifiableList(this.registeredVariables);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class StringSetParamterVariable
    extends ParamterVariable<Set<String>> {
        private StringSetParamterVariable(String name, String ... parameters) {
            super(name, new HashSet(), parameters);
        }

        @Override
        public boolean setValue(String value) {
            ((Set)this.value).add(value);
            return true;
        }

        @Override
        public boolean isEmpty() {
            return ((Set)this.value).isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringParamterVariable
    extends ParamterVariable<String> {
        protected StringParamterVariable(String name, String defaultValue, String ... parameters) {
            super(name, defaultValue, parameters);
        }

        @Override
        public boolean setValue(String value) {
            this.value = value;
            return true;
        }

        @Override
        public boolean doesReadValue() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.value == null || ((String)this.value).length() == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ParamterVariable<T>
    extends Variable<T> {
        private final String[] parameters;

        protected ParamterVariable(String name, T defaultValue, String ... parameters) {
            super(name, defaultValue);
            this.parameters = parameters;
        }

        @Override
        public Iterable<String> getParameters() {
            return Arrays.asList(this.parameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Variable<T> {
        private final String name;
        protected T value;

        protected Variable(String name, T defaultValue) {
            this.name = name;
            this.value = defaultValue;
            OBORunnerConfiguration.this.registeredVariables.add(this);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return null;
        }

        public Iterable<String> getParameters() {
            return null;
        }

        public abstract boolean setValue(String var1);

        public void setRealValue(T value) {
            this.value = value;
        }

        public String getSetValueFailure() {
            return null;
        }

        public T getValue() {
            return this.value;
        }

        public boolean doesReadValue() {
            return false;
        }

        public boolean isEmpty() {
            return this.value == null;
        }

        public String toString() {
            return this.getName() + ":" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpandMacrosModeOptions {
        GCI,
        INPLACE;

    }
}

