/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.cli;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.swing.JOptionPane;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.obolibrary.cli.OBORunner;
import org.obolibrary.cli.OBORunnerConfigCLIReader;
import org.obolibrary.cli.OBORunnerConfiguration;
import org.obolibrary.gui.GuiMainFrame;

public class OBORunnerGui
extends OBORunner {
    private static final Logger logger = Logger.getLogger(OBORunnerGui.class);
    private static final ThreadLocal<DateFormat> df = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public static void main(String[] args) {
        Logger rootLogger = Logger.getRootLogger();
        final ArrayBlockingQueue logQueue = new ArrayBlockingQueue(100000);
        rootLogger.addAppender((Appender)new AppenderSkeleton(){

            public boolean requiresLayout() {
                return false;
            }

            public void close() {
            }

            protected void append(LoggingEvent event) {
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append(((DateFormat)df.get()).format(new Date(event.timeStamp)));
                    sb.append(' ');
                    sb.append(event.getLevel());
                    sb.append(' ');
                    sb.append(event.getRenderedMessage());
                    logQueue.put(sb.toString());
                }
                catch (InterruptedException e) {
                    logger.fatal((Object)"Interruped during wait for writing to the message panel.", (Throwable)e);
                }
            }
        });
        OBORunnerConfiguration config = OBORunnerConfigCLIReader.readConfig(args);
        if (config.showHelp.getValue().booleanValue()) {
            System.out.println("GUI version of OBORunner. All parameters are set using the GUI.");
            System.exit(0);
        }
        new GuiMainFrameWorker(logQueue, config);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GuiMainFrameWorker
    extends GuiMainFrame {
        private static final long serialVersionUID = -7439731894262579201L;

        private GuiMainFrameWorker(BlockingQueue<String> logQueue, OBORunnerConfiguration config) {
            super(logQueue, config);
        }

        @Override
        protected void executeConversion(final OBORunnerConfiguration config) {
            this.disableRunButton();
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        String buildDir = config.buildDir.getValue();
                        if (buildDir != null) {
                            OBORunner.buildAllOboOwlFiles(buildDir, config, logger);
                        }
                        OBORunner.runConversion(config, logger);
                        logger.info((Object)"Finished ontology conversion.");
                        JOptionPane.showMessageDialog(GuiMainFrameWorker.this, "Finished ontology conversion.");
                    }
                    catch (Exception e) {
                        String message = "Internal error: " + e.getMessage();
                        logger.error((Object)message, (Throwable)e);
                        JOptionPane.showMessageDialog(GuiMainFrameWorker.this, message, "Error", 0);
                    }
                    catch (Throwable e) {
                        String message = "Internal error: " + e.getMessage();
                        logger.fatal((Object)message, e);
                        JOptionPane.showMessageDialog(GuiMainFrameWorker.this, message, "FatalError", 0);
                    }
                    finally {
                        GuiMainFrameWorker.this.enableRunButton();
                    }
                }
            };
            t.start();
        }
    }
}

