/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.examples;

import java.io.FileOutputStream;
import java.io.OutputStream;
import org.obolibrary.obo2owl.Obo2Owl;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class ExportLabelsAsOWL {
    public static void main(String[] args) throws Exception {
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = p.parse(args[0]);
        Obo2Owl bridge = new Obo2Owl();
        OWLOntologyManager manager = bridge.getManager();
        OWLOntology ontology = bridge.convert(obodoc);
        FileOutputStream os = new FileOutputStream(args[1]);
        IRI rdfsLabelIRI = OWLRDFVocabulary.RDFS_LABEL.getIRI();
        OWLOntology ontology2 = manager.createOntology(IRI.create((String)"http://example.org"));
        for (OWLClass c : ontology.getClassesInSignature()) {
            manager.addAxiom(ontology2, (OWLAxiom)manager.getOWLDataFactory().getOWLDeclarationAxiom((OWLEntity)c));
            for (OWLAnnotationAssertionAxiom a : ontology.getAnnotationAssertionAxioms((OWLAnnotationSubject)c.getIRI())) {
                if (!a.getProperty().getIRI().equals((Object)rdfsLabelIRI)) continue;
                manager.addAxiom(ontology2, (OWLAxiom)a);
            }
        }
        RDFXMLOntologyFormat format = new RDFXMLOntologyFormat();
        manager.saveOntology(ontology2, (OWLOntologyFormat)format, (OutputStream)os);
    }
}

