/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.BlockingQueue;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.obolibrary.gui.GuiTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiLogPanel
extends GuiTools.SizedJPanel {
    private static final long serialVersionUID = 3246873806276885090L;
    final JTextPane logTextPane;
    private final BlockingQueue<String> logQueue;
    private Thread thread = new Thread(){

        public void run() {
            while (true) {
                GuiLogPanel.this.appendToLogPanel();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    };

    public GuiLogPanel(BlockingQueue<String> logQueue) {
        this.logQueue = logQueue;
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)new JLabel("LOGS"), "North");
        this.logTextPane = new JTextPane();
        this.logTextPane.setEditable(false);
        JScrollPane logScrollPane = new JScrollPane(this.logTextPane);
        logScrollPane.setVerticalScrollBarPolicy(22);
        logScrollPane.setWheelScrollingEnabled(true);
        this.add((Component)logScrollPane, "Center");
        this.thread.start();
    }

    private void appendToLogPanel() {
        StyledDocument document = this.logTextPane.getStyledDocument();
        try {
            while (true) {
                String message = this.logQueue.take();
                document.insertString(document.getLength(), message, null);
                document.insertString(document.getLength(), "\n", null);
                this.logTextPane.setCaretPosition(document.getLength());
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

