/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.Set;
import org.apache.log4j.Logger;
import org.coode.owlapi.manchesterowlsyntax.OntologyAxiomPair;
import org.obolibrary.macro.AbstractMacroExpansionVisitor;
import org.obolibrary.macro.ManchesterSyntaxTool;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class MacroExpansionGCIVisitor {
    private static final Logger log = Logger.getLogger(MacroExpansionGCIVisitor.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private OWLOntology inputOntology;
    private OWLOntologyManager outputManager;
    private OWLOntology outputOntology;
    private ManchesterSyntaxTool manchesterSyntaxTool;
    private GCIVisitor visitor;

    public MacroExpansionGCIVisitor(OWLOntology inputOntology) {
        this.inputOntology = inputOntology;
        this.visitor = new GCIVisitor(inputOntology);
        this.manchesterSyntaxTool = new ManchesterSyntaxTool(inputOntology);
        this.outputManager = OWLManager.createOWLOntologyManager();
        try {
            this.outputOntology = this.outputManager.createOntology(inputOntology.getOntologyID());
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void output(OWLAxiom axiom) {
        if (axiom == null) {
            log.error((Object)"no axiom");
            return;
        }
        AddAxiom addAx = new AddAxiom(this.outputOntology, axiom);
        try {
            this.outputManager.applyChange((OWLOntologyChange)addAx);
        }
        catch (Exception e) {
            log.error((Object)"COULD NOT TRANSLATE AXIOM", (Throwable)e);
        }
    }

    public OWLOntology createGCIOntology() {
        for (OWLAxiom ax : this.inputOntology.getAxioms()) {
            if (ax instanceof OWLSubClassOfAxiom) {
                this.visitor.visit((OWLSubClassOfAxiom)ax);
                continue;
            }
            if (ax instanceof OWLEquivalentClassesAxiom) {
                this.visitor.visit((OWLEquivalentClassesAxiom)ax);
                continue;
            }
            if (ax instanceof OWLClassAssertionAxiom) {
                this.visitor.visit((OWLClassAssertionAxiom)ax);
                continue;
            }
            if (!(ax instanceof OWLAnnotationAssertionAxiom)) continue;
            this.expand((OWLAnnotationAssertionAxiom)ax);
        }
        return this.outputOntology;
    }

    private void expand(OWLAnnotationAssertionAxiom ax) {
        OWLAnnotationProperty prop = ax.getProperty();
        String expandTo = (String)this.visitor.expandAssertionToMap.get(prop.getIRI());
        if (expandTo != null) {
            if (DEBUG) {
                log.debug((Object)("Template to Expand" + expandTo));
            }
            expandTo = expandTo.replaceAll("\\?X", this.manchesterSyntaxTool.getId((IRI)ax.getSubject()));
            expandTo = expandTo.replaceAll("\\?Y", this.manchesterSyntaxTool.getId((IRI)ax.getValue()));
            if (DEBUG) {
                log.debug((Object)("Expanding " + expandTo));
            }
            try {
                Set<OntologyAxiomPair> setAxp = this.manchesterSyntaxTool.parseManchesterExpressionFrames(expandTo);
                for (OntologyAxiomPair axp : setAxp) {
                    this.output(axp.getAxiom());
                }
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void dispose() {
        this.manchesterSyntaxTool.dispose();
    }

    private class GCIVisitor
    extends AbstractMacroExpansionVisitor {
        GCIVisitor(OWLOntology inputOntology) {
            super(inputOntology, log);
        }

        OWLClassExpression expandOWLObjSomeVal(OWLClassExpression filler, OWLObjectPropertyExpression p) {
            OWLClassExpression gciRHS = this.expandObject(filler, p);
            if (gciRHS != null) {
                OWLObjectSomeValuesFrom gciLHS = this.dataFactory.getOWLObjectSomeValuesFrom(p, filler);
                OWLEquivalentClassesAxiom ax = this.dataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)gciLHS, gciRHS);
                MacroExpansionGCIVisitor.this.output((OWLAxiom)ax);
            }
            return gciRHS;
        }

        OWLClassExpression expandOWLObjHasVal(OWLObjectHasValue desc, OWLIndividual filler, OWLObjectPropertyExpression p) {
            OWLClassExpression gciRHS = this.expandObject(filler, p);
            if (gciRHS != null) {
                OWLObjectHasValue gciLHS = this.dataFactory.getOWLObjectHasValue(p, filler);
                OWLEquivalentClassesAxiom ax = this.dataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)gciLHS, gciRHS);
                MacroExpansionGCIVisitor.this.output((OWLAxiom)ax);
            }
            return gciRHS;
        }

        private OWLClassExpression expandObject(Object filler, OWLObjectPropertyExpression p) {
            OWLClassExpression result = null;
            IRI iri = ((OWLObjectProperty)p).getIRI();
            IRI templateVal = null;
            if (this.expandExpressionMap.containsKey(iri)) {
                Set inds;
                System.out.println("svf " + p + " " + filler);
                if (filler instanceof OWLObjectOneOf && (inds = ((OWLObjectOneOf)filler).getIndividuals()).size() == 1) {
                    OWLIndividual ind = (OWLIndividual)inds.iterator().next();
                    System.out.println("**svf " + p + " " + ind);
                    if (ind instanceof OWLNamedIndividual) {
                        templateVal = ((OWLNamedObject)ind).getIRI();
                    }
                }
                if (filler instanceof OWLNamedObject) {
                    templateVal = ((OWLNamedObject)filler).getIRI();
                }
                if (templateVal != null) {
                    System.out.println("TEMPLATEVAL: " + templateVal.toString());
                    String tStr = (String)this.expandExpressionMap.get(iri);
                    System.out.println("t: " + tStr);
                    String exStr = tStr.replaceAll("\\?Y", MacroExpansionGCIVisitor.this.manchesterSyntaxTool.getId(templateVal));
                    System.out.println("R: " + exStr);
                    try {
                        result = MacroExpansionGCIVisitor.this.manchesterSyntaxTool.parseManchesterExpression(exStr);
                    }
                    catch (ParserException e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            return result;
        }
    }
}

