/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxEditorParser;
import org.coode.owlapi.manchesterowlsyntax.OntologyAxiomPair;
import org.obolibrary.obo2owl.Obo2Owl;
import org.obolibrary.oboformat.model.OBODoc;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.expression.ShortFormEntityChecker;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.BidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.BidirectionalShortFormProviderAdapter;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterSyntaxTool {
    private static final Logger log = Logger.getLogger(ManchesterSyntaxTool.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private IRIShortFormProvider iriShortFormProvider;
    private OWLDataFactory dataFactory;
    private OWLEntityChecker entityChecker;
    private ShortFormProvider shortFormProvider;
    private BidirectionalShortFormProviderAdapter bidirectionalShortFormProvider;
    private volatile boolean disposed = false;
    private Object disposedLock = new Object();

    public ManchesterSyntaxTool(OWLOntology inputOntology) {
        this(inputOntology, null, true);
    }

    public ManchesterSyntaxTool(OWLOntology inputOntology, Collection<OWLOntology> auxiliaryOntologies) {
        this(inputOntology, auxiliaryOntologies, true);
    }

    public ManchesterSyntaxTool(OWLOntology inputOntology, Collection<OWLOntology> auxiliaryOntologies, boolean resolveEntities) {
        HashSet<OWLOntology> ontologies;
        OWLOntologyManager manager = inputOntology.getOWLOntologyManager();
        this.dataFactory = manager.getOWLDataFactory();
        if (auxiliaryOntologies != null && !auxiliaryOntologies.isEmpty()) {
            ontologies = new HashSet<OWLOntology>();
            ontologies.addAll(inputOntology.getImportsClosure());
            for (OWLOntology auxOnt : auxiliaryOntologies) {
                ontologies.addAll(auxOnt.getImportsClosure());
            }
        } else {
            ontologies = inputOntology.getImportsClosure();
        }
        this.iriShortFormProvider = new SimpleIRIShortFormProvider();
        this.shortFormProvider = new ShortFormProvider(){

            public void dispose() {
            }

            public String getShortForm(OWLEntity owlEntity) {
                return ManchesterSyntaxTool.this.iriShortFormProvider.getShortForm(owlEntity.getIRI());
            }
        };
        this.bidirectionalShortFormProvider = new BidirectionalShortFormProviderAdapter(manager, ontologies, this.shortFormProvider);
        ShortFormEntityChecker defaultInstance = new ShortFormEntityChecker((BidirectionalShortFormProvider)this.bidirectionalShortFormProvider);
        this.entityChecker = resolveEntities ? new AdvancedEntityChecker((OWLEntityChecker)defaultInstance, ontologies) : defaultInstance;
    }

    public Set<OntologyAxiomPair> parseManchesterExpressionFrames(String expression) throws ParserException {
        ManchesterOWLSyntaxEditorParser parser = this.createParser(expression);
        Set set = parser.parseFrames();
        return set;
    }

    public OWLClassExpression parseManchesterExpression(String expression) throws ParserException {
        ManchesterOWLSyntaxEditorParser parser = this.createParser(expression);
        OWLClassExpression ce = parser.parseClassExpression();
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManchesterOWLSyntaxEditorParser createParser(String expression) {
        Object object = this.disposedLock;
        synchronized (object) {
            if (this.disposed) {
                throw new RuntimeException("Illegal State: Trying to use an disposed instance.");
            }
        }
        ManchesterOWLSyntaxEditorParser parser = new ManchesterOWLSyntaxEditorParser(this.dataFactory, expression);
        parser.setOWLEntityChecker(this.entityChecker);
        if (DEBUG) {
            log.debug((Object)("parsing:" + expression));
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(IRI iri) {
        Object object = this.disposedLock;
        synchronized (object) {
            if (this.disposed) {
                throw new RuntimeException("Illegal State: Trying to use an disposed instance.");
            }
        }
        return this.iriShortFormProvider.getShortForm(iri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(OWLEntity entity) {
        Object object = this.disposedLock;
        synchronized (object) {
            if (this.disposed) {
                throw new RuntimeException("Illegal State: Trying to use an disposed instance.");
            }
        }
        return this.shortFormProvider.getShortForm(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.disposedLock;
        synchronized (object) {
            if (!this.disposed) {
                this.disposed = true;
                this.iriShortFormProvider = null;
                this.dataFactory = null;
                this.entityChecker = null;
                this.shortFormProvider.dispose();
                this.shortFormProvider = null;
                this.bidirectionalShortFormProvider.dispose();
                this.bidirectionalShortFormProvider = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AdvancedEntityChecker
    implements OWLEntityChecker {
        private final OWLEntityChecker defaultInstance;
        private final Set<OWLOntology> ontologies;

        AdvancedEntityChecker(OWLEntityChecker defaultInstance, Set<OWLOntology> ontologies) {
            this.defaultInstance = defaultInstance;
            this.ontologies = ontologies;
        }

        public OWLClass getOWLClass(String name) {
            IRI iri;
            OWLClass owlClass = this.defaultInstance.getOWLClass(name);
            if (owlClass != null || (iri = this.getIRI(name)) == null || (owlClass = this.getOWLClass(iri)) == null) {
                // empty if block
            }
            return owlClass;
        }

        public OWLObjectProperty getOWLObjectProperty(String name) {
            IRI iri;
            OWLObjectProperty owlObjectProperty = this.defaultInstance.getOWLObjectProperty(name);
            if (owlObjectProperty == null && (iri = this.getIRI(name)) != null) {
                owlObjectProperty = this.getOWLObjectProperty(iri);
            }
            return owlObjectProperty;
        }

        public OWLDataProperty getOWLDataProperty(String name) {
            return this.defaultInstance.getOWLDataProperty(name);
        }

        public OWLNamedIndividual getOWLIndividual(String name) {
            IRI iri;
            OWLNamedIndividual owlIndividual = this.defaultInstance.getOWLIndividual(name);
            if (owlIndividual == null && (iri = this.getIRI(name)) != null) {
                owlIndividual = this.getOWLIndividual(iri);
            }
            return owlIndividual;
        }

        public OWLDatatype getOWLDatatype(String name) {
            return this.defaultInstance.getOWLDatatype(name);
        }

        public OWLAnnotationProperty getOWLAnnotationProperty(String name) {
            return this.defaultInstance.getOWLAnnotationProperty(name);
        }

        IRI getIRI(String name) {
            if (this.isQuoted(name)) {
                return this.getIRIByLabel(name.substring(1, name.length() - 1));
            }
            if (name.length() > 2 && name.charAt(0) == '<' && name.charAt(name.length() - 1) == '>') {
                return IRI.create((String)name.substring(1, name.length() - 1));
            }
            return this.getIRIByIdentifier(name);
        }

        private boolean isQuoted(String s) {
            int length = s.length();
            if (length > 2) {
                return s.charAt(0) == '\'' && s.charAt(length - 1) == '\'';
            }
            return false;
        }

        IRI getIRIByIdentifier(String id) {
            Obo2Owl b = new Obo2Owl();
            b.setObodoc(new OBODoc());
            return b.oboIdToIRI(id);
        }

        IRI getIRIByLabel(String label) {
            IRI iri = null;
            for (OWLOntology o : this.ontologies) {
                Set aas = o.getAxioms(AxiomType.ANNOTATION_ASSERTION);
                for (OWLAnnotationAssertionAxiom aa : aas) {
                    OWLAnnotationSubject obj;
                    OWLAnnotationValue v = aa.getValue();
                    OWLAnnotationProperty property = aa.getProperty();
                    if (!(v instanceof OWLLiteral) || !property.isLabel() || !label.equals(((OWLLiteral)v).getLiteral()) || !((obj = aa.getSubject()) instanceof IRI)) continue;
                    return (IRI)obj;
                }
            }
            return iri;
        }

        OWLClass getOWLClass(IRI iri) {
            for (OWLOntology o : this.ontologies) {
                OWLClass c;
                if (o.getDeclarationAxioms((OWLEntity)(c = o.getOWLOntologyManager().getOWLDataFactory().getOWLClass(iri))).size() > 0) {
                    return c;
                }
                if (!o.getOWLOntologyManager().getOWLDataFactory().getOWLNothing().equals(c)) continue;
                return c;
            }
            return null;
        }

        OWLNamedIndividual getOWLIndividual(IRI iri) {
            for (OWLOntology o : this.ontologies) {
                OWLDataFactory dataFactory = o.getOWLOntologyManager().getOWLDataFactory();
                OWLNamedIndividual c = dataFactory.getOWLNamedIndividual(iri);
                for (OWLDeclarationAxiom da : o.getDeclarationAxioms((OWLEntity)c)) {
                    if (!(da.getEntity() instanceof OWLNamedIndividual)) continue;
                    return (OWLNamedIndividual)da.getEntity();
                }
            }
            return null;
        }

        OWLObjectProperty getOWLObjectProperty(IRI iri) {
            for (OWLOntology o : this.ontologies) {
                OWLDataFactory dataFactory;
                OWLObjectProperty p;
                if (o.getDeclarationAxioms((OWLEntity)(p = (dataFactory = o.getOWLOntologyManager().getOWLDataFactory()).getOWLObjectProperty(iri))).size() <= 0) continue;
                return p;
            }
            return null;
        }
    }
}

