/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.obolibrary.obo2owl.OwlStringTools;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Obo2Owl {
    private static Logger LOG = Logger.getLogger(Obo2Owl.class);
    public static final boolean DEBUG = LOG.isDebugEnabled();
    @Deprecated
    public static final String DEFAULT_IRI_PREFIX = "http://purl.obolibrary.org/obo/";
    public static final String IRI_PROP_isReversiblePropertyChain = "http://purl.obolibrary.org/obo/IAO_isReversiblePropertyChain";
    private String defaultIDSpace = "";
    OWLOntologyManager manager;
    OWLOntology owlOntology;
    OWLDataFactory fac;
    OBODoc obodoc;
    final Map<String, String> idSpaceMap = new HashMap<String, String>();
    public static Map<String, IRI> annotationPropertyMap = Obo2Owl.initAnnotationPropertyMap();
    final Set<OWLAnnotationProperty> apToDeclare = new HashSet<OWLAnnotationProperty>();
    private final Map<String, OWLClass> clsToDeclar = new Hashtable<String, OWLClass>();
    private final Map<String, OWLAnnotationProperty> typedefToAnnotationProperty = new Hashtable<String, OWLAnnotationProperty>();

    public Obo2Owl() {
        this(OWLManager.createOWLOntologyManager());
    }

    public Obo2Owl(OWLOntologyManager manager) {
        this.init(manager);
    }

    private void init(OWLOntologyManager manager) {
        this.manager = manager;
        this.fac = this.manager.getOWLDataFactory();
        this.idSpaceMap.clear();
        this.apToDeclare.clear();
        this.clsToDeclar.clear();
        this.typedefToAnnotationProperty.clear();
    }

    public static void convertURL(String iri, String outFile) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException, OBOFormatParserException {
        Obo2Owl bridge = new Obo2Owl();
        OWLOntologyManager manager = bridge.getManager();
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = p.parse(new URL(iri));
        OWLOntology ontology = bridge.convert(obodoc);
        IRI outputStream = IRI.create((String)outFile);
        RDFXMLOntologyFormat format = new RDFXMLOntologyFormat();
        if (DEBUG) {
            LOG.debug((Object)("saving to " + outputStream + " fmt=" + format));
        }
        manager.saveOntology(ontology, (OWLOntologyFormat)format, outputStream);
    }

    public static void convertURL(String iri, String outFile, String defaultOnt) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException, OBOFormatParserException {
        Obo2Owl bridge = new Obo2Owl();
        OWLOntologyManager manager = bridge.getManager();
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = p.parse(new URL(iri));
        obodoc.addDefaultOntologyHeader(defaultOnt);
        OWLOntology ontology = bridge.convert(obodoc);
        IRI outputStream = IRI.create((String)outFile);
        RDFXMLOntologyFormat format = new RDFXMLOntologyFormat();
        if (DEBUG) {
            LOG.debug((Object)("saving to " + outputStream + " fmt=" + format));
        }
        manager.saveOntology(ontology, (OWLOntologyFormat)format, outputStream);
    }

    private static HashMap<String, IRI> initAnnotationPropertyMap() {
        HashMap<String, IRI> map = new HashMap<String, IRI>();
        map.put(OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE.getTag(), OWLRDFVocabulary.OWL_DEPRECATED.getIRI());
        map.put(OBOFormatConstants.OboFormatTag.TAG_NAME.getTag(), OWLRDFVocabulary.RDFS_LABEL.getIRI());
        map.put(OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag(), OWLRDFVocabulary.RDFS_COMMENT.getIRI());
        for (Obo2OWLConstants.Obo2OWLVocabulary vac : Obo2OWLConstants.Obo2OWLVocabulary.values()) {
            map.put(vac.getMappedTag(), vac.getIRI());
        }
        return map;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public void setManager(OWLOntologyManager manager) {
        this.manager = manager;
    }

    public OBODoc getObodoc() {
        return this.obodoc;
    }

    public void setObodoc(OBODoc obodoc) {
        this.obodoc = obodoc;
    }

    protected OWLOntology getOwlOntology() {
        return this.owlOntology;
    }

    protected void setOwlOntology(OWLOntology owlOntology) {
        this.owlOntology = owlOntology;
    }

    public OWLOntology convert(String oboFile) throws OWLOntologyCreationException {
        try {
            OBOFormatParser p = new OBOFormatParser();
            OBODoc obodoc = p.parse(oboFile);
            return this.convert(obodoc);
        }
        catch (IOException ex) {
            throw new OWLOntologyCreationException("Error Occured while parsing OBO '" + oboFile + "'", (Throwable)ex);
        }
        catch (OBOFormatParserException ex) {
            throw new OWLOntologyCreationException("Syntax error occured while parsing OBO '" + oboFile + "'", (Throwable)ex);
        }
    }

    public OWLOntology convert(OBODoc obodoc, boolean useFreshManager) throws OWLOntologyCreationException {
        this.obodoc = obodoc;
        if (useFreshManager) {
            this.init(OWLManager.createOWLOntologyManager());
        } else {
            this.init(this.manager);
        }
        return this.tr();
    }

    public OWLOntology convert(OBODoc obodoc) throws OWLOntologyCreationException {
        return this.convert(obodoc, false);
    }

    private OWLOntology tr() throws OWLOntologyCreationException {
        Frame hf = this.obodoc.getHeaderFrame();
        Clause ontClause = hf.getClause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY);
        if (ontClause != null) {
            String ontOboId;
            this.defaultIDSpace = ontOboId = (String)ontClause.getValue();
            IRI ontIRI = ontOboId.contains(":") ? IRI.create((String)ontOboId) : IRI.create((String)(DEFAULT_IRI_PREFIX + ontOboId + ".owl"));
            Clause dvclause = hf.getClause(OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION);
            if (dvclause != null) {
                String dv = dvclause.getValue().toString();
                IRI vIRI = IRI.create((String)(DEFAULT_IRI_PREFIX + ontOboId + "/" + dv + "/" + ontOboId + ".owl"));
                OWLOntologyID oid = new OWLOntologyID(ontIRI, vIRI);
                this.owlOntology = this.manager.createOntology(oid);
            } else {
                this.owlOntology = this.manager.createOntology(ontIRI);
            }
        } else {
            this.defaultIDSpace = "TEMP";
            IRI ontIRI = IRI.create((String)(DEFAULT_IRI_PREFIX + this.defaultIDSpace));
            this.owlOntology = this.manager.createOntology(ontIRI);
        }
        this.trHeaderFrame(hf);
        for (Frame f : this.obodoc.getTypedefFrames()) {
            this.trTypedefToAnnotationProperty(f);
        }
        for (Frame f : this.obodoc.getTypedefFrames()) {
            this.trTypedefFrame(f);
        }
        for (Frame f : this.obodoc.getTermFrames()) {
            this.trTermFrame(f);
        }
        for (Clause cl : hf.getClauses(OBOFormatConstants.OboFormatTag.TAG_IMPORT)) {
            String path = this.getURI(cl.getValue().toString());
            IRI importIRI = IRI.create((String)path);
            this.manager.loadOntology(importIRI);
            AddImport ai = new AddImport(this.owlOntology, this.fac.getOWLImportsDeclaration(importIRI));
            this.manager.applyChange((OWLOntologyChange)ai);
        }
        this.postProcess(this.owlOntology);
        return this.owlOntology;
    }

    private void postProcess(OWLOntology owlOntology) {
        IRI pIRI = null;
        for (OWLAnnotation ann : owlOntology.getAnnotations()) {
            if (!ann.getProperty().getIRI().equals((Object)Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_LogicalDefinitionViewRelation.getIRI())) continue;
            OWLAnnotationValue v = ann.getValue();
            if (v instanceof OWLLiteral) {
                String rel = ((OWLLiteral)v).getLiteral();
                pIRI = this.oboIdToIRI(rel);
                break;
            }
            pIRI = (IRI)v;
            break;
        }
        if (pIRI != null) {
            OWLObjectProperty vp = this.fac.getOWLObjectProperty(pIRI);
            HashSet<OWLEquivalentClassesAxiom> rmAxioms = new HashSet<OWLEquivalentClassesAxiom>();
            HashSet<OWLEquivalentClassesAxiom> newAxioms = new HashSet<OWLEquivalentClassesAxiom>();
            for (OWLEquivalentClassesAxiom eca : owlOntology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
                int numNamed = 0;
                HashSet<Object> xs = new HashSet<Object>();
                for (OWLClassExpression x : eca.getClassExpressions()) {
                    if (x instanceof OWLClass) {
                        xs.add(x);
                        ++numNamed;
                        continue;
                    }
                    xs.add(this.fac.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)vp, x));
                }
                if (numNamed != true) continue;
                rmAxioms.add(eca);
                newAxioms.add(this.fac.getOWLEquivalentClassesAxiom(xs));
            }
            this.manager.removeAxioms(owlOntology, rmAxioms);
            this.manager.addAxioms(owlOntology, newAxioms);
        }
    }

    private String getURI(String path) {
        if (path.startsWith("http://") || path.startsWith("file:")) {
            return path;
        }
        File f = new File(path);
        return f.toURI().toString();
    }

    public void trHeaderFrame(Frame headerFrame) {
        for (String t : headerFrame.getTags()) {
            Collection<Clause> clauses;
            OWLAnnotationProperty parentAnnotProp;
            OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
            if (tag == OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY || tag == OBOFormatConstants.OboFormatTag.TAG_IMPORT) continue;
            if (tag == OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF) {
                parentAnnotProp = this.trTagToAnnotationProp(t);
                for (Clause clause : headerFrame.getClauses(t)) {
                    OWLAnnotationProperty childAnnotProp = this.trAnnotationProp(clause.getValue(String.class));
                    Set<OWLAnnotation> annotations = this.trAnnotations(clause);
                    this.add((OWLAxiom)this.fac.getOWLSubAnnotationPropertyOfAxiom(childAnnotProp, parentAnnotProp, annotations));
                    OWLAnnotationProperty ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag());
                    this.add((OWLAxiom)this.fac.getOWLAnnotationAssertionAxiom(ap, (OWLAnnotationSubject)childAnnotProp.getIRI(), this.trLiteral(clause.getValue2())));
                }
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF) {
                parentAnnotProp = this.trTagToAnnotationProp(t);
                for (Clause clause : headerFrame.getClauses(t)) {
                    Object[] values = clause.getValues().toArray();
                    OWLAnnotationProperty childAnnotProp = this.trAnnotationProp(values[0].toString());
                    IRI childIRI = childAnnotProp.getIRI();
                    Set<OWLAnnotation> annotations = this.trAnnotations(clause);
                    this.add((OWLAxiom)this.fac.getOWLSubAnnotationPropertyOfAxiom(childAnnotProp, parentAnnotProp, annotations));
                    OWLAnnotationProperty ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_NAME.getTag());
                    this.add((OWLAxiom)this.fac.getOWLAnnotationAssertionAxiom(ap, (OWLAnnotationSubject)childIRI, this.trLiteral(values[1])));
                    if (values.length <= 2 || values[2].toString().length() <= 0) continue;
                    ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_SCOPE.getTag());
                    this.add((OWLAxiom)this.fac.getOWLAnnotationAssertionAxiom(ap, (OWLAnnotationSubject)childIRI, (OWLAnnotationValue)this.trTagToAnnotationProp(values[2].toString()).getIRI()));
                }
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DATE) {
                Clause clause = headerFrame.getClause(tag);
                Object value = clause.getValue();
                String dateString = null;
                if (value instanceof Date) {
                    dateString = OBOFormatConstants.headerDateFormat.get().format((Date)value);
                } else if (value instanceof String) {
                    dateString = (String)value;
                }
                if (dateString != null) {
                    this.addOntologyAnnotation(this.trTagToAnnotationProp(t), this.trLiteral(dateString), this.trAnnotations(clause));
                    continue;
                }
                LOG.warn((Object)("Cannot translate: " + clause));
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE) {
                this.addPropertyValueHeaders(headerFrame.getClauses(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE));
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION) continue;
            if (tag == OBOFormatConstants.OboFormatTag.TAG_REMARK) {
                clauses = headerFrame.getClauses(t);
                for (Clause clause : clauses) {
                    this.addOntologyAnnotation(this.fac.getRDFSComment(), this.trLiteral(clause.getValue()), this.trAnnotations(clause));
                }
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_IDSPACE) continue;
            if (tag == OBOFormatConstants.OboFormatTag.TAG_OWL_AXIOMS) {
                Collection<String> axiomStrings = headerFrame.getTagValues(tag, String.class);
                if (axiomStrings == null) continue;
                try {
                    for (String axiomString : axiomStrings) {
                        Set<OWLAxiom> axioms = OwlStringTools.translate(axiomString);
                        if (axioms == null) continue;
                        this.manager.addAxioms(this.owlOntology, axioms);
                    }
                    continue;
                }
                catch (OwlStringTools.OwlStringException e) {
                    throw new RuntimeException(e);
                }
            }
            clauses = headerFrame.getClauses(t);
            for (Clause clause : clauses) {
                this.addOntologyAnnotation(this.trTagToAnnotationProp(t), this.trLiteral(clause.getValue()), this.trAnnotations(clause));
            }
        }
    }

    private void addPropertyValueHeaders(Collection<Clause> clauses) {
        for (Clause clause : clauses) {
            Set<OWLAnnotation> annotations = this.trAnnotations(clause);
            Collection<Object> values = clause.getValues();
            Object v = clause.getValue();
            Object v2 = clause.getValue2();
            if (v == null) {
                LOG.warn((Object)("Cannot translate: " + clause));
                continue;
            }
            if (values.size() == 2) {
                OWLAnnotationProperty prop = this.trAnnotationProp((String)v);
                IRI value = this.trAnnotationProp(v2.toString()).getIRI();
                OWLAnnotation ontAnn = this.fac.getOWLAnnotation(prop, (OWLAnnotationValue)value, annotations);
                AddOntologyAnnotation addAnn = new AddOntologyAnnotation(this.owlOntology, ontAnn);
                this.apply((OWLOntologyChange)addAnn);
                continue;
            }
            if (values.size() == 3) {
                Iterator<Object> it = clause.getValues().iterator();
                it.next();
                it.next();
                String v3String = (String)it.next();
                IRI valueIRI = v3String.startsWith("xsd:") ? IRI.create((String)(Namespaces.XSD + v3String.substring(4))) : IRI.create((String)v3String);
                OWLLiteral value = this.fac.getOWLLiteral((String)v2, OWL2Datatype.getDatatype((IRI)valueIRI));
                OWLAnnotationProperty prop = this.trAnnotationProp((String)v);
                OWLAnnotation ontAnn = this.fac.getOWLAnnotation(prop, (OWLAnnotationValue)value, annotations);
                AddOntologyAnnotation addAnn = new AddOntologyAnnotation(this.owlOntology, ontAnn);
                this.apply((OWLOntologyChange)addAnn);
                continue;
            }
            LOG.warn((Object)("Cannot translate: " + clause));
        }
    }

    protected void addOntologyAnnotation(OWLAnnotationProperty ap, OWLAnnotationValue v, Set<OWLAnnotation> annotations) {
        OWLAnnotation ontAnn = this.fac.getOWLAnnotation(ap, v, annotations);
        AddOntologyAnnotation addAnn = new AddOntologyAnnotation(this.owlOntology, ontAnn);
        this.apply((OWLOntologyChange)addAnn);
    }

    public OWLClassExpression trTermFrame(Frame termFrame) {
        OWLClass cls = this.trClass(termFrame.getId());
        this.add((OWLAxiom)this.fac.getOWLDeclarationAxiom((OWLEntity)cls));
        for (String t : termFrame.getTags()) {
            Collection<Clause> clauses = termFrame.getClauses(t);
            OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
            if (tag == OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF) {
                this.add(this.trIntersectionOf(cls, clauses));
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_UNION_OF) {
                this.add(this.trUnionOf(cls, clauses));
                continue;
            }
            for (Clause clause : clauses) {
                this.add(this.trTermClause(cls, t, clause));
            }
        }
        return cls;
    }

    private OWLNamedObject trTypedefToAnnotationProperty(Frame typedefFrame) {
        if (typedefFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG) != null && ((Boolean)typedefFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG)).booleanValue()) {
            String id = typedefFrame.getId();
            OWLAnnotationProperty p = this.trAnnotationProp(id);
            this.add((OWLAxiom)this.fac.getOWLDeclarationAxiom((OWLEntity)p));
            String xid = this.translateShorthandIdToExpandedId(id);
            if (!id.equals(xid)) {
                OWLAnnotationAssertionAxiom ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp("shorthand"), (OWLAnnotationSubject)p.getIRI(), this.trLiteral(id), new HashSet());
                this.add((OWLAxiom)ax);
            }
            this.typedefToAnnotationProperty.put(p.getIRI().toString(), p);
            for (String tag : typedefFrame.getTags()) {
                OBOFormatConstants.OboFormatTag _tag = OBOFormatConstants.getTag(tag);
                if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_A) continue;
                for (Clause clause : typedefFrame.getClauses(tag)) {
                    this.add(this.trGenericClause((OWLNamedObject)p, tag, clause));
                }
            }
            return p;
        }
        return null;
    }

    public OWLNamedObject trTypedefFrame(Frame typedefFrame) {
        if (typedefFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG) != null && ((Boolean)typedefFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG)).booleanValue()) {
            return null;
        }
        String id = typedefFrame.getId();
        OWLObjectProperty p = this.trObjectProp(id);
        this.add((OWLAxiom)this.fac.getOWLDeclarationAxiom((OWLEntity)p));
        String xid = this.translateShorthandIdToExpandedId(id);
        if (!xid.equals(id)) {
            OWLAnnotationAssertionAxiom ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp("shorthand"), (OWLAnnotationSubject)p.getIRI(), this.trLiteral(id), new HashSet());
            this.add((OWLAxiom)ax);
        }
        for (String tag : typedefFrame.getTags()) {
            OWLAxiom axiom;
            Collection<Clause> clauses = typedefFrame.getClauses(tag);
            OBOFormatConstants.OboFormatTag _tag = OBOFormatConstants.getTag(tag);
            if (_tag == OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF) {
                axiom = this.trRelationIntersectionOf(id, (OWLProperty<?, ?>)p, clauses);
                if (axiom == null) continue;
                this.add(axiom);
                continue;
            }
            if (_tag == OBOFormatConstants.OboFormatTag.TAG_UNION_OF) {
                axiom = this.trRelationUnionOf(id, (OWLProperty<?, ?>)p, clauses);
                if (axiom == null) continue;
                this.add(axiom);
                continue;
            }
            for (Clause clause : clauses) {
                this.add(this.trTypedefClause(p, tag, clause));
            }
        }
        return p;
    }

    private OWLAxiom trRelationUnionOf(String id, OWLProperty<?, ?> p, Collection<Clause> clauses) {
        LOG.warn((Object)("The relation union_of for " + id + " is currently non-translatable to OWL. Ignoring clauses: " + clauses));
        return null;
    }

    private OWLAxiom trRelationIntersectionOf(String id, OWLProperty<?, ?> p, Collection<Clause> clauses) {
        LOG.warn((Object)("The relation intersection_of for " + id + " is currently non-translatable to OWL. Ignoring clauses: " + clauses));
        return null;
    }

    private OWLAxiom trUnionOf(OWLClass cls, Collection<Clause> clauses) {
        Set<? extends OWLAnnotation> annotations = this.trAnnotations(clauses);
        HashSet<Object> eSet = new HashSet<Object>();
        eSet.add(cls);
        HashSet<OWLClassExpression> iSet = new HashSet<OWLClassExpression>();
        for (Clause clause : clauses) {
            Collection<QualifierValue> qvs = clause.getQualifierValues();
            if (clause.getValues().size() == 1) {
                iSet.add(this.trClass(clause.getValue()));
                continue;
            }
            LOG.error((Object)"union_of n-ary slots not is standard - converting anyway");
            iSet.add(this.trRel((String)clause.getValue(), (String)clause.getValue2(), qvs));
        }
        eSet.add(this.fac.getOWLObjectUnionOf(iSet));
        if (annotations == null || annotations.size() == 0) {
            return this.fac.getOWLEquivalentClassesAxiom(eSet);
        }
        return this.fac.getOWLEquivalentClassesAxiom(eSet, annotations);
    }

    private OWLAxiom trIntersectionOf(OWLClass cls, Collection<Clause> clauses) {
        Set<? extends OWLAnnotation> annotations = this.trAnnotations(clauses);
        HashSet<Object> eSet = new HashSet<Object>();
        eSet.add(cls);
        HashSet<OWLClassExpression> iSet = new HashSet<OWLClassExpression>();
        for (Clause clause : clauses) {
            Collection<QualifierValue> qvs = clause.getQualifierValues();
            if (clause.getValues().size() == 1) {
                iSet.add(this.trClass(clause.getValue()));
                continue;
            }
            iSet.add(this.trRel((String)clause.getValue(), (String)clause.getValue2(), qvs));
        }
        eSet.add(this.fac.getOWLObjectIntersectionOf(iSet));
        if (annotations == null || annotations.size() == 0) {
            return this.fac.getOWLEquivalentClassesAxiom(eSet);
        }
        return this.fac.getOWLEquivalentClassesAxiom(eSet, annotations);
    }

    protected void add(OWLAxiom axiom) {
        if (axiom == null) {
            LOG.error((Object)"no axiom");
            return;
        }
        AddAxiom addAx = new AddAxiom(this.owlOntology, axiom);
        this.apply((OWLOntologyChange)addAx);
    }

    protected void apply(OWLOntologyChange change) {
        try {
            this.manager.applyChange(change);
        }
        catch (Exception e) {
            LOG.error((Object)(e + "\nCOULD NOT TRANSLATE AXIOM"));
        }
    }

    private OWLAxiom trTermClause(OWLClass cls, String tag, Clause clause) {
        HashSet<OWLClass> cSet;
        Object ax;
        Collection<QualifierValue> qvs = clause.getQualifierValues();
        Set<OWLAnnotation> annotations = this.trAnnotations(clause);
        OBOFormatConstants.OboFormatTag _tag = OBOFormatConstants.getTag(tag);
        OWLClass clsx = cls;
        String gciRel = this.getQVString("gci_relation", qvs);
        if (gciRel != null && !gciRel.equals("")) {
            String gciFiller = this.getQVString("gci_filler", qvs);
            OWLClassExpression r = this.trRel(gciRel, gciFiller, new HashSet<QualifierValue>());
            clsx = this.fac.getOWLObjectIntersectionOf(new OWLClassExpression[]{cls, r});
        }
        if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_A) {
            ax = this.fac.getOWLSubClassOfAxiom((OWLClassExpression)clsx, (OWLClassExpression)this.trClass((String)clause.getValue()), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP) {
            IRI relId = this.oboIdToIRI((String)clause.getValue());
            OWLAnnotationProperty prop = this.typedefToAnnotationProperty.get(relId.toString());
            ax = prop != null ? this.fac.getOWLAnnotationAssertionAxiom(prop, (OWLAnnotationSubject)cls.getIRI(), (OWLAnnotationValue)this.oboIdToIRI((String)clause.getValue2()), annotations) : this.fac.getOWLSubClassOfAxiom((OWLClassExpression)clsx, this.trRel((String)clause.getValue(), (String)clause.getValue2(), qvs), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM) {
            cSet = new HashSet<OWLClass>();
            cSet.add(clsx);
            cSet.add(this.trClass((String)clause.getValue()));
            ax = this.fac.getOWLDisjointClassesAxiom(cSet, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO) {
            cSet = new HashSet();
            cSet.add(clsx);
            cSet.add(this.trClass((String)clause.getValue()));
            ax = this.fac.getOWLEquivalentClassesAxiom(cSet, annotations);
        } else {
            return this.trGenericClause((OWLNamedObject)cls, tag, clause);
        }
        return ax;
    }

    private OWLAxiom trTypedefClause(OWLObjectProperty p, String tag, Clause clause) {
        Object ax = null;
        Object v = clause.getValue();
        Set<OWLAnnotation> annotations = this.trAnnotations(clause);
        OBOFormatConstants.OboFormatTag _tag = OBOFormatConstants.getTag(tag);
        if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_A) {
            ax = this.fac.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)this.trObjectProp((String)v), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP) {
            IRI relId = this.oboIdToIRI((String)clause.getValue());
            OWLAnnotationProperty metaProp = this.typedefToAnnotationProperty.get(relId.toString());
            ax = metaProp != null ? this.fac.getOWLAnnotationAssertionAxiom(metaProp, (OWLAnnotationSubject)p.getIRI(), (OWLAnnotationValue)this.oboIdToIRI((String)clause.getValue2()), annotations) : null;
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM) {
            HashSet<OWLObjectProperty> cSet = new HashSet<OWLObjectProperty>();
            cSet.add(p);
            cSet.add(this.trObjectProp((String)v));
            ax = this.fac.getOWLDisjointObjectPropertiesAxiom(cSet, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF) {
            HashSet<OWLObjectProperty> cSet = new HashSet<OWLObjectProperty>();
            cSet.add(p);
            cSet.add(this.trObjectProp((String)v));
            ax = this.fac.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)this.trObjectProp((String)v), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO) {
            HashSet<OWLObjectProperty> cSet = new HashSet<OWLObjectProperty>();
            cSet.add(p);
            cSet.add(this.trObjectProp((String)v));
            ax = this.fac.getOWLEquivalentObjectPropertiesAxiom(cSet, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_DOMAIN) {
            ax = this.fac.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)p, this.trClass(v), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_RANGE) {
            ax = this.fac.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)p, this.trClass(v), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER) {
            ArrayList<Object> chain = new ArrayList<Object>(2);
            chain.add(p);
            chain.add(this.trObjectProp(v));
            ax = this.fac.getOWLSubPropertyChainOfAxiom(chain, (OWLObjectPropertyExpression)p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN || _tag == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN) {
            if (_tag == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN) {
                OWLAnnotation ann = this.fac.getOWLAnnotation(this.trAnnotationProp(IRI_PROP_isReversiblePropertyChain), this.trLiteral("true"));
                annotations.add(ann);
            }
            Vector<OWLObjectPropertyExpression> chain = new Vector<OWLObjectPropertyExpression>();
            chain.add(this.trObjectProp(v));
            chain.add(this.trObjectProp(clause.getValue2()));
            ax = this.fac.getOWLSubPropertyChainOfAxiom(chain, (OWLObjectPropertyExpression)p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_ASYMMETRIC && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p, annotations);
        } else {
            return this.trGenericClause((OWLNamedObject)p, tag, clause);
        }
        return ax;
    }

    private OWLAxiom trGenericClause(OWLNamedObject e, String tag, Clause clause) {
        return this.trGenericClause((OWLAnnotationSubject)e.getIRI(), tag, clause);
    }

    protected OWLAxiom trGenericClause(OWLAnnotationSubject sub, String tag, Clause clause) {
        Set<OWLAnnotation> annotations = this.trAnnotations(clause);
        if (clause.getValue() == null) {
            LOG.error((Object)("Problem: " + clause));
        }
        OWLAnnotationAssertionAxiom ax = null;
        OBOFormatConstants.OboFormatTag _tag = OBOFormatConstants.getTag(tag);
        if (_tag == OBOFormatConstants.OboFormatTag.TAG_NAME) {
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_DEF) {
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_SUBSET) {
            Object v = clause.getValue();
            if (v == null) {
                LOG.warn((Object)("Cannot translate: " + clause));
            } else {
                ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, (OWLAnnotationValue)this.trAnnotationProp(v.toString()).getIRI(), annotations);
            }
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE) {
            Collection<Object> values = clause.getValues();
            Object v = clause.getValue();
            Object v2 = clause.getValue2();
            if (v == null) {
                LOG.warn((Object)("Cannot translate: " + clause));
            } else if (values.size() == 2) {
                ax = this.fac.getOWLAnnotationAssertionAxiom(this.trAnnotationProp((String)v), sub, (OWLAnnotationValue)this.trAnnotationProp(v2.toString()).getIRI(), annotations);
            } else if (values.size() == 3) {
                Iterator<Object> it = clause.getValues().iterator();
                it.next();
                it.next();
                String v3String = (String)it.next();
                IRI valueIRI = v3String.startsWith("xsd:") ? IRI.create((String)(Namespaces.XSD + v3String.substring(4))) : IRI.create((String)v3String);
                OWLLiteral value = this.fac.getOWLLiteral((String)v2, OWL2Datatype.getDatatype((IRI)valueIRI));
                ax = this.fac.getOWLAnnotationAssertionAxiom(this.trAnnotationProp((String)v), sub, (OWLAnnotationValue)value, annotations);
            } else {
                LOG.warn((Object)("Cannot translate: " + clause));
            }
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_SYNONYM) {
            String synType;
            Object[] values = clause.getValues().toArray();
            if (values.length > 1) {
                synType = values[1].toString();
                if (values.length > 2) {
                    OWLAnnotation ann = this.fac.getOWLAnnotation(this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_HAS_SYNONYM_TYPE.getTag()), (OWLAnnotationValue)this.trAnnotationProp(values[2].toString()).getIRI());
                    annotations.add(ann);
                }
            } else {
                LOG.warn((Object)("Assume 'RELATED'for missing scope in synonym clause: " + clause));
                synType = OBOFormatConstants.OboFormatTag.TAG_RELATED.getTag();
            }
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trSynonymType(synType), sub, this.trLiteral(clause.getValue()), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_XREF) {
            Xref xref = (Xref)clause.getValue();
            String xrefAnnotation = xref.getAnnotation();
            if (xrefAnnotation != null) {
                OWLAnnotation owlAnnotation = this.fac.getOWLAnnotation(this.fac.getRDFSLabel(), (OWLAnnotationValue)this.fac.getOWLLiteral(xrefAnnotation));
                annotations.add(owlAnnotation);
            }
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        } else {
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        }
        return ax;
    }

    private OWLAnnotationProperty trSynonymType(String type) {
        if (type.equals(OBOFormatConstants.OboFormatTag.TAG_RELATED.getTag()) || type.equals(OBOFormatConstants.OboFormatTag.TAG_EXACT.getTag()) || type.equals(OBOFormatConstants.OboFormatTag.TAG_NARROW.getTag()) || type.equals(OBOFormatConstants.OboFormatTag.TAG_BROAD.getTag())) {
            return this.trTagToAnnotationProp(type);
        }
        return this.trAnnotationProp(type);
    }

    private Set<OWLAnnotation> trAnnotations(Clause clause) {
        HashSet<OWLAnnotation> anns = new HashSet<OWLAnnotation>();
        this.trAnnotations(clause, anns);
        return anns;
    }

    private void trAnnotations(Clause clause, Set<OWLAnnotation> anns) {
        Collection<QualifierValue> qvs;
        Collection<Xref> xrefs = clause.getXrefs();
        if (xrefs != null) {
            for (Xref x : xrefs) {
                if (x.getIdref() == null || x.getIdref().length() <= 0) continue;
                OWLAnnotationProperty ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_XREF.getTag());
                OWLAnnotation ann = this.fac.getOWLAnnotation(ap, this.trLiteral(x));
                anns.add(ann);
            }
        }
        if ((qvs = clause.getQualifierValues()) != null) {
            for (QualifierValue qv : qvs) {
                String qTag = qv.getQualifier();
                if (qTag.equals("gci_relation") || qTag.equals("gci_filler") || qTag.equals("cardinality") || qTag.equals("minCardinality") || qTag.equals("maxCardinality") || qTag.equals("all_some") || qTag.equals("all_only")) continue;
                OWLAnnotationProperty ap = this.trTagToAnnotationProp(qTag);
                OWLAnnotation ann = this.fac.getOWLAnnotation(ap, this.trLiteral(qv.getValue()));
                anns.add(ann);
            }
        }
    }

    private Set<? extends OWLAnnotation> trAnnotations(Collection<Clause> clauses) {
        if (clauses != null) {
            HashSet<OWLAnnotation> anns = new HashSet<OWLAnnotation>();
            for (Clause clause : clauses) {
                this.trAnnotations(clause, anns);
            }
            return anns;
        }
        return null;
    }

    public OWLClassExpression trRel(String relId, String classId, Collection<QualifierValue> quals) {
        Object ex;
        Frame relFrame = this.obodoc.getTypedefFrame(relId);
        OWLObjectProperty pe = this.trObjectProp(relId);
        OWLClass ce = this.trClass(classId);
        Integer exact = this.getQVInt("cardinality", quals);
        Integer min = this.getQVInt("minCardinality", quals);
        Integer max = this.getQVInt("maxCardinality", quals);
        Boolean allSome = this.getQVBoolean("all_some", quals);
        Boolean allOnly = this.getQVBoolean("all_only", quals);
        if (ce instanceof OWLClass) {
            this.add((OWLAxiom)this.fac.getOWLDeclarationAxiom((OWLEntity)ce));
        }
        if (exact != null && exact > 0) {
            ex = this.fac.getOWLObjectExactCardinality(exact.intValue(), (OWLObjectPropertyExpression)pe, (OWLClassExpression)ce);
        } else if (exact != null && exact == 0 || max != null && max == 0) {
            OWLObjectComplementOf ceCompl = this.fac.getOWLObjectComplementOf((OWLClassExpression)ce);
            ex = this.fac.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)pe, (OWLClassExpression)ceCompl);
        } else {
            ex = max != null && min != null ? this.fac.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.fac.getOWLObjectMinCardinality(min.intValue(), (OWLObjectPropertyExpression)pe, (OWLClassExpression)ce), this.fac.getOWLObjectMaxCardinality(max.intValue(), (OWLObjectPropertyExpression)pe, (OWLClassExpression)ce)}) : (min != null ? this.fac.getOWLObjectMinCardinality(min.intValue(), (OWLObjectPropertyExpression)pe, (OWLClassExpression)ce) : (max != null ? this.fac.getOWLObjectMaxCardinality(max.intValue(), (OWLObjectPropertyExpression)pe, (OWLClassExpression)ce) : (allSome != null && allSome != false && allOnly != null && allOnly != false ? this.fac.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.fac.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)pe, (OWLClassExpression)ce), this.fac.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)pe, (OWLClassExpression)ce)}) : (allOnly != null && allOnly != false ? this.fac.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)pe, (OWLClassExpression)ce) : (relFrame != null && relFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_CLASS_LEVEL_TAG) != null && (Boolean)relFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_CLASS_LEVEL_TAG) != false ? this.fac.getOWLObjectHasValue((OWLObjectPropertyExpression)pe, this.trIndividual(classId)) : this.fac.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)pe, (OWLClassExpression)ce))))));
        }
        return ex;
    }

    private String getQVString(String q, Collection<QualifierValue> quals) {
        for (QualifierValue qv : quals) {
            if (!qv.getQualifier().equals(q)) continue;
            Object v = qv.getValue();
            return (String)v;
        }
        return null;
    }

    private Boolean getQVBoolean(String q, Collection<QualifierValue> quals) {
        for (QualifierValue qv : quals) {
            if (!qv.getQualifier().equals(q)) continue;
            Object v = qv.getValue();
            return Boolean.valueOf((String)v);
        }
        return null;
    }

    private Integer getQVInt(String q, Collection<QualifierValue> quals) {
        for (QualifierValue qv : quals) {
            if (!qv.getQualifier().equals(q)) continue;
            Object v = qv.getValue();
            return Integer.valueOf((String)v);
        }
        return null;
    }

    private OWLClass trClass(String classId) {
        IRI iri = this.oboIdToIRI(classId);
        return this.fac.getOWLClass(iri);
    }

    private OWLClassExpression trClass(Object v) {
        return this.trClass((String)v);
    }

    private String mapPropId(String id) {
        Frame f = this.obodoc.getTypedefFrame(id);
        if (f != null) {
            Collection<Xref> xrefs = f.getTagValues(OBOFormatConstants.OboFormatTag.TAG_XREF, Xref.class);
            for (Xref x : xrefs) {
                String xid = x.getIdref();
                if (!this.obodoc.isTreatXrefsAsEquivalent(this.getIdPrefix(xid))) continue;
                return xid;
            }
        }
        return id;
    }

    private String getIdPrefix(String x) {
        String[] parts = x.split(":", 2);
        return parts[0];
    }

    private OWLIndividual trIndividual(String instId) {
        IRI iri = this.oboIdToIRI(instId);
        return this.fac.getOWLNamedIndividual(iri);
    }

    public static IRI trTagToIRI(String tag) {
        IRI iri = null;
        iri = annotationPropertyMap.containsKey(tag) ? annotationPropertyMap.get(tag) : IRI.create((String)("http://www.geneontology.org/formats/oboInOwl#" + tag));
        return iri;
    }

    private OWLAnnotationProperty trTagToAnnotationProp(String tag) {
        IRI iri = Obo2Owl.trTagToIRI(tag);
        OWLAnnotationProperty ap = this.fac.getOWLAnnotationProperty(iri);
        if (!this.apToDeclare.contains(ap)) {
            this.apToDeclare.add(ap);
            this.add((OWLAxiom)this.fac.getOWLDeclarationAxiom((OWLEntity)ap));
            Obo2OWLConstants.Obo2OWLVocabulary vocab = Obo2OWLConstants.getVocabularyObj(tag);
            if (vocab != null) {
                this.add((OWLAxiom)this.fac.getOWLAnnotationAssertionAxiom(this.fac.getRDFSLabel(), (OWLAnnotationSubject)iri, this.trLiteral(vocab.getLabel())));
            }
        }
        return ap;
    }

    private OWLAnnotationProperty trAnnotationProp(String relId) {
        IRI iri = this.oboIdToIRI(this.mapPropId(relId));
        return this.fac.getOWLAnnotationProperty(iri);
    }

    private OWLObjectProperty trObjectProp(String relId) {
        IRI iri = this.oboIdToIRI(this.mapPropId(relId));
        return this.fac.getOWLObjectProperty(iri);
    }

    private OWLObjectPropertyExpression trObjectProp(Object v) {
        IRI iri = this.oboIdToIRI(this.mapPropId((String)v));
        return this.fac.getOWLObjectProperty(iri);
    }

    protected OWLAnnotationValue trLiteral(Object value) {
        if (value instanceof Xref) {
            value = ((Xref)value).getIdref();
        } else {
            if (value instanceof Date) {
                String lexicalValue = Obo2OWLConstants.OWL2_DATE_LITERAL_FORMAT.get().format((Date)value);
                return this.fac.getOWLLiteral(lexicalValue, OWL2Datatype.XSD_DATE_TIME);
            }
            if (value instanceof Boolean) {
                return this.fac.getOWLLiteral(((Boolean)value).booleanValue());
            }
            if (!(value instanceof String)) {
                value = value.toString();
            }
        }
        return this.fac.getOWLLiteral((String)value);
    }

    public IRI oboIdToIRI(String id) {
        String safeId;
        String localId;
        String db;
        String xid;
        if (id.contains(" ")) {
            LOG.error((Object)("id contains space: \"" + id + "\""));
            return null;
        }
        if (id.startsWith("http:")) {
            return IRI.create((String)id);
        }
        if (id.startsWith("https:")) {
            return IRI.create((String)id);
        }
        if (id.startsWith("ftp:")) {
            return IRI.create((String)id);
        }
        if (id.startsWith("urn:")) {
            return IRI.create((String)id);
        }
        if (!id.contains(":") && !(xid = this.translateShorthandIdToExpandedId(id)).equals(id)) {
            return this.oboIdToIRI(xid);
        }
        String[] idParts = id.split(":", 2);
        if (idParts.length > 1) {
            db = idParts[0];
            localId = idParts[1];
            db = localId.contains("_") ? db + "#_" : db + "_";
        } else if (idParts.length == 0) {
            db = this.getDefaultIDSpace() + "#";
            localId = id;
        } else {
            db = this.getDefaultIDSpace() + "#";
            localId = idParts[0];
        }
        String uriPrefix = DEFAULT_IRI_PREFIX + db;
        if (this.idSpaceMap.containsKey(db)) {
            uriPrefix = this.idSpaceMap.get(db);
        }
        try {
            safeId = URLEncoder.encode(localId, "US-ASCII");
        }
        catch (UnsupportedEncodingException e1) {
            return null;
        }
        if (safeId.contains(" ")) {
            safeId = safeId.replace(" ", "_");
        }
        IRI iri = null;
        try {
            iri = IRI.create((String)(uriPrefix + safeId));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return iri;
    }

    private String translateShorthandIdToExpandedId(String id) {
        if (id.contains(":")) {
            return id;
        }
        Frame tdf = this.obodoc.getTypedefFrame(id);
        if (tdf == null) {
            return id;
        }
        Collection<Xref> xrefs = tdf.getTagValues(OBOFormatConstants.OboFormatTag.TAG_XREF, Xref.class);
        String matchingExpandedId = null;
        for (Xref xref : xrefs) {
            String xid;
            if (xref == null || (xid = xref.getIdref()).equals(id)) continue;
            if (matchingExpandedId == null) {
                matchingExpandedId = xid;
                continue;
            }
            if (!xid.startsWith("RO") && !xid.startsWith("BFO")) continue;
            matchingExpandedId = xid;
        }
        if (matchingExpandedId == null) {
            return id;
        }
        return matchingExpandedId;
    }

    private String getDefaultIDSpace() {
        return this.defaultIDSpace;
    }
}

