/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.FrameMergeException;
import org.obolibrary.oboformat.model.FrameStructureException;
import org.obolibrary.oboformat.parser.OBOFormatConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBODoc {
    protected Frame headerFrame;
    protected Map<String, Frame> termFrameMap = new HashMap<String, Frame>();
    protected Map<String, Frame> typedefFrameMap = new HashMap<String, Frame>();
    protected Map<String, Frame> instanceFrameMap = new HashMap<String, Frame>();
    protected Collection<Frame> annotationFrames = new LinkedList<Frame>();
    protected Collection<OBODoc> importedOBODocs = new LinkedList<OBODoc>();

    public Frame getHeaderFrame() {
        return this.headerFrame;
    }

    public void setHeaderFrame(Frame headerFrame) {
        this.headerFrame = headerFrame;
    }

    public Collection<Frame> getTermFrames() {
        return this.termFrameMap.values();
    }

    public Collection<Frame> getTypedefFrames() {
        return this.typedefFrameMap.values();
    }

    public Collection<Frame> getInstanceFrames() {
        return this.instanceFrameMap.values();
    }

    public Frame getTermFrame(String id) {
        return this.getTermFrame(id, false);
    }

    public Frame getTermFrame(String id, boolean followImport) {
        if (!followImport) {
            return this.termFrameMap.get(id);
        }
        HashSet<String> visited = new HashSet<String>();
        visited.add(this.getHeaderDescriptor());
        return this._getTermFrame(id, visited);
    }

    private Frame _getTermFrame(String id, Set<String> visitedDocs) {
        Frame f = this.termFrameMap.get(id);
        if (f != null) {
            return f;
        }
        for (OBODoc doc : this.importedOBODocs) {
            String headerDescriptor = doc.getHeaderDescriptor();
            if (!visitedDocs.contains(headerDescriptor)) {
                visitedDocs.add(headerDescriptor);
                f = doc.getTermFrame(id, true);
            }
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public Frame getTypedefFrame(String id) {
        return this.getTypedefFrame(id, false);
    }

    public Frame getTypedefFrame(String id, boolean followImports) {
        if (!followImports) {
            return this.typedefFrameMap.get(id);
        }
        HashSet<String> visited = new HashSet<String>();
        visited.add(this.getHeaderDescriptor());
        return this._getTypedefFrame(id, visited);
    }

    private Frame _getTypedefFrame(String id, Set<String> visitedDocs) {
        Frame f = this.typedefFrameMap.get(id);
        if (f != null) {
            return f;
        }
        for (OBODoc doc : this.importedOBODocs) {
            String headerDescriptor = doc.getHeaderDescriptor();
            if (!visitedDocs.contains(headerDescriptor)) {
                visitedDocs.add(headerDescriptor);
                f = doc.getTypedefFrame(id, true);
            }
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public Frame getInstanceFrame(String id) {
        return this.instanceFrameMap.get(id);
    }

    public Collection<OBODoc> getImportedOBODocs() {
        return this.importedOBODocs;
    }

    public void setImportedOBODocs(Collection<OBODoc> importedOBODocs) {
        this.importedOBODocs = importedOBODocs;
    }

    public void addImportedOBODoc(OBODoc doc) {
        if (this.importedOBODocs == null) {
            this.importedOBODocs = new ArrayList<OBODoc>();
        }
        this.importedOBODocs.add(doc);
    }

    public void addFrame(Frame f) throws FrameMergeException {
        if (f.getType() == Frame.FrameType.TERM) {
            this.addTermFrame(f);
        } else if (f.getType() == Frame.FrameType.TYPEDEF) {
            this.addTypedefFrame(f);
        } else if (f.getType() == Frame.FrameType.INSTANCE) {
            this.addInstanceFrame(f);
        }
    }

    public void addTermFrame(Frame f) throws FrameMergeException {
        String id = f.getId();
        if (this.termFrameMap.containsKey(id)) {
            this.termFrameMap.get(id).merge(f);
        } else {
            this.termFrameMap.put(id, f);
        }
    }

    public void addTypedefFrame(Frame f) throws FrameMergeException {
        String id = f.getId();
        if (this.typedefFrameMap.containsKey(id)) {
            this.typedefFrameMap.get(id).merge(f);
        } else {
            this.typedefFrameMap.put(id, f);
        }
    }

    public void addInstanceFrame(Frame f) throws FrameMergeException {
        String id = f.getId();
        if (this.instanceFrameMap.containsKey(id)) {
            this.instanceFrameMap.get(id).merge(f);
        } else {
            this.instanceFrameMap.put(id, f);
        }
    }

    public String getIDSpace(String prefix) {
        if (prefix.equals("RO")) {
            return "http://purl.obolibrary.org/obo/RO_";
        }
        return null;
    }

    public boolean isTreatXrefsAsEquivalent(String prefix) {
        return prefix != null && prefix.equals("RO");
    }

    public void mergeContents(OBODoc extDoc) throws FrameMergeException {
        for (Frame f : extDoc.getTermFrames()) {
            this.addTermFrame(f);
        }
        for (Frame f : extDoc.getTypedefFrames()) {
            this.addTypedefFrame(f);
        }
        for (Frame f : extDoc.getInstanceFrames()) {
            this.addInstanceFrame(f);
        }
    }

    public void addDefaultOntologyHeader(String defaultOnt) {
        Frame hf = this.getHeaderFrame();
        Clause ontClause = hf.getClause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY);
        if (ontClause == null) {
            ontClause = new Clause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY, defaultOnt);
            hf.addClause(ontClause);
        }
    }

    public void check() throws FrameStructureException {
        this.getHeaderFrame().check();
        for (Frame f : this.getTermFrames()) {
            f.check();
        }
        for (Frame f : this.getTypedefFrames()) {
            f.check();
        }
        for (Frame f : this.getInstanceFrames()) {
            f.check();
        }
    }

    public String toString() {
        return this.getHeaderDescriptor();
    }

    private String getHeaderDescriptor() {
        return "OBODoc(" + this.headerFrame + ")";
    }
}

