/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paint.annotation;

import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.QualifierDif;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.paint.datamodel.GeneNode;
import org.paint.util.GeneNodeUtil;

public class AnnotationForTerm {
    private GeneNode gNode;
    private GOTerm gTerm;
    private HashSet<Qualifier> qSet = new HashSet();
    private HashSet<Annotation> annotSet = new HashSet();

    public AnnotationForTerm(GeneNode gNode, GOTerm gTerm, GOTermHelper gth) {
        this.gNode = gNode;
        this.gTerm = gTerm;
        if (GeneNodeUtil.inPrunedBranch(gNode)) {
            return;
        }
        Node n = gNode.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            this.qSet = null;
            return;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            this.qSet = null;
            return;
        }
        HashSet<Annotation> handledSet = new HashSet<Annotation>();
        ArrayList notAncestors = gth.getAncestors(gTerm);
        for (Annotation a : annotList) {
            boolean not;
            if (!a.isExperimental() || !(not = QualifierDif.containsNegative((Set)a.getQualifierSet()))) continue;
            handledSet.add(a);
            String curTerm = a.getGoTerm();
            GOTerm cGOTerm = gth.getTerm(curTerm);
            if (!notAncestors.contains(cGOTerm) && !cGOTerm.equals(gTerm)) continue;
            this.annotSet.add(a);
            QualifierDif.addIfNotPresent(this.qSet, (HashSet)a.getQualifierSet());
        }
        for (Annotation a : annotList) {
            String curTerm;
            GOTerm cGOTerm;
            ArrayList ancestors;
            if (!a.isExperimental() || handledSet.contains(a) || !(ancestors = gth.getAncestors(cGOTerm = gth.getTerm(curTerm = a.getGoTerm()))).contains(gTerm) && !cGOTerm.equals(gTerm)) continue;
            this.annotSet.add(a);
            HashSet curSet = a.getQualifierSet();
            if (null == curSet) continue;
            for (Qualifier q : curSet) {
                if (!gth.isQualifierValidForTerm(gTerm, q)) continue;
                QualifierDif.addIfNotPresent(this.qSet, (Qualifier)q);
            }
        }
        if (this.qSet.isEmpty()) {
            this.qSet = null;
        }
    }

    public GeneNode getgNode() {
        return this.gNode;
    }

    public GOTerm getgTerm() {
        return this.gTerm;
    }

    public HashSet<Qualifier> getQset() {
        return this.qSet;
    }

    public HashSet<Annotation> getAnnotSet() {
        return this.annotSet;
    }

    public boolean annotationExists() {
        return !this.annotSet.isEmpty();
    }

    public static boolean annotationApplicable(AnnotationForTerm aft, AnnotationForTerm compAft) {
        if (!aft.annotationExists() || !compAft.annotationExists()) {
            return false;
        }
        boolean qualifierNeg = QualifierDif.containsNegative(aft.getQset());
        return qualifierNeg == QualifierDif.containsNegative(compAft.getQset());
    }
}

