/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paint.matrix;

import edu.usc.ksom.pm.panther.paint.matrix.NodeInfoForMatrix;
import edu.usc.ksom.pm.panther.paint.matrix.TermAncestor;
import edu.usc.ksom.pm.panther.paint.matrix.TermToAssociation;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import java.util.ArrayList;
import org.paint.datamodel.Association;
import org.paint.main.PaintManager;

public class MatrixGroup
implements Comparable<MatrixGroup> {
    private ArrayList<TermAncestor> items = new ArrayList();
    GOTermHelper gth;
    PaintManager pm = PaintManager.inst();

    public MatrixGroup(TermAncestor ta) {
        this.gth = this.pm.goTermHelper();
        this.items.add(ta);
    }

    public int getCount() {
        return this.items.size();
    }

    public TermAncestor getTermAncestorAtIndex(int index) {
        if (null == this.items || index >= this.items.size()) {
            return null;
        }
        return this.items.get(index);
    }

    public GOTerm getTermAtIndex(int index) {
        if (null == this.items || index >= this.items.size()) {
            return null;
        }
        TermAncestor ta = this.items.get(index);
        TermToAssociation toa = ta.getTermToAssociation();
        if (null == toa) {
            return null;
        }
        return toa.getTerm();
    }

    public int getIndexOfGroupWithAncestor(GOTerm term) {
        for (int i = 0; i < this.items.size(); ++i) {
            TermAncestor cur = this.items.get(i);
            ArrayList<GOTerm> ancestorList = cur.getAncestorList();
            if (!ancestorList.contains(term)) continue;
            return i;
        }
        return -1;
    }

    public boolean addToList(TermAncestor ta) {
        ArrayList<GOTerm> curAncestorList;
        TermAncestor cur;
        int i;
        ArrayList<GOTerm> addAncestorList = ta.getAncestorList();
        ArrayList copyAddAncestorList = (ArrayList)addAncestorList.clone();
        copyAddAncestorList.add(0, ta.getTermToAssociation().getTerm());
        int insertIndex = -1;
        for (i = 0; i < this.items.size(); ++i) {
            cur = this.items.get(i);
            curAncestorList = cur.getAncestorList();
            if (!this.isSubSetWithOrder(curAncestorList, copyAddAncestorList)) continue;
            insertIndex = i + 1;
        }
        if (insertIndex >= 0) {
            this.items.add(insertIndex, ta);
            return true;
        }
        for (i = 0; i < this.items.size(); ++i) {
            cur = this.items.get(i);
            curAncestorList = cur.getAncestorList();
            ArrayList copyCurAncestorList = (ArrayList)curAncestorList.clone();
            copyCurAncestorList.add(0, cur.getTermToAssociation().getTerm());
            if (!this.isSubSetWithOrder(copyAddAncestorList, copyCurAncestorList)) continue;
            if (i >= 1) {
                TermAncestor previousTermAncestor = this.items.get(i - 1);
                ArrayList copyPreviousAncestorList = (ArrayList)previousTermAncestor.getAncestorList().clone();
                copyPreviousAncestorList.add(0, previousTermAncestor.getTermToAssociation().getTerm());
                if (!this.isSubSetWithOrder(copyPreviousAncestorList, copyAddAncestorList)) continue;
            }
            insertIndex = i;
        }
        if (insertIndex >= 0) {
            this.items.add(insertIndex, ta);
            return true;
        }
        return false;
    }

    public NodeInfoForMatrix getAnnotInfoForNode(Node n, int index) {
        if (null == n || index < 0 || index >= this.items.size()) {
            return null;
        }
        TermAncestor ta = this.items.get(index);
        TermToAssociation toa = ta.getTermToAssociation();
        GOTerm term = toa.getTerm();
        return new NodeInfoForMatrix(this.pm.getGeneByPTNId(n.getStaticInfo().getPublicId()), term, this.gth, true);
    }

    public boolean termExists(GOTerm term) {
        for (TermAncestor ta : this.items) {
            if (!ta.getTermToAssociation().getTerm().equals(term)) continue;
            return true;
        }
        return false;
    }

    public boolean addAssociation(GOTerm term, Association a) {
        boolean added = false;
        for (TermAncestor ta : this.items) {
            GOTerm curTerm = ta.getTermToAssociation().getTerm();
            if (!curTerm.equals(term)) continue;
            TermToAssociation trmToAsn = ta.getTermToAssociation();
            trmToAsn.addAsn(a);
            added = true;
        }
        return added;
    }

    public ArrayList<TermAncestor> getItems() {
        return this.items;
    }

    @Override
    public int compareTo(MatrixGroup o) {
        Integer other;
        Integer cur = this.getCountExperimentalAnnotations();
        int comp = cur.compareTo(other = Integer.valueOf(o.getCountExperimentalAnnotations()));
        if (0 != comp) {
            return comp;
        }
        GOTerm curT = this.getFirstTerm();
        GOTerm otherT = o.getFirstTerm();
        if (null == curT && null == otherT) {
            return 0;
        }
        if (null == curT && null != otherT) {
            return -1;
        }
        if (null != curT && null == otherT) {
            return 1;
        }
        String cName = curT.getName();
        String oName = otherT.getName();
        if (null == cName && null == oName) {
            return 0;
        }
        if (null == cName && null != oName) {
            return -1;
        }
        if (null != cName && null == oName) {
            return 1;
        }
        return cName.compareTo(oName);
    }

    public boolean isSubSetWithOrder(ArrayList<GOTerm> list1, ArrayList<GOTerm> list2) {
        if (null == list1 || null == list2) {
            return false;
        }
        if (list2.size() > list1.size()) {
            return false;
        }
        if (0 == list2.size()) {
            return false;
        }
        int indexOfFirstTerm = list1.indexOf(list2.get(0));
        if (indexOfFirstTerm < 0) {
            return false;
        }
        if (indexOfFirstTerm + list2.size() > list1.size()) {
            return false;
        }
        int counter = 1;
        for (int i = indexOfFirstTerm + 1; i < list1.size() && counter < list2.size(); ++counter, ++i) {
            GOTerm term2;
            GOTerm term1 = list1.get(i);
            if (term1.equals(term2 = list2.get(counter))) continue;
            return false;
        }
        return true;
    }

    private int getCountExperimentalAnnotations() {
        int total = 0;
        if (null == this.items) {
            return total;
        }
        for (TermAncestor ta : this.items) {
            TermToAssociation toa = ta.getTermToAssociation();
            String acc = toa.getTerm().getAcc();
            ArrayList<Association> asnList = toa.getAsnList();
            for (Association a : asnList) {
                Annotation annot = a.getAnnotation();
                if (!acc.equals(annot.getGoTerm()) || !annot.isExperimental()) continue;
                ++total;
            }
        }
        return total;
    }

    public GOTerm getFirstTerm() {
        if (null == this.items || 0 == this.items.size()) {
            return null;
        }
        TermAncestor ta = this.items.get(0);
        return ta.getTermToAssociation().getTerm();
    }
}

