/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paint.matrix;

import edu.usc.ksom.pm.panther.paint.matrix.MatrixGroup;
import edu.usc.ksom.pm.panther.paint.matrix.TermAncestor;
import edu.usc.ksom.pm.panther.paint.matrix.TermToAssociation;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationHelper;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import edu.usc.ksom.pm.panther.paintCommon.Organism;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.paint.datamodel.Association;
import org.paint.datamodel.GeneNode;
import org.paint.main.PaintManager;
import org.paint.util.GeneNodeUtil;

public class MatrixInfo {
    private GOTermHelper gth;
    private ArrayList<TermAncestor> termAncestorList;
    private HashMap<String, ArrayList<MatrixGroup>> annotTypeLookup = new HashMap();
    private List<GeneNode> nodes;
    private ArrayList<GOTerm> handledTerms = new ArrayList();
    private String familyId;
    private Hashtable<Organism, HashSet<String>> nonDisplayOrgToEvdneceLookup;

    protected MatrixInfo(GOTermHelper gth, List<GeneNode> treeNodes, ArrayList<TermAncestor> termAncestorList, String familyId) {
        NodeVariableInfo nvi;
        Node n;
        this.gth = gth;
        this.nodes = treeNodes;
        this.termAncestorList = termAncestorList;
        this.familyId = familyId;
        if (null == this.nodes) {
            return;
        }
        this.nonDisplayOrgToEvdneceLookup = PaintManager.inst().getnonDisplayedAnnotMatrixOrgToEvdnceLookup();
        for (TermAncestor ta : termAncestorList) {
            TermToAssociation toa = ta.getTermToAssociation();
            String aspect = toa.getTerm().getAspect();
            this.addTermAncestor(aspect, ta);
        }
        for (GeneNode gNode : this.nodes) {
            ArrayList annotList;
            n = gNode.getNode();
            if (n == null) {
                System.out.println("Did not find node for gn " + gNode.getPaintId());
                continue;
            }
            if (!this.annotApplicable(gNode) || null == (nvi = n.getVariableInfo()) || null == (annotList = nvi.getGoAnnotationList()) || 0 == annotList.size()) continue;
            for (Annotation a : annotList) {
                if (AnnotationHelper.ignoreAnnot((Annotation)a, (Node)n, this.nonDisplayOrgToEvdneceLookup)) continue;
                Association asn = new Association();
                asn.setAnnotation(a);
                asn.setNode(n);
                this.addAssociation(asn);
            }
        }
        for (GeneNode gNode : this.nodes) {
            n = gNode.getNode();
            if (n == null) {
                System.out.println("Did not find node for gn " + gNode.getPaintId());
                continue;
            }
            if (!this.annotApplicable(gNode) || null == (nvi = n.getVariableInfo())) continue;
            Collection<ArrayList<MatrixGroup>> groupListCollection = this.annotTypeLookup.values();
            for (ArrayList<MatrixGroup> curList : groupListCollection) {
                for (MatrixGroup mg : curList) {
                    ArrayList<TermAncestor> items = mg.getItems();
                    for (int i = 0; i < items.size(); ++i) {
                        TermAncestor ta = items.get(i);
                        boolean found = false;
                        TermToAssociation toa = ta.getTermToAssociation();
                        ArrayList<Association> asnList = toa.getAsnList();
                        for (Association a : asnList) {
                            if (!n.equals(a.getNode())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        GOTerm term = toa.getTerm();
                        ArrayList<GOTerm> otherTerms = new ArrayList<GOTerm>();
                        for (int j = i + 1; j < items.size(); ++j) {
                            TermAncestor otherTermAncestor = items.get(i);
                            otherTerms.add(otherTermAncestor.getTermToAssociation().getTerm());
                        }
                        Annotation annot = this.getParentTermAssoc(nvi, term);
                        if (null == annot) continue;
                        Association asn = new Association();
                        asn.setAnnotation(annot);
                        asn.setNode(n);
                        mg.addAssociation(term, asn);
                    }
                }
            }
        }
        for (String aspect : this.annotTypeLookup.keySet()) {
            ArrayList<MatrixGroup> groupList = this.annotTypeLookup.get(aspect);
            Collections.sort(groupList, Collections.reverseOrder());
        }
    }

    public String printTermInfo(ArrayList<GOTerm> termList) {
        StringBuffer sb = new StringBuffer();
        for (GOTerm term : termList) {
            sb.append(term.getName() + "(" + term.getAcc() + ")->");
        }
        return sb.toString();
    }

    public void printInfo() {
        Set<String> keySet = this.annotTypeLookup.keySet();
        for (String aspect : keySet) {
            System.out.println("Information for " + aspect);
            ArrayList<MatrixGroup> mgList = this.annotTypeLookup.get(aspect);
            int counter = 0;
            for (MatrixGroup mg : mgList) {
                System.out.println("Group " + counter);
                ++counter;
                ArrayList<TermAncestor> termAncestorList = mg.getItems();
                for (TermAncestor ta : termAncestorList) {
                    ArrayList<GOTerm> ancestors = ta.getAncestorList();
                    TermToAssociation toa = ta.getTermToAssociation();
                    GOTerm term = toa.getTerm();
                    System.out.println(term.getAspect() + " " + term.getName() + "(" + term.getAcc() + ") has ancestors " + this.printTermInfo(ancestors));
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    private Annotation getParentTermAssoc(NodeVariableInfo nvi, GOTerm term) {
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return null;
        }
        for (Annotation a : annotList) {
            GOTerm curTerm;
            if (AnnotationHelper.ignoreAnnot((Annotation)a, (Node)a.getAnnotationDetail().getAnnotatedNode(), this.nonDisplayOrgToEvdneceLookup) || !this.gth.getAncestors(curTerm = this.gth.getTerm(a.getGoTerm())).contains(term) || !a.isExperimental()) continue;
            return a;
        }
        return null;
    }

    private void addAssociation(Association a) {
        Annotation annot = a.getAnnotation();
        if (null == annot) {
            return;
        }
        String goTerm = annot.getGoTerm();
        if (null == goTerm) {
            return;
        }
        GOTerm gTerm = this.gth.getTerm(goTerm);
        if (this.termExists(gTerm)) {
            this.addAssociationToExistingList(gTerm, a);
            return;
        }
        String aspect2 = gTerm.getAspect();
        ArrayList ancestorList = this.gth.getAncestors(gTerm);
        if (null != ancestorList) {
            Iterator termIter = ancestorList.iterator();
            while (termIter.hasNext()) {
                GOTerm ancestor = (GOTerm)termIter.next();
                List curParents = ancestor.getParents();
                if (null != curParents && 0 != curParents.size()) continue;
                termIter.remove();
            }
        }
        ArrayList<GOTerm> differentAspectList = new ArrayList<GOTerm>();
        for (GOTerm parent : ancestorList) {
            if (aspect2.equals(parent.getAspect())) continue;
            differentAspectList.add(parent);
        }
        ancestorList.removeAll(differentAspectList);
        TermToAssociation toa = new TermToAssociation(gTerm);
        toa.addAsn(a);
        TermAncestor ta = new TermAncestor(toa, ancestorList);
        this.addTermAncestor(aspect2, ta);
        this.handledTerms.add(gTerm);
        if (differentAspectList.isEmpty()) {
            return;
        }
        HashMap otherAncestorLookup = GOTermHelper.organizeTerms(differentAspectList);
        Set aspectSet = otherAncestorLookup.keySet();
        for (String aspect2 : aspectSet) {
            ArrayList ancestorGroupList = (ArrayList)otherAncestorLookup.get(aspect2);
            for (int i = 0; i < ancestorGroupList.size(); ++i) {
                ancestorList = (ArrayList)ancestorGroupList.get(i);
                ancestorList.removeAll(this.handledTerms);
                if (0 == ancestorList.size()) continue;
                GOTerm cur = (GOTerm)ancestorList.get(0);
                ancestorList.remove(0);
                if (this.termExists(cur)) {
                    this.addAssociationToExistingList(cur, a);
                    continue;
                }
                this.handledTerms.add(cur);
                toa = new TermToAssociation(cur);
                toa.addAsn(a);
                ta = new TermAncestor(toa, ancestorList);
                this.addTermAncestor(aspect2, ta);
            }
        }
    }

    private void addTermAncestor(String aspect, TermAncestor ta) {
        MatrixGroup mg;
        ArrayList<MatrixGroup> lookupList = this.annotTypeLookup.get(aspect);
        if (null == lookupList) {
            lookupList = new ArrayList();
            this.annotTypeLookup.put(aspect, lookupList);
        }
        boolean added = false;
        for (int i = 0; i < lookupList.size() && !(added = (mg = lookupList.get(i)).addToList(ta)); ++i) {
        }
        if (!added) {
            MatrixGroup mg2 = new MatrixGroup(ta);
            lookupList.add(mg2);
        }
    }

    private boolean termExists(GOTerm term) {
        Collection<ArrayList<MatrixGroup>> groupListCollection = this.annotTypeLookup.values();
        if (null == groupListCollection || 0 == groupListCollection.size()) {
            return false;
        }
        for (ArrayList<MatrixGroup> curList : groupListCollection) {
            for (MatrixGroup mg : curList) {
                if (!mg.termExists(term)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean addAssociationToExistingList(GOTerm term, Association a) {
        Collection<ArrayList<MatrixGroup>> groupListCollection = this.annotTypeLookup.values();
        for (ArrayList<MatrixGroup> curList : groupListCollection) {
            for (MatrixGroup mg : curList) {
                if (!mg.termExists(term)) continue;
                return mg.addAssociation(term, a);
            }
        }
        return false;
    }

    private boolean annotApplicable(GeneNode gn) {
        if (null == gn) {
            return false;
        }
        if (GeneNodeUtil.inPrunedBranch(gn)) {
            return false;
        }
        Node n = gn.getNode();
        if (null == n) {
            return false;
        }
        NodeVariableInfo nvi = n.getVariableInfo();
        return null != nvi;
    }

    public ArrayList<MatrixGroup> getGroups(String aspect) {
        if (null == aspect) {
            return null;
        }
        return this.annotTypeLookup.get(aspect);
    }

    public Set<String> getAspects() {
        return this.annotTypeLookup.keySet();
    }

    public String getFamilyId() {
        return this.familyId;
    }

    public static void reorderMatrix(MatrixInfo previousMi, MatrixInfo newMi) {
        for (String aspect : previousMi.annotTypeLookup.keySet()) {
            ArrayList<MatrixGroup> pGroups = previousMi.getGroups(aspect);
            ArrayList<MatrixGroup> nGroups = newMi.getGroups(aspect);
            if (null == pGroups || 0 == pGroups.size() || null == nGroups || 0 == nGroups.size()) continue;
            ArrayList<MatrixGroup> reorderedGroups = new ArrayList<MatrixGroup>();
            block1: for (MatrixGroup pGroup : pGroups) {
                ArrayList<TermAncestor> pTermAncestors = pGroup.getItems();
                MatrixGroup createGroup = null;
                for (int i = 0; i < pTermAncestors.size(); ++i) {
                    TermAncestor ta = pTermAncestors.get(i);
                    boolean found = false;
                    for (MatrixGroup checkGroup : nGroups) {
                        ArrayList<TermAncestor> checkAncestors = checkGroup.getItems();
                        int foundIndex = MatrixInfo.findFromIndex(checkAncestors, 0, ta);
                        if (foundIndex < 0) continue;
                        if (i == 0) {
                            createGroup = new MatrixGroup(checkAncestors.remove(foundIndex));
                            reorderedGroups.add(createGroup);
                        } else {
                            TermAncestor matchAncestor;
                            boolean added;
                            if (i != 0 && createGroup == null || !(added = createGroup.addToList(matchAncestor = checkAncestors.get(foundIndex)))) break;
                            checkAncestors.remove(foundIndex);
                        }
                        found = true;
                    }
                    if (!found) continue block1;
                }
            }
            ArrayList<MatrixGroup> nonMatches = new ArrayList<MatrixGroup>();
            for (MatrixGroup nGroup : nGroups) {
                ArrayList<TermAncestor> remaining = nGroup.getItems();
                if (remaining.isEmpty()) continue;
                for (TermAncestor ta : remaining) {
                    boolean added = false;
                    for (MatrixGroup mg : nonMatches) {
                        if (!mg.addToList(ta)) continue;
                        added = true;
                        break;
                    }
                    if (added) continue;
                    MatrixGroup mg = new MatrixGroup(ta);
                    nonMatches.add(mg);
                }
            }
            if (!nonMatches.isEmpty()) {
                reorderedGroups.addAll(nonMatches);
            }
            if (reorderedGroups.isEmpty()) continue;
            newMi.annotTypeLookup.put(aspect, reorderedGroups);
        }
    }

    public static void reorderMatrixOld(MatrixInfo previousMi, MatrixInfo newMi) {
        HashSet<GOTerm> processedTerms = new HashSet<GOTerm>();
        for (String aspect : previousMi.annotTypeLookup.keySet()) {
            int i;
            ArrayList<MatrixGroup> pGroups = previousMi.getGroups(aspect);
            ArrayList<MatrixGroup> nGroups = newMi.getGroups(aspect);
            if (null == pGroups || 0 == pGroups.size() || null == nGroups || 0 == nGroups.size()) continue;
            System.out.println("Processing " + aspect + " previous group size is " + pGroups.size() + " new group size is " + nGroups.size());
            HashSet<MatrixGroup> brokenGroups = new HashSet<MatrixGroup>();
            int maxComp = Math.min(pGroups.size(), nGroups.size());
            block1: for (i = 0; i < maxComp; ++i) {
                MatrixGroup pGroup = pGroups.get(i);
                MatrixGroup nGroup = nGroups.get(i);
                ArrayList<TermAncestor> pTermAncestors = pGroup.getItems();
                ArrayList<TermAncestor> nTermAncestors = nGroup.getItems();
                if (nTermAncestors.size() > pTermAncestors.size()) {
                    System.out.println("New group has more items than old group for " + i);
                }
                for (int j = 0; j < pTermAncestors.size(); ++j) {
                    TermAncestor pTermAncestor = pTermAncestors.get(j);
                    GOTerm cur = pTermAncestor.getTermToAssociation().getTerm();
                    if (null != cur) {
                        if (!processedTerms.contains(cur)) {
                            processedTerms.add(cur);
                        } else {
                            System.out.println("Adding term multiple times");
                        }
                    }
                    if (j >= nTermAncestors.size()) {
                        boolean found = false;
                        for (int k = i + 1; k < nGroups.size(); ++k) {
                            MatrixGroup checkGroup = nGroups.get(k);
                            ArrayList<TermAncestor> checkAncestors = checkGroup.getItems();
                            int foundIndex = MatrixInfo.findFromIndex(checkAncestors, 0, pTermAncestor);
                            if (foundIndex < 0) continue;
                            TermAncestor match = checkAncestors.remove(foundIndex);
                            nTermAncestors.add(match);
                            found = true;
                            brokenGroups.add(checkGroup);
                            break;
                        }
                        if (found) continue;
                        continue block1;
                    }
                    TermAncestor nTermAncestor = nTermAncestors.get(j);
                    if (MatrixInfo.same(pTermAncestor, nTermAncestor)) continue;
                    int index = MatrixInfo.findFromIndex(nTermAncestors, j + 1, pTermAncestor);
                    if (index > 0) {
                        TermAncestor match = nTermAncestors.remove(index);
                        nTermAncestors.add(j, match);
                        continue;
                    }
                    boolean found = false;
                    for (int k = i + 1; k < nGroups.size(); ++k) {
                        MatrixGroup checkGroup = nGroups.get(k);
                        ArrayList<TermAncestor> checkAncestors = checkGroup.getItems();
                        int foundIndex = MatrixInfo.findFromIndex(checkAncestors, 0, pTermAncestor);
                        if (foundIndex < 0) continue;
                        TermAncestor match = checkAncestors.remove(foundIndex);
                        nTermAncestors.add(j, match);
                        found = true;
                        brokenGroups.add(checkGroup);
                        break;
                    }
                    if (found) continue;
                    for (int m = j; m < nTermAncestors.size(); ++m) {
                        boolean inserted = false;
                        TermAncestor ta = nTermAncestors.remove(m);
                        for (int n = i + 1; n < nGroups.size(); ++n) {
                            MatrixGroup mg = nGroups.get(n);
                            if (!mg.addToList(nTermAncestor)) continue;
                            inserted = true;
                            break;
                        }
                        if (inserted) continue;
                        MatrixGroup mg = new MatrixGroup(ta);
                        nGroups.add(mg);
                    }
                }
            }
            if (nGroups.size() > pGroups.size()) {
                MatrixGroup lastEntry = nGroups.get(Math.min(pGroups.size() - 1, nGroups.size() - 1));
                nGroups.removeAll(brokenGroups);
                int beginIndex = nGroups.indexOf(lastEntry) + 1;
                for (MatrixGroup fg : brokenGroups) {
                    for (TermAncestor ta : fg.getItems()) {
                        boolean inserted = false;
                        for (int j = beginIndex; j < nGroups.size(); ++j) {
                            MatrixGroup mg = nGroups.get(j);
                            if (!mg.addToList(ta)) continue;
                            inserted = true;
                        }
                        if (inserted) continue;
                        MatrixGroup mg = new MatrixGroup(ta);
                        nGroups.add(mg);
                    }
                }
            }
            for (i = 0; i < nGroups.size(); ++i) {
                MatrixGroup mg = nGroups.get(i);
                if (0 < mg.getCount()) continue;
                nGroups.remove(i);
                --i;
            }
        }
    }

    private static int findFromIndex(ArrayList<TermAncestor> termAncestors, int index, TermAncestor t1) {
        if (index >= termAncestors.size()) {
            return -1;
        }
        for (int i = index; i < termAncestors.size(); ++i) {
            TermAncestor cur = termAncestors.get(i);
            if (!MatrixInfo.same(t1, cur)) continue;
            return i;
        }
        return -1;
    }

    private static boolean same(TermAncestor ta1, TermAncestor ta2) {
        if (null == ta1 && null == ta2) {
            return true;
        }
        if (ta1 == null && ta2 != null || ta1 != null && ta2 == null) {
            return false;
        }
        TermToAssociation toa1 = ta1.getTermToAssociation();
        TermToAssociation toa2 = ta2.getTermToAssociation();
        if (null == toa1 && null == toa2) {
            return true;
        }
        if (toa1 == null && toa2 != null || toa1 != null && toa2 == null) {
            return false;
        }
        GOTerm gTerm1 = toa1.getTerm();
        GOTerm gTerm2 = toa2.getTerm();
        if (null == gTerm1 && null == gTerm2) {
            return true;
        }
        if (gTerm1 == null && gTerm2 != null || gTerm1 != null && gTerm2 == null) {
            return false;
        }
        String acc1 = gTerm1.getAcc();
        String acc2 = gTerm2.getAcc();
        if (null == acc1 && null == acc2) {
            return true;
        }
        if (acc1 == null && acc2 != null || acc1 != null && acc2 == null) {
            return false;
        }
        return acc1.equals(acc2);
    }
}

